/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.client.TypeRef;
import com.docusign.esign.model.FolderItemResponse;
import com.docusign.esign.model.FolderItemsResponse;
import com.docusign.esign.model.FoldersRequest;
import com.docusign.esign.model.FoldersResponse;
import java.util.ArrayList;
import java.util.HashMap;

public class FoldersApi {
    private ApiClient apiClient;

    public FoldersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FoldersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public FoldersResponse list(String accountId) throws ApiException {
        Object postBody = null;
        byte[] postBinaryBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling list");
        }
        String path = "/v2/accounts/{accountId}/folders".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        TypeRef<FoldersResponse> returnType = new TypeRef<FoldersResponse>(){};
        return (FoldersResponse)this.apiClient.invokeAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public FolderItemsResponse listItems(String accountId, String folderId) throws ApiException {
        Object postBody = null;
        byte[] postBinaryBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listItems");
        }
        if (folderId == null) {
            throw new ApiException(400, "Missing the required parameter 'folderId' when calling listItems");
        }
        String path = "/v2/accounts/{accountId}/folders/{folderId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{folderId\\}", this.apiClient.escapeString(folderId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        TypeRef<FolderItemsResponse> returnType = new TypeRef<FolderItemsResponse>(){};
        return (FolderItemsResponse)this.apiClient.invokeAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public FoldersResponse moveEnvelopes(String accountId, String folderId, FoldersRequest foldersRequest) throws ApiException {
        FoldersRequest postBody = foldersRequest;
        byte[] postBinaryBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling moveEnvelopes");
        }
        if (folderId == null) {
            throw new ApiException(400, "Missing the required parameter 'folderId' when calling moveEnvelopes");
        }
        String path = "/v2/accounts/{accountId}/folders/{folderId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{folderId\\}", this.apiClient.escapeString(folderId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        TypeRef<FoldersResponse> returnType = new TypeRef<FoldersResponse>(){};
        return (FoldersResponse)this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, postBinaryBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public FolderItemResponse search(String accountId, String searchFolderId) throws ApiException {
        return this.search(accountId, searchFolderId, null);
    }

    public FolderItemResponse search(String accountId, String searchFolderId, SearchOptions options) throws ApiException {
        Object postBody = null;
        byte[] postBinaryBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling search");
        }
        if (searchFolderId == null) {
            throw new ApiException(400, "Missing the required parameter 'searchFolderId' when calling search");
        }
        String path = "/v2/accounts/{accountId}/search_folders/{searchFolderId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{searchFolderId\\}", this.apiClient.escapeString(searchFolderId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "include_recipients", options.includeRecipients));
            queryParams.addAll(this.apiClient.parameterToPairs("", "all", options.all));
            queryParams.addAll(this.apiClient.parameterToPairs("", "order", options.order));
            queryParams.addAll(this.apiClient.parameterToPairs("", "count", options.count));
            queryParams.addAll(this.apiClient.parameterToPairs("", "start_position", options.startPosition));
            queryParams.addAll(this.apiClient.parameterToPairs("", "from_date", options.fromDate));
            queryParams.addAll(this.apiClient.parameterToPairs("", "to_date", options.toDate));
            queryParams.addAll(this.apiClient.parameterToPairs("", "order_by", options.orderBy));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        TypeRef<FolderItemResponse> returnType = new TypeRef<FolderItemResponse>(){};
        return (FolderItemResponse)this.apiClient.invokeAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public class SearchOptions {
        private String includeRecipients = null;
        private String all = null;
        private String order = null;
        private String count = null;
        private String startPosition = null;
        private String fromDate = null;
        private String toDate = null;
        private String orderBy = null;

        public void setIncludeRecipients(String includeRecipients) {
            this.includeRecipients = includeRecipients;
        }

        public String getIncludeRecipients() {
            return this.includeRecipients;
        }

        public void setAll(String all) {
            this.all = all;
        }

        public String getAll() {
            return this.all;
        }

        public void setOrder(String order) {
            this.order = order;
        }

        public String getOrder() {
            return this.order;
        }

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }

        public void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        public String getOrderBy() {
            return this.orderBy;
        }
    }
}

