/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.client;

import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.JSON;
import com.docusign.esign.client.Pair;
import com.docusign.esign.client.StringUtil;
import com.docusign.esign.client.TypeRef;
import com.docusign.esign.client.auth.ApiKeyAuth;
import com.docusign.esign.client.auth.Authentication;
import com.docusign.esign.client.auth.HttpBasicAuth;
import com.docusign.esign.client.auth.OAuth;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.file.FileDataBodyPart;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class ApiClient {
    private Map<String, Client> hostMap = new HashMap<String, Client>();
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private boolean debugging = false;
    private String basePath = "https://www.docusign.net/restapi";
    private JSON json = new JSON();
    private Map<String, Authentication> authentications;
    private int statusCode;
    private Map<String, List<String>> responseHeaders;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public ApiClient() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.json.setDateFormat((DateFormat)this.dateFormat.clone());
        this.setUserAgent("Java-Swagger");
        this.authentications = new HashMap<String, Authentication>();
        this.authentications = Collections.unmodifiableMap(this.authentications);
    }

    public JSON getJSON() {
        return this.json;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Authentication getAuthentication(String authName) {
        return this.authentications.get(authName);
    }

    public void setUsername(String username) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setUsername(username);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setPassword(String password) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setPassword(password);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setApiKey(String apiKey) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKey(apiKey);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setApiKeyPrefix(String apiKeyPrefix) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKeyPrefix(apiKeyPrefix);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setAccessToken(String accessToken) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            ((OAuth)auth).setAccessToken(accessToken);
            return;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    public ApiClient setUserAgent(String userAgent) {
        this.addDefaultHeader("User-Agent", userAgent);
        return this;
    }

    public ApiClient addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
        return this;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public ApiClient setDebugging(boolean debugging) {
        this.debugging = debugging;
        return this;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.json.setDateFormat((DateFormat)dateFormat.clone());
        return this;
    }

    public Date parseDate(String str) {
        try {
            return this.dateFormat.parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date) {
            return this.formatDate((Date)param);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Object value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null) {
            return params;
        }
        Collection valueCollection = null;
        if (!(value instanceof Collection)) {
            params.add(new Pair(name, this.parameterToString(value)));
            return params;
        }
        valueCollection = (Collection)value;
        if (valueCollection.isEmpty()) {
            return params;
        }
        String string = collectionFormat = collectionFormat == null || collectionFormat.isEmpty() ? "csv" : collectionFormat;
        if (collectionFormat.equals("multi")) {
            for (Object item : valueCollection) {
                params.add(new Pair(name, this.parameterToString(item)));
            }
            return params;
        }
        String delimiter = ",";
        if (collectionFormat.equals("csv")) {
            delimiter = ",";
        } else if (collectionFormat.equals("ssv")) {
            delimiter = " ";
        } else if (collectionFormat.equals("tsv")) {
            delimiter = "\t";
        } else if (collectionFormat.equals("pipes")) {
            delimiter = "|";
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : valueCollection) {
            sb.append(delimiter);
            sb.append(this.parameterToString(item));
        }
        params.add(new Pair(name, sb.substring(1)));
        return params;
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        if (StringUtil.containsIgnoreCase(accepts, "application/json")) {
            return "application/json";
        }
        return StringUtil.join(accepts, ",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0) {
            return "application/json";
        }
        if (StringUtil.containsIgnoreCase(contentTypes, "application/json")) {
            return "application/json";
        }
        return contentTypes[0];
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public String serialize(Object obj, String contentType) throws ApiException {
        if (contentType.startsWith("application/json")) {
            return this.json.serialize(obj);
        }
        throw new ApiException(400, "can not serialize object into Content-Type: " + contentType);
    }

    public <T> T deserialize(ClientResponse response, TypeRef returnType) throws ApiException {
        String contentType = null;
        List contentTypes = (List)response.getHeaders().get((Object)"Content-Type");
        if (contentTypes != null && !contentTypes.isEmpty()) {
            contentType = (String)contentTypes.get(0);
        }
        if (contentType == null) {
            throw new ApiException(500, "missing Content-Type in response");
        }
        String body = response.hasEntity() ? (String)response.getEntity(String.class) : "";
        if (contentType.startsWith("application/json")) {
            return this.json.deserialize(body, returnType);
        }
        if (returnType.getType().equals(String.class)) {
            return (T)body;
        }
        throw new ApiException(500, "Content type \"" + contentType + "\" is not supported for type: " + returnType.getType());
    }

    private ClientResponse getAPIResponse(String path, String method, List<Pair> queryParams, Object body, byte[] binaryBody, Map<String, String> headerParams, Map<String, Object> formParams, String accept, String contentType, String[] authNames) throws ApiException {
        if (body != null && binaryBody != null) {
            throw new ApiException(500, "either body or binaryBody must be null");
        }
        this.updateParamsForAuth(authNames, queryParams, headerParams);
        Client client = this.getClient();
        StringBuilder b = new StringBuilder();
        b.append("?");
        if (queryParams != null) {
            for (Pair queryParam : queryParams) {
                if (queryParam.getName().isEmpty()) continue;
                b.append(this.escapeString(queryParam.getName()));
                b.append("=");
                b.append(this.escapeString(queryParam.getValue()));
                b.append("&");
            }
        }
        String querystring = b.substring(0, b.length() - 1);
        WebResource.Builder builder = accept == null ? client.resource(this.basePath + path + querystring).getRequestBuilder() : client.resource(this.basePath + path + querystring).accept(new String[]{accept});
        for (String key : headerParams.keySet()) {
            builder = (WebResource.Builder)builder.header(key, (Object)headerParams.get(key));
        }
        for (String key : this.defaultHeaderMap.keySet()) {
            if (headerParams.containsKey(key)) continue;
            builder = (WebResource.Builder)builder.header(key, (Object)this.defaultHeaderMap.get(key));
        }
        builder = (WebResource.Builder)builder.header("X-DocuSign-SDK", (Object)"Java");
        String encodedFormParams = null;
        if (contentType.startsWith("multipart/form-data")) {
            FormDataMultiPart mp = new FormDataMultiPart();
            for (Map.Entry<String, Object> param : formParams.entrySet()) {
                if (param.getValue() instanceof File) {
                    File file = (File)param.getValue();
                    mp.bodyPart((BodyPart)new FileDataBodyPart(param.getKey(), file, MediaType.MULTIPART_FORM_DATA_TYPE));
                    continue;
                }
                mp.field(param.getKey(), (Object)this.parameterToString(param.getValue()), MediaType.MULTIPART_FORM_DATA_TYPE);
            }
            body = mp;
        } else if (contentType.startsWith("application/x-www-form-urlencoded")) {
            encodedFormParams = this.getXWWWFormUrlencodedParams(formParams);
        }
        ClientResponse response = null;
        if ("GET".equals(method)) {
            response = (ClientResponse)builder.get(ClientResponse.class);
        } else if ("POST".equals(method)) {
            response = encodedFormParams != null ? (ClientResponse)((WebResource.Builder)builder.type(contentType)).post(ClientResponse.class, (Object)encodedFormParams) : (body == null ? (binaryBody == null ? (ClientResponse)builder.post(ClientResponse.class, null) : (ClientResponse)((WebResource.Builder)builder.type(contentType)).post(ClientResponse.class, (Object)binaryBody)) : (body instanceof FormDataMultiPart ? (ClientResponse)((WebResource.Builder)builder.type(contentType)).post(ClientResponse.class, body) : (ClientResponse)((WebResource.Builder)builder.type(contentType)).post(ClientResponse.class, (Object)this.serialize(body, contentType))));
        } else if ("PUT".equals(method)) {
            response = encodedFormParams != null ? (ClientResponse)((WebResource.Builder)builder.type(contentType)).put(ClientResponse.class, (Object)encodedFormParams) : (body == null ? (binaryBody == null ? (ClientResponse)builder.put(ClientResponse.class, null) : (ClientResponse)((WebResource.Builder)builder.type(contentType)).put(ClientResponse.class, (Object)binaryBody)) : (ClientResponse)((WebResource.Builder)builder.type(contentType)).put(ClientResponse.class, (Object)this.serialize(body, contentType)));
        } else if ("DELETE".equals(method)) {
            response = encodedFormParams != null ? (ClientResponse)((WebResource.Builder)builder.type(contentType)).delete(ClientResponse.class, (Object)encodedFormParams) : (body == null ? (binaryBody == null ? (ClientResponse)builder.delete(ClientResponse.class) : (ClientResponse)((WebResource.Builder)builder.type(contentType)).delete(ClientResponse.class, (Object)binaryBody)) : (ClientResponse)((WebResource.Builder)builder.type(contentType)).delete(ClientResponse.class, (Object)this.serialize(body, contentType)));
        } else {
            throw new ApiException(500, "unknown method type " + method);
        }
        return response;
    }

    public <T> T invokeAPI(String path, String method, List<Pair> queryParams, Object body, byte[] binaryBody, Map<String, String> headerParams, Map<String, Object> formParams, String accept, String contentType, String[] authNames, TypeRef returnType) throws ApiException {
        ClientResponse response = this.getAPIResponse(path, method, queryParams, body, binaryBody, headerParams, formParams, accept, contentType, authNames);
        this.statusCode = response.getStatusInfo().getStatusCode();
        this.responseHeaders = response.getHeaders();
        if (response.getStatusInfo() == ClientResponse.Status.NO_CONTENT) {
            return null;
        }
        if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
            if (returnType == null) {
                return null;
            }
            return this.deserialize(response, returnType);
        }
        String message = "error";
        String respBody = null;
        if (response.hasEntity()) {
            try {
                message = respBody = String.valueOf(response.getEntity(String.class));
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        throw new ApiException(response.getStatusInfo().getStatusCode(), message, (Map<String, List<String>>)response.getHeaders(), respBody);
    }

    public byte[] invokeBinaryAPI(String path, String method, List<Pair> queryParams, Object body, byte[] binaryBody, Map<String, String> headerParams, Map<String, Object> formParams, String accept, String contentType, String[] authNames) throws ApiException {
        ClientResponse response = this.getAPIResponse(path, method, queryParams, body, binaryBody, headerParams, formParams, accept, contentType, authNames);
        if (response.getStatusInfo() == ClientResponse.Status.NO_CONTENT) {
            return null;
        }
        if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
            if (response.hasEntity()) {
                DataInputStream stream = new DataInputStream(response.getEntityInputStream());
                byte[] data = new byte[response.getLength()];
                try {
                    stream.readFully(data);
                }
                catch (IOException ex) {
                    throw new ApiException(500, "Error obtaining binary response data");
                }
                return data;
            }
            return new byte[0];
        }
        String message = "error";
        if (response.hasEntity()) {
            try {
                message = String.valueOf(response.getEntity(String.class));
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        throw new ApiException(response.getStatusInfo().getStatusCode(), message);
    }

    private void updateParamsForAuth(String[] authNames, List<Pair> queryParams, Map<String, String> headerParams) {
        for (String authName : authNames) {
            Authentication auth = this.authentications.get(authName);
            if (auth == null) {
                throw new RuntimeException("Authentication undefined: " + authName);
            }
            auth.applyToParams(queryParams, headerParams);
        }
    }

    private String getXWWWFormUrlencodedParams(Map<String, Object> formParams) {
        StringBuilder formParamBuilder = new StringBuilder();
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            String keyStr = param.getKey();
            String valueStr = this.parameterToString(param.getValue());
            try {
                formParamBuilder.append(URLEncoder.encode(param.getKey(), "utf8")).append("=").append(URLEncoder.encode(valueStr, "utf8"));
                formParamBuilder.append("&");
            }
            catch (UnsupportedEncodingException e) {}
        }
        String encodedFormParams = formParamBuilder.toString();
        if (encodedFormParams.endsWith("&")) {
            encodedFormParams = encodedFormParams.substring(0, encodedFormParams.length() - 1);
        }
        return encodedFormParams;
    }

    private Client getClient() {
        if (!this.hostMap.containsKey(this.basePath)) {
            Client client = Client.create();
            if (this.debugging) {
                client.addFilter((ClientFilter)new LoggingFilter());
            }
            this.hostMap.put(this.basePath, client);
        }
        return this.hostMap.get(this.basePath);
    }
}

