/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.client;

import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.TypeRef;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import java.io.IOException;
import java.text.DateFormat;

public class JSON {
    private ObjectMapper mapper = new ObjectMapper();

    public JSON() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        this.mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        this.mapper.registerModule((Module)new JodaModule());
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.mapper.setDateFormat(dateFormat);
    }

    public String serialize(Object obj) throws ApiException {
        try {
            if (obj != null) {
                return this.mapper.writeValueAsString(obj);
            }
            return null;
        }
        catch (Exception e) {
            throw new ApiException(400, e.getMessage());
        }
    }

    public <T> T deserialize(String body, TypeRef returnType) throws ApiException {
        JavaType javaType = this.mapper.constructType(returnType.getType());
        try {
            return (T)this.mapper.readValue(body, javaType);
        }
        catch (IOException e) {
            if (returnType.getType().equals(String.class)) {
                return (T)body;
            }
            throw new ApiException(500, e.getMessage(), null, body);
        }
    }
}

