/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.client.StringUtil;
import com.docusign.esign.model.Attachment;
import com.docusign.esign.model.AuthenticationStatus;
import com.docusign.esign.model.ErrorDetails;
import com.docusign.esign.model.IdCheckInformationInput;
import com.docusign.esign.model.RecipientEmailNotification;
import com.docusign.esign.model.RecipientPhoneAuthentication;
import com.docusign.esign.model.RecipientSAMLAuthentication;
import com.docusign.esign.model.RecipientSMSAuthentication;
import com.docusign.esign.model.SocialAuthentication;
import com.docusign.esign.model.UserInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class Agent {
    private List<String> excludedDocuments = new ArrayList<String>();
    private String name = null;
    private String email = null;
    private String emailRecipientPostSigningURL = null;
    private String signingGroupId = null;
    private String signingGroupName = null;
    private List<UserInfo> signingGroupUsers = new ArrayList<UserInfo>();
    private String recipientId = null;
    private String recipientIdGuid = null;
    private String accessCode = null;
    private String addAccessCodeToEmail = null;
    private String requireIdLookup = null;
    private String idCheckConfigurationName = null;
    private List<SocialAuthentication> socialAuthentications = new ArrayList<SocialAuthentication>();
    private RecipientPhoneAuthentication phoneAuthentication = null;
    private RecipientSAMLAuthentication samlAuthentication = null;
    private RecipientSMSAuthentication smsAuthentication = null;
    private String userId = null;
    private String clientUserId = null;
    private String embeddedRecipientStartURL = null;
    private List<String> customFields = new ArrayList<String>();
    private String routingOrder = null;
    private IdCheckInformationInput idCheckInformationInput = null;
    private List<Attachment> recipientAttachments = new ArrayList<Attachment>();
    private String note = null;
    private String roleName = null;
    private String status = null;
    private String signedDateTime = null;
    private String deliveredDateTime = null;
    private String declinedDateTime = null;
    private String sentDateTime = null;
    private String declinedReason = null;
    private String deliveryMethod = null;
    private String faxNumber = null;
    private String templateLocked = null;
    private String templateRequired = null;
    private RecipientEmailNotification emailNotification = null;
    private String inheritEmailNotificationConfiguration = null;
    private ErrorDetails errorDetails = null;
    private AuthenticationStatus recipientAuthenticationStatus = null;
    private String totalTabCount = null;

    @ApiModelProperty(value="Specifies the documents that are not visible to this recipient. Document Visibility must be enabled for the account and the `enforceSignerVisibility` property must be set to **true** for the envelope to use this.\n\nWhen enforce signer visibility is enabled, documents with tabs can only be viewed by signers that have a tab on that document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all the documents in an envelope, unless they are specifically excluded using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded using this setting when an envelope is sent.")
    @JsonProperty(value="excludedDocuments")
    public List<String> getExcludedDocuments() {
        return this.excludedDocuments;
    }

    public void setExcludedDocuments(List<String> excludedDocuments) {
        this.excludedDocuments = excludedDocuments;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="Email id of the recipient. Notification of the document to sign is sent to this email id. \n\nMaximum length: 100 characters.")
    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="emailRecipientPostSigningURL")
    public String getEmailRecipientPostSigningURL() {
        return this.emailRecipientPostSigningURL;
    }

    public void setEmailRecipientPostSigningURL(String emailRecipientPostSigningURL) {
        this.emailRecipientPostSigningURL = emailRecipientPostSigningURL;
    }

    @ApiModelProperty(value="When set to **true** and the feature is enabled in the sender's account, the signing recipient is required to draw signatures and initials at each signature/initial tab ( instead of adopting a signature/initial style or only drawing a signature/initial once).")
    @JsonProperty(value="signingGroupId")
    public String getSigningGroupId() {
        return this.signingGroupId;
    }

    public void setSigningGroupId(String signingGroupId) {
        this.signingGroupId = signingGroupId;
    }

    @ApiModelProperty(value="The display name for the signing group. \n\nMaximum Length: 100 characters.")
    @JsonProperty(value="signingGroupName")
    public String getSigningGroupName() {
        return this.signingGroupName;
    }

    public void setSigningGroupName(String signingGroupName) {
        this.signingGroupName = signingGroupName;
    }

    @ApiModelProperty(value="A complex type that contains information about users in the signing group.")
    @JsonProperty(value="signingGroupUsers")
    public List<UserInfo> getSigningGroupUsers() {
        return this.signingGroupUsers;
    }

    public void setSigningGroupUsers(List<UserInfo> signingGroupUsers) {
        this.signingGroupUsers = signingGroupUsers;
    }

    @ApiModelProperty(value="Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.")
    @JsonProperty(value="recipientId")
    public String getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(String recipientId) {
        this.recipientId = recipientId;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="recipientIdGuid")
    public String getRecipientIdGuid() {
        return this.recipientIdGuid;
    }

    public void setRecipientIdGuid(String recipientIdGuid) {
        this.recipientIdGuid = recipientIdGuid;
    }

    @ApiModelProperty(value="If a value is provided, the recipient must enter the value as the access code to view and sign the envelope. \n\nMaximum Length: 50 characters and must conform to account\u2019s access code format setting.\n\nIf blank, but the signer `accessCode` property is set in the envelope, then that value is used.\n\nIf blank and the signer `accessCode` property is not set, then access code is not required.")
    @JsonProperty(value="accessCode")
    public String getAccessCode() {
        return this.accessCode;
    }

    public void setAccessCode(String accessCode) {
        this.accessCode = accessCode;
    }

    @ApiModelProperty(value="This Optional attribute indicates that the access code will be added to the email sent to the recipient; this nullifies the Security measure of Access Code on the recipient.")
    @JsonProperty(value="addAccessCodeToEmail")
    public String getAddAccessCodeToEmail() {
        return this.addAccessCodeToEmail;
    }

    public void setAddAccessCodeToEmail(String addAccessCodeToEmail) {
        this.addAccessCodeToEmail = addAccessCodeToEmail;
    }

    @ApiModelProperty(value="When set to **true**, the recipient is required to use the specified ID check method (including Phone and SMS authentication) to validate their identity.")
    @JsonProperty(value="requireIdLookup")
    public String getRequireIdLookup() {
        return this.requireIdLookup;
    }

    public void setRequireIdLookup(String requireIdLookup) {
        this.requireIdLookup = requireIdLookup;
    }

    @ApiModelProperty(value="Specifies authentication check by name. The names used here must be the same as the authentication type names used by the account (these name can also be found in the web console sending interface in the Identify list for a recipient,) This overrides any default authentication setting.\n\n*Example*: Your account has ID Check and SMS Authentication available and in the web console Identify list these appear as 'ID Check $' and 'SMS Auth $'. To use ID check in an envelope, the idCheckConfigurationName should be 'ID Check '. If you wanted to use SMS, it would be 'SMS Auth $' and you would need to add you would need to add phone number information to the `smsAuthentication` node.")
    @JsonProperty(value="idCheckConfigurationName")
    public String getIdCheckConfigurationName() {
        return this.idCheckConfigurationName;
    }

    public void setIdCheckConfigurationName(String idCheckConfigurationName) {
        this.idCheckConfigurationName = idCheckConfigurationName;
    }

    @ApiModelProperty(value="Lists the social ID type that can be used for recipient authentication.")
    @JsonProperty(value="socialAuthentications")
    public List<SocialAuthentication> getSocialAuthentications() {
        return this.socialAuthentications;
    }

    public void setSocialAuthentications(List<SocialAuthentication> socialAuthentications) {
        this.socialAuthentications = socialAuthentications;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="phoneAuthentication")
    public RecipientPhoneAuthentication getPhoneAuthentication() {
        return this.phoneAuthentication;
    }

    public void setPhoneAuthentication(RecipientPhoneAuthentication phoneAuthentication) {
        this.phoneAuthentication = phoneAuthentication;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="samlAuthentication")
    public RecipientSAMLAuthentication getSamlAuthentication() {
        return this.samlAuthentication;
    }

    public void setSamlAuthentication(RecipientSAMLAuthentication samlAuthentication) {
        this.samlAuthentication = samlAuthentication;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="smsAuthentication")
    public RecipientSMSAuthentication getSmsAuthentication() {
        return this.smsAuthentication;
    }

    public void setSmsAuthentication(RecipientSMSAuthentication smsAuthentication) {
        this.smsAuthentication = smsAuthentication;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @ApiModelProperty(value="Specifies whether the recipient is embedded or remote. \n\nIf the `clientUserId` property is not null then the recipient is embedded. Note that if the `ClientUserId` property is set and either `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to  **true**, an error is generated on sending.ng. \n\nMaximum length: 100 characters.")
    @JsonProperty(value="clientUserId")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    @ApiModelProperty(value="Specifies a sender provided valid URL string for redirecting an embedded recipient. When using this option, the embedded recipient still receives an email from DocuSign, just as a remote recipient would. When the document link in the email is clicked the recipient is redirected, through DocuSign, to the supplied URL to complete their actions. When routing to the URL, the sender\u2019s system (the server responding to the URL) must request a recipient token to launch a signing session. \n\nIf set to `SIGN_AT_DOCUSIGN`, the recipient is directed to an embedded signing or viewing process directly at DocuSign. The signing or viewing action is initiated by the DocuSign system and the transaction activity and Certificate of Completion records will reflect this. In all other ways the process is identical to an embedded signing or viewing operation that is launched by any partner.\n\nIt is important to remember that in a typical embedded workflow the authentication of an embedded recipient is the responsibility of the sending application, DocuSign expects that senders will follow their own process for establishing the recipient\u2019s identity. In this workflow the recipient goes through the sending application before the embedded signing or viewing process in initiated. However, when the sending application sets `EmbeddedRecipientStartURL=SIGN_AT_DOCUSIGN`, the recipient goes directly to the embedded signing or viewing process bypassing the sending application and any authentication steps the sending application would use. In this case, DocuSign recommends that you use one of the normal DocuSign authentication features (Access Code, Phone Authentication, SMS Authentication, etc.) to verify the identity of the recipient.\n\nIf the `clientUserId` property is NOT set, and the `embeddedRecipientStartURL` is set, DocuSign will ignore the redirect URL and launch the standard signing process for the email recipient. Information can be appended to the embedded recipient start URL using merge fields. The available merge fields items are: envelopeId, recipientId, recipientName, recipientEmail, and customFields. The `customFields` property must be set fort the recipient or envelope. The merge fields are enclosed in double brackets. \n\n*Example*: \n\n`http://senderHost/[[mergeField1]]/ beginSigningSession? [[mergeField2]]&[[mergeField3]]`")
    @JsonProperty(value="embeddedRecipientStartURL")
    public String getEmbeddedRecipientStartURL() {
        return this.embeddedRecipientStartURL;
    }

    public void setEmbeddedRecipientStartURL(String embeddedRecipientStartURL) {
        this.embeddedRecipientStartURL = embeddedRecipientStartURL;
    }

    @ApiModelProperty(value="An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.")
    @JsonProperty(value="customFields")
    public List<String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(List<String> customFields) {
        this.customFields = customFields;
    }

    @ApiModelProperty(value="Specifies the routing order of the recipient in the envelope.")
    @JsonProperty(value="routingOrder")
    public String getRoutingOrder() {
        return this.routingOrder;
    }

    public void setRoutingOrder(String routingOrder) {
        this.routingOrder = routingOrder;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="idCheckInformationInput")
    public IdCheckInformationInput getIdCheckInformationInput() {
        return this.idCheckInformationInput;
    }

    public void setIdCheckInformationInput(IdCheckInformationInput idCheckInformationInput) {
        this.idCheckInformationInput = idCheckInformationInput;
    }

    @ApiModelProperty(value="Reserved:")
    @JsonProperty(value="recipientAttachments")
    public List<Attachment> getRecipientAttachments() {
        return this.recipientAttachments;
    }

    public void setRecipientAttachments(List<Attachment> recipientAttachments) {
        this.recipientAttachments = recipientAttachments;
    }

    @ApiModelProperty(value="Specifies a note that is unique to this recipient. This note is sent to the recipient via the signing email. The note displays in the signing UI near the upper left corner of the document on the signing screen.\n\nMaximum Length: 1000 characters.")
    @JsonProperty(value="note")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    @ApiModelProperty(value="Optional element. Specifies the role name associated with the recipient.<br/><br/>This is required when working with template recipients.")
    @JsonProperty(value="roleName")
    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    @ApiModelProperty(value="Indicates the envelope status. Valid values are:\n\n* sent - The envelope is sent to the recipients. \n* created - The envelope is saved as a draft and can be modified and sent later.")
    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @ApiModelProperty(value="Reserved: For DocuSign use only.")
    @JsonProperty(value="signedDateTime")
    public String getSignedDateTime() {
        return this.signedDateTime;
    }

    public void setSignedDateTime(String signedDateTime) {
        this.signedDateTime = signedDateTime;
    }

    @ApiModelProperty(value="Reserved: For DocuSign use only.")
    @JsonProperty(value="deliveredDateTime")
    public String getDeliveredDateTime() {
        return this.deliveredDateTime;
    }

    public void setDeliveredDateTime(String deliveredDateTime) {
        this.deliveredDateTime = deliveredDateTime;
    }

    @ApiModelProperty(value="The date and time the recipient declined the document.")
    @JsonProperty(value="declinedDateTime")
    public String getDeclinedDateTime() {
        return this.declinedDateTime;
    }

    public void setDeclinedDateTime(String declinedDateTime) {
        this.declinedDateTime = declinedDateTime;
    }

    @ApiModelProperty(value="The date and time the envelope was sent.")
    @JsonProperty(value="sentDateTime")
    public String getSentDateTime() {
        return this.sentDateTime;
    }

    public void setSentDateTime(String sentDateTime) {
        this.sentDateTime = sentDateTime;
    }

    @ApiModelProperty(value="The reason the recipient declined the document.")
    @JsonProperty(value="declinedReason")
    public String getDeclinedReason() {
        return this.declinedReason;
    }

    public void setDeclinedReason(String declinedReason) {
        this.declinedReason = declinedReason;
    }

    @ApiModelProperty(value="Reserved: For DocuSign use only.")
    @JsonProperty(value="deliveryMethod")
    public String getDeliveryMethod() {
        return this.deliveryMethod;
    }

    public void setDeliveryMethod(String deliveryMethod) {
        this.deliveryMethod = deliveryMethod;
    }

    @ApiModelProperty(value="Reserved:")
    @JsonProperty(value="faxNumber")
    public String getFaxNumber() {
        return this.faxNumber;
    }

    public void setFaxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
    }

    @ApiModelProperty(value="When set to **true**, the sender cannot change any attributes of the recipient. Used only when working with template recipients.")
    @JsonProperty(value="templateLocked")
    public String getTemplateLocked() {
        return this.templateLocked;
    }

    public void setTemplateLocked(String templateLocked) {
        this.templateLocked = templateLocked;
    }

    @ApiModelProperty(value="When set to **true**, the sender may not remove the recipient. Used only when working with template recipients.")
    @JsonProperty(value="templateRequired")
    public String getTemplateRequired() {
        return this.templateRequired;
    }

    public void setTemplateRequired(String templateRequired) {
        this.templateRequired = templateRequired;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="emailNotification")
    public RecipientEmailNotification getEmailNotification() {
        return this.emailNotification;
    }

    public void setEmailNotification(RecipientEmailNotification emailNotification) {
        this.emailNotification = emailNotification;
    }

    @ApiModelProperty(value="When set to **true** and the envelope recipient creates a DocuSign account after signing, the Manage Account Email Notification settings are used as the default settings for the recipient's account.")
    @JsonProperty(value="inheritEmailNotificationConfiguration")
    public String getInheritEmailNotificationConfiguration() {
        return this.inheritEmailNotificationConfiguration;
    }

    public void setInheritEmailNotificationConfiguration(String inheritEmailNotificationConfiguration) {
        this.inheritEmailNotificationConfiguration = inheritEmailNotificationConfiguration;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="errorDetails")
    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="recipientAuthenticationStatus")
    public AuthenticationStatus getRecipientAuthenticationStatus() {
        return this.recipientAuthenticationStatus;
    }

    public void setRecipientAuthenticationStatus(AuthenticationStatus recipientAuthenticationStatus) {
        this.recipientAuthenticationStatus = recipientAuthenticationStatus;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="totalTabCount")
    public String getTotalTabCount() {
        return this.totalTabCount;
    }

    public void setTotalTabCount(String totalTabCount) {
        this.totalTabCount = totalTabCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Agent agent = (Agent)o;
        return Objects.equals(this.excludedDocuments, agent.excludedDocuments) && Objects.equals(this.name, agent.name) && Objects.equals(this.email, agent.email) && Objects.equals(this.emailRecipientPostSigningURL, agent.emailRecipientPostSigningURL) && Objects.equals(this.signingGroupId, agent.signingGroupId) && Objects.equals(this.signingGroupName, agent.signingGroupName) && Objects.equals(this.signingGroupUsers, agent.signingGroupUsers) && Objects.equals(this.recipientId, agent.recipientId) && Objects.equals(this.recipientIdGuid, agent.recipientIdGuid) && Objects.equals(this.accessCode, agent.accessCode) && Objects.equals(this.addAccessCodeToEmail, agent.addAccessCodeToEmail) && Objects.equals(this.requireIdLookup, agent.requireIdLookup) && Objects.equals(this.idCheckConfigurationName, agent.idCheckConfigurationName) && Objects.equals(this.socialAuthentications, agent.socialAuthentications) && Objects.equals(this.phoneAuthentication, agent.phoneAuthentication) && Objects.equals(this.samlAuthentication, agent.samlAuthentication) && Objects.equals(this.smsAuthentication, agent.smsAuthentication) && Objects.equals(this.userId, agent.userId) && Objects.equals(this.clientUserId, agent.clientUserId) && Objects.equals(this.embeddedRecipientStartURL, agent.embeddedRecipientStartURL) && Objects.equals(this.customFields, agent.customFields) && Objects.equals(this.routingOrder, agent.routingOrder) && Objects.equals(this.idCheckInformationInput, agent.idCheckInformationInput) && Objects.equals(this.recipientAttachments, agent.recipientAttachments) && Objects.equals(this.note, agent.note) && Objects.equals(this.roleName, agent.roleName) && Objects.equals(this.status, agent.status) && Objects.equals(this.signedDateTime, agent.signedDateTime) && Objects.equals(this.deliveredDateTime, agent.deliveredDateTime) && Objects.equals(this.declinedDateTime, agent.declinedDateTime) && Objects.equals(this.sentDateTime, agent.sentDateTime) && Objects.equals(this.declinedReason, agent.declinedReason) && Objects.equals(this.deliveryMethod, agent.deliveryMethod) && Objects.equals(this.faxNumber, agent.faxNumber) && Objects.equals(this.templateLocked, agent.templateLocked) && Objects.equals(this.templateRequired, agent.templateRequired) && Objects.equals(this.emailNotification, agent.emailNotification) && Objects.equals(this.inheritEmailNotificationConfiguration, agent.inheritEmailNotificationConfiguration) && Objects.equals(this.errorDetails, agent.errorDetails) && Objects.equals(this.recipientAuthenticationStatus, agent.recipientAuthenticationStatus) && Objects.equals(this.totalTabCount, agent.totalTabCount);
    }

    public int hashCode() {
        return Objects.hash(this.excludedDocuments, this.name, this.email, this.emailRecipientPostSigningURL, this.signingGroupId, this.signingGroupName, this.signingGroupUsers, this.recipientId, this.recipientIdGuid, this.accessCode, this.addAccessCodeToEmail, this.requireIdLookup, this.idCheckConfigurationName, this.socialAuthentications, this.phoneAuthentication, this.samlAuthentication, this.smsAuthentication, this.userId, this.clientUserId, this.embeddedRecipientStartURL, this.customFields, this.routingOrder, this.idCheckInformationInput, this.recipientAttachments, this.note, this.roleName, this.status, this.signedDateTime, this.deliveredDateTime, this.declinedDateTime, this.sentDateTime, this.declinedReason, this.deliveryMethod, this.faxNumber, this.templateLocked, this.templateRequired, this.emailNotification, this.inheritEmailNotificationConfiguration, this.errorDetails, this.recipientAuthenticationStatus, this.totalTabCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Agent {\n");
        sb.append("    excludedDocuments: ").append(StringUtil.toIndentedString(this.excludedDocuments)).append("\n");
        sb.append("    name: ").append(StringUtil.toIndentedString(this.name)).append("\n");
        sb.append("    email: ").append(StringUtil.toIndentedString(this.email)).append("\n");
        sb.append("    emailRecipientPostSigningURL: ").append(StringUtil.toIndentedString(this.emailRecipientPostSigningURL)).append("\n");
        sb.append("    signingGroupId: ").append(StringUtil.toIndentedString(this.signingGroupId)).append("\n");
        sb.append("    signingGroupName: ").append(StringUtil.toIndentedString(this.signingGroupName)).append("\n");
        sb.append("    signingGroupUsers: ").append(StringUtil.toIndentedString(this.signingGroupUsers)).append("\n");
        sb.append("    recipientId: ").append(StringUtil.toIndentedString(this.recipientId)).append("\n");
        sb.append("    recipientIdGuid: ").append(StringUtil.toIndentedString(this.recipientIdGuid)).append("\n");
        sb.append("    accessCode: ").append(StringUtil.toIndentedString(this.accessCode)).append("\n");
        sb.append("    addAccessCodeToEmail: ").append(StringUtil.toIndentedString(this.addAccessCodeToEmail)).append("\n");
        sb.append("    requireIdLookup: ").append(StringUtil.toIndentedString(this.requireIdLookup)).append("\n");
        sb.append("    idCheckConfigurationName: ").append(StringUtil.toIndentedString(this.idCheckConfigurationName)).append("\n");
        sb.append("    socialAuthentications: ").append(StringUtil.toIndentedString(this.socialAuthentications)).append("\n");
        sb.append("    phoneAuthentication: ").append(StringUtil.toIndentedString(this.phoneAuthentication)).append("\n");
        sb.append("    samlAuthentication: ").append(StringUtil.toIndentedString(this.samlAuthentication)).append("\n");
        sb.append("    smsAuthentication: ").append(StringUtil.toIndentedString(this.smsAuthentication)).append("\n");
        sb.append("    userId: ").append(StringUtil.toIndentedString(this.userId)).append("\n");
        sb.append("    clientUserId: ").append(StringUtil.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    embeddedRecipientStartURL: ").append(StringUtil.toIndentedString(this.embeddedRecipientStartURL)).append("\n");
        sb.append("    customFields: ").append(StringUtil.toIndentedString(this.customFields)).append("\n");
        sb.append("    routingOrder: ").append(StringUtil.toIndentedString(this.routingOrder)).append("\n");
        sb.append("    idCheckInformationInput: ").append(StringUtil.toIndentedString(this.idCheckInformationInput)).append("\n");
        sb.append("    recipientAttachments: ").append(StringUtil.toIndentedString(this.recipientAttachments)).append("\n");
        sb.append("    note: ").append(StringUtil.toIndentedString(this.note)).append("\n");
        sb.append("    roleName: ").append(StringUtil.toIndentedString(this.roleName)).append("\n");
        sb.append("    status: ").append(StringUtil.toIndentedString(this.status)).append("\n");
        sb.append("    signedDateTime: ").append(StringUtil.toIndentedString(this.signedDateTime)).append("\n");
        sb.append("    deliveredDateTime: ").append(StringUtil.toIndentedString(this.deliveredDateTime)).append("\n");
        sb.append("    declinedDateTime: ").append(StringUtil.toIndentedString(this.declinedDateTime)).append("\n");
        sb.append("    sentDateTime: ").append(StringUtil.toIndentedString(this.sentDateTime)).append("\n");
        sb.append("    declinedReason: ").append(StringUtil.toIndentedString(this.declinedReason)).append("\n");
        sb.append("    deliveryMethod: ").append(StringUtil.toIndentedString(this.deliveryMethod)).append("\n");
        sb.append("    faxNumber: ").append(StringUtil.toIndentedString(this.faxNumber)).append("\n");
        sb.append("    templateLocked: ").append(StringUtil.toIndentedString(this.templateLocked)).append("\n");
        sb.append("    templateRequired: ").append(StringUtil.toIndentedString(this.templateRequired)).append("\n");
        sb.append("    emailNotification: ").append(StringUtil.toIndentedString(this.emailNotification)).append("\n");
        sb.append("    inheritEmailNotificationConfiguration: ").append(StringUtil.toIndentedString(this.inheritEmailNotificationConfiguration)).append("\n");
        sb.append("    errorDetails: ").append(StringUtil.toIndentedString(this.errorDetails)).append("\n");
        sb.append("    recipientAuthenticationStatus: ").append(StringUtil.toIndentedString(this.recipientAuthenticationStatus)).append("\n");
        sb.append("    totalTabCount: ").append(StringUtil.toIndentedString(this.totalTabCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

