/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.client.StringUtil;
import com.docusign.esign.model.ErrorDetails;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="")
public class BulkEnvelope {
    private String transactionId = null;
    private String submittedDateTime = null;
    private String envelopeId = null;
    private String envelopeUri = null;
    private String bulkRecipientRow = null;
    private String name = null;
    private String email = null;
    private String bulkStatus = null;
    private ErrorDetails errorDetails = null;

    @ApiModelProperty(value="Used to identify an envelope. The id is a sender-generated value and is valid in the DocuSign system for 7 days. It is recommended that a transaction ID is used for offline signing to ensure that an envelope is not sent multiple times. The `transactionId` property can be used determine if an envelope status (i.e. was created or not) for cases where an internet connection was lost before the envelope status could be returned.")
    @JsonProperty(value="transactionId")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="submittedDateTime")
    public String getSubmittedDateTime() {
        return this.submittedDateTime;
    }

    public void setSubmittedDateTime(String submittedDateTime) {
        this.submittedDateTime = submittedDateTime;
    }

    @ApiModelProperty(value="The envelope ID of the envelope status that failed to post.")
    @JsonProperty(value="envelopeId")
    public String getEnvelopeId() {
        return this.envelopeId;
    }

    public void setEnvelopeId(String envelopeId) {
        this.envelopeId = envelopeId;
    }

    @ApiModelProperty(value="Contains a URI for an endpoint that you can use to retrieve the envelope or envelopes.")
    @JsonProperty(value="envelopeUri")
    public String getEnvelopeUri() {
        return this.envelopeUri;
    }

    public void setEnvelopeUri(String envelopeUri) {
        this.envelopeUri = envelopeUri;
    }

    @ApiModelProperty(value="Reserved: TBD")
    @JsonProperty(value="bulkRecipientRow")
    public String getBulkRecipientRow() {
        return this.bulkRecipientRow;
    }

    public void setBulkRecipientRow(String bulkRecipientRow) {
        this.bulkRecipientRow = bulkRecipientRow;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="bulkStatus")
    public String getBulkStatus() {
        return this.bulkStatus;
    }

    public void setBulkStatus(String bulkStatus) {
        this.bulkStatus = bulkStatus;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="errorDetails")
    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkEnvelope bulkEnvelope = (BulkEnvelope)o;
        return Objects.equals(this.transactionId, bulkEnvelope.transactionId) && Objects.equals(this.submittedDateTime, bulkEnvelope.submittedDateTime) && Objects.equals(this.envelopeId, bulkEnvelope.envelopeId) && Objects.equals(this.envelopeUri, bulkEnvelope.envelopeUri) && Objects.equals(this.bulkRecipientRow, bulkEnvelope.bulkRecipientRow) && Objects.equals(this.name, bulkEnvelope.name) && Objects.equals(this.email, bulkEnvelope.email) && Objects.equals(this.bulkStatus, bulkEnvelope.bulkStatus) && Objects.equals(this.errorDetails, bulkEnvelope.errorDetails);
    }

    public int hashCode() {
        return Objects.hash(this.transactionId, this.submittedDateTime, this.envelopeId, this.envelopeUri, this.bulkRecipientRow, this.name, this.email, this.bulkStatus, this.errorDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkEnvelope {\n");
        sb.append("    transactionId: ").append(StringUtil.toIndentedString(this.transactionId)).append("\n");
        sb.append("    submittedDateTime: ").append(StringUtil.toIndentedString(this.submittedDateTime)).append("\n");
        sb.append("    envelopeId: ").append(StringUtil.toIndentedString(this.envelopeId)).append("\n");
        sb.append("    envelopeUri: ").append(StringUtil.toIndentedString(this.envelopeUri)).append("\n");
        sb.append("    bulkRecipientRow: ").append(StringUtil.toIndentedString(this.bulkRecipientRow)).append("\n");
        sb.append("    name: ").append(StringUtil.toIndentedString(this.name)).append("\n");
        sb.append("    email: ").append(StringUtil.toIndentedString(this.email)).append("\n");
        sb.append("    bulkStatus: ").append(StringUtil.toIndentedString(this.bulkStatus)).append("\n");
        sb.append("    errorDetails: ").append(StringUtil.toIndentedString(this.errorDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

