/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.client.StringUtil;
import com.docusign.esign.model.Document;
import com.docusign.esign.model.InlineTemplate;
import com.docusign.esign.model.ServerTemplate;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class CompositeTemplate {
    private String compositeTemplateId = null;
    private List<ServerTemplate> serverTemplates = new ArrayList<ServerTemplate>();
    private List<InlineTemplate> inlineTemplates = new ArrayList<InlineTemplate>();
    private String pdfMetaDataTemplateSequence = null;
    private Document document = null;

    @ApiModelProperty(value="Specifies the identify the composite template. It is used as a reference when adding document object information. If used, the document content-disposition must include the composite template ID to which the document should be added. If composite template ID is not specified in the content-disposition, the document is applied based on the value of the `documentId` property only. If no document object is specified, the composite template inherits the first document.")
    @JsonProperty(value="compositeTemplateId")
    public String getCompositeTemplateId() {
        return this.compositeTemplateId;
    }

    public void setCompositeTemplateId(String compositeTemplateId) {
        this.compositeTemplateId = compositeTemplateId;
    }

    @ApiModelProperty(value="0 or more server-side templates and their position in the overlay. If supplied, they are overlaid into the envelope in the order of their Sequence value")
    @JsonProperty(value="serverTemplates")
    public List<ServerTemplate> getServerTemplates() {
        return this.serverTemplates;
    }

    public void setServerTemplates(List<ServerTemplate> serverTemplates) {
        this.serverTemplates = serverTemplates;
    }

    @ApiModelProperty(value="Zero or more inline templates and their position in the overlay. If supplied, they are overlaid into the envelope in the order of their Sequence value.")
    @JsonProperty(value="inlineTemplates")
    public List<InlineTemplate> getInlineTemplates() {
        return this.inlineTemplates;
    }

    public void setInlineTemplates(List<InlineTemplate> inlineTemplates) {
        this.inlineTemplates = inlineTemplates;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="pdfMetaDataTemplateSequence")
    public String getPdfMetaDataTemplateSequence() {
        return this.pdfMetaDataTemplateSequence;
    }

    public void setPdfMetaDataTemplateSequence(String pdfMetaDataTemplateSequence) {
        this.pdfMetaDataTemplateSequence = pdfMetaDataTemplateSequence;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="document")
    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeTemplate compositeTemplate = (CompositeTemplate)o;
        return Objects.equals(this.compositeTemplateId, compositeTemplate.compositeTemplateId) && Objects.equals(this.serverTemplates, compositeTemplate.serverTemplates) && Objects.equals(this.inlineTemplates, compositeTemplate.inlineTemplates) && Objects.equals(this.pdfMetaDataTemplateSequence, compositeTemplate.pdfMetaDataTemplateSequence) && Objects.equals(this.document, compositeTemplate.document);
    }

    public int hashCode() {
        return Objects.hash(this.compositeTemplateId, this.serverTemplates, this.inlineTemplates, this.pdfMetaDataTemplateSequence, this.document);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompositeTemplate {\n");
        sb.append("    compositeTemplateId: ").append(StringUtil.toIndentedString(this.compositeTemplateId)).append("\n");
        sb.append("    serverTemplates: ").append(StringUtil.toIndentedString(this.serverTemplates)).append("\n");
        sb.append("    inlineTemplates: ").append(StringUtil.toIndentedString(this.inlineTemplates)).append("\n");
        sb.append("    pdfMetaDataTemplateSequence: ").append(StringUtil.toIndentedString(this.pdfMetaDataTemplateSequence)).append("\n");
        sb.append("    document: ").append(StringUtil.toIndentedString(this.document)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

