/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.client.StringUtil;
import com.docusign.esign.model.EmailSettings;
import com.docusign.esign.model.LockInformation;
import com.docusign.esign.model.Notification;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="")
public class Envelope {
    private String transactionId = null;
    private String status = null;
    private String documentsUri = null;
    private String recipientsUri = null;
    private String asynchronous = null;
    private String envelopeUri = null;
    private String emailSubject = null;
    private String emailBlurb = null;
    private String envelopeId = null;
    private String signingLocation = null;
    private String customFieldsUri = null;
    private String envelopeIdStamping = null;
    private String authoritativeCopy = null;
    private Notification notification = null;
    private String notificationUri = null;
    private String enforceSignerVisibility = null;
    private String enableWetSign = null;
    private String allowMarkup = null;
    private String allowReassign = null;
    private String createdDateTime = null;
    private String lastModifiedDateTime = null;
    private String deliveredDateTime = null;
    private String sentDateTime = null;
    private String completedDateTime = null;
    private String voidedDateTime = null;
    private String voidedReason = null;
    private String deletedDateTime = null;
    private String declinedDateTime = null;
    private String statusChangedDateTime = null;
    private String documentsCombinedUri = null;
    private String certificateUri = null;
    private String templatesUri = null;
    private String messageLock = null;
    private String recipientsLock = null;
    private String useDisclosure = null;
    private EmailSettings emailSettings = null;
    private String purgeState = null;
    private LockInformation lockInformation = null;
    private String is21CFRPart11 = null;

    @ApiModelProperty(value="Used to identify an envelope. The id is a sender-generated value and is valid in the DocuSign system for 7 days. It is recommended that a transaction ID is used for offline signing to ensure that an envelope is not sent multiple times. The `transactionId` property can be used determine if an envelope status (i.e. was created or not) for cases where an internet connection was lost before the envelope status could be returned.")
    @JsonProperty(value="transactionId")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @ApiModelProperty(value="Indicates the envelope status. Valid values are:\n\n* sent - The envelope is sent to the recipients. \n*created - The envelope is saved as a draft and can be modified and sent later.")
    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @ApiModelProperty(value="Contains a URI for an endpoint that you can use to retrieve the documents.")
    @JsonProperty(value="documentsUri")
    public String getDocumentsUri() {
        return this.documentsUri;
    }

    public void setDocumentsUri(String documentsUri) {
        this.documentsUri = documentsUri;
    }

    @ApiModelProperty(value="Contains a URI for an endpoint that you can use to retrieve the recipients.")
    @JsonProperty(value="recipientsUri")
    public String getRecipientsUri() {
        return this.recipientsUri;
    }

    public void setRecipientsUri(String recipientsUri) {
        this.recipientsUri = recipientsUri;
    }

    @ApiModelProperty(value="When set to **true**, the envelope is queued for processing and the value of the `status` property is set to 'Processing'. Additionally, get status calls return 'Processing' until completed.")
    @JsonProperty(value="asynchronous")
    public String getAsynchronous() {
        return this.asynchronous;
    }

    public void setAsynchronous(String asynchronous) {
        this.asynchronous = asynchronous;
    }

    @ApiModelProperty(value="Contains a URI for an endpoint that you can use to retrieve the envelope or envelopes.")
    @JsonProperty(value="envelopeUri")
    public String getEnvelopeUri() {
        return this.envelopeUri;
    }

    public void setEnvelopeUri(String envelopeUri) {
        this.envelopeUri = envelopeUri;
    }

    @ApiModelProperty(value="Specifies the subject of the email that is sent to all recipients.\n\nSee [ML:Template Email Subject Merge Fields] for information about adding merge field information to the email subject.")
    @JsonProperty(value="emailSubject")
    public String getEmailSubject() {
        return this.emailSubject;
    }

    public void setEmailSubject(String emailSubject) {
        this.emailSubject = emailSubject;
    }

    @ApiModelProperty(value="This is the same as the email body. If specified it is included in email body for all envelope recipients.")
    @JsonProperty(value="emailBlurb")
    public String getEmailBlurb() {
        return this.emailBlurb;
    }

    public void setEmailBlurb(String emailBlurb) {
        this.emailBlurb = emailBlurb;
    }

    @ApiModelProperty(value="The envelope ID of the envelope status that failed to post.")
    @JsonProperty(value="envelopeId")
    public String getEnvelopeId() {
        return this.envelopeId;
    }

    public void setEnvelopeId(String envelopeId) {
        this.envelopeId = envelopeId;
    }

    @ApiModelProperty(value="Specifies the physical location where the signing takes place. It can have two enumeration values; InPerson and Online. The default value is Online.")
    @JsonProperty(value="signingLocation")
    public String getSigningLocation() {
        return this.signingLocation;
    }

    public void setSigningLocation(String signingLocation) {
        this.signingLocation = signingLocation;
    }

    @ApiModelProperty(value="Contains a URI for an endpoint that you can use to retrieve the custom fields.")
    @JsonProperty(value="customFieldsUri")
    public String getCustomFieldsUri() {
        return this.customFieldsUri;
    }

    public void setCustomFieldsUri(String customFieldsUri) {
        this.customFieldsUri = customFieldsUri;
    }

    @ApiModelProperty(value="When set to **true**, Envelope ID Stamping is enabled.")
    @JsonProperty(value="envelopeIdStamping")
    public String getEnvelopeIdStamping() {
        return this.envelopeIdStamping;
    }

    public void setEnvelopeIdStamping(String envelopeIdStamping) {
        this.envelopeIdStamping = envelopeIdStamping;
    }

    @ApiModelProperty(value="Specifies the Authoritative copy feature. If set to true the Authoritative copy feature is enabled.")
    @JsonProperty(value="authoritativeCopy")
    public String getAuthoritativeCopy() {
        return this.authoritativeCopy;
    }

    public void setAuthoritativeCopy(String authoritativeCopy) {
        this.authoritativeCopy = authoritativeCopy;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="notification")
    public Notification getNotification() {
        return this.notification;
    }

    public void setNotification(Notification notification) {
        this.notification = notification;
    }

    @ApiModelProperty(value="Contains a URI for an endpoint that you can use to retrieve the notifications.")
    @JsonProperty(value="notificationUri")
    public String getNotificationUri() {
        return this.notificationUri;
    }

    public void setNotificationUri(String notificationUri) {
        this.notificationUri = notificationUri;
    }

    @ApiModelProperty(value="When set to **true**, documents with tabs can only be viewed by signers that have a tab on that document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all the documents in an envelope, unless they are specifically excluded using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded using this setting when an envelope is sent.\n\nYour account must have Document Visibility enabled to use this.")
    @JsonProperty(value="enforceSignerVisibility")
    public String getEnforceSignerVisibility() {
        return this.enforceSignerVisibility;
    }

    public void setEnforceSignerVisibility(String enforceSignerVisibility) {
        this.enforceSignerVisibility = enforceSignerVisibility;
    }

    @ApiModelProperty(value="When set to **true**, the signer is allowed to print the document and sign it on paper.")
    @JsonProperty(value="enableWetSign")
    public String getEnableWetSign() {
        return this.enableWetSign;
    }

    public void setEnableWetSign(String enableWetSign) {
        this.enableWetSign = enableWetSign;
    }

    @ApiModelProperty(value="When set to **true**, Document Markup is enabled for envelope. Account must have Document Markup enabled to use this")
    @JsonProperty(value="allowMarkup")
    public String getAllowMarkup() {
        return this.allowMarkup;
    }

    public void setAllowMarkup(String allowMarkup) {
        this.allowMarkup = allowMarkup;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="allowReassign")
    public String getAllowReassign() {
        return this.allowReassign;
    }

    public void setAllowReassign(String allowReassign) {
        this.allowReassign = allowReassign;
    }

    @ApiModelProperty(value="Indicates the date and time the item was created.")
    @JsonProperty(value="createdDateTime")
    public String getCreatedDateTime() {
        return this.createdDateTime;
    }

    public void setCreatedDateTime(String createdDateTime) {
        this.createdDateTime = createdDateTime;
    }

    @ApiModelProperty(value="The date and time the item was last modified.")
    @JsonProperty(value="lastModifiedDateTime")
    public String getLastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public void setLastModifiedDateTime(String lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
    }

    @ApiModelProperty(value="Reserved: For DocuSign use only.")
    @JsonProperty(value="deliveredDateTime")
    public String getDeliveredDateTime() {
        return this.deliveredDateTime;
    }

    public void setDeliveredDateTime(String deliveredDateTime) {
        this.deliveredDateTime = deliveredDateTime;
    }

    @ApiModelProperty(value="The date and time the envelope was sent.")
    @JsonProperty(value="sentDateTime")
    public String getSentDateTime() {
        return this.sentDateTime;
    }

    public void setSentDateTime(String sentDateTime) {
        this.sentDateTime = sentDateTime;
    }

    @ApiModelProperty(value="Specifies the date and time this item was completed.")
    @JsonProperty(value="completedDateTime")
    public String getCompletedDateTime() {
        return this.completedDateTime;
    }

    public void setCompletedDateTime(String completedDateTime) {
        this.completedDateTime = completedDateTime;
    }

    @ApiModelProperty(value="The date and time the envelope or template was voided.")
    @JsonProperty(value="voidedDateTime")
    public String getVoidedDateTime() {
        return this.voidedDateTime;
    }

    public void setVoidedDateTime(String voidedDateTime) {
        this.voidedDateTime = voidedDateTime;
    }

    @ApiModelProperty(value="The reason the envelope or template was voided.")
    @JsonProperty(value="voidedReason")
    public String getVoidedReason() {
        return this.voidedReason;
    }

    public void setVoidedReason(String voidedReason) {
        this.voidedReason = voidedReason;
    }

    @ApiModelProperty(value="Specifies the data and time the item was deleted.")
    @JsonProperty(value="deletedDateTime")
    public String getDeletedDateTime() {
        return this.deletedDateTime;
    }

    public void setDeletedDateTime(String deletedDateTime) {
        this.deletedDateTime = deletedDateTime;
    }

    @ApiModelProperty(value="The date and time the recipient declined the document.")
    @JsonProperty(value="declinedDateTime")
    public String getDeclinedDateTime() {
        return this.declinedDateTime;
    }

    public void setDeclinedDateTime(String declinedDateTime) {
        this.declinedDateTime = declinedDateTime;
    }

    @ApiModelProperty(value="The data and time the status changed.")
    @JsonProperty(value="statusChangedDateTime")
    public String getStatusChangedDateTime() {
        return this.statusChangedDateTime;
    }

    public void setStatusChangedDateTime(String statusChangedDateTime) {
        this.statusChangedDateTime = statusChangedDateTime;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="documentsCombinedUri")
    public String getDocumentsCombinedUri() {
        return this.documentsCombinedUri;
    }

    public void setDocumentsCombinedUri(String documentsCombinedUri) {
        this.documentsCombinedUri = documentsCombinedUri;
    }

    @ApiModelProperty(value="Retrieves a URI for an endpoint that allows you to easily retrieve certificate information.")
    @JsonProperty(value="certificateUri")
    public String getCertificateUri() {
        return this.certificateUri;
    }

    public void setCertificateUri(String certificateUri) {
        this.certificateUri = certificateUri;
    }

    @ApiModelProperty(value="Contains a URI for an endpoint which you can use to retrieve the templates.")
    @JsonProperty(value="templatesUri")
    public String getTemplatesUri() {
        return this.templatesUri;
    }

    public void setTemplatesUri(String templatesUri) {
        this.templatesUri = templatesUri;
    }

    @ApiModelProperty(value="When set to **true**, prevents senders from changing the contents of `emailBlurb` and `emailSubject` properties for the envelope. \n\nAdditionally, this prevents users from making changes to the contents of `emailBlurb` and `emailSubject` properties when correcting envelopes. \n\nHowever, if the `messageLock` node is set to true**** and the `emailSubject` property is empty, senders and correctors are able to add a subject to the envelope.")
    @JsonProperty(value="messageLock")
    public String getMessageLock() {
        return this.messageLock;
    }

    public void setMessageLock(String messageLock) {
        this.messageLock = messageLock;
    }

    @ApiModelProperty(value="When set to **true**, prevents senders from changing, correcting, or deleting the recipient information for the envelope.")
    @JsonProperty(value="recipientsLock")
    public String getRecipientsLock() {
        return this.recipientsLock;
    }

    public void setRecipientsLock(String recipientsLock) {
        this.recipientsLock = recipientsLock;
    }

    @ApiModelProperty(value="When set to **true**, the disclosure is shown to recipients in accordance with the account\u2019s Electronic Record and Signature Disclosure frequency setting. When set to **false**, the Electronic Record and Signature Disclosure is not shown to any envelope recipients. \n\nIf the `useDisclosure` property is not set, then the account's normal disclosure setting is used and the value of the `useDisclosure` property is not returned in responses when getting envelope information.")
    @JsonProperty(value="useDisclosure")
    public String getUseDisclosure() {
        return this.useDisclosure;
    }

    public void setUseDisclosure(String useDisclosure) {
        this.useDisclosure = useDisclosure;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="emailSettings")
    public EmailSettings getEmailSettings() {
        return this.emailSettings;
    }

    public void setEmailSettings(EmailSettings emailSettings) {
        this.emailSettings = emailSettings;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="purgeState")
    public String getPurgeState() {
        return this.purgeState;
    }

    public void setPurgeState(String purgeState) {
        this.purgeState = purgeState;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="lockInformation")
    public LockInformation getLockInformation() {
        return this.lockInformation;
    }

    public void setLockInformation(LockInformation lockInformation) {
        this.lockInformation = lockInformation;
    }

    @ApiModelProperty(value="When set to **true**, indicates that this module is enabled on the account.")
    @JsonProperty(value="is21CFRPart11")
    public String getIs21CFRPart11() {
        return this.is21CFRPart11;
    }

    public void setIs21CFRPart11(String is21CFRPart11) {
        this.is21CFRPart11 = is21CFRPart11;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Envelope envelope = (Envelope)o;
        return Objects.equals(this.transactionId, envelope.transactionId) && Objects.equals(this.status, envelope.status) && Objects.equals(this.documentsUri, envelope.documentsUri) && Objects.equals(this.recipientsUri, envelope.recipientsUri) && Objects.equals(this.asynchronous, envelope.asynchronous) && Objects.equals(this.envelopeUri, envelope.envelopeUri) && Objects.equals(this.emailSubject, envelope.emailSubject) && Objects.equals(this.emailBlurb, envelope.emailBlurb) && Objects.equals(this.envelopeId, envelope.envelopeId) && Objects.equals(this.signingLocation, envelope.signingLocation) && Objects.equals(this.customFieldsUri, envelope.customFieldsUri) && Objects.equals(this.envelopeIdStamping, envelope.envelopeIdStamping) && Objects.equals(this.authoritativeCopy, envelope.authoritativeCopy) && Objects.equals(this.notification, envelope.notification) && Objects.equals(this.notificationUri, envelope.notificationUri) && Objects.equals(this.enforceSignerVisibility, envelope.enforceSignerVisibility) && Objects.equals(this.enableWetSign, envelope.enableWetSign) && Objects.equals(this.allowMarkup, envelope.allowMarkup) && Objects.equals(this.allowReassign, envelope.allowReassign) && Objects.equals(this.createdDateTime, envelope.createdDateTime) && Objects.equals(this.lastModifiedDateTime, envelope.lastModifiedDateTime) && Objects.equals(this.deliveredDateTime, envelope.deliveredDateTime) && Objects.equals(this.sentDateTime, envelope.sentDateTime) && Objects.equals(this.completedDateTime, envelope.completedDateTime) && Objects.equals(this.voidedDateTime, envelope.voidedDateTime) && Objects.equals(this.voidedReason, envelope.voidedReason) && Objects.equals(this.deletedDateTime, envelope.deletedDateTime) && Objects.equals(this.declinedDateTime, envelope.declinedDateTime) && Objects.equals(this.statusChangedDateTime, envelope.statusChangedDateTime) && Objects.equals(this.documentsCombinedUri, envelope.documentsCombinedUri) && Objects.equals(this.certificateUri, envelope.certificateUri) && Objects.equals(this.templatesUri, envelope.templatesUri) && Objects.equals(this.messageLock, envelope.messageLock) && Objects.equals(this.recipientsLock, envelope.recipientsLock) && Objects.equals(this.useDisclosure, envelope.useDisclosure) && Objects.equals(this.emailSettings, envelope.emailSettings) && Objects.equals(this.purgeState, envelope.purgeState) && Objects.equals(this.lockInformation, envelope.lockInformation) && Objects.equals(this.is21CFRPart11, envelope.is21CFRPart11);
    }

    public int hashCode() {
        return Objects.hash(this.transactionId, this.status, this.documentsUri, this.recipientsUri, this.asynchronous, this.envelopeUri, this.emailSubject, this.emailBlurb, this.envelopeId, this.signingLocation, this.customFieldsUri, this.envelopeIdStamping, this.authoritativeCopy, this.notification, this.notificationUri, this.enforceSignerVisibility, this.enableWetSign, this.allowMarkup, this.allowReassign, this.createdDateTime, this.lastModifiedDateTime, this.deliveredDateTime, this.sentDateTime, this.completedDateTime, this.voidedDateTime, this.voidedReason, this.deletedDateTime, this.declinedDateTime, this.statusChangedDateTime, this.documentsCombinedUri, this.certificateUri, this.templatesUri, this.messageLock, this.recipientsLock, this.useDisclosure, this.emailSettings, this.purgeState, this.lockInformation, this.is21CFRPart11);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Envelope {\n");
        sb.append("    transactionId: ").append(StringUtil.toIndentedString(this.transactionId)).append("\n");
        sb.append("    status: ").append(StringUtil.toIndentedString(this.status)).append("\n");
        sb.append("    documentsUri: ").append(StringUtil.toIndentedString(this.documentsUri)).append("\n");
        sb.append("    recipientsUri: ").append(StringUtil.toIndentedString(this.recipientsUri)).append("\n");
        sb.append("    asynchronous: ").append(StringUtil.toIndentedString(this.asynchronous)).append("\n");
        sb.append("    envelopeUri: ").append(StringUtil.toIndentedString(this.envelopeUri)).append("\n");
        sb.append("    emailSubject: ").append(StringUtil.toIndentedString(this.emailSubject)).append("\n");
        sb.append("    emailBlurb: ").append(StringUtil.toIndentedString(this.emailBlurb)).append("\n");
        sb.append("    envelopeId: ").append(StringUtil.toIndentedString(this.envelopeId)).append("\n");
        sb.append("    signingLocation: ").append(StringUtil.toIndentedString(this.signingLocation)).append("\n");
        sb.append("    customFieldsUri: ").append(StringUtil.toIndentedString(this.customFieldsUri)).append("\n");
        sb.append("    envelopeIdStamping: ").append(StringUtil.toIndentedString(this.envelopeIdStamping)).append("\n");
        sb.append("    authoritativeCopy: ").append(StringUtil.toIndentedString(this.authoritativeCopy)).append("\n");
        sb.append("    notification: ").append(StringUtil.toIndentedString(this.notification)).append("\n");
        sb.append("    notificationUri: ").append(StringUtil.toIndentedString(this.notificationUri)).append("\n");
        sb.append("    enforceSignerVisibility: ").append(StringUtil.toIndentedString(this.enforceSignerVisibility)).append("\n");
        sb.append("    enableWetSign: ").append(StringUtil.toIndentedString(this.enableWetSign)).append("\n");
        sb.append("    allowMarkup: ").append(StringUtil.toIndentedString(this.allowMarkup)).append("\n");
        sb.append("    allowReassign: ").append(StringUtil.toIndentedString(this.allowReassign)).append("\n");
        sb.append("    createdDateTime: ").append(StringUtil.toIndentedString(this.createdDateTime)).append("\n");
        sb.append("    lastModifiedDateTime: ").append(StringUtil.toIndentedString(this.lastModifiedDateTime)).append("\n");
        sb.append("    deliveredDateTime: ").append(StringUtil.toIndentedString(this.deliveredDateTime)).append("\n");
        sb.append("    sentDateTime: ").append(StringUtil.toIndentedString(this.sentDateTime)).append("\n");
        sb.append("    completedDateTime: ").append(StringUtil.toIndentedString(this.completedDateTime)).append("\n");
        sb.append("    voidedDateTime: ").append(StringUtil.toIndentedString(this.voidedDateTime)).append("\n");
        sb.append("    voidedReason: ").append(StringUtil.toIndentedString(this.voidedReason)).append("\n");
        sb.append("    deletedDateTime: ").append(StringUtil.toIndentedString(this.deletedDateTime)).append("\n");
        sb.append("    declinedDateTime: ").append(StringUtil.toIndentedString(this.declinedDateTime)).append("\n");
        sb.append("    statusChangedDateTime: ").append(StringUtil.toIndentedString(this.statusChangedDateTime)).append("\n");
        sb.append("    documentsCombinedUri: ").append(StringUtil.toIndentedString(this.documentsCombinedUri)).append("\n");
        sb.append("    certificateUri: ").append(StringUtil.toIndentedString(this.certificateUri)).append("\n");
        sb.append("    templatesUri: ").append(StringUtil.toIndentedString(this.templatesUri)).append("\n");
        sb.append("    messageLock: ").append(StringUtil.toIndentedString(this.messageLock)).append("\n");
        sb.append("    recipientsLock: ").append(StringUtil.toIndentedString(this.recipientsLock)).append("\n");
        sb.append("    useDisclosure: ").append(StringUtil.toIndentedString(this.useDisclosure)).append("\n");
        sb.append("    emailSettings: ").append(StringUtil.toIndentedString(this.emailSettings)).append("\n");
        sb.append("    purgeState: ").append(StringUtil.toIndentedString(this.purgeState)).append("\n");
        sb.append("    lockInformation: ").append(StringUtil.toIndentedString(this.lockInformation)).append("\n");
        sb.append("    is21CFRPart11: ").append(StringUtil.toIndentedString(this.is21CFRPart11)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

