/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.client.StringUtil;
import com.docusign.esign.model.ErrorDetails;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="")
public class EnvelopeTransactionStatus {
    private String transactionId = null;
    private String envelopeId = null;
    private String status = null;
    private ErrorDetails errorDetails = null;

    @ApiModelProperty(value="Used to identify an envelope. The id is a sender-generated value and is valid in the DocuSign system for 7 days. It is recommended that a transaction ID is used for offline signing to ensure that an envelope is not sent multiple times. The `transactionId` property can be used determine if an envelope status (i.e. was created or not) for cases where an internet connection was lost before the envelope status could be returned.")
    @JsonProperty(value="transactionId")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @ApiModelProperty(value="The envelope ID of the envelope status that failed to post.")
    @JsonProperty(value="envelopeId")
    public String getEnvelopeId() {
        return this.envelopeId;
    }

    public void setEnvelopeId(String envelopeId) {
        this.envelopeId = envelopeId;
    }

    @ApiModelProperty(value="Indicates the envelope status. Valid values are:\n\n* sent - The envelope is sent to the recipients. \n* created - The envelope is saved as a draft and can be modified and sent later.")
    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="errorDetails")
    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvelopeTransactionStatus envelopeTransactionStatus = (EnvelopeTransactionStatus)o;
        return Objects.equals(this.transactionId, envelopeTransactionStatus.transactionId) && Objects.equals(this.envelopeId, envelopeTransactionStatus.envelopeId) && Objects.equals(this.status, envelopeTransactionStatus.status) && Objects.equals(this.errorDetails, envelopeTransactionStatus.errorDetails);
    }

    public int hashCode() {
        return Objects.hash(this.transactionId, this.envelopeId, this.status, this.errorDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EnvelopeTransactionStatus {\n");
        sb.append("    transactionId: ").append(StringUtil.toIndentedString(this.transactionId)).append("\n");
        sb.append("    envelopeId: ").append(StringUtil.toIndentedString(this.envelopeId)).append("\n");
        sb.append("    status: ").append(StringUtil.toIndentedString(this.status)).append("\n");
        sb.append("    errorDetails: ").append(StringUtil.toIndentedString(this.errorDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

