/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.client.StringUtil;
import com.docusign.esign.model.EnvelopeEvent;
import com.docusign.esign.model.RecipientEvent;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class EventNotification {
    private String url = null;
    private String loggingEnabled = null;
    private String requireAcknowledgment = null;
    private List<EnvelopeEvent> envelopeEvents = new ArrayList<EnvelopeEvent>();
    private List<RecipientEvent> recipientEvents = new ArrayList<RecipientEvent>();
    private String useSoapInterface = null;
    private String soapNameSpace = null;
    private String includeCertificateWithSoap = null;
    private String signMessageWithX509Cert = null;
    private String includeDocuments = null;
    private String includeEnvelopeVoidReason = null;
    private String includeTimeZone = null;
    private String includeSenderAccountAsCustomField = null;
    private String includeDocumentFields = null;
    private String includeCertificateOfCompletion = null;

    @ApiModelProperty(value="The endpoint where envelope updates are sent. This will accept XML unless \ufffduseSoapInterface\ufffd is set to true.")
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @ApiModelProperty(value="When set to **true**, logging is turned on for envelope events on the Web Console Connect page.")
    @JsonProperty(value="loggingEnabled")
    public String getLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void setLoggingEnabled(String loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    @ApiModelProperty(value="When set to **true**, the DocuSign Connect service checks that the message was received and retries on failures.")
    @JsonProperty(value="requireAcknowledgment")
    public String getRequireAcknowledgment() {
        return this.requireAcknowledgment;
    }

    public void setRequireAcknowledgment(String requireAcknowledgment) {
        this.requireAcknowledgment = requireAcknowledgment;
    }

    @ApiModelProperty(value="The list of envelope-level events statuses that will trigger Connect to send updates to the url.")
    @JsonProperty(value="envelopeEvents")
    public List<EnvelopeEvent> getEnvelopeEvents() {
        return this.envelopeEvents;
    }

    public void setEnvelopeEvents(List<EnvelopeEvent> envelopeEvents) {
        this.envelopeEvents = envelopeEvents;
    }

    @ApiModelProperty(value="The list of recipient event statuses that will trigger Connect to send updates to the url.")
    @JsonProperty(value="recipientEvents")
    public List<RecipientEvent> getRecipientEvents() {
        return this.recipientEvents;
    }

    public void setRecipientEvents(List<RecipientEvent> recipientEvents) {
        this.recipientEvents = recipientEvents;
    }

    @ApiModelProperty(value="When set to **true**, this tells the Connect service that the user\ufffds endpoint has implemented a SOAP interface.")
    @JsonProperty(value="useSoapInterface")
    public String getUseSoapInterface() {
        return this.useSoapInterface;
    }

    public void setUseSoapInterface(String useSoapInterface) {
        this.useSoapInterface = useSoapInterface;
    }

    @ApiModelProperty(value="This lists the namespace in the SOAP listener provided.")
    @JsonProperty(value="soapNameSpace")
    public String getSoapNameSpace() {
        return this.soapNameSpace;
    }

    public void setSoapNameSpace(String soapNameSpace) {
        this.soapNameSpace = soapNameSpace;
    }

    @ApiModelProperty(value="When set to **true**, this tells the Connect service to send the DocuSign signedby certificate as part of the outgoing SOAP xml. This appears in the XML as wsse:BinarySecurityToken.")
    @JsonProperty(value="includeCertificateWithSoap")
    public String getIncludeCertificateWithSoap() {
        return this.includeCertificateWithSoap;
    }

    public void setIncludeCertificateWithSoap(String includeCertificateWithSoap) {
        this.includeCertificateWithSoap = includeCertificateWithSoap;
    }

    @ApiModelProperty(value="When set to **true**, messages are signed with an X509 certificate. This provides support for 2-way SSL in the envelope.")
    @JsonProperty(value="signMessageWithX509Cert")
    public String getSignMessageWithX509Cert() {
        return this.signMessageWithX509Cert;
    }

    public void setSignMessageWithX509Cert(String signMessageWithX509Cert) {
        this.signMessageWithX509Cert = signMessageWithX509Cert;
    }

    @ApiModelProperty(value="When set to **true**, the PDF documents are included in the message along with the updated XML.")
    @JsonProperty(value="includeDocuments")
    public String getIncludeDocuments() {
        return this.includeDocuments;
    }

    public void setIncludeDocuments(String includeDocuments) {
        this.includeDocuments = includeDocuments;
    }

    @ApiModelProperty(value="When set to **true**, this tells the Connect Service to include the void reason, as entered by the person that voided the envelope, in the message.")
    @JsonProperty(value="includeEnvelopeVoidReason")
    public String getIncludeEnvelopeVoidReason() {
        return this.includeEnvelopeVoidReason;
    }

    public void setIncludeEnvelopeVoidReason(String includeEnvelopeVoidReason) {
        this.includeEnvelopeVoidReason = includeEnvelopeVoidReason;
    }

    @ApiModelProperty(value="When set to **true**, the envelope time zone information is included in the message.")
    @JsonProperty(value="includeTimeZone")
    public String getIncludeTimeZone() {
        return this.includeTimeZone;
    }

    public void setIncludeTimeZone(String includeTimeZone) {
        this.includeTimeZone = includeTimeZone;
    }

    @ApiModelProperty(value="When set to **true**, the sender account ID is included as a envelope custom field in the data.")
    @JsonProperty(value="includeSenderAccountAsCustomField")
    public String getIncludeSenderAccountAsCustomField() {
        return this.includeSenderAccountAsCustomField;
    }

    public void setIncludeSenderAccountAsCustomField(String includeSenderAccountAsCustomField) {
        this.includeSenderAccountAsCustomField = includeSenderAccountAsCustomField;
    }

    @ApiModelProperty(value="When set to **true**, the Document Fields associated with envelope documents are included in the data. Document Fields are optional custom name-value pairs added to documents using the API")
    @JsonProperty(value="includeDocumentFields")
    public String getIncludeDocumentFields() {
        return this.includeDocumentFields;
    }

    public void setIncludeDocumentFields(String includeDocumentFields) {
        this.includeDocumentFields = includeDocumentFields;
    }

    @ApiModelProperty(value="When set to **true**, the Connect Service includes the Certificate of Completion with completed envelopes.")
    @JsonProperty(value="includeCertificateOfCompletion")
    public String getIncludeCertificateOfCompletion() {
        return this.includeCertificateOfCompletion;
    }

    public void setIncludeCertificateOfCompletion(String includeCertificateOfCompletion) {
        this.includeCertificateOfCompletion = includeCertificateOfCompletion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventNotification eventNotification = (EventNotification)o;
        return Objects.equals(this.url, eventNotification.url) && Objects.equals(this.loggingEnabled, eventNotification.loggingEnabled) && Objects.equals(this.requireAcknowledgment, eventNotification.requireAcknowledgment) && Objects.equals(this.envelopeEvents, eventNotification.envelopeEvents) && Objects.equals(this.recipientEvents, eventNotification.recipientEvents) && Objects.equals(this.useSoapInterface, eventNotification.useSoapInterface) && Objects.equals(this.soapNameSpace, eventNotification.soapNameSpace) && Objects.equals(this.includeCertificateWithSoap, eventNotification.includeCertificateWithSoap) && Objects.equals(this.signMessageWithX509Cert, eventNotification.signMessageWithX509Cert) && Objects.equals(this.includeDocuments, eventNotification.includeDocuments) && Objects.equals(this.includeEnvelopeVoidReason, eventNotification.includeEnvelopeVoidReason) && Objects.equals(this.includeTimeZone, eventNotification.includeTimeZone) && Objects.equals(this.includeSenderAccountAsCustomField, eventNotification.includeSenderAccountAsCustomField) && Objects.equals(this.includeDocumentFields, eventNotification.includeDocumentFields) && Objects.equals(this.includeCertificateOfCompletion, eventNotification.includeCertificateOfCompletion);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.loggingEnabled, this.requireAcknowledgment, this.envelopeEvents, this.recipientEvents, this.useSoapInterface, this.soapNameSpace, this.includeCertificateWithSoap, this.signMessageWithX509Cert, this.includeDocuments, this.includeEnvelopeVoidReason, this.includeTimeZone, this.includeSenderAccountAsCustomField, this.includeDocumentFields, this.includeCertificateOfCompletion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventNotification {\n");
        sb.append("    url: ").append(StringUtil.toIndentedString(this.url)).append("\n");
        sb.append("    loggingEnabled: ").append(StringUtil.toIndentedString(this.loggingEnabled)).append("\n");
        sb.append("    requireAcknowledgment: ").append(StringUtil.toIndentedString(this.requireAcknowledgment)).append("\n");
        sb.append("    envelopeEvents: ").append(StringUtil.toIndentedString(this.envelopeEvents)).append("\n");
        sb.append("    recipientEvents: ").append(StringUtil.toIndentedString(this.recipientEvents)).append("\n");
        sb.append("    useSoapInterface: ").append(StringUtil.toIndentedString(this.useSoapInterface)).append("\n");
        sb.append("    soapNameSpace: ").append(StringUtil.toIndentedString(this.soapNameSpace)).append("\n");
        sb.append("    includeCertificateWithSoap: ").append(StringUtil.toIndentedString(this.includeCertificateWithSoap)).append("\n");
        sb.append("    signMessageWithX509Cert: ").append(StringUtil.toIndentedString(this.signMessageWithX509Cert)).append("\n");
        sb.append("    includeDocuments: ").append(StringUtil.toIndentedString(this.includeDocuments)).append("\n");
        sb.append("    includeEnvelopeVoidReason: ").append(StringUtil.toIndentedString(this.includeEnvelopeVoidReason)).append("\n");
        sb.append("    includeTimeZone: ").append(StringUtil.toIndentedString(this.includeTimeZone)).append("\n");
        sb.append("    includeSenderAccountAsCustomField: ").append(StringUtil.toIndentedString(this.includeSenderAccountAsCustomField)).append("\n");
        sb.append("    includeDocumentFields: ").append(StringUtil.toIndentedString(this.includeDocumentFields)).append("\n");
        sb.append("    includeCertificateOfCompletion: ").append(StringUtil.toIndentedString(this.includeCertificateOfCompletion)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

