/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.client.StringUtil;
import com.docusign.esign.model.NameValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class LoginAccount {
    private String name = null;
    private String accountId = null;
    private String accountIdGuid = null;
    private String baseUrl = null;
    private String isDefault = null;
    private String userName = null;
    private String userId = null;
    private String email = null;
    private String siteDescription = null;
    private List<NameValue> loginAccountSettings = new ArrayList<NameValue>();
    private List<NameValue> loginUserSettings = new ArrayList<NameValue>();

    @ApiModelProperty(value="The name associated with the account.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="The account ID associated with the envelope.")
    @JsonProperty(value="accountId")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    @ApiModelProperty(value="The GUID associated with the account ID.")
    @JsonProperty(value="accountIdGuid")
    public String getAccountIdGuid() {
        return this.accountIdGuid;
    }

    public void setAccountIdGuid(String accountIdGuid) {
        this.accountIdGuid = accountIdGuid;
    }

    @ApiModelProperty(value="The URL that should be used for successive calls to this account. It includes the protocal (https), the DocuSign server where the account is located, and the account number. Use this Url to make API calls against this account. Many of the API calls provide Uri's that are relative to this baseUrl.")
    @JsonProperty(value="baseUrl")
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @ApiModelProperty(value="This value is true if this is the default account for the user, otherwise false is returned.")
    @JsonProperty(value="isDefault")
    public String getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(String isDefault) {
        this.isDefault = isDefault;
    }

    @ApiModelProperty(value="The name of this user as defined by the account.")
    @JsonProperty(value="userName")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @ApiModelProperty(value="An optional descirption of the site that hosts the account.")
    @JsonProperty(value="siteDescription")
    public String getSiteDescription() {
        return this.siteDescription;
    }

    public void setSiteDescription(String siteDescription) {
        this.siteDescription = siteDescription;
    }

    @ApiModelProperty(value="A list of settings on the acccount that indicate what features are available.")
    @JsonProperty(value="loginAccountSettings")
    public List<NameValue> getLoginAccountSettings() {
        return this.loginAccountSettings;
    }

    public void setLoginAccountSettings(List<NameValue> loginAccountSettings) {
        this.loginAccountSettings = loginAccountSettings;
    }

    @ApiModelProperty(value="A list of user-level settings that indicate what user-specific features are available.")
    @JsonProperty(value="loginUserSettings")
    public List<NameValue> getLoginUserSettings() {
        return this.loginUserSettings;
    }

    public void setLoginUserSettings(List<NameValue> loginUserSettings) {
        this.loginUserSettings = loginUserSettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoginAccount loginAccount = (LoginAccount)o;
        return Objects.equals(this.name, loginAccount.name) && Objects.equals(this.accountId, loginAccount.accountId) && Objects.equals(this.accountIdGuid, loginAccount.accountIdGuid) && Objects.equals(this.baseUrl, loginAccount.baseUrl) && Objects.equals(this.isDefault, loginAccount.isDefault) && Objects.equals(this.userName, loginAccount.userName) && Objects.equals(this.userId, loginAccount.userId) && Objects.equals(this.email, loginAccount.email) && Objects.equals(this.siteDescription, loginAccount.siteDescription) && Objects.equals(this.loginAccountSettings, loginAccount.loginAccountSettings) && Objects.equals(this.loginUserSettings, loginAccount.loginUserSettings);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.accountId, this.accountIdGuid, this.baseUrl, this.isDefault, this.userName, this.userId, this.email, this.siteDescription, this.loginAccountSettings, this.loginUserSettings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LoginAccount {\n");
        sb.append("    name: ").append(StringUtil.toIndentedString(this.name)).append("\n");
        sb.append("    accountId: ").append(StringUtil.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountIdGuid: ").append(StringUtil.toIndentedString(this.accountIdGuid)).append("\n");
        sb.append("    baseUrl: ").append(StringUtil.toIndentedString(this.baseUrl)).append("\n");
        sb.append("    isDefault: ").append(StringUtil.toIndentedString(this.isDefault)).append("\n");
        sb.append("    userName: ").append(StringUtil.toIndentedString(this.userName)).append("\n");
        sb.append("    userId: ").append(StringUtil.toIndentedString(this.userId)).append("\n");
        sb.append("    email: ").append(StringUtil.toIndentedString(this.email)).append("\n");
        sb.append("    siteDescription: ").append(StringUtil.toIndentedString(this.siteDescription)).append("\n");
        sb.append("    loginAccountSettings: ").append(StringUtil.toIndentedString(this.loginAccountSettings)).append("\n");
        sb.append("    loginUserSettings: ").append(StringUtil.toIndentedString(this.loginUserSettings)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

