/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.client.StringUtil;
import com.docusign.esign.model.ErrorDetails;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="")
public class Radio {
    private String pageNumber = null;
    private String xPosition = null;
    private String yPosition = null;
    private String anchorString = null;
    private String anchorXOffset = null;
    private String anchorYOffset = null;
    private String anchorUnits = null;
    private String anchorIgnoreIfNotPresent = null;
    private String anchorCaseSensitive = null;
    private String anchorMatchWholeWord = null;
    private String anchorHorizontalAlignment = null;
    private String value = null;
    private String selected = null;
    private String tabId = null;
    private String required = null;
    private String locked = null;
    private ErrorDetails errorDetails = null;

    @ApiModelProperty(value="Specifies the page number on which the tab is located.")
    @JsonProperty(value="pageNumber")
    public String getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(String pageNumber) {
        this.pageNumber = pageNumber;
    }

    @ApiModelProperty(value="This indicates the horizontal offset of the object on the page. DocuSign uses 72 DPI when determining position.")
    @JsonProperty(value="xPosition")
    public String getXPosition() {
        return this.xPosition;
    }

    public void setXPosition(String xPosition) {
        this.xPosition = xPosition;
    }

    @ApiModelProperty(value="This indicates the vertical offset of the object on the page. DocuSign uses 72 DPI when determining position.")
    @JsonProperty(value="yPosition")
    public String getYPosition() {
        return this.yPosition;
    }

    public void setYPosition(String yPosition) {
        this.yPosition = yPosition;
    }

    @ApiModelProperty(value="Anchor text information for a radio button.")
    @JsonProperty(value="anchorString")
    public String getAnchorString() {
        return this.anchorString;
    }

    public void setAnchorString(String anchorString) {
        this.anchorString = anchorString;
    }

    @ApiModelProperty(value="Specifies the X axis location of the tab, in achorUnits, relative to the anchorString.")
    @JsonProperty(value="anchorXOffset")
    public String getAnchorXOffset() {
        return this.anchorXOffset;
    }

    public void setAnchorXOffset(String anchorXOffset) {
        this.anchorXOffset = anchorXOffset;
    }

    @ApiModelProperty(value="Specifies the Y axis location of the tab, in achorUnits, relative to the anchorString.")
    @JsonProperty(value="anchorYOffset")
    public String getAnchorYOffset() {
        return this.anchorYOffset;
    }

    public void setAnchorYOffset(String anchorYOffset) {
        this.anchorYOffset = anchorYOffset;
    }

    @ApiModelProperty(value="Specifies units of the X and Y offset. Units could be pixels, millimeters, centimeters, or inches.")
    @JsonProperty(value="anchorUnits")
    public String getAnchorUnits() {
        return this.anchorUnits;
    }

    public void setAnchorUnits(String anchorUnits) {
        this.anchorUnits = anchorUnits;
    }

    @ApiModelProperty(value="When set to **true**, this tab is ignored if anchorString is not found in the document.")
    @JsonProperty(value="anchorIgnoreIfNotPresent")
    public String getAnchorIgnoreIfNotPresent() {
        return this.anchorIgnoreIfNotPresent;
    }

    public void setAnchorIgnoreIfNotPresent(String anchorIgnoreIfNotPresent) {
        this.anchorIgnoreIfNotPresent = anchorIgnoreIfNotPresent;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="anchorCaseSensitive")
    public String getAnchorCaseSensitive() {
        return this.anchorCaseSensitive;
    }

    public void setAnchorCaseSensitive(String anchorCaseSensitive) {
        this.anchorCaseSensitive = anchorCaseSensitive;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="anchorMatchWholeWord")
    public String getAnchorMatchWholeWord() {
        return this.anchorMatchWholeWord;
    }

    public void setAnchorMatchWholeWord(String anchorMatchWholeWord) {
        this.anchorMatchWholeWord = anchorMatchWholeWord;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="anchorHorizontalAlignment")
    public String getAnchorHorizontalAlignment() {
        return this.anchorHorizontalAlignment;
    }

    public void setAnchorHorizontalAlignment(String anchorHorizontalAlignment) {
        this.anchorHorizontalAlignment = anchorHorizontalAlignment;
    }

    @ApiModelProperty(value="Specifies the value of the tab.")
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @ApiModelProperty(value="When set to **true**, the radio button is selected.")
    @JsonProperty(value="selected")
    public String getSelected() {
        return this.selected;
    }

    public void setSelected(String selected) {
        this.selected = selected;
    }

    @ApiModelProperty(value="The unique identifier for the tab. The tabid can be retrieved with the [ML:GET call].")
    @JsonProperty(value="tabId")
    public String getTabId() {
        return this.tabId;
    }

    public void setTabId(String tabId) {
        this.tabId = tabId;
    }

    @ApiModelProperty(value="When set to **true**, the signer is required to fill out this tab")
    @JsonProperty(value="required")
    public String getRequired() {
        return this.required;
    }

    public void setRequired(String required) {
        this.required = required;
    }

    @ApiModelProperty(value="When set to **true**, the signer cannot change the data of the custom tab.")
    @JsonProperty(value="locked")
    public String getLocked() {
        return this.locked;
    }

    public void setLocked(String locked) {
        this.locked = locked;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="errorDetails")
    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Radio radio = (Radio)o;
        return Objects.equals(this.pageNumber, radio.pageNumber) && Objects.equals(this.xPosition, radio.xPosition) && Objects.equals(this.yPosition, radio.yPosition) && Objects.equals(this.anchorString, radio.anchorString) && Objects.equals(this.anchorXOffset, radio.anchorXOffset) && Objects.equals(this.anchorYOffset, radio.anchorYOffset) && Objects.equals(this.anchorUnits, radio.anchorUnits) && Objects.equals(this.anchorIgnoreIfNotPresent, radio.anchorIgnoreIfNotPresent) && Objects.equals(this.anchorCaseSensitive, radio.anchorCaseSensitive) && Objects.equals(this.anchorMatchWholeWord, radio.anchorMatchWholeWord) && Objects.equals(this.anchorHorizontalAlignment, radio.anchorHorizontalAlignment) && Objects.equals(this.value, radio.value) && Objects.equals(this.selected, radio.selected) && Objects.equals(this.tabId, radio.tabId) && Objects.equals(this.required, radio.required) && Objects.equals(this.locked, radio.locked) && Objects.equals(this.errorDetails, radio.errorDetails);
    }

    public int hashCode() {
        return Objects.hash(this.pageNumber, this.xPosition, this.yPosition, this.anchorString, this.anchorXOffset, this.anchorYOffset, this.anchorUnits, this.anchorIgnoreIfNotPresent, this.anchorCaseSensitive, this.anchorMatchWholeWord, this.anchorHorizontalAlignment, this.value, this.selected, this.tabId, this.required, this.locked, this.errorDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Radio {\n");
        sb.append("    pageNumber: ").append(StringUtil.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    xPosition: ").append(StringUtil.toIndentedString(this.xPosition)).append("\n");
        sb.append("    yPosition: ").append(StringUtil.toIndentedString(this.yPosition)).append("\n");
        sb.append("    anchorString: ").append(StringUtil.toIndentedString(this.anchorString)).append("\n");
        sb.append("    anchorXOffset: ").append(StringUtil.toIndentedString(this.anchorXOffset)).append("\n");
        sb.append("    anchorYOffset: ").append(StringUtil.toIndentedString(this.anchorYOffset)).append("\n");
        sb.append("    anchorUnits: ").append(StringUtil.toIndentedString(this.anchorUnits)).append("\n");
        sb.append("    anchorIgnoreIfNotPresent: ").append(StringUtil.toIndentedString(this.anchorIgnoreIfNotPresent)).append("\n");
        sb.append("    anchorCaseSensitive: ").append(StringUtil.toIndentedString(this.anchorCaseSensitive)).append("\n");
        sb.append("    anchorMatchWholeWord: ").append(StringUtil.toIndentedString(this.anchorMatchWholeWord)).append("\n");
        sb.append("    anchorHorizontalAlignment: ").append(StringUtil.toIndentedString(this.anchorHorizontalAlignment)).append("\n");
        sb.append("    value: ").append(StringUtil.toIndentedString(this.value)).append("\n");
        sb.append("    selected: ").append(StringUtil.toIndentedString(this.selected)).append("\n");
        sb.append("    tabId: ").append(StringUtil.toIndentedString(this.tabId)).append("\n");
        sb.append("    required: ").append(StringUtil.toIndentedString(this.required)).append("\n");
        sb.append("    locked: ").append(StringUtil.toIndentedString(this.locked)).append("\n");
        sb.append("    errorDetails: ").append(StringUtil.toIndentedString(this.errorDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

