/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.client.StringUtil;
import com.docusign.esign.model.Radio;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class RadioGroup {
    private String documentId = null;
    private String recipientId = null;
    private String conditionalParentLabel = null;
    private String conditionalParentValue = null;
    private String groupName = null;
    private List<Radio> radios = new ArrayList<Radio>();
    private String shared = null;
    private String requireInitialOnSharedChange = null;
    private String requireAll = null;

    @ApiModelProperty(value="Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.")
    @JsonProperty(value="documentId")
    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    @ApiModelProperty(value="Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.")
    @JsonProperty(value="recipientId")
    public String getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(String recipientId) {
        this.recipientId = recipientId;
    }

    @ApiModelProperty(value="For conditional fields this is the TabLabel of the parent tab that controls this tab's visibility.")
    @JsonProperty(value="conditionalParentLabel")
    public String getConditionalParentLabel() {
        return this.conditionalParentLabel;
    }

    public void setConditionalParentLabel(String conditionalParentLabel) {
        this.conditionalParentLabel = conditionalParentLabel;
    }

    @ApiModelProperty(value="For conditional fields, this is the value of the parent tab that controls the tab's visibility.\n\nIf the parent tab is a Checkbox, Radio button, Optional Signature, or Optional Initial use \"on\" as the value to show that the parent tab is active.")
    @JsonProperty(value="conditionalParentValue")
    public String getConditionalParentValue() {
        return this.conditionalParentValue;
    }

    public void setConditionalParentValue(String conditionalParentValue) {
        this.conditionalParentValue = conditionalParentValue;
    }

    @ApiModelProperty(value="The name of the group.")
    @JsonProperty(value="groupName")
    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @ApiModelProperty(value="Specifies the locations and status for radio buttons that are grouped together.")
    @JsonProperty(value="radios")
    public List<Radio> getRadios() {
        return this.radios;
    }

    public void setRadios(List<Radio> radios) {
        this.radios = radios;
    }

    @ApiModelProperty(value="When set to **true**, this custom tab is shared.")
    @JsonProperty(value="shared")
    public String getShared() {
        return this.shared;
    }

    public void setShared(String shared) {
        this.shared = shared;
    }

    @ApiModelProperty(value="Optional element for field markup. When set to **true**, the signer is required to initial when they modify a shared field.")
    @JsonProperty(value="requireInitialOnSharedChange")
    public String getRequireInitialOnSharedChange() {
        return this.requireInitialOnSharedChange;
    }

    public void setRequireInitialOnSharedChange(String requireInitialOnSharedChange) {
        this.requireInitialOnSharedChange = requireInitialOnSharedChange;
    }

    @ApiModelProperty(value="When set to **true** and shared is true, information must be entered in this field to complete the envelope.")
    @JsonProperty(value="requireAll")
    public String getRequireAll() {
        return this.requireAll;
    }

    public void setRequireAll(String requireAll) {
        this.requireAll = requireAll;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RadioGroup radioGroup = (RadioGroup)o;
        return Objects.equals(this.documentId, radioGroup.documentId) && Objects.equals(this.recipientId, radioGroup.recipientId) && Objects.equals(this.conditionalParentLabel, radioGroup.conditionalParentLabel) && Objects.equals(this.conditionalParentValue, radioGroup.conditionalParentValue) && Objects.equals(this.groupName, radioGroup.groupName) && Objects.equals(this.radios, radioGroup.radios) && Objects.equals(this.shared, radioGroup.shared) && Objects.equals(this.requireInitialOnSharedChange, radioGroup.requireInitialOnSharedChange) && Objects.equals(this.requireAll, radioGroup.requireAll);
    }

    public int hashCode() {
        return Objects.hash(this.documentId, this.recipientId, this.conditionalParentLabel, this.conditionalParentValue, this.groupName, this.radios, this.shared, this.requireInitialOnSharedChange, this.requireAll);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RadioGroup {\n");
        sb.append("    documentId: ").append(StringUtil.toIndentedString(this.documentId)).append("\n");
        sb.append("    recipientId: ").append(StringUtil.toIndentedString(this.recipientId)).append("\n");
        sb.append("    conditionalParentLabel: ").append(StringUtil.toIndentedString(this.conditionalParentLabel)).append("\n");
        sb.append("    conditionalParentValue: ").append(StringUtil.toIndentedString(this.conditionalParentValue)).append("\n");
        sb.append("    groupName: ").append(StringUtil.toIndentedString(this.groupName)).append("\n");
        sb.append("    radios: ").append(StringUtil.toIndentedString(this.radios)).append("\n");
        sb.append("    shared: ").append(StringUtil.toIndentedString(this.shared)).append("\n");
        sb.append("    requireInitialOnSharedChange: ").append(StringUtil.toIndentedString(this.requireInitialOnSharedChange)).append("\n");
        sb.append("    requireAll: ").append(StringUtil.toIndentedString(this.requireAll)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

