/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.client.StringUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="")
public class RecipientViewRequest {
    private String clientUserId = null;
    private String userId = null;
    private String userName = null;
    private String email = null;
    private String recipientId = null;
    private String returnUrl = null;
    private String pingUrl = null;
    private String pingFrequency = null;
    private String authenticationMethod = null;
    private String assertionId = null;
    private String authenticationInstant = null;
    private String securityDomain = null;

    @ApiModelProperty(value="A sender created value that shows the recipient is embedded (captive). \n\nMaximum length: 100 characters.")
    @JsonProperty(value="clientUserId")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    @ApiModelProperty(value="Specifies the user ID of the recipient. You can use with user ID or email and user name to identify the recipient. If user ID is used and a client user ID is provided, the value in the `userId` property must match a recipient ID (which can be retrieved with a GET recipients call) for the envelope. If a user ID is used and a clientUser ID is not provided, the user ID match the user ID of the authenticating user.")
    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @ApiModelProperty(value="Specifies the username of the recipient. You can use either email and userName or userId to identify the recipient.")
    @JsonProperty(value="userName")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @ApiModelProperty(value="Specifies the email of the recipient. You can use either email and userName or userId to identify the recipient.")
    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @ApiModelProperty(value="Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.")
    @JsonProperty(value="recipientId")
    public String getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(String recipientId) {
        this.recipientId = recipientId;
    }

    @ApiModelProperty(value="The URL the recipient is directed to on certain events. DocuSign sends returns to the URL and includes an event parameter that can be used to redirect the recipient to another location. The possible event parameters returned are: \n\n* cancel (recipient cancels signing)\n* decline (recipient declines signing)\n* exception (exception occurs)\n* fax_pending (recipient has fax pending)\n* check); session_timeout (session times out)\n* completes signing)\n* expires)\n* viewing_complete (recipient completes viewing the envelope)\n\n## Important: You must include HTTPS:// in the URL or the redirect might be blocked by some browsers.")
    @JsonProperty(value="returnUrl")
    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    @ApiModelProperty(value="A client Url to be pinged by the DocuSign Signing experience to indicate to the client that Signing is active. An HTTP Get is executed against the client. The response from the client is ignored. The intent is for the client to reset it's session timer when the request is received.")
    @JsonProperty(value="pingUrl")
    public String getPingUrl() {
        return this.pingUrl;
    }

    public void setPingUrl(String pingUrl) {
        this.pingUrl = pingUrl;
    }

    @ApiModelProperty(value="Only used if pingUrl is specified. This is the interval, in seconds, between pings on the pingUrl.  The default is 300 seconds. Valid values are 60-1200 seconds.")
    @JsonProperty(value="pingFrequency")
    public String getPingFrequency() {
        return this.pingFrequency;
    }

    public void setPingFrequency(String pingFrequency) {
        this.pingFrequency = pingFrequency;
    }

    @ApiModelProperty(value="A sender created value that indicates the convention used to authenticate the signer. This information is included in the Certificate of Completion.")
    @JsonProperty(value="authenticationMethod")
    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    @ApiModelProperty(value="A unique identifier of the authentication event executed by the client application.")
    @JsonProperty(value="assertionId")
    public String getAssertionId() {
        return this.assertionId;
    }

    public void setAssertionId(String assertionId) {
        this.assertionId = assertionId;
    }

    @ApiModelProperty(value="A sender generated value that indicates the date/time that the signer was authenticated.")
    @JsonProperty(value="authenticationInstant")
    public String getAuthenticationInstant() {
        return this.authenticationInstant;
    }

    public void setAuthenticationInstant(String authenticationInstant) {
        this.authenticationInstant = authenticationInstant;
    }

    @ApiModelProperty(value="The domain in which the user authenticated.")
    @JsonProperty(value="securityDomain")
    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecipientViewRequest recipientViewRequest = (RecipientViewRequest)o;
        return Objects.equals(this.clientUserId, recipientViewRequest.clientUserId) && Objects.equals(this.userId, recipientViewRequest.userId) && Objects.equals(this.userName, recipientViewRequest.userName) && Objects.equals(this.email, recipientViewRequest.email) && Objects.equals(this.recipientId, recipientViewRequest.recipientId) && Objects.equals(this.returnUrl, recipientViewRequest.returnUrl) && Objects.equals(this.pingUrl, recipientViewRequest.pingUrl) && Objects.equals(this.pingFrequency, recipientViewRequest.pingFrequency) && Objects.equals(this.authenticationMethod, recipientViewRequest.authenticationMethod) && Objects.equals(this.assertionId, recipientViewRequest.assertionId) && Objects.equals(this.authenticationInstant, recipientViewRequest.authenticationInstant) && Objects.equals(this.securityDomain, recipientViewRequest.securityDomain);
    }

    public int hashCode() {
        return Objects.hash(this.clientUserId, this.userId, this.userName, this.email, this.recipientId, this.returnUrl, this.pingUrl, this.pingFrequency, this.authenticationMethod, this.assertionId, this.authenticationInstant, this.securityDomain);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecipientViewRequest {\n");
        sb.append("    clientUserId: ").append(StringUtil.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    userId: ").append(StringUtil.toIndentedString(this.userId)).append("\n");
        sb.append("    userName: ").append(StringUtil.toIndentedString(this.userName)).append("\n");
        sb.append("    email: ").append(StringUtil.toIndentedString(this.email)).append("\n");
        sb.append("    recipientId: ").append(StringUtil.toIndentedString(this.recipientId)).append("\n");
        sb.append("    returnUrl: ").append(StringUtil.toIndentedString(this.returnUrl)).append("\n");
        sb.append("    pingUrl: ").append(StringUtil.toIndentedString(this.pingUrl)).append("\n");
        sb.append("    pingFrequency: ").append(StringUtil.toIndentedString(this.pingFrequency)).append("\n");
        sb.append("    authenticationMethod: ").append(StringUtil.toIndentedString(this.authenticationMethod)).append("\n");
        sb.append("    assertionId: ").append(StringUtil.toIndentedString(this.assertionId)).append("\n");
        sb.append("    authenticationInstant: ").append(StringUtil.toIndentedString(this.authenticationInstant)).append("\n");
        sb.append("    securityDomain: ").append(StringUtil.toIndentedString(this.securityDomain)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

