/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.client.StringUtil;
import com.docusign.esign.model.Agent;
import com.docusign.esign.model.CarbonCopy;
import com.docusign.esign.model.CertifiedDelivery;
import com.docusign.esign.model.Editor;
import com.docusign.esign.model.ErrorDetails;
import com.docusign.esign.model.InPersonSigner;
import com.docusign.esign.model.Intermediary;
import com.docusign.esign.model.Signer;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class Recipients {
    private List<Signer> signers = new ArrayList<Signer>();
    private List<Agent> agents = new ArrayList<Agent>();
    private List<Editor> editors = new ArrayList<Editor>();
    private List<Intermediary> intermediaries = new ArrayList<Intermediary>();
    private List<CarbonCopy> carbonCopies = new ArrayList<CarbonCopy>();
    private List<CertifiedDelivery> certifiedDeliveries = new ArrayList<CertifiedDelivery>();
    private List<InPersonSigner> inPersonSigners = new ArrayList<InPersonSigner>();
    private String recipientCount = null;
    private String currentRoutingOrder = null;
    private ErrorDetails errorDetails = null;

    @ApiModelProperty(value="A complex type containing information about the Signer recipient.")
    @JsonProperty(value="signers")
    public List<Signer> getSigners() {
        return this.signers;
    }

    public void setSigners(List<Signer> signers) {
        this.signers = signers;
    }

    @ApiModelProperty(value="A complex type defining the management and access rights of a recipient assigned assigned as an agent on the document.")
    @JsonProperty(value="agents")
    public List<Agent> getAgents() {
        return this.agents;
    }

    public void setAgents(List<Agent> agents) {
        this.agents = agents;
    }

    @ApiModelProperty(value="A complex type defining the management and access rights of a recipient assigned assigned as an editor on the document.")
    @JsonProperty(value="editors")
    public List<Editor> getEditors() {
        return this.editors;
    }

    public void setEditors(List<Editor> editors) {
        this.editors = editors;
    }

    @ApiModelProperty(value="Identifies a recipient that can, but is not required to, add name and email information for recipients at the same or subsequent level in the routing order (until subsequent Agents, Editors or Intermediaries recipient types are added).")
    @JsonProperty(value="intermediaries")
    public List<Intermediary> getIntermediaries() {
        return this.intermediaries;
    }

    public void setIntermediaries(List<Intermediary> intermediaries) {
        this.intermediaries = intermediaries;
    }

    @ApiModelProperty(value="A complex type containing information about recipients who should receive a copy of the envelope, but does not need to sign it.")
    @JsonProperty(value="carbonCopies")
    public List<CarbonCopy> getCarbonCopies() {
        return this.carbonCopies;
    }

    public void setCarbonCopies(List<CarbonCopy> carbonCopies) {
        this.carbonCopies = carbonCopies;
    }

    @ApiModelProperty(value="A complex type containing information on a recipient the must receive the completed documents for the envelope to be completed, but the recipient does not need to sign, initial, date, or add information to any of the documents.")
    @JsonProperty(value="certifiedDeliveries")
    public List<CertifiedDelivery> getCertifiedDeliveries() {
        return this.certifiedDeliveries;
    }

    public void setCertifiedDeliveries(List<CertifiedDelivery> certifiedDeliveries) {
        this.certifiedDeliveries = certifiedDeliveries;
    }

    @ApiModelProperty(value="Specifies a signer that is in the same physical location as a DocuSign user who will act as a Signing Host for the transaction. The recipient added is the Signing Host and new separate Signer Name field appears after Sign in person is selected.")
    @JsonProperty(value="inPersonSigners")
    public List<InPersonSigner> getInPersonSigners() {
        return this.inPersonSigners;
    }

    public void setInPersonSigners(List<InPersonSigner> inPersonSigners) {
        this.inPersonSigners = inPersonSigners;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="recipientCount")
    public String getRecipientCount() {
        return this.recipientCount;
    }

    public void setRecipientCount(String recipientCount) {
        this.recipientCount = recipientCount;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="currentRoutingOrder")
    public String getCurrentRoutingOrder() {
        return this.currentRoutingOrder;
    }

    public void setCurrentRoutingOrder(String currentRoutingOrder) {
        this.currentRoutingOrder = currentRoutingOrder;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="errorDetails")
    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recipients recipients = (Recipients)o;
        return Objects.equals(this.signers, recipients.signers) && Objects.equals(this.agents, recipients.agents) && Objects.equals(this.editors, recipients.editors) && Objects.equals(this.intermediaries, recipients.intermediaries) && Objects.equals(this.carbonCopies, recipients.carbonCopies) && Objects.equals(this.certifiedDeliveries, recipients.certifiedDeliveries) && Objects.equals(this.inPersonSigners, recipients.inPersonSigners) && Objects.equals(this.recipientCount, recipients.recipientCount) && Objects.equals(this.currentRoutingOrder, recipients.currentRoutingOrder) && Objects.equals(this.errorDetails, recipients.errorDetails);
    }

    public int hashCode() {
        return Objects.hash(this.signers, this.agents, this.editors, this.intermediaries, this.carbonCopies, this.certifiedDeliveries, this.inPersonSigners, this.recipientCount, this.currentRoutingOrder, this.errorDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Recipients {\n");
        sb.append("    signers: ").append(StringUtil.toIndentedString(this.signers)).append("\n");
        sb.append("    agents: ").append(StringUtil.toIndentedString(this.agents)).append("\n");
        sb.append("    editors: ").append(StringUtil.toIndentedString(this.editors)).append("\n");
        sb.append("    intermediaries: ").append(StringUtil.toIndentedString(this.intermediaries)).append("\n");
        sb.append("    carbonCopies: ").append(StringUtil.toIndentedString(this.carbonCopies)).append("\n");
        sb.append("    certifiedDeliveries: ").append(StringUtil.toIndentedString(this.certifiedDeliveries)).append("\n");
        sb.append("    inPersonSigners: ").append(StringUtil.toIndentedString(this.inPersonSigners)).append("\n");
        sb.append("    recipientCount: ").append(StringUtil.toIndentedString(this.recipientCount)).append("\n");
        sb.append("    currentRoutingOrder: ").append(StringUtil.toIndentedString(this.currentRoutingOrder)).append("\n");
        sb.append("    errorDetails: ").append(StringUtil.toIndentedString(this.errorDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

