/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.client.StringUtil;
import com.docusign.esign.model.RecipientEmailNotification;
import com.docusign.esign.model.Tabs;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="")
public class TemplateRole {
    private String email = null;
    private String roleName = null;
    private String name = null;
    private String signingGroupId = null;
    private String inPersonSignerName = null;
    private String clientUserId = null;
    private String embeddedRecipientStartURL = null;
    private String defaultRecipient = null;
    private String accessCode = null;
    private String routingOrder = null;
    private RecipientEmailNotification emailNotification = null;
    private Tabs tabs = null;

    @ApiModelProperty(value="Specifies the email associated with a role name.")
    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @ApiModelProperty(value="Optional element. Specifies the role name associated with the recipient.<br/><br/>This is required when working with template recipients.")
    @JsonProperty(value="roleName")
    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    @ApiModelProperty(value="Specifies the recipient's name.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="When set to **true** and the feature is enabled in the sender's account, the signing recipient is required to draw signatures and initials at each signature/initial tab ( instead of adopting a signature/initial style or only drawing a signature/initial once).")
    @JsonProperty(value="signingGroupId")
    public String getSigningGroupId() {
        return this.signingGroupId;
    }

    public void setSigningGroupId(String signingGroupId) {
        this.signingGroupId = signingGroupId;
    }

    @ApiModelProperty(value="Specifies the full legal name of the signer in person signer template roles.\n\nMaximum Length: 100 characters.")
    @JsonProperty(value="inPersonSignerName")
    public String getInPersonSignerName() {
        return this.inPersonSignerName;
    }

    public void setInPersonSignerName(String inPersonSignerName) {
        this.inPersonSignerName = inPersonSignerName;
    }

    @ApiModelProperty(value="Specifies whether the recipient is embedded or remote. \n\nIf the `clientUserId` property is not null then the recipient is embedded. Note that if the `ClientUserId` property is set and either `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to  **true**, an error is generated on sending.ng. \n\nMaximum length: 100 characters.")
    @JsonProperty(value="clientUserId")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    @ApiModelProperty(value="Specifies a sender provided valid URL string for redirecting an embedded recipient. When using this option, the embedded recipient still receives an email from DocuSign, just as a remote recipient would. When the document link in the email is clicked the recipient is redirected, through DocuSign, to the supplied URL to complete their actions. When routing to the URL, the sender\u2019s system (the server responding to the URL) must request a recipient token to launch a signing session. \n\nIf set to `SIGN_AT_DOCUSIGN`, the recipient is directed to an embedded signing or viewing process directly at DocuSign. The signing or viewing action is initiated by the DocuSign system and the transaction activity and Certificate of Completion records will reflect this. In all other ways the process is identical to an embedded signing or viewing operation that is launched by any partner.\n\nIt is important to remember that in a typical embedded workflow the authentication of an embedded recipient is the responsibility of the sending application, DocuSign expects that senders will follow their own process for establishing the recipient\u2019s identity. In this workflow the recipient goes through the sending application before the embedded signing or viewing process in initiated. However, when the sending application sets `EmbeddedRecipientStartURL=SIGN_AT_DOCUSIGN`, the recipient goes directly to the embedded signing or viewing process bypassing the sending application and any authentication steps the sending application would use. In this case, DocuSign recommends that you use one of the normal DocuSign authentication features (Access Code, Phone Authentication, SMS Authentication, etc.) to verify the identity of the recipient.\n\nIf the `clientUserId` property is NOT set, and the `embeddedRecipientStartURL` is set, DocuSign will ignore the redirect URL and launch the standard signing process for the email recipient. Information can be appended to the embedded recipient start URL using merge fields. The available merge fields items are: envelopeId, recipientId, recipientName, recipientEmail, and customFields. The `customFields` property must be set fort the recipient or envelope. The merge fields are enclosed in double brackets. \n\n*Example*: \n\n`http://senderHost/[[mergeField1]]/ beginSigningSession? [[mergeField2]]&[[mergeField3]]`")
    @JsonProperty(value="embeddedRecipientStartURL")
    public String getEmbeddedRecipientStartURL() {
        return this.embeddedRecipientStartURL;
    }

    public void setEmbeddedRecipientStartURL(String embeddedRecipientStartURL) {
        this.embeddedRecipientStartURL = embeddedRecipientStartURL;
    }

    @ApiModelProperty(value="When set to **true**, this recipient is the default recipient and any tabs generated by the transformPdfFields option are mapped to this recipient.")
    @JsonProperty(value="defaultRecipient")
    public String getDefaultRecipient() {
        return this.defaultRecipient;
    }

    public void setDefaultRecipient(String defaultRecipient) {
        this.defaultRecipient = defaultRecipient;
    }

    @ApiModelProperty(value="If a value is provided, the recipient must enter the value as the access code to view and sign the envelope. \n\nMaximum Length: 50 characters and must conform to account\u2019s access code format setting.\n\nIf blank, but the signer `accessCode` property is set in the envelope, then that value is used.\n\nIf blank and the signer `accessCode` property is not set, then access code is not required.")
    @JsonProperty(value="accessCode")
    public String getAccessCode() {
        return this.accessCode;
    }

    public void setAccessCode(String accessCode) {
        this.accessCode = accessCode;
    }

    @ApiModelProperty(value="Specifies the routing order of the recipient in the envelope.")
    @JsonProperty(value="routingOrder")
    public String getRoutingOrder() {
        return this.routingOrder;
    }

    public void setRoutingOrder(String routingOrder) {
        this.routingOrder = routingOrder;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="emailNotification")
    public RecipientEmailNotification getEmailNotification() {
        return this.emailNotification;
    }

    public void setEmailNotification(RecipientEmailNotification emailNotification) {
        this.emailNotification = emailNotification;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="tabs")
    public Tabs getTabs() {
        return this.tabs;
    }

    public void setTabs(Tabs tabs) {
        this.tabs = tabs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateRole templateRole = (TemplateRole)o;
        return Objects.equals(this.email, templateRole.email) && Objects.equals(this.roleName, templateRole.roleName) && Objects.equals(this.name, templateRole.name) && Objects.equals(this.signingGroupId, templateRole.signingGroupId) && Objects.equals(this.inPersonSignerName, templateRole.inPersonSignerName) && Objects.equals(this.clientUserId, templateRole.clientUserId) && Objects.equals(this.embeddedRecipientStartURL, templateRole.embeddedRecipientStartURL) && Objects.equals(this.defaultRecipient, templateRole.defaultRecipient) && Objects.equals(this.accessCode, templateRole.accessCode) && Objects.equals(this.routingOrder, templateRole.routingOrder) && Objects.equals(this.emailNotification, templateRole.emailNotification) && Objects.equals(this.tabs, templateRole.tabs);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.roleName, this.name, this.signingGroupId, this.inPersonSignerName, this.clientUserId, this.embeddedRecipientStartURL, this.defaultRecipient, this.accessCode, this.routingOrder, this.emailNotification, this.tabs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TemplateRole {\n");
        sb.append("    email: ").append(StringUtil.toIndentedString(this.email)).append("\n");
        sb.append("    roleName: ").append(StringUtil.toIndentedString(this.roleName)).append("\n");
        sb.append("    name: ").append(StringUtil.toIndentedString(this.name)).append("\n");
        sb.append("    signingGroupId: ").append(StringUtil.toIndentedString(this.signingGroupId)).append("\n");
        sb.append("    inPersonSignerName: ").append(StringUtil.toIndentedString(this.inPersonSignerName)).append("\n");
        sb.append("    clientUserId: ").append(StringUtil.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    embeddedRecipientStartURL: ").append(StringUtil.toIndentedString(this.embeddedRecipientStartURL)).append("\n");
        sb.append("    defaultRecipient: ").append(StringUtil.toIndentedString(this.defaultRecipient)).append("\n");
        sb.append("    accessCode: ").append(StringUtil.toIndentedString(this.accessCode)).append("\n");
        sb.append("    routingOrder: ").append(StringUtil.toIndentedString(this.routingOrder)).append("\n");
        sb.append("    emailNotification: ").append(StringUtil.toIndentedString(this.emailNotification)).append("\n");
        sb.append("    tabs: ").append(StringUtil.toIndentedString(this.tabs)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

