/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.LoginInformation;
import com.docusign.esign.model.OauthAccess;
import com.docusign.esign.model.SocialAccountInformation;
import com.docusign.esign.model.UserPasswordInformation;
import com.docusign.esign.model.UserSocialIdResult;
import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class AuthenticationApi {
    private ApiClient apiClient;

    public AuthenticationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthenticationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public UserSocialIdResult listSocialLogins(String accountId, String userId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listSocialLogins");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listSocialLogins");
        }
        String path = "/v2/accounts/{accountId}/users/{userId}/social".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<UserSocialIdResult> returnType = new GenericType<UserSocialIdResult>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public void updateSocialLogin(String accountId, String userId, SocialAccountInformation socialAccountInformation) throws ApiException {
        SocialAccountInformation postBody = socialAccountInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateSocialLogin");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateSocialLogin");
        }
        String path = "/v2/accounts/{accountId}/users/{userId}/social".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public void deleteSocialLogin(String accountId, String userId, SocialAccountInformation socialAccountInformation) throws ApiException {
        SocialAccountInformation postBody = socialAccountInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteSocialLogin");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling deleteSocialLogin");
        }
        String path = "/v2/accounts/{accountId}/users/{userId}/social".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public LoginInformation login() throws ApiException {
        return this.login(null);
    }

    public LoginInformation login(LoginOptions options) throws ApiException {
        Object postBody = null;
        String path = "/v2/login_information".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "api_password", options.apiPassword));
            queryParams.addAll(this.apiClient.parameterToPairs("", "embed_account_id_guid", options.embedAccountIdGuid));
            queryParams.addAll(this.apiClient.parameterToPairs("", "include_account_id_guid", options.includeAccountIdGuid));
            queryParams.addAll(this.apiClient.parameterToPairs("", "login_settings", options.loginSettings));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<LoginInformation> returnType = new GenericType<LoginInformation>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public void updatePassword(String loginPart, UserPasswordInformation userPasswordInformation) throws ApiException {
        UserPasswordInformation postBody = userPasswordInformation;
        if (loginPart == null) {
            throw new ApiException(400, "Missing the required parameter 'loginPart' when calling updatePassword");
        }
        String path = "/v2/login_information/{loginPart}".replaceAll("\\{format\\}", "json").replaceAll("\\{loginPart\\}", this.apiClient.escapeString(loginPart.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public void revokeOAuthToken() throws ApiException {
        Object postBody = null;
        String path = "/v2/oauth2/revoke".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public OauthAccess getOAuthToken() throws ApiException {
        Object postBody = null;
        String path = "/v2/oauth2/token".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<OauthAccess> returnType = new GenericType<OauthAccess>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public class LoginOptions {
        private String apiPassword = null;
        private String embedAccountIdGuid = null;
        private String includeAccountIdGuid = null;
        private String loginSettings = null;

        public void setApiPassword(String apiPassword) {
            this.apiPassword = apiPassword;
        }

        public String getApiPassword() {
            return this.apiPassword;
        }

        public void setEmbedAccountIdGuid(String embedAccountIdGuid) {
            this.embedAccountIdGuid = embedAccountIdGuid;
        }

        public String getEmbedAccountIdGuid() {
            return this.embedAccountIdGuid;
        }

        public void setIncludeAccountIdGuid(String includeAccountIdGuid) {
            this.includeAccountIdGuid = includeAccountIdGuid;
        }

        public String getIncludeAccountIdGuid() {
            return this.includeAccountIdGuid;
        }

        public void setLoginSettings(String loginSettings) {
            this.loginSettings = loginSettings;
        }

        public String getLoginSettings() {
            return this.loginSettings;
        }
    }
}

