/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.Attachment;
import com.docusign.esign.model.ChunkedUploadRequest;
import com.docusign.esign.model.ChunkedUploadResponse;
import com.docusign.esign.model.ConsoleViewRequest;
import com.docusign.esign.model.ConsumerDisclosure;
import com.docusign.esign.model.CorrectViewRequest;
import com.docusign.esign.model.CustomFields;
import com.docusign.esign.model.CustomFieldsEnvelope;
import com.docusign.esign.model.DocumentFieldsInformation;
import com.docusign.esign.model.DocumentTemplateList;
import com.docusign.esign.model.DocumentVisibilityList;
import com.docusign.esign.model.EmailSettings;
import com.docusign.esign.model.Envelope;
import com.docusign.esign.model.EnvelopeAttachmentsRequest;
import com.docusign.esign.model.EnvelopeAttachmentsResult;
import com.docusign.esign.model.EnvelopeAuditEventResponse;
import com.docusign.esign.model.EnvelopeDefinition;
import com.docusign.esign.model.EnvelopeDocumentsResult;
import com.docusign.esign.model.EnvelopeFormData;
import com.docusign.esign.model.EnvelopeIdsRequest;
import com.docusign.esign.model.EnvelopeNotificationRequest;
import com.docusign.esign.model.EnvelopeSummary;
import com.docusign.esign.model.EnvelopeUpdateSummary;
import com.docusign.esign.model.EnvelopesInformation;
import com.docusign.esign.model.LockInformation;
import com.docusign.esign.model.LockRequest;
import com.docusign.esign.model.Notification;
import com.docusign.esign.model.PageRequest;
import com.docusign.esign.model.RecipientViewRequest;
import com.docusign.esign.model.Recipients;
import com.docusign.esign.model.RecipientsUpdateSummary;
import com.docusign.esign.model.ReturnUrlRequest;
import com.docusign.esign.model.Tabs;
import com.docusign.esign.model.TemplateDocumentVisibilityList;
import com.docusign.esign.model.TemplateInformation;
import com.docusign.esign.model.UserSignature;
import com.docusign.esign.model.ViewLinkRequest;
import com.docusign.esign.model.ViewUrl;
import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class EnvelopesApi {
    private ApiClient apiClient;

    public EnvelopesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EnvelopesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ChunkedUploadResponse createChunkedUpload(String accountId, ChunkedUploadRequest chunkedUploadRequest) throws ApiException {
        ChunkedUploadRequest postBody = chunkedUploadRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createChunkedUpload");
        }
        String path = "/v2/accounts/{accountId}/chunked_uploads".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<ChunkedUploadResponse> returnType = new GenericType<ChunkedUploadResponse>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public ChunkedUploadResponse getChunkedUpload(String accountId, String chunkedUploadId) throws ApiException {
        return this.getChunkedUpload(accountId, chunkedUploadId, null);
    }

    public ChunkedUploadResponse getChunkedUpload(String accountId, String chunkedUploadId, GetChunkedUploadOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getChunkedUpload");
        }
        if (chunkedUploadId == null) {
            throw new ApiException(400, "Missing the required parameter 'chunkedUploadId' when calling getChunkedUpload");
        }
        String path = "/v2/accounts/{accountId}/chunked_uploads/{chunkedUploadId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{chunkedUploadId\\}", this.apiClient.escapeString(chunkedUploadId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "include", options.include));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<ChunkedUploadResponse> returnType = new GenericType<ChunkedUploadResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public ChunkedUploadResponse updateChunkedUpload(String accountId, String chunkedUploadId) throws ApiException {
        return this.updateChunkedUpload(accountId, chunkedUploadId, null);
    }

    public ChunkedUploadResponse updateChunkedUpload(String accountId, String chunkedUploadId, UpdateChunkedUploadOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateChunkedUpload");
        }
        if (chunkedUploadId == null) {
            throw new ApiException(400, "Missing the required parameter 'chunkedUploadId' when calling updateChunkedUpload");
        }
        String path = "/v2/accounts/{accountId}/chunked_uploads/{chunkedUploadId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{chunkedUploadId\\}", this.apiClient.escapeString(chunkedUploadId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "action", options.action));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<ChunkedUploadResponse> returnType = new GenericType<ChunkedUploadResponse>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public ChunkedUploadResponse deleteChunkedUpload(String accountId, String chunkedUploadId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteChunkedUpload");
        }
        if (chunkedUploadId == null) {
            throw new ApiException(400, "Missing the required parameter 'chunkedUploadId' when calling deleteChunkedUpload");
        }
        String path = "/v2/accounts/{accountId}/chunked_uploads/{chunkedUploadId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{chunkedUploadId\\}", this.apiClient.escapeString(chunkedUploadId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<ChunkedUploadResponse> returnType = new GenericType<ChunkedUploadResponse>(){};
        return this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public ChunkedUploadResponse updateChunkedUploadPart(String accountId, String chunkedUploadId, String chunkedUploadPartSeq, ChunkedUploadRequest chunkedUploadRequest) throws ApiException {
        ChunkedUploadRequest postBody = chunkedUploadRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateChunkedUploadPart");
        }
        if (chunkedUploadId == null) {
            throw new ApiException(400, "Missing the required parameter 'chunkedUploadId' when calling updateChunkedUploadPart");
        }
        if (chunkedUploadPartSeq == null) {
            throw new ApiException(400, "Missing the required parameter 'chunkedUploadPartSeq' when calling updateChunkedUploadPart");
        }
        String path = "/v2/accounts/{accountId}/chunked_uploads/{chunkedUploadId}/{chunkedUploadPartSeq}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{chunkedUploadId\\}", this.apiClient.escapeString(chunkedUploadId.toString())).replaceAll("\\{chunkedUploadPartSeq\\}", this.apiClient.escapeString(chunkedUploadPartSeq.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<ChunkedUploadResponse> returnType = new GenericType<ChunkedUploadResponse>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public EnvelopesInformation listStatusChanges(String accountId) throws ApiException {
        return this.listStatusChanges(accountId, null);
    }

    public EnvelopesInformation listStatusChanges(String accountId, ListStatusChangesOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listStatusChanges");
        }
        String path = "/v2/accounts/{accountId}/envelopes".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "ac_status", options.acStatus));
            queryParams.addAll(this.apiClient.parameterToPairs("", "block", options.block));
            queryParams.addAll(this.apiClient.parameterToPairs("", "count", options.count));
            queryParams.addAll(this.apiClient.parameterToPairs("", "custom_field", options.customField));
            queryParams.addAll(this.apiClient.parameterToPairs("", "email", options.email));
            queryParams.addAll(this.apiClient.parameterToPairs("", "envelope_ids", options.envelopeIds));
            queryParams.addAll(this.apiClient.parameterToPairs("", "exclude", options.exclude));
            queryParams.addAll(this.apiClient.parameterToPairs("", "folder_ids", options.folderIds));
            queryParams.addAll(this.apiClient.parameterToPairs("", "folder_types", options.folderTypes));
            queryParams.addAll(this.apiClient.parameterToPairs("", "from_date", options.fromDate));
            queryParams.addAll(this.apiClient.parameterToPairs("", "from_to_status", options.fromToStatus));
            queryParams.addAll(this.apiClient.parameterToPairs("", "include", options.include));
            queryParams.addAll(this.apiClient.parameterToPairs("", "intersecting_folder_ids", options.intersectingFolderIds));
            queryParams.addAll(this.apiClient.parameterToPairs("", "order", options.order));
            queryParams.addAll(this.apiClient.parameterToPairs("", "order_by", options.orderBy));
            queryParams.addAll(this.apiClient.parameterToPairs("", "powerformids", options.powerformids));
            queryParams.addAll(this.apiClient.parameterToPairs("", "search_text", options.searchText));
            queryParams.addAll(this.apiClient.parameterToPairs("", "start_position", options.startPosition));
            queryParams.addAll(this.apiClient.parameterToPairs("", "status", options.status));
            queryParams.addAll(this.apiClient.parameterToPairs("", "to_date", options.toDate));
            queryParams.addAll(this.apiClient.parameterToPairs("", "transaction_ids", options.transactionIds));
            queryParams.addAll(this.apiClient.parameterToPairs("", "user_filter", options.userFilter));
            queryParams.addAll(this.apiClient.parameterToPairs("", "user_id", options.userId));
            queryParams.addAll(this.apiClient.parameterToPairs("", "user_name", options.userName));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<EnvelopesInformation> returnType = new GenericType<EnvelopesInformation>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public EnvelopeSummary createEnvelope(String accountId, EnvelopeDefinition envelopeDefinition) throws ApiException {
        return this.createEnvelope(accountId, envelopeDefinition, null);
    }

    public EnvelopeSummary createEnvelope(String accountId, EnvelopeDefinition envelopeDefinition, CreateEnvelopeOptions options) throws ApiException {
        EnvelopeDefinition postBody = envelopeDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createEnvelope");
        }
        String path = "/v2/accounts/{accountId}/envelopes".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "cdse_mode", options.cdseMode));
            queryParams.addAll(this.apiClient.parameterToPairs("", "completed_documents_only", options.completedDocumentsOnly));
            queryParams.addAll(this.apiClient.parameterToPairs("", "merge_roles_on_draft", options.mergeRolesOnDraft));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<EnvelopeSummary> returnType = new GenericType<EnvelopeSummary>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public EnvelopesInformation listStatus(String accountId, EnvelopeIdsRequest envelopeIdsRequest) throws ApiException {
        return this.listStatus(accountId, envelopeIdsRequest, null);
    }

    public EnvelopesInformation listStatus(String accountId, EnvelopeIdsRequest envelopeIdsRequest, ListStatusOptions options) throws ApiException {
        EnvelopeIdsRequest postBody = envelopeIdsRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listStatus");
        }
        String path = "/v2/accounts/{accountId}/envelopes/status".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "email", options.email));
            queryParams.addAll(this.apiClient.parameterToPairs("", "from_date", options.fromDate));
            queryParams.addAll(this.apiClient.parameterToPairs("", "start_position", options.startPosition));
            queryParams.addAll(this.apiClient.parameterToPairs("", "to_date", options.toDate));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<EnvelopesInformation> returnType = new GenericType<EnvelopesInformation>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public Envelope getEnvelope(String accountId, String envelopeId) throws ApiException {
        return this.getEnvelope(accountId, envelopeId, null);
    }

    public Envelope getEnvelope(String accountId, String envelopeId, GetEnvelopeOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getEnvelope");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getEnvelope");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "advanced_update", options.advancedUpdate));
            queryParams.addAll(this.apiClient.parameterToPairs("", "include", options.include));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<Envelope> returnType = new GenericType<Envelope>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public EnvelopeUpdateSummary update(String accountId, String envelopeId, Envelope envelope) throws ApiException {
        return this.update(accountId, envelopeId, envelope, null);
    }

    public EnvelopeUpdateSummary update(String accountId, String envelopeId, Envelope envelope, UpdateOptions options) throws ApiException {
        Envelope postBody = envelope;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling update");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling update");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "advanced_update", options.advancedUpdate));
            queryParams.addAll(this.apiClient.parameterToPairs("", "resend_envelope", options.resendEnvelope));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<EnvelopeUpdateSummary> returnType = new GenericType<EnvelopeUpdateSummary>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public EnvelopeAttachmentsResult getAttachments(String accountId, String envelopeId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAttachments");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getAttachments");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/attachments".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<EnvelopeAttachmentsResult> returnType = new GenericType<EnvelopeAttachmentsResult>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public EnvelopeAttachmentsResult putAttachments(String accountId, String envelopeId, EnvelopeAttachmentsRequest envelopeAttachmentsRequest) throws ApiException {
        EnvelopeAttachmentsRequest postBody = envelopeAttachmentsRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling putAttachments");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling putAttachments");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/attachments".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<EnvelopeAttachmentsResult> returnType = new GenericType<EnvelopeAttachmentsResult>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public EnvelopeAttachmentsResult deleteAttachments(String accountId, String envelopeId, EnvelopeAttachmentsRequest envelopeAttachmentsRequest) throws ApiException {
        EnvelopeAttachmentsRequest postBody = envelopeAttachmentsRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteAttachments");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteAttachments");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/attachments".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<EnvelopeAttachmentsResult> returnType = new GenericType<EnvelopeAttachmentsResult>(){};
        return this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public void getAttachment(String accountId, String envelopeId, String attachmentId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAttachment");
        }
        if (attachmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'attachmentId' when calling getAttachment");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getAttachment");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/attachments/{attachmentId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{attachmentId\\}", this.apiClient.escapeString(attachmentId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public EnvelopeAttachmentsResult putAttachment(String accountId, String envelopeId, String attachmentId, Attachment attachment) throws ApiException {
        Attachment postBody = attachment;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling putAttachment");
        }
        if (attachmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'attachmentId' when calling putAttachment");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling putAttachment");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/attachments/{attachmentId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{attachmentId\\}", this.apiClient.escapeString(attachmentId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<EnvelopeAttachmentsResult> returnType = new GenericType<EnvelopeAttachmentsResult>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public EnvelopeAuditEventResponse listAuditEvents(String accountId, String envelopeId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listAuditEvents");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listAuditEvents");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/audit_events".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<EnvelopeAuditEventResponse> returnType = new GenericType<EnvelopeAuditEventResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public CustomFieldsEnvelope listCustomFields(String accountId, String envelopeId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listCustomFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listCustomFields");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/custom_fields".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<CustomFieldsEnvelope> returnType = new GenericType<CustomFieldsEnvelope>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public CustomFields updateCustomFields(String accountId, String envelopeId, CustomFields customFields) throws ApiException {
        CustomFields postBody = customFields;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateCustomFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateCustomFields");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/custom_fields".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<CustomFields> returnType = new GenericType<CustomFields>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public CustomFields createCustomFields(String accountId, String envelopeId, CustomFields customFields) throws ApiException {
        CustomFields postBody = customFields;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createCustomFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createCustomFields");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/custom_fields".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<CustomFields> returnType = new GenericType<CustomFields>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public CustomFields deleteCustomFields(String accountId, String envelopeId, CustomFields customFields) throws ApiException {
        CustomFields postBody = customFields;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteCustomFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteCustomFields");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/custom_fields".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<CustomFields> returnType = new GenericType<CustomFields>(){};
        return this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public EnvelopeDocumentsResult listDocuments(String accountId, String envelopeId) throws ApiException {
        return this.listDocuments(accountId, envelopeId, null);
    }

    public EnvelopeDocumentsResult listDocuments(String accountId, String envelopeId, ListDocumentsOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listDocuments");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listDocuments");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "include_metadata", options.includeMetadata));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<EnvelopeDocumentsResult> returnType = new GenericType<EnvelopeDocumentsResult>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public EnvelopeDocumentsResult updateDocuments(String accountId, String envelopeId, EnvelopeDefinition envelopeDefinition) throws ApiException {
        return this.updateDocuments(accountId, envelopeId, envelopeDefinition, null);
    }

    public EnvelopeDocumentsResult updateDocuments(String accountId, String envelopeId, EnvelopeDefinition envelopeDefinition, UpdateDocumentsOptions options) throws ApiException {
        EnvelopeDefinition postBody = envelopeDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateDocuments");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateDocuments");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "apply_document_fields", options.applyDocumentFields));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<EnvelopeDocumentsResult> returnType = new GenericType<EnvelopeDocumentsResult>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public EnvelopeDocumentsResult deleteDocuments(String accountId, String envelopeId, EnvelopeDefinition envelopeDefinition) throws ApiException {
        EnvelopeDefinition postBody = envelopeDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteDocuments");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteDocuments");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<EnvelopeDocumentsResult> returnType = new GenericType<EnvelopeDocumentsResult>(){};
        return this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public byte[] getDocument(String accountId, String envelopeId, String documentId) throws ApiException {
        return this.getDocument(accountId, envelopeId, documentId, null);
    }

    public byte[] getDocument(String accountId, String envelopeId, String documentId, GetDocumentOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling getDocument");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getDocument");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "certificate", options.certificate));
            queryParams.addAll(this.apiClient.parameterToPairs("", "encoding", options.encoding));
            queryParams.addAll(this.apiClient.parameterToPairs("", "encrypt", options.encrypt));
            queryParams.addAll(this.apiClient.parameterToPairs("", "language", options.language));
            queryParams.addAll(this.apiClient.parameterToPairs("", "recipient_id", options.recipientId));
            queryParams.addAll(this.apiClient.parameterToPairs("", "show_changes", options.showChanges));
            queryParams.addAll(this.apiClient.parameterToPairs("", "watermark", options.watermark));
        }
        String[] accepts = new String[]{"application/pdf"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<byte[]> returnType = new GenericType<byte[]>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public void updateDocument(String accountId, String envelopeId, String documentId) throws ApiException {
        this.updateDocument(accountId, envelopeId, documentId, null);
    }

    public void updateDocument(String accountId, String envelopeId, String documentId, UpdateDocumentOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling updateDocument");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateDocument");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "apply_document_fields", options.applyDocumentFields));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public DocumentFieldsInformation listDocumentFields(String accountId, String envelopeId, String documentId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listDocumentFields");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling listDocumentFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listDocumentFields");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<DocumentFieldsInformation> returnType = new GenericType<DocumentFieldsInformation>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public DocumentFieldsInformation updateDocumentFields(String accountId, String envelopeId, String documentId, DocumentFieldsInformation documentFieldsInformation) throws ApiException {
        DocumentFieldsInformation postBody = documentFieldsInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateDocumentFields");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling updateDocumentFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateDocumentFields");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<DocumentFieldsInformation> returnType = new GenericType<DocumentFieldsInformation>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public DocumentFieldsInformation createDocumentFields(String accountId, String envelopeId, String documentId, DocumentFieldsInformation documentFieldsInformation) throws ApiException {
        DocumentFieldsInformation postBody = documentFieldsInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createDocumentFields");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling createDocumentFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createDocumentFields");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<DocumentFieldsInformation> returnType = new GenericType<DocumentFieldsInformation>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public DocumentFieldsInformation deleteDocumentFields(String accountId, String envelopeId, String documentId, DocumentFieldsInformation documentFieldsInformation) throws ApiException {
        DocumentFieldsInformation postBody = documentFieldsInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteDocumentFields");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling deleteDocumentFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteDocumentFields");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<DocumentFieldsInformation> returnType = new GenericType<DocumentFieldsInformation>(){};
        return this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public void deleteDocumentPage(String accountId, String envelopeId, String documentId, String pageNumber) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteDocumentPage");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling deleteDocumentPage");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteDocumentPage");
        }
        if (pageNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'pageNumber' when calling deleteDocumentPage");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString())).replaceAll("\\{pageNumber\\}", this.apiClient.escapeString(pageNumber.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public byte[] getDocumentPageImage(String accountId, String envelopeId, String documentId, String pageNumber) throws ApiException {
        return this.getDocumentPageImage(accountId, envelopeId, documentId, pageNumber, null);
    }

    public byte[] getDocumentPageImage(String accountId, String envelopeId, String documentId, String pageNumber, GetDocumentPageImageOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getDocumentPageImage");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling getDocumentPageImage");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getDocumentPageImage");
        }
        if (pageNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'pageNumber' when calling getDocumentPageImage");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}/page_image".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString())).replaceAll("\\{pageNumber\\}", this.apiClient.escapeString(pageNumber.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "dpi", options.dpi));
            queryParams.addAll(this.apiClient.parameterToPairs("", "max_height", options.maxHeight));
            queryParams.addAll(this.apiClient.parameterToPairs("", "max_width", options.maxWidth));
            queryParams.addAll(this.apiClient.parameterToPairs("", "show_changes", options.showChanges));
        }
        String[] accepts = new String[]{"image/png"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<byte[]> returnType = new GenericType<byte[]>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public void rotateDocumentPage(String accountId, String envelopeId, String documentId, String pageNumber, PageRequest pageRequest) throws ApiException {
        PageRequest postBody = pageRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling rotateDocumentPage");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling rotateDocumentPage");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling rotateDocumentPage");
        }
        if (pageNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'pageNumber' when calling rotateDocumentPage");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}/page_image".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString())).replaceAll("\\{pageNumber\\}", this.apiClient.escapeString(pageNumber.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public TemplateInformation listTemplatesForDocument(String accountId, String envelopeId, String documentId) throws ApiException {
        return this.listTemplatesForDocument(accountId, envelopeId, documentId, null);
    }

    public TemplateInformation listTemplatesForDocument(String accountId, String envelopeId, String documentId, ListTemplatesForDocumentOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listTemplatesForDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling listTemplatesForDocument");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listTemplatesForDocument");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "include", options.include));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<TemplateInformation> returnType = new GenericType<TemplateInformation>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public DocumentTemplateList applyTemplateToDocument(String accountId, String envelopeId, String documentId, DocumentTemplateList documentTemplateList) throws ApiException {
        DocumentTemplateList postBody = documentTemplateList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling applyTemplateToDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling applyTemplateToDocument");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling applyTemplateToDocument");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<DocumentTemplateList> returnType = new GenericType<DocumentTemplateList>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public void deleteTemplatesFromDocument(String accountId, String envelopeId, String documentId, String templateId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteTemplatesFromDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling deleteTemplatesFromDocument");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteTemplatesFromDocument");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling deleteTemplatesFromDocument");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates/{templateId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public EmailSettings getEmailSettings(String accountId, String envelopeId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getEmailSettings");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getEmailSettings");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/email_settings".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<EmailSettings> returnType = new GenericType<EmailSettings>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public EmailSettings updateEmailSettings(String accountId, String envelopeId, EmailSettings emailSettings) throws ApiException {
        EmailSettings postBody = emailSettings;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateEmailSettings");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateEmailSettings");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/email_settings".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<EmailSettings> returnType = new GenericType<EmailSettings>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public EmailSettings createEmailSettings(String accountId, String envelopeId, EmailSettings emailSettings) throws ApiException {
        EmailSettings postBody = emailSettings;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createEmailSettings");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createEmailSettings");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/email_settings".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<EmailSettings> returnType = new GenericType<EmailSettings>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public EmailSettings deleteEmailSettings(String accountId, String envelopeId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteEmailSettings");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteEmailSettings");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/email_settings".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<EmailSettings> returnType = new GenericType<EmailSettings>(){};
        return this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public EnvelopeFormData getFormData(String accountId, String envelopeId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getFormData");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getFormData");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/form_data".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<EnvelopeFormData> returnType = new GenericType<EnvelopeFormData>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public LockInformation getLock(String accountId, String envelopeId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getLock");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getLock");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/lock".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<LockInformation> returnType = new GenericType<LockInformation>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public LockInformation updateLock(String accountId, String envelopeId, LockRequest lockRequest) throws ApiException {
        LockRequest postBody = lockRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateLock");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateLock");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/lock".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<LockInformation> returnType = new GenericType<LockInformation>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public LockInformation createLock(String accountId, String envelopeId, LockRequest lockRequest) throws ApiException {
        LockRequest postBody = lockRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createLock");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createLock");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/lock".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<LockInformation> returnType = new GenericType<LockInformation>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public LockInformation deleteLock(String accountId, String envelopeId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteLock");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteLock");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/lock".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<LockInformation> returnType = new GenericType<LockInformation>(){};
        return this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public Notification getNotificationSettings(String accountId, String envelopeId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getNotificationSettings");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getNotificationSettings");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/notification".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<Notification> returnType = new GenericType<Notification>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public Notification updateNotificationSettings(String accountId, String envelopeId, EnvelopeNotificationRequest envelopeNotificationRequest) throws ApiException {
        EnvelopeNotificationRequest postBody = envelopeNotificationRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateNotificationSettings");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateNotificationSettings");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/notification".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<Notification> returnType = new GenericType<Notification>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public Recipients listRecipients(String accountId, String envelopeId) throws ApiException {
        return this.listRecipients(accountId, envelopeId, null);
    }

    public Recipients listRecipients(String accountId, String envelopeId, ListRecipientsOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listRecipients");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listRecipients");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "include_anchor_tab_locations", options.includeAnchorTabLocations));
            queryParams.addAll(this.apiClient.parameterToPairs("", "include_extended", options.includeExtended));
            queryParams.addAll(this.apiClient.parameterToPairs("", "include_metadata", options.includeMetadata));
            queryParams.addAll(this.apiClient.parameterToPairs("", "include_tabs", options.includeTabs));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<Recipients> returnType = new GenericType<Recipients>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public RecipientsUpdateSummary updateRecipients(String accountId, String envelopeId, Recipients recipients) throws ApiException {
        return this.updateRecipients(accountId, envelopeId, recipients, null);
    }

    public RecipientsUpdateSummary updateRecipients(String accountId, String envelopeId, Recipients recipients, UpdateRecipientsOptions options) throws ApiException {
        Recipients postBody = recipients;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateRecipients");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateRecipients");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "resend_envelope", options.resendEnvelope));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<RecipientsUpdateSummary> returnType = new GenericType<RecipientsUpdateSummary>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public Recipients createRecipient(String accountId, String envelopeId, Recipients recipients) throws ApiException {
        return this.createRecipient(accountId, envelopeId, recipients, null);
    }

    public Recipients createRecipient(String accountId, String envelopeId, Recipients recipients, CreateRecipientOptions options) throws ApiException {
        Recipients postBody = recipients;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createRecipient");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createRecipient");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "resend_envelope", options.resendEnvelope));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<Recipients> returnType = new GenericType<Recipients>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public Recipients deleteRecipients(String accountId, String envelopeId, Recipients recipients) throws ApiException {
        Recipients postBody = recipients;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteRecipients");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteRecipients");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<Recipients> returnType = new GenericType<Recipients>(){};
        return this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public DocumentVisibilityList updateRecipientsDocumentVisibility(String accountId, String envelopeId, DocumentVisibilityList documentVisibilityList) throws ApiException {
        DocumentVisibilityList postBody = documentVisibilityList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateRecipientsDocumentVisibility");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateRecipientsDocumentVisibility");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/document_visibility".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<DocumentVisibilityList> returnType = new GenericType<DocumentVisibilityList>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public Recipients deleteRecipient(String accountId, String envelopeId, String recipientId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteRecipient");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteRecipient");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling deleteRecipient");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<Recipients> returnType = new GenericType<Recipients>(){};
        return this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public ConsumerDisclosure getConsumerDisclosureDefault(String accountId, String envelopeId, String recipientId) throws ApiException {
        return this.getConsumerDisclosureDefault(accountId, envelopeId, recipientId, null);
    }

    public ConsumerDisclosure getConsumerDisclosureDefault(String accountId, String envelopeId, String recipientId, GetConsumerDisclosureDefaultOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getConsumerDisclosureDefault");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getConsumerDisclosureDefault");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling getConsumerDisclosureDefault");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/consumer_disclosure".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "langCode", options.langCode));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<ConsumerDisclosure> returnType = new GenericType<ConsumerDisclosure>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public ConsumerDisclosure getConsumerDisclosure(String accountId, String envelopeId, String recipientId, String langCode) throws ApiException {
        return this.getConsumerDisclosure(accountId, envelopeId, recipientId, langCode, null);
    }

    public ConsumerDisclosure getConsumerDisclosure(String accountId, String envelopeId, String recipientId, String langCode, GetConsumerDisclosureOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getConsumerDisclosure");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getConsumerDisclosure");
        }
        if (langCode == null) {
            throw new ApiException(400, "Missing the required parameter 'langCode' when calling getConsumerDisclosure");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling getConsumerDisclosure");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/consumer_disclosure/{langCode}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString())).replaceAll("\\{langCode\\}", this.apiClient.escapeString(langCode.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "langCode", options.langCode2));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<ConsumerDisclosure> returnType = new GenericType<ConsumerDisclosure>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public DocumentVisibilityList getRecipientDocumentVisibility(String accountId, String envelopeId, String recipientId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getRecipientDocumentVisibility");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getRecipientDocumentVisibility");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling getRecipientDocumentVisibility");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/document_visibility".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<DocumentVisibilityList> returnType = new GenericType<DocumentVisibilityList>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public DocumentVisibilityList updateRecipientDocumentVisibility(String accountId, String envelopeId, String recipientId, DocumentVisibilityList documentVisibilityList) throws ApiException {
        DocumentVisibilityList postBody = documentVisibilityList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateRecipientDocumentVisibility");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateRecipientDocumentVisibility");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling updateRecipientDocumentVisibility");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/document_visibility".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<DocumentVisibilityList> returnType = new GenericType<DocumentVisibilityList>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public byte[] getRecipientInitialsImage(String accountId, String envelopeId, String recipientId) throws ApiException {
        return this.getRecipientInitialsImage(accountId, envelopeId, recipientId, null);
    }

    public byte[] getRecipientInitialsImage(String accountId, String envelopeId, String recipientId, GetRecipientInitialsImageOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getRecipientInitialsImage");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getRecipientInitialsImage");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling getRecipientInitialsImage");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/initials_image".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "include_chrome", options.includeChrome));
        }
        String[] accepts = new String[]{"image/gif"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<byte[]> returnType = new GenericType<byte[]>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public void updateRecipientInitialsImage(String accountId, String envelopeId, String recipientId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateRecipientInitialsImage");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateRecipientInitialsImage");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling updateRecipientInitialsImage");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/initials_image".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public UserSignature getRecipientSignature(String accountId, String envelopeId, String recipientId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getRecipientSignature");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getRecipientSignature");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling getRecipientSignature");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<UserSignature> returnType = new GenericType<UserSignature>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public byte[] getRecipientSignatureImage(String accountId, String envelopeId, String recipientId) throws ApiException {
        return this.getRecipientSignatureImage(accountId, envelopeId, recipientId, null);
    }

    public byte[] getRecipientSignatureImage(String accountId, String envelopeId, String recipientId, GetRecipientSignatureImageOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getRecipientSignatureImage");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getRecipientSignatureImage");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling getRecipientSignatureImage");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature_image".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "include_chrome", options.includeChrome));
        }
        String[] accepts = new String[]{"image/gif"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<byte[]> returnType = new GenericType<byte[]>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public void updateRecipientSignatureImage(String accountId, String envelopeId, String recipientId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateRecipientSignatureImage");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateRecipientSignatureImage");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling updateRecipientSignatureImage");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature_image".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public Tabs listTabs(String accountId, String envelopeId, String recipientId) throws ApiException {
        return this.listTabs(accountId, envelopeId, recipientId, null);
    }

    public Tabs listTabs(String accountId, String envelopeId, String recipientId, ListTabsOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listTabs");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling listTabs");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "include_anchor_tab_locations", options.includeAnchorTabLocations));
            queryParams.addAll(this.apiClient.parameterToPairs("", "include_metadata", options.includeMetadata));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<Tabs> returnType = new GenericType<Tabs>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public Tabs updateTabs(String accountId, String envelopeId, String recipientId, Tabs tabs) throws ApiException {
        Tabs postBody = tabs;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateTabs");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling updateTabs");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<Tabs> returnType = new GenericType<Tabs>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public Tabs createTabs(String accountId, String envelopeId, String recipientId, Tabs tabs) throws ApiException {
        Tabs postBody = tabs;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createTabs");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling createTabs");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<Tabs> returnType = new GenericType<Tabs>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public Tabs deleteTabs(String accountId, String envelopeId, String recipientId, Tabs tabs) throws ApiException {
        Tabs postBody = tabs;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteTabs");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling deleteTabs");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<Tabs> returnType = new GenericType<Tabs>(){};
        return this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public TemplateInformation listTemplates(String accountId, String envelopeId) throws ApiException {
        return this.listTemplates(accountId, envelopeId, null);
    }

    public TemplateInformation listTemplates(String accountId, String envelopeId, ListTemplatesOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listTemplates");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listTemplates");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/templates".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "include", options.include));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<TemplateInformation> returnType = new GenericType<TemplateInformation>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public DocumentTemplateList applyTemplate(String accountId, String envelopeId, DocumentTemplateList documentTemplateList) throws ApiException {
        DocumentTemplateList postBody = documentTemplateList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling applyTemplate");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling applyTemplate");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/templates".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<DocumentTemplateList> returnType = new GenericType<DocumentTemplateList>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public ViewUrl createCorrectView(String accountId, String envelopeId, CorrectViewRequest correctViewRequest) throws ApiException {
        CorrectViewRequest postBody = correctViewRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createCorrectView");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createCorrectView");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/views/correct".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<ViewUrl> returnType = new GenericType<ViewUrl>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public ViewUrl createEditView(String accountId, String envelopeId, ReturnUrlRequest returnUrlRequest) throws ApiException {
        ReturnUrlRequest postBody = returnUrlRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createEditView");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createEditView");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/views/edit".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<ViewUrl> returnType = new GenericType<ViewUrl>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public ViewUrl createRecipientView(String accountId, String envelopeId, RecipientViewRequest recipientViewRequest) throws ApiException {
        RecipientViewRequest postBody = recipientViewRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createRecipientView");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createRecipientView");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/views/recipient".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<ViewUrl> returnType = new GenericType<ViewUrl>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public ViewUrl createSenderView(String accountId, String envelopeId, ReturnUrlRequest returnUrlRequest) throws ApiException {
        ReturnUrlRequest postBody = returnUrlRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createSenderView");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createSenderView");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/views/sender".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<ViewUrl> returnType = new GenericType<ViewUrl>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public ViewUrl createViewLink(String accountId, String envelopeId, ViewLinkRequest viewLinkRequest) throws ApiException {
        ViewLinkRequest postBody = viewLinkRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createViewLink");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createViewLink");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/views/viewlink".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<ViewUrl> returnType = new GenericType<ViewUrl>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public void deleteViewLink(String accountId, String envelopeId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteViewLink");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteViewLink");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/views/viewlink".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public TemplateDocumentVisibilityList updateTemplateRecipientsDocumentVisibility(String accountId, String templateId, TemplateDocumentVisibilityList templateDocumentVisibilityList) throws ApiException {
        TemplateDocumentVisibilityList postBody = templateDocumentVisibilityList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateTemplateRecipientsDocumentVisibility");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateTemplateRecipientsDocumentVisibility");
        }
        String path = "/v2/accounts/{accountId}/templates/{templateId}/recipients/document_visibility".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<TemplateDocumentVisibilityList> returnType = new GenericType<TemplateDocumentVisibilityList>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public DocumentVisibilityList getTemplateRecipientDocumentVisibility(String accountId, String templateId, String recipientId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getTemplateRecipientDocumentVisibility");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling getTemplateRecipientDocumentVisibility");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling getTemplateRecipientDocumentVisibility");
        }
        String path = "/v2/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/document_visibility".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<DocumentVisibilityList> returnType = new GenericType<DocumentVisibilityList>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public TemplateDocumentVisibilityList updateTemplateRecipientDocumentVisibility(String accountId, String templateId, String recipientId, TemplateDocumentVisibilityList templateDocumentVisibilityList) throws ApiException {
        TemplateDocumentVisibilityList postBody = templateDocumentVisibilityList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateTemplateRecipientDocumentVisibility");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling updateTemplateRecipientDocumentVisibility");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateTemplateRecipientDocumentVisibility");
        }
        String path = "/v2/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/document_visibility".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<TemplateDocumentVisibilityList> returnType = new GenericType<TemplateDocumentVisibilityList>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public ViewUrl createConsoleView(String accountId, ConsoleViewRequest consoleViewRequest) throws ApiException {
        ConsoleViewRequest postBody = consoleViewRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createConsoleView");
        }
        String path = "/v2/accounts/{accountId}/views/console".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<ViewUrl> returnType = new GenericType<ViewUrl>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public class ListTemplatesOptions {
        private String include = null;

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }
    }

    public class ListTabsOptions {
        private String includeAnchorTabLocations = null;
        private String includeMetadata = null;

        public void setIncludeAnchorTabLocations(String includeAnchorTabLocations) {
            this.includeAnchorTabLocations = includeAnchorTabLocations;
        }

        public String getIncludeAnchorTabLocations() {
            return this.includeAnchorTabLocations;
        }

        public void setIncludeMetadata(String includeMetadata) {
            this.includeMetadata = includeMetadata;
        }

        public String getIncludeMetadata() {
            return this.includeMetadata;
        }
    }

    public class GetRecipientSignatureImageOptions {
        private String includeChrome = null;

        public void setIncludeChrome(String includeChrome) {
            this.includeChrome = includeChrome;
        }

        public String getIncludeChrome() {
            return this.includeChrome;
        }
    }

    public class GetRecipientInitialsImageOptions {
        private String includeChrome = null;

        public void setIncludeChrome(String includeChrome) {
            this.includeChrome = includeChrome;
        }

        public String getIncludeChrome() {
            return this.includeChrome;
        }
    }

    public class GetConsumerDisclosureOptions {
        private String langCode2 = null;

        public void setLangCode2(String langCode2) {
            this.langCode2 = langCode2;
        }

        public String getLangCode2() {
            return this.langCode2;
        }
    }

    public class GetConsumerDisclosureDefaultOptions {
        private String langCode = null;

        public void setLangCode(String langCode) {
            this.langCode = langCode;
        }

        public String getLangCode() {
            return this.langCode;
        }
    }

    public class CreateRecipientOptions {
        private String resendEnvelope = null;

        public void setResendEnvelope(String resendEnvelope) {
            this.resendEnvelope = resendEnvelope;
        }

        public String getResendEnvelope() {
            return this.resendEnvelope;
        }
    }

    public class UpdateRecipientsOptions {
        private String resendEnvelope = null;

        public void setResendEnvelope(String resendEnvelope) {
            this.resendEnvelope = resendEnvelope;
        }

        public String getResendEnvelope() {
            return this.resendEnvelope;
        }
    }

    public class ListRecipientsOptions {
        private String includeAnchorTabLocations = null;
        private String includeExtended = null;
        private String includeMetadata = null;
        private String includeTabs = null;

        public void setIncludeAnchorTabLocations(String includeAnchorTabLocations) {
            this.includeAnchorTabLocations = includeAnchorTabLocations;
        }

        public String getIncludeAnchorTabLocations() {
            return this.includeAnchorTabLocations;
        }

        public void setIncludeExtended(String includeExtended) {
            this.includeExtended = includeExtended;
        }

        public String getIncludeExtended() {
            return this.includeExtended;
        }

        public void setIncludeMetadata(String includeMetadata) {
            this.includeMetadata = includeMetadata;
        }

        public String getIncludeMetadata() {
            return this.includeMetadata;
        }

        public void setIncludeTabs(String includeTabs) {
            this.includeTabs = includeTabs;
        }

        public String getIncludeTabs() {
            return this.includeTabs;
        }
    }

    public class ListTemplatesForDocumentOptions {
        private String include = null;

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }
    }

    public class GetDocumentPageImageOptions {
        private String dpi = null;
        private String maxHeight = null;
        private String maxWidth = null;
        private String showChanges = null;

        public void setDpi(String dpi) {
            this.dpi = dpi;
        }

        public String getDpi() {
            return this.dpi;
        }

        public void setMaxHeight(String maxHeight) {
            this.maxHeight = maxHeight;
        }

        public String getMaxHeight() {
            return this.maxHeight;
        }

        public void setMaxWidth(String maxWidth) {
            this.maxWidth = maxWidth;
        }

        public String getMaxWidth() {
            return this.maxWidth;
        }

        public void setShowChanges(String showChanges) {
            this.showChanges = showChanges;
        }

        public String getShowChanges() {
            return this.showChanges;
        }
    }

    public class UpdateDocumentOptions {
        private String applyDocumentFields = null;

        public void setApplyDocumentFields(String applyDocumentFields) {
            this.applyDocumentFields = applyDocumentFields;
        }

        public String getApplyDocumentFields() {
            return this.applyDocumentFields;
        }
    }

    public class GetDocumentOptions {
        private String certificate = null;
        private String encoding = null;
        private String encrypt = null;
        private String language = null;
        private String recipientId = null;
        private String showChanges = null;
        private String watermark = null;

        public void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        public String getCertificate() {
            return this.certificate;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setEncrypt(String encrypt) {
            this.encrypt = encrypt;
        }

        public String getEncrypt() {
            return this.encrypt;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setRecipientId(String recipientId) {
            this.recipientId = recipientId;
        }

        public String getRecipientId() {
            return this.recipientId;
        }

        public void setShowChanges(String showChanges) {
            this.showChanges = showChanges;
        }

        public String getShowChanges() {
            return this.showChanges;
        }

        public void setWatermark(String watermark) {
            this.watermark = watermark;
        }

        public String getWatermark() {
            return this.watermark;
        }
    }

    public class UpdateDocumentsOptions {
        private String applyDocumentFields = null;

        public void setApplyDocumentFields(String applyDocumentFields) {
            this.applyDocumentFields = applyDocumentFields;
        }

        public String getApplyDocumentFields() {
            return this.applyDocumentFields;
        }
    }

    public class ListDocumentsOptions {
        private String includeMetadata = null;

        public void setIncludeMetadata(String includeMetadata) {
            this.includeMetadata = includeMetadata;
        }

        public String getIncludeMetadata() {
            return this.includeMetadata;
        }
    }

    public class UpdateOptions {
        private String advancedUpdate = null;
        private String resendEnvelope = null;

        public void setAdvancedUpdate(String advancedUpdate) {
            this.advancedUpdate = advancedUpdate;
        }

        public String getAdvancedUpdate() {
            return this.advancedUpdate;
        }

        public void setResendEnvelope(String resendEnvelope) {
            this.resendEnvelope = resendEnvelope;
        }

        public String getResendEnvelope() {
            return this.resendEnvelope;
        }
    }

    public class GetEnvelopeOptions {
        private String advancedUpdate = null;
        private String include = null;

        public void setAdvancedUpdate(String advancedUpdate) {
            this.advancedUpdate = advancedUpdate;
        }

        public String getAdvancedUpdate() {
            return this.advancedUpdate;
        }

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }
    }

    public class ListStatusOptions {
        private String email = null;
        private String fromDate = null;
        private String startPosition = null;
        private String toDate = null;

        public void setEmail(String email) {
            this.email = email;
        }

        public String getEmail() {
            return this.email;
        }

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }
    }

    public class CreateEnvelopeOptions {
        private String cdseMode = null;
        private String completedDocumentsOnly = null;
        private String mergeRolesOnDraft = null;

        public void setCdseMode(String cdseMode) {
            this.cdseMode = cdseMode;
        }

        public String getCdseMode() {
            return this.cdseMode;
        }

        public void setCompletedDocumentsOnly(String completedDocumentsOnly) {
            this.completedDocumentsOnly = completedDocumentsOnly;
        }

        public String getCompletedDocumentsOnly() {
            return this.completedDocumentsOnly;
        }

        public void setMergeRolesOnDraft(String mergeRolesOnDraft) {
            this.mergeRolesOnDraft = mergeRolesOnDraft;
        }

        public String getMergeRolesOnDraft() {
            return this.mergeRolesOnDraft;
        }
    }

    public class ListStatusChangesOptions {
        private String acStatus = null;
        private String block = null;
        private String count = null;
        private String customField = null;
        private String email = null;
        private String envelopeIds = null;
        private String exclude = null;
        private String folderIds = null;
        private String folderTypes = null;
        private String fromDate = null;
        private String fromToStatus = null;
        private String include = null;
        private String intersectingFolderIds = null;
        private String order = null;
        private String orderBy = null;
        private String powerformids = null;
        private String searchText = null;
        private String startPosition = null;
        private String status = null;
        private String toDate = null;
        private String transactionIds = null;
        private String userFilter = null;
        private String userId = null;
        private String userName = null;

        public void setAcStatus(String acStatus) {
            this.acStatus = acStatus;
        }

        public String getAcStatus() {
            return this.acStatus;
        }

        public void setBlock(String block) {
            this.block = block;
        }

        public String getBlock() {
            return this.block;
        }

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setCustomField(String customField) {
            this.customField = customField;
        }

        public String getCustomField() {
            return this.customField;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEnvelopeIds(String envelopeIds) {
            this.envelopeIds = envelopeIds;
        }

        public String getEnvelopeIds() {
            return this.envelopeIds;
        }

        public void setExclude(String exclude) {
            this.exclude = exclude;
        }

        public String getExclude() {
            return this.exclude;
        }

        public void setFolderIds(String folderIds) {
            this.folderIds = folderIds;
        }

        public String getFolderIds() {
            return this.folderIds;
        }

        public void setFolderTypes(String folderTypes) {
            this.folderTypes = folderTypes;
        }

        public String getFolderTypes() {
            return this.folderTypes;
        }

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setFromToStatus(String fromToStatus) {
            this.fromToStatus = fromToStatus;
        }

        public String getFromToStatus() {
            return this.fromToStatus;
        }

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }

        public void setIntersectingFolderIds(String intersectingFolderIds) {
            this.intersectingFolderIds = intersectingFolderIds;
        }

        public String getIntersectingFolderIds() {
            return this.intersectingFolderIds;
        }

        public void setOrder(String order) {
            this.order = order;
        }

        public String getOrder() {
            return this.order;
        }

        public void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        public String getOrderBy() {
            return this.orderBy;
        }

        public void setPowerformids(String powerformids) {
            this.powerformids = powerformids;
        }

        public String getPowerformids() {
            return this.powerformids;
        }

        public void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        public String getSearchText() {
            return this.searchText;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }

        public void setTransactionIds(String transactionIds) {
            this.transactionIds = transactionIds;
        }

        public String getTransactionIds() {
            return this.transactionIds;
        }

        public void setUserFilter(String userFilter) {
            this.userFilter = userFilter;
        }

        public String getUserFilter() {
            return this.userFilter;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getUserName() {
            return this.userName;
        }
    }

    public class UpdateChunkedUploadOptions {
        private String action = null;

        public void setAction(String action) {
            this.action = action;
        }

        public String getAction() {
            return this.action;
        }
    }

    public class GetChunkedUploadOptions {
        private String include = null;

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }
    }
}

