/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.SigningGroup;
import com.docusign.esign.model.SigningGroupInformation;
import com.docusign.esign.model.SigningGroupUsers;
import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class SigningGroupsApi {
    private ApiClient apiClient;

    public SigningGroupsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SigningGroupsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public SigningGroupInformation list(String accountId) throws ApiException {
        return this.list(accountId, null);
    }

    public SigningGroupInformation list(String accountId, ListOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling list");
        }
        String path = "/v2/accounts/{accountId}/signing_groups".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "group_type", options.groupType));
            queryParams.addAll(this.apiClient.parameterToPairs("", "include_users", options.includeUsers));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<SigningGroupInformation> returnType = new GenericType<SigningGroupInformation>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public SigningGroupInformation updateList(String accountId, SigningGroupInformation signingGroupInformation) throws ApiException {
        SigningGroupInformation postBody = signingGroupInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateList");
        }
        String path = "/v2/accounts/{accountId}/signing_groups".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<SigningGroupInformation> returnType = new GenericType<SigningGroupInformation>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public SigningGroupInformation createList(String accountId, SigningGroupInformation signingGroupInformation) throws ApiException {
        SigningGroupInformation postBody = signingGroupInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createList");
        }
        String path = "/v2/accounts/{accountId}/signing_groups".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<SigningGroupInformation> returnType = new GenericType<SigningGroupInformation>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public SigningGroupInformation deleteList(String accountId, SigningGroupInformation signingGroupInformation) throws ApiException {
        SigningGroupInformation postBody = signingGroupInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteList");
        }
        String path = "/v2/accounts/{accountId}/signing_groups".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<SigningGroupInformation> returnType = new GenericType<SigningGroupInformation>(){};
        return this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public SigningGroup get(String accountId, String signingGroupId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling get");
        }
        if (signingGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'signingGroupId' when calling get");
        }
        String path = "/v2/accounts/{accountId}/signing_groups/{signingGroupId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{signingGroupId\\}", this.apiClient.escapeString(signingGroupId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<SigningGroup> returnType = new GenericType<SigningGroup>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public SigningGroup update(String accountId, String signingGroupId, SigningGroup signingGroup) throws ApiException {
        SigningGroup postBody = signingGroup;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling update");
        }
        if (signingGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'signingGroupId' when calling update");
        }
        String path = "/v2/accounts/{accountId}/signing_groups/{signingGroupId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{signingGroupId\\}", this.apiClient.escapeString(signingGroupId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<SigningGroup> returnType = new GenericType<SigningGroup>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public SigningGroupUsers listUsers(String accountId, String signingGroupId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listUsers");
        }
        if (signingGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'signingGroupId' when calling listUsers");
        }
        String path = "/v2/accounts/{accountId}/signing_groups/{signingGroupId}/users".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{signingGroupId\\}", this.apiClient.escapeString(signingGroupId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<SigningGroupUsers> returnType = new GenericType<SigningGroupUsers>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public SigningGroupUsers updateUsers(String accountId, String signingGroupId, SigningGroupUsers signingGroupUsers) throws ApiException {
        SigningGroupUsers postBody = signingGroupUsers;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateUsers");
        }
        if (signingGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'signingGroupId' when calling updateUsers");
        }
        String path = "/v2/accounts/{accountId}/signing_groups/{signingGroupId}/users".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{signingGroupId\\}", this.apiClient.escapeString(signingGroupId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<SigningGroupUsers> returnType = new GenericType<SigningGroupUsers>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public SigningGroupUsers deleteUsers(String accountId, String signingGroupId, SigningGroupUsers signingGroupUsers) throws ApiException {
        SigningGroupUsers postBody = signingGroupUsers;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteUsers");
        }
        if (signingGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'signingGroupId' when calling deleteUsers");
        }
        String path = "/v2/accounts/{accountId}/signing_groups/{signingGroupId}/users".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{signingGroupId\\}", this.apiClient.escapeString(signingGroupId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        GenericType<SigningGroupUsers> returnType = new GenericType<SigningGroupUsers>(){};
        return this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public class ListOptions {
        private String groupType = null;
        private String includeUsers = null;

        public void setGroupType(String groupType) {
            this.groupType = groupType;
        }

        public String getGroupType() {
            return this.groupType;
        }

        public void setIncludeUsers(String includeUsers) {
            this.includeUsers = includeUsers;
        }

        public String getIncludeUsers() {
            return this.includeUsers;
        }
    }
}

