/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.AppStoreProduct;
import com.docusign.esign.model.CurrencyPlanPrice;
import com.docusign.esign.model.FeatureSet;
import com.docusign.esign.model.SeatDiscount;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Contains information about a billing plan.")
public class BillingPlan {
    private List<AppStoreProduct> appStoreProducts = new ArrayList<AppStoreProduct>();
    private List<CurrencyPlanPrice> currencyPlanPrices = new ArrayList<CurrencyPlanPrice>();
    private String enableSupport = null;
    private String includedSeats = null;
    private String otherDiscountPercent = null;
    private String paymentCycle = null;
    private String paymentMethod = null;
    private String perSeatPrice = null;
    private String planClassification = null;
    private List<FeatureSet> planFeatureSets = new ArrayList<FeatureSet>();
    private String planId = null;
    private String planName = null;
    private List<SeatDiscount> seatDiscounts = new ArrayList<SeatDiscount>();
    private String supportIncidentFee = null;
    private String supportPlanFee = null;

    @ApiModelProperty(value="Reserved: TBD")
    @JsonProperty(value="appStoreProducts")
    public List<AppStoreProduct> getAppStoreProducts() {
        return this.appStoreProducts;
    }

    public void setAppStoreProducts(List<AppStoreProduct> appStoreProducts) {
        this.appStoreProducts = appStoreProducts;
    }

    @ApiModelProperty(value="Contains the currencyCode and currencySymbol for the alternate currency values for envelopeFee, fixedFee, and seatFee that are configured for this plan feature set.")
    @JsonProperty(value="currencyPlanPrices")
    public List<CurrencyPlanPrice> getCurrencyPlanPrices() {
        return this.currencyPlanPrices;
    }

    public void setCurrencyPlanPrices(List<CurrencyPlanPrice> currencyPlanPrices) {
        this.currencyPlanPrices = currencyPlanPrices;
    }

    @ApiModelProperty(value="When set to **true**, then customer support is provided as part of the account plan.")
    @JsonProperty(value="enableSupport")
    public String getEnableSupport() {
        return this.enableSupport;
    }

    public void setEnableSupport(String enableSupport) {
        this.enableSupport = enableSupport;
    }

    @ApiModelProperty(value="The number of seats (users) included.")
    @JsonProperty(value="includedSeats")
    public String getIncludedSeats() {
        return this.includedSeats;
    }

    public void setIncludedSeats(String includedSeats) {
        this.includedSeats = includedSeats;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="otherDiscountPercent")
    public String getOtherDiscountPercent() {
        return this.otherDiscountPercent;
    }

    public void setOtherDiscountPercent(String otherDiscountPercent) {
        this.otherDiscountPercent = otherDiscountPercent;
    }

    @ApiModelProperty(value="The payment cycle associated with the plan. The possible values are: Monthly or Annually.")
    @JsonProperty(value="paymentCycle")
    public String getPaymentCycle() {
        return this.paymentCycle;
    }

    public void setPaymentCycle(String paymentCycle) {
        this.paymentCycle = paymentCycle;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="paymentMethod")
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    @ApiModelProperty(value="The per seat price for the plan.")
    @JsonProperty(value="perSeatPrice")
    public String getPerSeatPrice() {
        return this.perSeatPrice;
    }

    public void setPerSeatPrice(String perSeatPrice) {
        this.perSeatPrice = perSeatPrice;
    }

    @ApiModelProperty(value="Identifies the type of plan. Examples include Business, Corporate, Enterprise, Free.")
    @JsonProperty(value="planClassification")
    public String getPlanClassification() {
        return this.planClassification;
    }

    public void setPlanClassification(String planClassification) {
        this.planClassification = planClassification;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="planFeatureSets")
    public List<FeatureSet> getPlanFeatureSets() {
        return this.planFeatureSets;
    }

    public void setPlanFeatureSets(List<FeatureSet> planFeatureSets) {
        this.planFeatureSets = planFeatureSets;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="planId")
    public String getPlanId() {
        return this.planId;
    }

    public void setPlanId(String planId) {
        this.planId = planId;
    }

    @ApiModelProperty(value="The name of the Billing Plan.")
    @JsonProperty(value="planName")
    public String getPlanName() {
        return this.planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="seatDiscounts")
    public List<SeatDiscount> getSeatDiscounts() {
        return this.seatDiscounts;
    }

    public void setSeatDiscounts(List<SeatDiscount> seatDiscounts) {
        this.seatDiscounts = seatDiscounts;
    }

    @ApiModelProperty(value="The support incident fee charged for each support incident.")
    @JsonProperty(value="supportIncidentFee")
    public String getSupportIncidentFee() {
        return this.supportIncidentFee;
    }

    public void setSupportIncidentFee(String supportIncidentFee) {
        this.supportIncidentFee = supportIncidentFee;
    }

    @ApiModelProperty(value="The support plan fee charged for this plan.")
    @JsonProperty(value="supportPlanFee")
    public String getSupportPlanFee() {
        return this.supportPlanFee;
    }

    public void setSupportPlanFee(String supportPlanFee) {
        this.supportPlanFee = supportPlanFee;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingPlan billingPlan = (BillingPlan)o;
        return Objects.equals(this.appStoreProducts, billingPlan.appStoreProducts) && Objects.equals(this.currencyPlanPrices, billingPlan.currencyPlanPrices) && Objects.equals(this.enableSupport, billingPlan.enableSupport) && Objects.equals(this.includedSeats, billingPlan.includedSeats) && Objects.equals(this.otherDiscountPercent, billingPlan.otherDiscountPercent) && Objects.equals(this.paymentCycle, billingPlan.paymentCycle) && Objects.equals(this.paymentMethod, billingPlan.paymentMethod) && Objects.equals(this.perSeatPrice, billingPlan.perSeatPrice) && Objects.equals(this.planClassification, billingPlan.planClassification) && Objects.equals(this.planFeatureSets, billingPlan.planFeatureSets) && Objects.equals(this.planId, billingPlan.planId) && Objects.equals(this.planName, billingPlan.planName) && Objects.equals(this.seatDiscounts, billingPlan.seatDiscounts) && Objects.equals(this.supportIncidentFee, billingPlan.supportIncidentFee) && Objects.equals(this.supportPlanFee, billingPlan.supportPlanFee);
    }

    public int hashCode() {
        return Objects.hash(this.appStoreProducts, this.currencyPlanPrices, this.enableSupport, this.includedSeats, this.otherDiscountPercent, this.paymentCycle, this.paymentMethod, this.perSeatPrice, this.planClassification, this.planFeatureSets, this.planId, this.planName, this.seatDiscounts, this.supportIncidentFee, this.supportPlanFee);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingPlan {\n");
        if (this.appStoreProducts != null) {
            sb.append("    appStoreProducts: ").append(this.toIndentedString(this.appStoreProducts)).append("\n");
        }
        if (this.currencyPlanPrices != null) {
            sb.append("    currencyPlanPrices: ").append(this.toIndentedString(this.currencyPlanPrices)).append("\n");
        }
        if (this.enableSupport != null) {
            sb.append("    enableSupport: ").append(this.toIndentedString(this.enableSupport)).append("\n");
        }
        if (this.includedSeats != null) {
            sb.append("    includedSeats: ").append(this.toIndentedString(this.includedSeats)).append("\n");
        }
        if (this.otherDiscountPercent != null) {
            sb.append("    otherDiscountPercent: ").append(this.toIndentedString(this.otherDiscountPercent)).append("\n");
        }
        if (this.paymentCycle != null) {
            sb.append("    paymentCycle: ").append(this.toIndentedString(this.paymentCycle)).append("\n");
        }
        if (this.paymentMethod != null) {
            sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        }
        if (this.perSeatPrice != null) {
            sb.append("    perSeatPrice: ").append(this.toIndentedString(this.perSeatPrice)).append("\n");
        }
        if (this.planClassification != null) {
            sb.append("    planClassification: ").append(this.toIndentedString(this.planClassification)).append("\n");
        }
        if (this.planFeatureSets != null) {
            sb.append("    planFeatureSets: ").append(this.toIndentedString(this.planFeatureSets)).append("\n");
        }
        if (this.planId != null) {
            sb.append("    planId: ").append(this.toIndentedString(this.planId)).append("\n");
        }
        if (this.planName != null) {
            sb.append("    planName: ").append(this.toIndentedString(this.planName)).append("\n");
        }
        if (this.seatDiscounts != null) {
            sb.append("    seatDiscounts: ").append(this.toIndentedString(this.seatDiscounts)).append("\n");
        }
        if (this.supportIncidentFee != null) {
            sb.append("    supportIncidentFee: ").append(this.toIndentedString(this.supportIncidentFee)).append("\n");
        }
        if (this.supportPlanFee != null) {
            sb.append("    supportPlanFee: ").append(this.toIndentedString(this.supportPlanFee)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

