/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.BulkRecipientSignatureProvider;
import com.docusign.esign.model.BulkRecipientTabLabel;
import com.docusign.esign.model.ErrorDetails;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class BulkRecipient {
    private String accessCode = null;
    private String email = null;
    private List<ErrorDetails> errorDetails = new ArrayList<ErrorDetails>();
    private String identification = null;
    private String name = null;
    private String note = null;
    private String phoneNumber = null;
    private List<BulkRecipientSignatureProvider> recipientSignatureProviderInfo = new ArrayList<BulkRecipientSignatureProvider>();
    private String rowNumber = null;
    private List<BulkRecipientTabLabel> tabLabels = new ArrayList<BulkRecipientTabLabel>();

    @ApiModelProperty(value="If a value is provided, the recipient must enter the value as the access code to view and sign the envelope. \n\nMaximum Length: 50 characters and it must conform to the account\u2019s access code format setting.\n\nIf blank, but the signer `accessCode` property is set in the envelope, then that value is used.\n\nIf blank and the signer `accessCode` property is not set, then the access code is not required.")
    @JsonProperty(value="accessCode")
    public String getAccessCode() {
        return this.accessCode;
    }

    public void setAccessCode(String accessCode) {
        this.accessCode = accessCode;
    }

    @ApiModelProperty(value="Specifies the recipient's email address. \n\nMaximum length: 100 characters.")
    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @ApiModelProperty(value="Array or errors.")
    @JsonProperty(value="errorDetails")
    public List<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(List<ErrorDetails> errorDetails) {
        this.errorDetails = errorDetails;
    }

    @ApiModelProperty(value="Specifies the authentication check used for the signer. If blank then no authentication check is required for the signer. Only one value can be used in this field.\n\nThe acceptable values are:\n\n* KBA: Enables the normal ID check authentication set up for your account.\n* Phone: Enables phone authentication.\n* SMS: Enables SMS authentication.")
    @JsonProperty(value="identification")
    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    @ApiModelProperty(value="Specifies the recipient's name. \n\nMaximum length: 50 characters.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="Specifies a note that is unique to this recipient. This note is sent to the recipient via the signing email. The note displays in the signing UI near the upper left corner of the document on the signing screen.\n\nMaximum Length: 1000 characters.")
    @JsonProperty(value="note")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    @ApiModelProperty(value="This is only used if the Identification field value is Phone or SMS. The value for this field can be a valid telephone number or, if Phone, usersupplied (SMS authentication cannot use a user supplied number). Parenthesis and dashes can be used in the telephone number.\n\nIf `usersupplied` is used, the signer supplies his or her own telephone number.")
    @JsonProperty(value="phoneNumber")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="recipientSignatureProviderInfo")
    public List<BulkRecipientSignatureProvider> getRecipientSignatureProviderInfo() {
        return this.recipientSignatureProviderInfo;
    }

    public void setRecipientSignatureProviderInfo(List<BulkRecipientSignatureProvider> recipientSignatureProviderInfo) {
        this.recipientSignatureProviderInfo = recipientSignatureProviderInfo;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="rowNumber")
    public String getRowNumber() {
        return this.rowNumber;
    }

    public void setRowNumber(String rowNumber) {
        this.rowNumber = rowNumber;
    }

    @ApiModelProperty(value="Specifies values used to populate recipient tabs with information. This allows each bulk recipient signer to have different values for their associated tabs. Any number of `tabLabel` columns can be added to the bulk recipient file.\n\nThe information used in the bulk recipient file header must be the same as the `tabLabel` for the tab.\n\nThe values entered in this column are automatically inserted into the corresponding tab for the recipient in the same row.\n\nNote that this option cannot be used for tabs that do not have data or that are automatically populated data such as Signature, Full Name, Email Address, Company, Title, and Date Signed tabs.")
    @JsonProperty(value="tabLabels")
    public List<BulkRecipientTabLabel> getTabLabels() {
        return this.tabLabels;
    }

    public void setTabLabels(List<BulkRecipientTabLabel> tabLabels) {
        this.tabLabels = tabLabels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkRecipient bulkRecipient = (BulkRecipient)o;
        return Objects.equals(this.accessCode, bulkRecipient.accessCode) && Objects.equals(this.email, bulkRecipient.email) && Objects.equals(this.errorDetails, bulkRecipient.errorDetails) && Objects.equals(this.identification, bulkRecipient.identification) && Objects.equals(this.name, bulkRecipient.name) && Objects.equals(this.note, bulkRecipient.note) && Objects.equals(this.phoneNumber, bulkRecipient.phoneNumber) && Objects.equals(this.recipientSignatureProviderInfo, bulkRecipient.recipientSignatureProviderInfo) && Objects.equals(this.rowNumber, bulkRecipient.rowNumber) && Objects.equals(this.tabLabels, bulkRecipient.tabLabels);
    }

    public int hashCode() {
        return Objects.hash(this.accessCode, this.email, this.errorDetails, this.identification, this.name, this.note, this.phoneNumber, this.recipientSignatureProviderInfo, this.rowNumber, this.tabLabels);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkRecipient {\n");
        if (this.accessCode != null) {
            sb.append("    accessCode: ").append(this.toIndentedString(this.accessCode)).append("\n");
        }
        if (this.email != null) {
            sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        }
        if (this.errorDetails != null) {
            sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        }
        if (this.identification != null) {
            sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        }
        if (this.name != null) {
            sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        }
        if (this.note != null) {
            sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        }
        if (this.phoneNumber != null) {
            sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        }
        if (this.recipientSignatureProviderInfo != null) {
            sb.append("    recipientSignatureProviderInfo: ").append(this.toIndentedString(this.recipientSignatureProviderInfo)).append("\n");
        }
        if (this.rowNumber != null) {
            sb.append("    rowNumber: ").append(this.toIndentedString(this.rowNumber)).append("\n");
        }
        if (this.tabLabels != null) {
            sb.append("    tabLabels: ").append(this.toIndentedString(this.tabLabels)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

