/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.ErrorDetails;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class CloudStorageProvider {
    private String authenticationUrl = null;
    private ErrorDetails errorDetails = null;
    private String redirectUrl = null;
    private String service = null;
    private String serviceId = null;

    @ApiModelProperty(value="The authentication URL used for the cloud storage provider. This information is only included in the response if the user has not passed authentication for the cloud storage provider. If the redirectUrl query string is provided, the returnUrl is appended to the authenticationUrl.")
    @JsonProperty(value="authenticationUrl")
    public String getAuthenticationUrl() {
        return this.authenticationUrl;
    }

    public void setAuthenticationUrl(String authenticationUrl) {
        this.authenticationUrl = authenticationUrl;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="errorDetails")
    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
    }

    @ApiModelProperty(value="The URL the user is redirected to after the cloud storage provider authenticates the user. Using this will append the redirectUrl to the authenticationUrl.\n\nThe redirectUrl is restricted to URLs in the docusign.com or docusign.net domains.")
    @JsonProperty(value="redirectUrl")
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    @ApiModelProperty(value="The service name for the cloud storage provider.")
    @JsonProperty(value="service")
    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    @ApiModelProperty(value="The DocuSign generated ID for the cloud storage provider")
    @JsonProperty(value="serviceId")
    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudStorageProvider cloudStorageProvider = (CloudStorageProvider)o;
        return Objects.equals(this.authenticationUrl, cloudStorageProvider.authenticationUrl) && Objects.equals(this.errorDetails, cloudStorageProvider.errorDetails) && Objects.equals(this.redirectUrl, cloudStorageProvider.redirectUrl) && Objects.equals(this.service, cloudStorageProvider.service) && Objects.equals(this.serviceId, cloudStorageProvider.serviceId);
    }

    public int hashCode() {
        return Objects.hash(this.authenticationUrl, this.errorDetails, this.redirectUrl, this.service, this.serviceId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CloudStorageProvider {\n");
        if (this.authenticationUrl != null) {
            sb.append("    authenticationUrl: ").append(this.toIndentedString(this.authenticationUrl)).append("\n");
        }
        if (this.errorDetails != null) {
            sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        }
        if (this.redirectUrl != null) {
            sb.append("    redirectUrl: ").append(this.toIndentedString(this.redirectUrl)).append("\n");
        }
        if (this.service != null) {
            sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        }
        if (this.serviceId != null) {
            sb.append("    serviceId: ").append(this.toIndentedString(this.serviceId)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

