/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.UserInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A complex element containing the following information:\n\ntemplateId: Unique identifier of the template. If this is not provided, DocuSign will generate a value. \n\nname: Name of the template. Maximum length: 100 characters.\n\nshared: When set to **true**, the template is shared with the Everyone group in the account. If false, the template is only shared with the Administrator group.\n\npassword: Password, if the template is locked.\n\ndescription: Description of the template. Maximum Length: 500 characters.\n\npageCount: Number of document pages in the template.\n\nfolderName: The name of the folder the template is located in.\n\nfolderId: The ID for the folder.\n\nowner: The userName, email, userId, userType, and userStatus for the template owner.")
public class EnvelopeTemplateDefinition {
    private String description = null;
    private String folderId = null;
    private String folderName = null;
    private String folderUri = null;
    private String lastModified = null;
    private UserInfo lastModifiedBy = null;
    private String name = null;
    private String newPassword = null;
    private UserInfo owner = null;
    private Integer pageCount = null;
    private String parentFolderUri = null;
    private String password = null;
    private String shared = null;
    private String templateId = null;
    private String uri = null;

    @ApiModelProperty(value="")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(value="The ID for the folder.")
    @JsonProperty(value="folderId")
    public String getFolderId() {
        return this.folderId;
    }

    public void setFolderId(String folderId) {
        this.folderId = folderId;
    }

    @ApiModelProperty(value="The name of the folder in which the template is located.")
    @JsonProperty(value="folderName")
    public String getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    @ApiModelProperty(value="The URI of the folder.")
    @JsonProperty(value="folderUri")
    public String getFolderUri() {
        return this.folderUri;
    }

    public void setFolderUri(String folderUri) {
        this.folderUri = folderUri;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="lastModified")
    public String getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="lastModifiedBy")
    public UserInfo getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(UserInfo lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="newPassword")
    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="owner")
    public UserInfo getOwner() {
        return this.owner;
    }

    public void setOwner(UserInfo owner) {
        this.owner = owner;
    }

    @ApiModelProperty(value="An integer value specifying the number of document pages in the template. Omit this property if not submitting a page count.")
    @JsonProperty(value="pageCount")
    public Integer getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(Integer pageCount) {
        this.pageCount = pageCount;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="parentFolderUri")
    public String getParentFolderUri() {
        return this.parentFolderUri;
    }

    public void setParentFolderUri(String parentFolderUri) {
        this.parentFolderUri = parentFolderUri;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @ApiModelProperty(value="When set to **true**, this custom tab is shared.")
    @JsonProperty(value="shared")
    public String getShared() {
        return this.shared;
    }

    public void setShared(String shared) {
        this.shared = shared;
    }

    @ApiModelProperty(value="The unique identifier of the template. If this is not provided, DocuSign will generate a value.")
    @JsonProperty(value="templateId")
    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="uri")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvelopeTemplateDefinition envelopeTemplateDefinition = (EnvelopeTemplateDefinition)o;
        return Objects.equals(this.description, envelopeTemplateDefinition.description) && Objects.equals(this.folderId, envelopeTemplateDefinition.folderId) && Objects.equals(this.folderName, envelopeTemplateDefinition.folderName) && Objects.equals(this.folderUri, envelopeTemplateDefinition.folderUri) && Objects.equals(this.lastModified, envelopeTemplateDefinition.lastModified) && Objects.equals(this.lastModifiedBy, envelopeTemplateDefinition.lastModifiedBy) && Objects.equals(this.name, envelopeTemplateDefinition.name) && Objects.equals(this.newPassword, envelopeTemplateDefinition.newPassword) && Objects.equals(this.owner, envelopeTemplateDefinition.owner) && Objects.equals(this.pageCount, envelopeTemplateDefinition.pageCount) && Objects.equals(this.parentFolderUri, envelopeTemplateDefinition.parentFolderUri) && Objects.equals(this.password, envelopeTemplateDefinition.password) && Objects.equals(this.shared, envelopeTemplateDefinition.shared) && Objects.equals(this.templateId, envelopeTemplateDefinition.templateId) && Objects.equals(this.uri, envelopeTemplateDefinition.uri);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.folderId, this.folderName, this.folderUri, this.lastModified, this.lastModifiedBy, this.name, this.newPassword, this.owner, this.pageCount, this.parentFolderUri, this.password, this.shared, this.templateId, this.uri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EnvelopeTemplateDefinition {\n");
        if (this.description != null) {
            sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        }
        if (this.folderId != null) {
            sb.append("    folderId: ").append(this.toIndentedString(this.folderId)).append("\n");
        }
        if (this.folderName != null) {
            sb.append("    folderName: ").append(this.toIndentedString(this.folderName)).append("\n");
        }
        if (this.folderUri != null) {
            sb.append("    folderUri: ").append(this.toIndentedString(this.folderUri)).append("\n");
        }
        if (this.lastModified != null) {
            sb.append("    lastModified: ").append(this.toIndentedString(this.lastModified)).append("\n");
        }
        if (this.lastModifiedBy != null) {
            sb.append("    lastModifiedBy: ").append(this.toIndentedString(this.lastModifiedBy)).append("\n");
        }
        if (this.name != null) {
            sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        }
        if (this.newPassword != null) {
            sb.append("    newPassword: ").append(this.toIndentedString(this.newPassword)).append("\n");
        }
        if (this.owner != null) {
            sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        }
        if (this.pageCount != null) {
            sb.append("    pageCount: ").append(this.toIndentedString(this.pageCount)).append("\n");
        }
        if (this.parentFolderUri != null) {
            sb.append("    parentFolderUri: ").append(this.toIndentedString(this.parentFolderUri)).append("\n");
        }
        if (this.password != null) {
            sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        }
        if (this.shared != null) {
            sb.append("    shared: ").append(this.toIndentedString(this.shared)).append("\n");
        }
        if (this.templateId != null) {
            sb.append("    templateId: ").append(this.toIndentedString(this.templateId)).append("\n");
        }
        if (this.uri != null) {
            sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

