/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.Group;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class GroupInformation {
    private String endPosition = null;
    private List<Group> groups = new ArrayList<Group>();
    private String nextUri = null;
    private String previousUri = null;
    private String resultSetSize = null;
    private String startPosition = null;
    private String totalSetSize = null;

    @ApiModelProperty(value="The last position in the result set.")
    @JsonProperty(value="endPosition")
    public String getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(String endPosition) {
        this.endPosition = endPosition;
    }

    @ApiModelProperty(value="A collection group objects containing information about the groups returned.")
    @JsonProperty(value="groups")
    public List<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    @ApiModelProperty(value="The URI to the next chunk of records based on the search request. If the endPosition is the entire results of the search, this is null.")
    @JsonProperty(value="nextUri")
    public String getNextUri() {
        return this.nextUri;
    }

    public void setNextUri(String nextUri) {
        this.nextUri = nextUri;
    }

    @ApiModelProperty(value="The postal code for the billing address.")
    @JsonProperty(value="previousUri")
    public String getPreviousUri() {
        return this.previousUri;
    }

    public void setPreviousUri(String previousUri) {
        this.previousUri = previousUri;
    }

    @ApiModelProperty(value="The number of results returned in this response.")
    @JsonProperty(value="resultSetSize")
    public String getResultSetSize() {
        return this.resultSetSize;
    }

    public void setResultSetSize(String resultSetSize) {
        this.resultSetSize = resultSetSize;
    }

    @ApiModelProperty(value="Starting position of the current result set.")
    @JsonProperty(value="startPosition")
    public String getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(String startPosition) {
        this.startPosition = startPosition;
    }

    @ApiModelProperty(value="The total number of items available in the result set. This will always be greater than or equal to the value of the property returning the results in the in the response.")
    @JsonProperty(value="totalSetSize")
    public String getTotalSetSize() {
        return this.totalSetSize;
    }

    public void setTotalSetSize(String totalSetSize) {
        this.totalSetSize = totalSetSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupInformation groupInformation = (GroupInformation)o;
        return Objects.equals(this.endPosition, groupInformation.endPosition) && Objects.equals(this.groups, groupInformation.groups) && Objects.equals(this.nextUri, groupInformation.nextUri) && Objects.equals(this.previousUri, groupInformation.previousUri) && Objects.equals(this.resultSetSize, groupInformation.resultSetSize) && Objects.equals(this.startPosition, groupInformation.startPosition) && Objects.equals(this.totalSetSize, groupInformation.totalSetSize);
    }

    public int hashCode() {
        return Objects.hash(this.endPosition, this.groups, this.nextUri, this.previousUri, this.resultSetSize, this.startPosition, this.totalSetSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupInformation {\n");
        if (this.endPosition != null) {
            sb.append("    endPosition: ").append(this.toIndentedString(this.endPosition)).append("\n");
        }
        if (this.groups != null) {
            sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        }
        if (this.nextUri != null) {
            sb.append("    nextUri: ").append(this.toIndentedString(this.nextUri)).append("\n");
        }
        if (this.previousUri != null) {
            sb.append("    previousUri: ").append(this.toIndentedString(this.previousUri)).append("\n");
        }
        if (this.resultSetSize != null) {
            sb.append("    resultSetSize: ").append(this.toIndentedString(this.resultSetSize)).append("\n");
        }
        if (this.startPosition != null) {
            sb.append("    startPosition: ").append(this.toIndentedString(this.startPosition)).append("\n");
        }
        if (this.totalSetSize != null) {
            sb.append("    totalSetSize: ").append(this.toIndentedString(this.totalSetSize)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

