/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.NameValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LoginAccount {
    private String accountId = null;
    private String accountIdGuid = null;
    private String baseUrl = null;
    private String email = null;
    private String isDefault = null;
    private List<NameValue> loginAccountSettings = new ArrayList<NameValue>();
    private List<NameValue> loginUserSettings = new ArrayList<NameValue>();
    private String name = null;
    private String siteDescription = null;
    private String userId = null;
    private String userName = null;

    @ApiModelProperty(value="The account ID associated with the envelope.")
    @JsonProperty(value="accountId")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    @ApiModelProperty(value="The GUID associated with the account ID.")
    @JsonProperty(value="accountIdGuid")
    public String getAccountIdGuid() {
        return this.accountIdGuid;
    }

    public void setAccountIdGuid(String accountIdGuid) {
        this.accountIdGuid = accountIdGuid;
    }

    @ApiModelProperty(value="The URL that should be used for successive calls to this account. It includes the protocal (https), the DocuSign server where the account is located, and the account number. Use this Url to make API calls against this account. Many of the API calls provide Uri's that are relative to this baseUrl.")
    @JsonProperty(value="baseUrl")
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @ApiModelProperty(value="The email address for the user.")
    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @ApiModelProperty(value="This value is true if this is the default account for the user, otherwise false is returned.")
    @JsonProperty(value="isDefault")
    public String getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(String isDefault) {
        this.isDefault = isDefault;
    }

    @ApiModelProperty(value="A list of settings on the acccount that indicate what features are available.")
    @JsonProperty(value="loginAccountSettings")
    public List<NameValue> getLoginAccountSettings() {
        return this.loginAccountSettings;
    }

    public void setLoginAccountSettings(List<NameValue> loginAccountSettings) {
        this.loginAccountSettings = loginAccountSettings;
    }

    @ApiModelProperty(value="A list of user-level settings that indicate what user-specific features are available.")
    @JsonProperty(value="loginUserSettings")
    public List<NameValue> getLoginUserSettings() {
        return this.loginUserSettings;
    }

    public void setLoginUserSettings(List<NameValue> loginUserSettings) {
        this.loginUserSettings = loginUserSettings;
    }

    @ApiModelProperty(value="The name associated with the account.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="An optional descirption of the site that hosts the account.")
    @JsonProperty(value="siteDescription")
    public String getSiteDescription() {
        return this.siteDescription;
    }

    public void setSiteDescription(String siteDescription) {
        this.siteDescription = siteDescription;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @ApiModelProperty(value="The name of this user as defined by the account.")
    @JsonProperty(value="userName")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoginAccount loginAccount = (LoginAccount)o;
        return Objects.equals(this.accountId, loginAccount.accountId) && Objects.equals(this.accountIdGuid, loginAccount.accountIdGuid) && Objects.equals(this.baseUrl, loginAccount.baseUrl) && Objects.equals(this.email, loginAccount.email) && Objects.equals(this.isDefault, loginAccount.isDefault) && Objects.equals(this.loginAccountSettings, loginAccount.loginAccountSettings) && Objects.equals(this.loginUserSettings, loginAccount.loginUserSettings) && Objects.equals(this.name, loginAccount.name) && Objects.equals(this.siteDescription, loginAccount.siteDescription) && Objects.equals(this.userId, loginAccount.userId) && Objects.equals(this.userName, loginAccount.userName);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.accountIdGuid, this.baseUrl, this.email, this.isDefault, this.loginAccountSettings, this.loginUserSettings, this.name, this.siteDescription, this.userId, this.userName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LoginAccount {\n");
        if (this.accountId != null) {
            sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        }
        if (this.accountIdGuid != null) {
            sb.append("    accountIdGuid: ").append(this.toIndentedString(this.accountIdGuid)).append("\n");
        }
        if (this.baseUrl != null) {
            sb.append("    baseUrl: ").append(this.toIndentedString(this.baseUrl)).append("\n");
        }
        if (this.email != null) {
            sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        }
        if (this.isDefault != null) {
            sb.append("    isDefault: ").append(this.toIndentedString(this.isDefault)).append("\n");
        }
        if (this.loginAccountSettings != null) {
            sb.append("    loginAccountSettings: ").append(this.toIndentedString(this.loginAccountSettings)).append("\n");
        }
        if (this.loginUserSettings != null) {
            sb.append("    loginUserSettings: ").append(this.toIndentedString(this.loginUserSettings)).append("\n");
        }
        if (this.name != null) {
            sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        }
        if (this.siteDescription != null) {
            sb.append("    siteDescription: ").append(this.toIndentedString(this.siteDescription)).append("\n");
        }
        if (this.userId != null) {
            sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        }
        if (this.userName != null) {
            sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

