/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Reserved for DocuSign use.")
public class OfflineAttributes {
    private String accountEsignId = null;
    private String deviceModel = null;
    private String deviceName = null;
    private String gpsLatitude = null;
    private String gpsLongitude = null;
    private String offlineSigningHash = null;

    @ApiModelProperty(value="A GUID identifying the account associated with the consumer disclosure")
    @JsonProperty(value="accountEsignId")
    public String getAccountEsignId() {
        return this.accountEsignId;
    }

    public void setAccountEsignId(String accountEsignId) {
        this.accountEsignId = accountEsignId;
    }

    @ApiModelProperty(value="A string containing information about the model of the device used for offline signing.")
    @JsonProperty(value="deviceModel")
    public String getDeviceModel() {
        return this.deviceModel;
    }

    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    @ApiModelProperty(value="A string containing information about the type of device used for offline signing.")
    @JsonProperty(value="deviceName")
    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    @ApiModelProperty(value="A string containing the latitude of the device location at the time of signing.")
    @JsonProperty(value="gpsLatitude")
    public String getGpsLatitude() {
        return this.gpsLatitude;
    }

    public void setGpsLatitude(String gpsLatitude) {
        this.gpsLatitude = gpsLatitude;
    }

    @ApiModelProperty(value="A string containing the longitude of the device location at the time of signing.")
    @JsonProperty(value="gpsLongitude")
    public String getGpsLongitude() {
        return this.gpsLongitude;
    }

    public void setGpsLongitude(String gpsLongitude) {
        this.gpsLongitude = gpsLongitude;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="offlineSigningHash")
    public String getOfflineSigningHash() {
        return this.offlineSigningHash;
    }

    public void setOfflineSigningHash(String offlineSigningHash) {
        this.offlineSigningHash = offlineSigningHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfflineAttributes offlineAttributes = (OfflineAttributes)o;
        return Objects.equals(this.accountEsignId, offlineAttributes.accountEsignId) && Objects.equals(this.deviceModel, offlineAttributes.deviceModel) && Objects.equals(this.deviceName, offlineAttributes.deviceName) && Objects.equals(this.gpsLatitude, offlineAttributes.gpsLatitude) && Objects.equals(this.gpsLongitude, offlineAttributes.gpsLongitude) && Objects.equals(this.offlineSigningHash, offlineAttributes.offlineSigningHash);
    }

    public int hashCode() {
        return Objects.hash(this.accountEsignId, this.deviceModel, this.deviceName, this.gpsLatitude, this.gpsLongitude, this.offlineSigningHash);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OfflineAttributes {\n");
        if (this.accountEsignId != null) {
            sb.append("    accountEsignId: ").append(this.toIndentedString(this.accountEsignId)).append("\n");
        }
        if (this.deviceModel != null) {
            sb.append("    deviceModel: ").append(this.toIndentedString(this.deviceModel)).append("\n");
        }
        if (this.deviceName != null) {
            sb.append("    deviceName: ").append(this.toIndentedString(this.deviceName)).append("\n");
        }
        if (this.gpsLatitude != null) {
            sb.append("    gpsLatitude: ").append(this.toIndentedString(this.gpsLatitude)).append("\n");
        }
        if (this.gpsLongitude != null) {
            sb.append("    gpsLongitude: ").append(this.toIndentedString(this.gpsLongitude)).append("\n");
        }
        if (this.offlineSigningHash != null) {
            sb.append("    offlineSigningHash: ").append(this.toIndentedString(this.offlineSigningHash)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

