/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A complex element that specifies reminder settings for the envelope")
public class Reminders {
    private String reminderDelay = null;
    private String reminderEnabled = null;
    private String reminderFrequency = null;

    @ApiModelProperty(value="An interger that sets the number of days after the recipient receives the envelope that reminder emails are sent to the recipient.")
    @JsonProperty(value="reminderDelay")
    public String getReminderDelay() {
        return this.reminderDelay;
    }

    public void setReminderDelay(String reminderDelay) {
        this.reminderDelay = reminderDelay;
    }

    @ApiModelProperty(value="When set to **true**, the envelope expires (is no longer available for signing) in the set number of days. If false, the account default setting is used. If the account does not have an expiration setting, the DocuSign default value of 120 days is used.")
    @JsonProperty(value="reminderEnabled")
    public String getReminderEnabled() {
        return this.reminderEnabled;
    }

    public void setReminderEnabled(String reminderEnabled) {
        this.reminderEnabled = reminderEnabled;
    }

    @ApiModelProperty(value="An interger that sets the interval, in days, between reminder emails.")
    @JsonProperty(value="reminderFrequency")
    public String getReminderFrequency() {
        return this.reminderFrequency;
    }

    public void setReminderFrequency(String reminderFrequency) {
        this.reminderFrequency = reminderFrequency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reminders reminders = (Reminders)o;
        return Objects.equals(this.reminderDelay, reminders.reminderDelay) && Objects.equals(this.reminderEnabled, reminders.reminderEnabled) && Objects.equals(this.reminderFrequency, reminders.reminderFrequency);
    }

    public int hashCode() {
        return Objects.hash(this.reminderDelay, this.reminderEnabled, this.reminderFrequency);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Reminders {\n");
        if (this.reminderDelay != null) {
            sb.append("    reminderDelay: ").append(this.toIndentedString(this.reminderDelay)).append("\n");
        }
        if (this.reminderEnabled != null) {
            sb.append("    reminderEnabled: ").append(this.toIndentedString(this.reminderEnabled)).append("\n");
        }
        if (this.reminderFrequency != null) {
            sb.append("    reminderFrequency: ").append(this.toIndentedString(this.reminderFrequency)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

