/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.client;

import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.Pair;
import com.docusign.esign.client.StringUtil;
import com.docusign.esign.client.auth.AccessTokenListener;
import com.docusign.esign.client.auth.ApiKeyAuth;
import com.docusign.esign.client.auth.Authentication;
import com.docusign.esign.client.auth.HttpBasicAuth;
import com.docusign.esign.client.auth.JWTUtils;
import com.docusign.esign.client.auth.OAuth;
import com.docusign.esign.client.auth.OAuthFlow;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.migcomponents.migbase64.Base64;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.file.FileDataBodyPart;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;

public class ApiClient {
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    public static final String PRODUCTION_REST_BASEPATH = "https://www.docusign.net/restapi";
    public static final String DEMO_REST_BASEPATH = "https://demo.docusign.net/restapi";
    public static final String STAGE_REST_BASEPATH = "https://stage.docusign.net/restapi";
    private String basePath = "https://www.docusign.net/restapi";
    private String oAuthBasePath = "account.docusign.com";
    private boolean debugging = false;
    private int connectionTimeout = 0;
    private int readTimeout = 0;
    private Client httpClient;
    private ObjectMapper mapper = new ObjectMapper();
    private Map<String, Authentication> authentications;
    private int statusCode;
    private Map<String, List<String>> responseHeaders;
    private DateFormat dateFormat;
    private SSLContext sslContext = null;

    public ApiClient() {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        this.mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        this.mapper.registerModule((Module)new JodaModule());
        this.httpClient = this.buildHttpClient(this.debugging);
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.mapper.setDateFormat((DateFormat)this.dateFormat.clone());
        this.setUserAgent("Swagger-Codegen/2.11.0/java");
        this.authentications = new HashMap<String, Authentication>();
        this.authentications.put("docusignAccessCode", new OAuth(null, null, null));
        this.deriveOAuthBasePathFromRestBasePath();
        this.rebuildHttpClient();
    }

    public ApiClient(String basePath) {
        this();
        this.basePath = basePath;
        this.deriveOAuthBasePathFromRestBasePath();
    }

    public ApiClient(String oAuthBasePath, String[] authNames) {
        this();
        this.setOAuthBasePath(oAuthBasePath);
        for (String authName : authNames) {
            Authentication auth;
            if ("docusignAccessCode".equals(authName)) {
                auth = new OAuth(this.httpClient, OAuthFlow.accessCode, oAuthBasePath + "/oauth/auth", oAuthBasePath + "/oauth/token", "all");
            } else if ("docusignApiKey".equals(authName)) {
                auth = new ApiKeyAuth("header", "docusignApiKey");
            } else {
                throw new RuntimeException("auth name \"" + authName + "\" not found in available auth names");
            }
            this.addAuthorization(authName, auth);
        }
    }

    public ApiClient(String oAuthBasePath, String authName) {
        this(oAuthBasePath, new String[]{authName});
    }

    public ApiClient(String oAuthBasePath, String authName, String clientId, String secret) {
        this(oAuthBasePath, authName);
        this.getTokenEndPoint().setClientId(clientId).setClientSecret(secret);
    }

    public ApiClient rebuildHttpClient() {
        JacksonJsonProvider jsonProvider = new JacksonJsonProvider(this.mapper);
        DefaultClientConfig conf = new DefaultClientConfig();
        conf.getSingletons().add(jsonProvider);
        Client client = Client.create((ClientConfig)conf);
        if (this.debugging) {
            client.addFilter((ClientFilter)new LoggingFilter());
        }
        this.httpClient = client;
        return this;
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    public ApiClient setObjectMapper(ObjectMapper mapper) {
        this.mapper = mapper;
        this.rebuildHttpClient();
        return this;
    }

    public Client getHttpClient() {
        return this.httpClient;
    }

    public ApiClient setHttpClient(Client httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        this.deriveOAuthBasePathFromRestBasePath();
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Authentication getAuthentication(String authName) {
        return this.authentications.get(authName);
    }

    public void addAuthorization(String authName, Authentication auth) {
        this.authentications.put(authName, auth);
    }

    public void setUsername(String username) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setUsername(username);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setPassword(String password) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setPassword(password);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setApiKey(String apiKey) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKey(apiKey);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setApiKeyPrefix(String apiKeyPrefix) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKeyPrefix(apiKeyPrefix);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void updateAccessToken() {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            ((OAuth)auth).updateAccessToken();
            return;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    public void setAccessToken(String accessToken, Long expiresIn) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            ((OAuth)auth).setAccessToken(accessToken, expiresIn);
            return;
        }
        OAuth oAuth = new OAuth(null, null, null);
        oAuth.setAccessToken(accessToken, expiresIn);
        this.addAuthorization("docusignAccessCode", oAuth);
    }

    public String getAccessToken() {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            return ((OAuth)auth).getAccessToken();
        }
        return null;
    }

    public ApiClient setUserAgent(String userAgent) {
        this.addDefaultHeader("User-Agent", userAgent);
        return this;
    }

    public ApiClient addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
        return this;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public ApiClient setDebugging(boolean debugging) {
        this.debugging = debugging;
        this.httpClient = this.buildHttpClient(debugging);
        return this;
    }

    public int getConnectTimeout() {
        return this.connectionTimeout;
    }

    public ApiClient setConnectTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        this.httpClient.setConnectTimeout(Integer.valueOf(connectionTimeout));
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public ApiClient setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        this.httpClient.setReadTimeout(Integer.valueOf(readTimeout));
        return this;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.mapper.setDateFormat((DateFormat)dateFormat.clone());
        this.rebuildHttpClient();
        return this;
    }

    public OAuthClientRequest.TokenRequestBuilder getTokenEndPoint() {
        for (Authentication auth : this.getAuthentications().values()) {
            if (!(auth instanceof OAuth)) continue;
            OAuth oauth = (OAuth)auth;
            return oauth.getTokenRequestBuilder();
        }
        return null;
    }

    public OAuthClientRequest.AuthenticationRequestBuilder getAuthorizationEndPoint() {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            OAuth oauth = (OAuth)auth;
            return oauth.getAuthenticationRequestBuilder();
        }
        return null;
    }

    public void configureAuthorizationFlow(String clientId, String clientSecret, String redirectURI) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            OAuth oauth = (OAuth)auth;
            oauth.getTokenRequestBuilder().setClientId(clientId).setClientSecret(clientSecret).setRedirectURI(redirectURI);
            oauth.getAuthenticationRequestBuilder().setClientId(clientId).setRedirectURI(redirectURI);
            return;
        }
    }

    public String getAuthorizationUri() throws OAuthSystemException {
        return this.getAuthorizationEndPoint().buildQueryMessage().getLocationUri();
    }

    public URI getAuthorizationUri(String clientId, List<String> scopes, String redirectUri, String responseType, String state) throws IllegalArgumentException, UriBuilderException {
        String formattedScopes = scopes == null || scopes.size() < 1 ? "" : scopes.get(0);
        StringBuilder sb = new StringBuilder(formattedScopes);
        for (int i = 1; i < scopes.size(); ++i) {
            sb.append("%20" + scopes.get(i));
        }
        UriBuilder builder = UriBuilder.fromUri((String)this.getOAuthBasePath()).scheme("https").path("/oauth/auth").queryParam("response_type", new Object[]{responseType}).queryParam("scope", new Object[]{sb.toString()}).queryParam("client_id", new Object[]{clientId}).queryParam("redirect_uri", new Object[]{redirectUri});
        if (state != null) {
            builder = builder.queryParam("state", new Object[]{state});
        }
        return builder.build(new Object[0]);
    }

    public URI getAuthorizationUri(String clientId, List<String> scopes, String redirectUri, String responseType) throws IllegalArgumentException, UriBuilderException {
        return this.getAuthorizationUri(clientId, scopes, redirectUri, responseType, null);
    }

    private void deriveOAuthBasePathFromRestBasePath() {
        this.oAuthBasePath = this.basePath == null ? "account.docusign.com" : (this.basePath.startsWith("https://demo") || this.basePath.startsWith("http://demo") ? "account-d.docusign.com" : (this.basePath.startsWith("https://stage") || this.basePath.startsWith("http://stage") ? "account-s.docusign.com" : "account.docusign.com"));
    }

    private String getOAuthBasePath() {
        return this.oAuthBasePath;
    }

    public ApiClient setOAuthBasePath(String oAuthBasePath) {
        this.oAuthBasePath = oAuthBasePath;
        return this;
    }

    public OAuth.OAuthToken generateAccessToken(String clientId, String clientSecret, String code) throws ApiException, IOException {
        try {
            String clientStr = (clientId == null ? "" : clientId) + ":" + (clientSecret == null ? "" : clientSecret);
            MultivaluedMapImpl form = new MultivaluedMapImpl();
            form.add((Object)"code", (Object)code);
            form.add((Object)"grant_type", (Object)"authorization_code");
            Client client = this.buildHttpClient(this.debugging);
            WebResource webResource = client.resource("https://" + this.getOAuthBasePath() + "/oauth/token");
            ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)webResource.type(MediaType.APPLICATION_FORM_URLENCODED_TYPE).header("Authorization", (Object)("Basic " + Base64.encodeToString((byte[])clientStr.getBytes("UTF-8"), (boolean)false)))).header("Cache-Control", (Object)"no-store")).header("Pragma", (Object)"no-cache")).post(ClientResponse.class, (Object)form);
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                String respBody = (String)response.getEntity(String.class);
                throw new ApiException(response.getStatusInfo().getStatusCode(), "Error while requesting server, received a non successful HTTP code " + response.getStatusInfo().getStatusCode() + " with response Body: '" + respBody + "'", (Map<String, List<String>>)response.getHeaders(), respBody);
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            OAuth.OAuthToken oAuthToken = (OAuth.OAuthToken)mapper.readValue(response.getEntityInputStream(), OAuth.OAuthToken.class);
            return oAuthToken;
        }
        catch (JsonParseException e) {
            throw new ApiException("Error while parsing the response for the access token: " + e.getMessage());
        }
        catch (JsonMappingException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    public OAuth.UserInfo getUserInfo(String accessToken) throws IllegalArgumentException, ApiException {
        try {
            if (accessToken == null || "".equals(accessToken)) {
                throw new IllegalArgumentException("Cannot find a valid access token. Make sure OAuth is configured before you try again.");
            }
            Client client = this.buildHttpClient(this.debugging);
            WebResource webResource = client.resource("https://" + this.getOAuthBasePath() + "/oauth/userinfo");
            ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.header("Authorization", (Object)("Bearer " + accessToken)).header("Cache-Control", (Object)"no-store")).header("Pragma", (Object)"no-cache")).get(ClientResponse.class);
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                String respBody = (String)response.getEntity(String.class);
                throw new ApiException(response.getStatusInfo().getStatusCode(), "Error while requesting server, received a non successful HTTP code " + response.getStatusInfo().getStatusCode() + " with response Body: '" + respBody + "'", (Map<String, List<String>>)response.getHeaders(), respBody);
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            OAuth.UserInfo userInfo = (OAuth.UserInfo)mapper.readValue(response.getEntityInputStream(), OAuth.UserInfo.class);
            return userInfo;
        }
        catch (Exception e) {
            throw new ApiException("Error while fetching user info: " + e.getMessage());
        }
    }

    public void registerAccessTokenListener(AccessTokenListener accessTokenListener) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            OAuth oauth = (OAuth)auth;
            oauth.registerAccessTokenListener(accessTokenListener);
            return;
        }
    }

    public String getJWTUri(String clientId, String redirectURI, String oAuthBasePath) {
        return UriBuilder.fromUri((String)oAuthBasePath).scheme("https").path("/oauth/auth").queryParam("response_type", new Object[]{"code"}).queryParam("scope", new Object[]{"signature%20impersonation"}).queryParam("client_id", new Object[]{clientId}).queryParam("redirect_uri", new Object[]{redirectURI}).build(new Object[0]).toString();
    }

    @Deprecated
    public void configureJWTAuthorizationFlow(String publicKeyFilename, String privateKeyFilename, String oAuthBasePath, String clientId, String userId, long expiresIn) throws IOException, ApiException {
        try {
            String assertion = JWTUtils.generateJWTAssertion(publicKeyFilename, privateKeyFilename, oAuthBasePath, clientId, userId, expiresIn);
            MultivaluedMapImpl form = new MultivaluedMapImpl();
            form.add((Object)"assertion", (Object)assertion);
            form.add((Object)"grant_type", (Object)"urn:ietf:params:oauth:grant-type:jwt-bearer");
            Client client = this.buildHttpClient(this.debugging);
            WebResource webResource = client.resource("https://" + oAuthBasePath + "/oauth/token");
            ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.type(MediaType.APPLICATION_FORM_URLENCODED_TYPE).header("Cache-Control", (Object)"no-store")).header("Pragma", (Object)"no-cache")).post(ClientResponse.class, (Object)form);
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            JsonNode responseJson = (JsonNode)mapper.readValue(response.getEntityInputStream(), JsonNode.class);
            if (!responseJson.has("access_token") || !responseJson.has("expires_in")) {
                throw new ApiException("Error while requesting an access token: " + responseJson);
            }
            String accessToken = responseJson.get("access_token").asText();
            expiresIn = responseJson.get("expires_in").asLong();
            this.setAccessToken(accessToken, expiresIn);
        }
        catch (JsonParseException e) {
            throw new ApiException("Error while parsing the response for the access token.");
        }
        catch (JsonMappingException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    public OAuth.OAuthToken requestJWTUserToken(String clientId, String userId, List<String> scopes, byte[] rsaPrivateKey, long expiresIn) throws IllegalArgumentException, IOException, ApiException {
        String formattedScopes = scopes == null || scopes.size() < 1 ? "" : scopes.get(0);
        StringBuilder sb = new StringBuilder(formattedScopes);
        for (int i = 1; i < scopes.size(); ++i) {
            sb.append(" " + scopes.get(i));
        }
        try {
            String assertion = JWTUtils.generateJWTAssertionFromByteArray(rsaPrivateKey, this.getOAuthBasePath(), clientId, userId, expiresIn, sb.toString());
            MultivaluedMapImpl form = new MultivaluedMapImpl();
            form.add((Object)"assertion", (Object)assertion);
            form.add((Object)"grant_type", (Object)"urn:ietf:params:oauth:grant-type:jwt-bearer");
            Client client = this.buildHttpClient(this.debugging);
            WebResource webResource = client.resource("https://" + this.getOAuthBasePath() + "/oauth/token");
            ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.type(MediaType.APPLICATION_FORM_URLENCODED_TYPE).header("Cache-Control", (Object)"no-store")).header("Pragma", (Object)"no-cache")).post(ClientResponse.class, (Object)form);
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            OAuth.OAuthToken oAuthToken = (OAuth.OAuthToken)mapper.readValue(response.getEntityInputStream(), OAuth.OAuthToken.class);
            if (oAuthToken.getAccessToken() == null || "".equals(oAuthToken.getAccessToken()) || oAuthToken.getExpiresIn() <= 0L) {
                throw new ApiException("Error while requesting an access token: " + response.toString());
            }
            return oAuthToken;
        }
        catch (JsonParseException e) {
            throw new ApiException("Error while parsing the response for the access token: " + (Object)((Object)e));
        }
        catch (JsonMappingException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    public OAuth.OAuthToken requestJWTApplicationToken(String clientId, List<String> scopes, byte[] rsaPrivateKey, long expiresIn) throws IllegalArgumentException, IOException, ApiException {
        return this.requestJWTUserToken(clientId, null, scopes, rsaPrivateKey, expiresIn);
    }

    public Date parseDate(String str) {
        try {
            return this.dateFormat.parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date) {
            return this.formatDate((Date)param);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Object value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null) {
            return params;
        }
        Collection valueCollection = null;
        if (!(value instanceof Collection)) {
            params.add(new Pair(name, this.parameterToString(value)));
            return params;
        }
        valueCollection = (Collection)value;
        if (valueCollection.isEmpty()) {
            return params;
        }
        String string = collectionFormat = collectionFormat == null || collectionFormat.isEmpty() ? "csv" : collectionFormat;
        if ("multi".equals(collectionFormat)) {
            for (Object item : valueCollection) {
                params.add(new Pair(name, this.parameterToString(item)));
            }
            return params;
        }
        String delimiter = ",";
        if ("csv".equals(collectionFormat)) {
            delimiter = ",";
        } else if ("ssv".equals(collectionFormat)) {
            delimiter = " ";
        } else if ("tsv".equals(collectionFormat)) {
            delimiter = "\t";
        } else if ("pipes".equals(collectionFormat)) {
            delimiter = "|";
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : valueCollection) {
            sb.append(delimiter);
            sb.append(this.parameterToString(item));
        }
        params.add(new Pair(name, sb.substring(1)));
        return params;
    }

    public boolean isJsonMime(String mime) {
        return mime != null && mime.matches("(?i)application\\/json(;.*)?");
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            if (!this.isJsonMime(accept)) continue;
            return accept;
        }
        return StringUtil.join(accepts, ",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0) {
            return "application/json";
        }
        for (String contentType : contentTypes) {
            if (!this.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public Object serialize(Object obj, String contentType, Map<String, Object> formParams) throws ApiException {
        if (contentType.startsWith("multipart/form-data")) {
            FormDataMultiPart mp = new FormDataMultiPart();
            for (Map.Entry<String, Object> param : formParams.entrySet()) {
                if (param.getValue() instanceof List && !((List)param.getValue()).isEmpty() && ((List)param.getValue()).get(0) instanceof File) {
                    List files = (List)param.getValue();
                    for (File file : files) {
                        mp.bodyPart((BodyPart)new FileDataBodyPart(param.getKey(), file, MediaType.MULTIPART_FORM_DATA_TYPE));
                    }
                    continue;
                }
                if (param.getValue() instanceof File) {
                    File file = (File)param.getValue();
                    mp.bodyPart((BodyPart)new FileDataBodyPart(param.getKey(), file, MediaType.MULTIPART_FORM_DATA_TYPE));
                    continue;
                }
                mp.field(param.getKey(), (Object)this.parameterToString(param.getValue()), MediaType.MULTIPART_FORM_DATA_TYPE);
            }
            return mp;
        }
        if (contentType.startsWith("application/x-www-form-urlencoded")) {
            return this.getXWWWFormUrlencodedParams(formParams);
        }
        if (contentType.startsWith("text/csv")) {
            return this.serializeToCsv(obj);
        }
        return obj;
    }

    private String buildUrl(String path, List<Pair> queryParams) {
        StringBuilder url = new StringBuilder();
        url.append(this.basePath).append(path);
        if (queryParams != null && !queryParams.isEmpty()) {
            String prefix = path.contains("?") ? "&" : "?";
            for (Pair param : queryParams) {
                if (param.getValue() == null) continue;
                if (prefix != null) {
                    url.append(prefix);
                    prefix = null;
                } else {
                    url.append("&");
                }
                String value = this.parameterToString(param.getValue());
                url.append(this.escapeString(param.getName())).append("=").append(this.escapeString(value));
            }
        }
        return url.toString();
    }

    private ClientResponse getAPIResponse(String path, String method, List<Pair> queryParams, Object body, Map<String, String> headerParams, Map<String, Object> formParams, String accept, String contentType, String[] authNames) throws ApiException {
        if (body != null && !formParams.isEmpty()) {
            throw new ApiException(500, "Cannot have body and form params");
        }
        this.updateParamsForAuth(authNames, queryParams, headerParams);
        String url = this.buildUrl(path, queryParams);
        WebResource.Builder builder = accept == null ? this.httpClient.resource(url).getRequestBuilder() : this.httpClient.resource(url).accept(new String[]{accept});
        for (String key : headerParams.keySet()) {
            builder = (WebResource.Builder)builder.header(key, (Object)headerParams.get(key));
        }
        for (String key : this.defaultHeaderMap.keySet()) {
            if (headerParams.containsKey(key)) continue;
            builder = (WebResource.Builder)builder.header(key, (Object)this.defaultHeaderMap.get(key));
        }
        builder = (WebResource.Builder)builder.header("X-DocuSign-SDK", (Object)"Java");
        if (body == null) {
            builder = (WebResource.Builder)builder.header("Content-Length", (Object)"0");
        }
        ClientResponse response = null;
        if ("GET".equals(method)) {
            response = (ClientResponse)builder.get(ClientResponse.class);
        } else if ("POST".equals(method)) {
            response = (ClientResponse)((WebResource.Builder)builder.type(contentType)).post(ClientResponse.class, this.serialize(body, contentType, formParams));
        } else if ("PUT".equals(method)) {
            response = (ClientResponse)((WebResource.Builder)builder.type(contentType)).put(ClientResponse.class, this.serialize(body, contentType, formParams));
        } else if ("DELETE".equals(method)) {
            response = (ClientResponse)((WebResource.Builder)builder.type(contentType)).delete(ClientResponse.class, this.serialize(body, contentType, formParams));
        } else if ("PATCH".equals(method)) {
            response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)builder.type(contentType)).header("X-HTTP-Method-Override", (Object)"PATCH")).post(ClientResponse.class, this.serialize(body, contentType, formParams));
        } else {
            throw new ApiException(500, "unknown method type " + method);
        }
        return response;
    }

    public <T> T invokeAPI(String path, String method, List<Pair> queryParams, Object body, Map<String, String> headerParams, Map<String, Object> formParams, String accept, String contentType, String[] authNames, GenericType<T> returnType) throws ApiException {
        ClientResponse response = this.getAPIResponse(path, method, queryParams, body, headerParams, formParams, accept, contentType, authNames);
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            String respBody = (String)response.getEntity(String.class);
            throw new ApiException(response.getStatusInfo().getStatusCode(), "Error while requesting server, received a non successful HTTP code " + response.getStatusInfo().getStatusCode() + " with response Body: '" + respBody + "'", (Map<String, List<String>>)response.getHeaders(), respBody);
        }
        this.statusCode = response.getStatusInfo().getStatusCode();
        this.responseHeaders = response.getHeaders();
        if (response.getStatusInfo() == ClientResponse.Status.NO_CONTENT) {
            return null;
        }
        if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
            if (returnType == null) {
                return null;
            }
            return (T)response.getEntity(returnType);
        }
        String message = "error";
        String respBody = null;
        if (response.hasEntity()) {
            try {
                message = respBody = (String)response.getEntity(String.class);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        throw new ApiException(response.getStatusInfo().getStatusCode(), message, (Map<String, List<String>>)response.getHeaders(), respBody);
    }

    private void updateParamsForAuth(String[] authNames, List<Pair> queryParams, Map<String, String> headerParams) {
        for (String authName : authNames) {
            Authentication auth = this.authentications.get(authName);
            if (auth == null) continue;
            auth.applyToParams(queryParams, headerParams);
        }
    }

    private String getXWWWFormUrlencodedParams(Map<String, Object> formParams) {
        StringBuilder formParamBuilder = new StringBuilder();
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            String valueStr = this.parameterToString(param.getValue());
            try {
                formParamBuilder.append(URLEncoder.encode(param.getKey(), "utf8")).append("=").append(URLEncoder.encode(valueStr, "utf8"));
                formParamBuilder.append("&");
            }
            catch (UnsupportedEncodingException e) {}
        }
        String encodedFormParams = formParamBuilder.toString();
        if (encodedFormParams.endsWith("&")) {
            encodedFormParams = encodedFormParams.substring(0, encodedFormParams.length() - 1);
        }
        return encodedFormParams;
    }

    private <T> String serializeToCsv(T obj) {
        if (obj == null) {
            return "";
        }
        if (obj.getClass() == byte[].class) {
            return new String((byte[])obj);
        }
        for (Method method : obj.getClass().getMethods()) {
            if (!"java.util.List".equals(method.getReturnType().getName())) continue;
            try {
                List itemList = (List)method.invoke(obj, new Object[0]);
                Object entry = itemList.get(0);
                ArrayList<String> stringList = new ArrayList<String>();
                char delimiter = ',';
                String lineSep = "\n";
                CsvMapper mapper = new CsvMapper();
                mapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.IGNORE_UNKNOWN});
                CsvSchema schema = mapper.schemaFor(entry.getClass());
                for (int i = 0; i < itemList.size(); ++i) {
                    schema = i == 0 ? schema.withHeader() : schema.withoutHeader();
                    String csv = mapper.writer((FormatSchema)schema.withColumnSeparator(delimiter).withoutQuoteChar().withLineSeparator(lineSep)).writeValueAsString(itemList.get(i));
                    stringList.add(csv);
                }
                return StringUtil.join(stringList.toArray(new String[0]), "");
            }
            catch (JsonProcessingException e) {
                System.out.println((Object)e);
            }
            catch (IllegalAccessException e) {
                System.out.println(e);
            }
            catch (IllegalArgumentException e) {
                System.out.println(e);
            }
            catch (InvocationTargetException e) {
                System.out.println(e);
            }
        }
        return "";
    }

    private Client buildHttpClient(boolean debugging) {
        DefaultClientConfig conf = new DefaultClientConfig();
        JacksonJsonProvider jsonProvider = new JacksonJsonProvider(this.mapper);
        conf.getSingletons().add(jsonProvider);
        try {
            System.setProperty("https.protocols", "TLSv1.2");
        }
        catch (SecurityException se) {
            System.err.println("failed to set https.protocols property");
        }
        if (this.sslContext == null) {
            try {
                this.sslContext = SSLContext.getInstance("TLSv1.2");
                this.sslContext.init(null, new TrustManager[]{new SecureTrustManager()}, new SecureRandom());
            }
            catch (Exception ex) {
                System.err.println("failed to initialize SSL context");
            }
            conf.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            }, this.sslContext));
            HttpsURLConnection.setDefaultSSLSocketFactory(this.sslContext.getSocketFactory());
        }
        Client client = new Client((ClientHandler)new URLConnectionClientHandler(new HttpURLConnectionFactory(){
            Proxy p = null;

            private boolean isNonProxyHost(String host, String nonProxyHosts) {
                if (null == host || null == nonProxyHosts) {
                    return false;
                }
                for (String spec : nonProxyHosts.split("\\|")) {
                    int length = spec.length();
                    StringBuilder sb = new StringBuilder(length);
                    block5: for (int i = 0; i < length; ++i) {
                        char c = spec.charAt(i);
                        switch (c) {
                            case '*': {
                                sb.append(".*");
                                continue block5;
                            }
                            case '.': {
                                sb.append("\\.");
                                continue block5;
                            }
                            default: {
                                sb.append(c);
                            }
                        }
                    }
                    if (!host.matches(sb.toString())) continue;
                    return true;
                }
                return false;
            }

            public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
                if (url == null) {
                    return null;
                }
                if (this.isNonProxyHost(url.getHost(), System.getProperty("http.nonProxyHosts"))) {
                    HttpsURLConnection connection = (HttpsURLConnection)url.openConnection(Proxy.NO_PROXY);
                    connection.setSSLSocketFactory(ApiClient.this.sslContext.getSocketFactory());
                    return connection;
                }
                if (this.p == null) {
                    String host;
                    if (System.getProperty("https.proxyHost") != null) {
                        host = System.getProperty("https.proxyHost");
                        final Integer port = Integer.getInteger("https.proxyPort");
                        if (host != null && port != null) {
                            this.p = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, (int)port));
                        }
                        final String user = System.getProperty("https.proxyUser");
                        final String password = System.getProperty("https.proxyPassword");
                        if (user != null && password != null) {
                            Authenticator.setDefault(new Authenticator(){

                                @Override
                                protected PasswordAuthentication getPasswordAuthentication() {
                                    if (this.getRequestorType() == Authenticator.RequestorType.PROXY && this.getRequestingHost().equalsIgnoreCase(host) && port.intValue() == this.getRequestingPort()) {
                                        return new PasswordAuthentication(user, password.toCharArray());
                                    }
                                    return null;
                                }
                            });
                        }
                    } else if (System.getProperty("http.proxyHost") != null) {
                        host = System.getProperty("http.proxyHost");
                        final Integer port = Integer.getInteger("http.proxyPort");
                        if (host != null && port != null) {
                            this.p = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, (int)port));
                        }
                        final String user = System.getProperty("http.proxyUser");
                        final String password = System.getProperty("http.proxyPassword");
                        if (user != null && password != null) {
                            Authenticator.setDefault(new Authenticator(){

                                @Override
                                protected PasswordAuthentication getPasswordAuthentication() {
                                    if (this.getRequestorType() == Authenticator.RequestorType.PROXY && this.getRequestingHost().equalsIgnoreCase(host) && port.intValue() == this.getRequestingPort()) {
                                        return new PasswordAuthentication(user, password.toCharArray());
                                    }
                                    return null;
                                }
                            });
                        }
                    }
                    if (this.p == null) {
                        this.p = Proxy.NO_PROXY;
                    }
                }
                HttpsURLConnection connection = (HttpsURLConnection)url.openConnection(this.p);
                connection.setSSLSocketFactory(ApiClient.this.sslContext.getSocketFactory());
                return connection;
            }
        }), (ClientConfig)conf);
        if (debugging) {
            client.addFilter((ClientFilter)new LoggingFilter());
        }
        return client;
    }

    class SecureTrustManager
    implements X509TrustManager {
        SecureTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        public boolean isClientTrusted(X509Certificate[] arg0) {
            return true;
        }

        public boolean isServerTrusted(X509Certificate[] arg0) {
            return true;
        }
    }
}

