/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.AuthenticationStatus;
import com.docusign.esign.model.DocumentVisibility;
import com.docusign.esign.model.ErrorDetails;
import com.docusign.esign.model.IdCheckInformationInput;
import com.docusign.esign.model.OfflineAttributes;
import com.docusign.esign.model.RecipientAttachment;
import com.docusign.esign.model.RecipientEmailNotification;
import com.docusign.esign.model.RecipientIdentityVerification;
import com.docusign.esign.model.RecipientPhoneAuthentication;
import com.docusign.esign.model.RecipientProofFile;
import com.docusign.esign.model.RecipientSAMLAuthentication;
import com.docusign.esign.model.RecipientSMSAuthentication;
import com.docusign.esign.model.RecipientSignatureInformation;
import com.docusign.esign.model.RecipientSignatureProvider;
import com.docusign.esign.model.SocialAuthentication;
import com.docusign.esign.model.Tabs;
import com.docusign.esign.model.UserInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Signer {
    @JsonProperty(value="accessCode")
    private String accessCode = null;
    @JsonProperty(value="addAccessCodeToEmail")
    private String addAccessCodeToEmail = null;
    @JsonProperty(value="agentCanEditEmail")
    private String agentCanEditEmail = null;
    @JsonProperty(value="agentCanEditName")
    private String agentCanEditName = null;
    @JsonProperty(value="autoNavigation")
    private String autoNavigation = null;
    @JsonProperty(value="bulkRecipientsUri")
    private String bulkRecipientsUri = null;
    @JsonProperty(value="canSignOffline")
    private String canSignOffline = null;
    @JsonProperty(value="clientUserId")
    private String clientUserId = null;
    @JsonProperty(value="creationReason")
    private String creationReason = null;
    @JsonProperty(value="customFields")
    private List<String> customFields = new ArrayList<String>();
    @JsonProperty(value="declinedDateTime")
    private String declinedDateTime = null;
    @JsonProperty(value="declinedReason")
    private String declinedReason = null;
    @JsonProperty(value="defaultRecipient")
    private String defaultRecipient = null;
    @JsonProperty(value="deliveredDateTime")
    private String deliveredDateTime = null;
    @JsonProperty(value="deliveryMethod")
    private String deliveryMethod = null;
    @JsonProperty(value="documentVisibility")
    private List<DocumentVisibility> documentVisibility = new ArrayList<DocumentVisibility>();
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="emailNotification")
    private RecipientEmailNotification emailNotification = null;
    @JsonProperty(value="emailRecipientPostSigningURL")
    private String emailRecipientPostSigningURL = null;
    @JsonProperty(value="embeddedRecipientStartURL")
    private String embeddedRecipientStartURL = null;
    @JsonProperty(value="errorDetails")
    private ErrorDetails errorDetails = null;
    @JsonProperty(value="excludedDocuments")
    private List<String> excludedDocuments = new ArrayList<String>();
    @JsonProperty(value="faxNumber")
    private String faxNumber = null;
    @JsonProperty(value="firstName")
    private String firstName = null;
    @JsonProperty(value="fullName")
    private String fullName = null;
    @JsonProperty(value="idCheckConfigurationName")
    private String idCheckConfigurationName = null;
    @JsonProperty(value="idCheckInformationInput")
    private IdCheckInformationInput idCheckInformationInput = null;
    @JsonProperty(value="identityVerification")
    private RecipientIdentityVerification identityVerification = null;
    @JsonProperty(value="inheritEmailNotificationConfiguration")
    private String inheritEmailNotificationConfiguration = null;
    @JsonProperty(value="isBulkRecipient")
    private String isBulkRecipient = null;
    @JsonProperty(value="lastName")
    private String lastName = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="note")
    private String note = null;
    @JsonProperty(value="offlineAttributes")
    private OfflineAttributes offlineAttributes = null;
    @JsonProperty(value="phoneAuthentication")
    private RecipientPhoneAuthentication phoneAuthentication = null;
    @JsonProperty(value="proofFile")
    private RecipientProofFile proofFile = null;
    @JsonProperty(value="recipientAttachments")
    private List<RecipientAttachment> recipientAttachments = new ArrayList<RecipientAttachment>();
    @JsonProperty(value="recipientAuthenticationStatus")
    private AuthenticationStatus recipientAuthenticationStatus = null;
    @JsonProperty(value="recipientId")
    private String recipientId = null;
    @JsonProperty(value="recipientIdGuid")
    private String recipientIdGuid = null;
    @JsonProperty(value="recipientSignatureProviders")
    private List<RecipientSignatureProvider> recipientSignatureProviders = new ArrayList<RecipientSignatureProvider>();
    @JsonProperty(value="recipientSuppliesTabs")
    private String recipientSuppliesTabs = null;
    @JsonProperty(value="requireIdLookup")
    private String requireIdLookup = null;
    @JsonProperty(value="requireSignerCertificate")
    private String requireSignerCertificate = null;
    @JsonProperty(value="requireSignOnPaper")
    private String requireSignOnPaper = null;
    @JsonProperty(value="roleName")
    private String roleName = null;
    @JsonProperty(value="routingOrder")
    private String routingOrder = null;
    @JsonProperty(value="samlAuthentication")
    private RecipientSAMLAuthentication samlAuthentication = null;
    @JsonProperty(value="sentDateTime")
    private String sentDateTime = null;
    @JsonProperty(value="signatureInfo")
    private RecipientSignatureInformation signatureInfo = null;
    @JsonProperty(value="signedDateTime")
    private String signedDateTime = null;
    @JsonProperty(value="signInEachLocation")
    private String signInEachLocation = null;
    @JsonProperty(value="signingGroupId")
    private String signingGroupId = null;
    @JsonProperty(value="signingGroupName")
    private String signingGroupName = null;
    @JsonProperty(value="signingGroupUsers")
    private List<UserInfo> signingGroupUsers = new ArrayList<UserInfo>();
    @JsonProperty(value="smsAuthentication")
    private RecipientSMSAuthentication smsAuthentication = null;
    @JsonProperty(value="socialAuthentications")
    private List<SocialAuthentication> socialAuthentications = new ArrayList<SocialAuthentication>();
    @JsonProperty(value="status")
    private String status = null;
    @JsonProperty(value="tabs")
    private Tabs tabs = null;
    @JsonProperty(value="templateLocked")
    private String templateLocked = null;
    @JsonProperty(value="templateRequired")
    private String templateRequired = null;
    @JsonProperty(value="totalTabCount")
    private String totalTabCount = null;
    @JsonProperty(value="userId")
    private String userId = null;

    public Signer accessCode(String accessCode) {
        this.accessCode = accessCode;
        return this;
    }

    @ApiModelProperty(example="null", value="If a value is provided, the recipient must enter the value as the access code to view and sign the envelope.   Maximum Length: 50 characters and it must conform to the account's access code format setting.  If blank, but the signer `accessCode` property is set in the envelope, then that value is used.  If blank and the signer `accessCode` property is not set, then the access code is not required.")
    public String getAccessCode() {
        return this.accessCode;
    }

    public void setAccessCode(String accessCode) {
        this.accessCode = accessCode;
    }

    public Signer addAccessCodeToEmail(String addAccessCodeToEmail) {
        this.addAccessCodeToEmail = addAccessCodeToEmail;
        return this;
    }

    @ApiModelProperty(example="null", value="This Optional attribute indicates that the access code will be added to the email sent to the recipient; this nullifies the Security measure of Access Code on the recipient.")
    public String getAddAccessCodeToEmail() {
        return this.addAccessCodeToEmail;
    }

    public void setAddAccessCodeToEmail(String addAccessCodeToEmail) {
        this.addAccessCodeToEmail = addAccessCodeToEmail;
    }

    public Signer agentCanEditEmail(String agentCanEditEmail) {
        this.agentCanEditEmail = agentCanEditEmail;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getAgentCanEditEmail() {
        return this.agentCanEditEmail;
    }

    public void setAgentCanEditEmail(String agentCanEditEmail) {
        this.agentCanEditEmail = agentCanEditEmail;
    }

    public Signer agentCanEditName(String agentCanEditName) {
        this.agentCanEditName = agentCanEditName;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getAgentCanEditName() {
        return this.agentCanEditName;
    }

    public void setAgentCanEditName(String agentCanEditName) {
        this.agentCanEditName = agentCanEditName;
    }

    public Signer autoNavigation(String autoNavigation) {
        this.autoNavigation = autoNavigation;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getAutoNavigation() {
        return this.autoNavigation;
    }

    public void setAutoNavigation(String autoNavigation) {
        this.autoNavigation = autoNavigation;
    }

    public Signer bulkRecipientsUri(String bulkRecipientsUri) {
        this.bulkRecipientsUri = bulkRecipientsUri;
        return this;
    }

    @ApiModelProperty(example="null", value="Contains a URI for an endpoint that allows you to easily retrieve bulk recipient information.")
    public String getBulkRecipientsUri() {
        return this.bulkRecipientsUri;
    }

    public void setBulkRecipientsUri(String bulkRecipientsUri) {
        this.bulkRecipientsUri = bulkRecipientsUri;
    }

    public Signer canSignOffline(String canSignOffline) {
        this.canSignOffline = canSignOffline;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, specifies that the signer can perform the signing ceremony offline.")
    public String getCanSignOffline() {
        return this.canSignOffline;
    }

    public void setCanSignOffline(String canSignOffline) {
        this.canSignOffline = canSignOffline;
    }

    public Signer clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies whether the recipient is embedded or remote.   If the `clientUserId` property is not null then the recipient is embedded. Note that if the `ClientUserId` property is set and either `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to  **true**, an error is generated on sending.ng.   Maximum length: 100 characters. ")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public Signer creationReason(String creationReason) {
        this.creationReason = creationReason;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getCreationReason() {
        return this.creationReason;
    }

    public void setCreationReason(String creationReason) {
        this.creationReason = creationReason;
    }

    public Signer customFields(List<String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public Signer addCustomFieldsItem(String customFieldsItem) {
        this.customFields.add(customFieldsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.")
    public List<String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(List<String> customFields) {
        this.customFields = customFields;
    }

    public Signer declinedDateTime(String declinedDateTime) {
        this.declinedDateTime = declinedDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The date and time the recipient declined the document.")
    public String getDeclinedDateTime() {
        return this.declinedDateTime;
    }

    public void setDeclinedDateTime(String declinedDateTime) {
        this.declinedDateTime = declinedDateTime;
    }

    public Signer declinedReason(String declinedReason) {
        this.declinedReason = declinedReason;
        return this;
    }

    @ApiModelProperty(example="null", value="The reason the recipient declined the document.")
    public String getDeclinedReason() {
        return this.declinedReason;
    }

    public void setDeclinedReason(String declinedReason) {
        this.declinedReason = declinedReason;
    }

    public Signer defaultRecipient(String defaultRecipient) {
        this.defaultRecipient = defaultRecipient;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getDefaultRecipient() {
        return this.defaultRecipient;
    }

    public void setDefaultRecipient(String defaultRecipient) {
        this.defaultRecipient = defaultRecipient;
    }

    public Signer deliveredDateTime(String deliveredDateTime) {
        this.deliveredDateTime = deliveredDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Reserved: For DocuSign use only.")
    public String getDeliveredDateTime() {
        return this.deliveredDateTime;
    }

    public void setDeliveredDateTime(String deliveredDateTime) {
        this.deliveredDateTime = deliveredDateTime;
    }

    public Signer deliveryMethod(String deliveryMethod) {
        this.deliveryMethod = deliveryMethod;
        return this;
    }

    @ApiModelProperty(example="null", value="Reserved: For DocuSign use only.")
    public String getDeliveryMethod() {
        return this.deliveryMethod;
    }

    public void setDeliveryMethod(String deliveryMethod) {
        this.deliveryMethod = deliveryMethod;
    }

    public Signer documentVisibility(List<DocumentVisibility> documentVisibility) {
        this.documentVisibility = documentVisibility;
        return this;
    }

    public Signer addDocumentVisibilityItem(DocumentVisibility documentVisibilityItem) {
        this.documentVisibility.add(documentVisibilityItem);
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public List<DocumentVisibility> getDocumentVisibility() {
        return this.documentVisibility;
    }

    public void setDocumentVisibility(List<DocumentVisibility> documentVisibility) {
        this.documentVisibility = documentVisibility;
    }

    public Signer email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(example="null", value="Email id of the recipient. Notification of the document to sign is sent to this email id.   Maximum length: 100 characters. ")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Signer emailNotification(RecipientEmailNotification emailNotification) {
        this.emailNotification = emailNotification;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public RecipientEmailNotification getEmailNotification() {
        return this.emailNotification;
    }

    public void setEmailNotification(RecipientEmailNotification emailNotification) {
        this.emailNotification = emailNotification;
    }

    public Signer emailRecipientPostSigningURL(String emailRecipientPostSigningURL) {
        this.emailRecipientPostSigningURL = emailRecipientPostSigningURL;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getEmailRecipientPostSigningURL() {
        return this.emailRecipientPostSigningURL;
    }

    public void setEmailRecipientPostSigningURL(String emailRecipientPostSigningURL) {
        this.emailRecipientPostSigningURL = emailRecipientPostSigningURL;
    }

    public Signer embeddedRecipientStartURL(String embeddedRecipientStartURL) {
        this.embeddedRecipientStartURL = embeddedRecipientStartURL;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies a sender provided valid URL string for redirecting an embedded recipient. When using this option, the embedded recipient still receives an email from DocuSign, just as a remote recipient would. When the document link in the email is clicked the recipient is redirected, through DocuSign, to the supplied URL to complete their actions. When routing to the URL, the sender's system (the server responding to the URL) must request a recipient token to launch a signing session.   If set to `SIGN_AT_DOCUSIGN`, the recipient is directed to an embedded signing or viewing process directly at DocuSign. The signing or viewing action is initiated by the DocuSign system and the transaction activity and Certificate of Completion records will reflect this. In all other ways the process is identical to an embedded signing or viewing operation that is launched by any partner.  It is important to remember that in a typical embedded workflow the authentication of an embedded recipient is the responsibility of the sending application, DocuSign expects that senders will follow their own process for establishing the recipient's identity. In this workflow the recipient goes through the sending application before the embedded signing or viewing process in initiated. However, when the sending application sets `EmbeddedRecipientStartURL=SIGN_AT_DOCUSIGN`, the recipient goes directly to the embedded signing or viewing process bypassing the sending application and any authentication steps the sending application would use. In this case, DocuSign recommends that you use one of the normal DocuSign authentication features (Access Code, Phone Authentication, SMS Authentication, etc.) to verify the identity of the recipient.  If the `clientUserId` property is NOT set, and the `embeddedRecipientStartURL` is set, DocuSign will ignore the redirect URL and launch the standard signing process for the email recipient. Information can be appended to the embedded recipient start URL using merge fields. The available merge fields items are: envelopeId, recipientId, recipientName, recipientEmail, and customFields. The `customFields` property must be set fort the recipient or envelope. The merge fields are enclosed in double brackets.   *Example*:   `http://senderHost/[[mergeField1]]/ beginSigningSession? [[mergeField2]]&[[mergeField3]]` ")
    public String getEmbeddedRecipientStartURL() {
        return this.embeddedRecipientStartURL;
    }

    public void setEmbeddedRecipientStartURL(String embeddedRecipientStartURL) {
        this.embeddedRecipientStartURL = embeddedRecipientStartURL;
    }

    public Signer errorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
    }

    public Signer excludedDocuments(List<String> excludedDocuments) {
        this.excludedDocuments = excludedDocuments;
        return this;
    }

    public Signer addExcludedDocumentsItem(String excludedDocumentsItem) {
        this.excludedDocuments.add(excludedDocumentsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies the documents that are not visible to this recipient. Document Visibility must be enabled for the account and the `enforceSignerVisibility` property must be set to **true** for the envelope to use this.  When enforce signer visibility is enabled, documents with tabs can only be viewed by signers that have a tab on that document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all the documents in an envelope, unless they are specifically excluded using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded using this setting when an envelope is sent.")
    public List<String> getExcludedDocuments() {
        return this.excludedDocuments;
    }

    public void setExcludedDocuments(List<String> excludedDocuments) {
        this.excludedDocuments = excludedDocuments;
    }

    public Signer faxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="Reserved:")
    public String getFaxNumber() {
        return this.faxNumber;
    }

    public void setFaxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
    }

    public Signer firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(example="null", value="The user's first name.  Maximum Length: 50 characters.")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public Signer fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Signer idCheckConfigurationName(String idCheckConfigurationName) {
        this.idCheckConfigurationName = idCheckConfigurationName;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies authentication check by name. The names used here must be the same as the authentication type names used by the account (these name can also be found in the web console sending interface in the Identify list for a recipient,) This overrides any default authentication setting.  *Example*: Your account has ID Check and SMS Authentication available and in the web console Identify list these appear as 'ID Check $' and 'SMS Auth $'. To use ID check in an envelope, the idCheckConfigurationName should be 'ID Check '. If you wanted to use SMS, it would be 'SMS Auth $' and you would need to add you would need to add phone number information to the `smsAuthentication` node.")
    public String getIdCheckConfigurationName() {
        return this.idCheckConfigurationName;
    }

    public void setIdCheckConfigurationName(String idCheckConfigurationName) {
        this.idCheckConfigurationName = idCheckConfigurationName;
    }

    public Signer idCheckInformationInput(IdCheckInformationInput idCheckInformationInput) {
        this.idCheckInformationInput = idCheckInformationInput;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public IdCheckInformationInput getIdCheckInformationInput() {
        return this.idCheckInformationInput;
    }

    public void setIdCheckInformationInput(IdCheckInformationInput idCheckInformationInput) {
        this.idCheckInformationInput = idCheckInformationInput;
    }

    public Signer identityVerification(RecipientIdentityVerification identityVerification) {
        this.identityVerification = identityVerification;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public RecipientIdentityVerification getIdentityVerification() {
        return this.identityVerification;
    }

    public void setIdentityVerification(RecipientIdentityVerification identityVerification) {
        this.identityVerification = identityVerification;
    }

    public Signer inheritEmailNotificationConfiguration(String inheritEmailNotificationConfiguration) {
        this.inheritEmailNotificationConfiguration = inheritEmailNotificationConfiguration;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true** and the envelope recipient creates a DocuSign account after signing, the Manage Account Email Notification settings are used as the default settings for the recipient's account. ")
    public String getInheritEmailNotificationConfiguration() {
        return this.inheritEmailNotificationConfiguration;
    }

    public void setInheritEmailNotificationConfiguration(String inheritEmailNotificationConfiguration) {
        this.inheritEmailNotificationConfiguration = inheritEmailNotificationConfiguration;
    }

    public Signer isBulkRecipient(String isBulkRecipient) {
        this.isBulkRecipient = isBulkRecipient;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, this signer is a bulk recipient and the recipient information is contained in a bulk recipient file.   Note that when this is true the email and name for the recipient becomes bulk@recipient.com and \"Bulk Recipient\". These fields can not be changed for the bulk recipient.  ")
    public String getIsBulkRecipient() {
        return this.isBulkRecipient;
    }

    public void setIsBulkRecipient(String isBulkRecipient) {
        this.isBulkRecipient = isBulkRecipient;
    }

    public Signer lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Signer name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Signer note(String note) {
        this.note = note;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies a note that is unique to this recipient. This note is sent to the recipient via the signing email. The note displays in the signing UI near the upper left corner of the document on the signing screen.  Maximum Length: 1000 characters.")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Signer offlineAttributes(OfflineAttributes offlineAttributes) {
        this.offlineAttributes = offlineAttributes;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public OfflineAttributes getOfflineAttributes() {
        return this.offlineAttributes;
    }

    public void setOfflineAttributes(OfflineAttributes offlineAttributes) {
        this.offlineAttributes = offlineAttributes;
    }

    public Signer phoneAuthentication(RecipientPhoneAuthentication phoneAuthentication) {
        this.phoneAuthentication = phoneAuthentication;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public RecipientPhoneAuthentication getPhoneAuthentication() {
        return this.phoneAuthentication;
    }

    public void setPhoneAuthentication(RecipientPhoneAuthentication phoneAuthentication) {
        this.phoneAuthentication = phoneAuthentication;
    }

    public Signer proofFile(RecipientProofFile proofFile) {
        this.proofFile = proofFile;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public RecipientProofFile getProofFile() {
        return this.proofFile;
    }

    public void setProofFile(RecipientProofFile proofFile) {
        this.proofFile = proofFile;
    }

    public Signer recipientAttachments(List<RecipientAttachment> recipientAttachments) {
        this.recipientAttachments = recipientAttachments;
        return this;
    }

    public Signer addRecipientAttachmentsItem(RecipientAttachment recipientAttachmentsItem) {
        this.recipientAttachments.add(recipientAttachmentsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="Reserved:")
    public List<RecipientAttachment> getRecipientAttachments() {
        return this.recipientAttachments;
    }

    public void setRecipientAttachments(List<RecipientAttachment> recipientAttachments) {
        this.recipientAttachments = recipientAttachments;
    }

    public Signer recipientAuthenticationStatus(AuthenticationStatus recipientAuthenticationStatus) {
        this.recipientAuthenticationStatus = recipientAuthenticationStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public AuthenticationStatus getRecipientAuthenticationStatus() {
        return this.recipientAuthenticationStatus;
    }

    public void setRecipientAuthenticationStatus(AuthenticationStatus recipientAuthenticationStatus) {
        this.recipientAuthenticationStatus = recipientAuthenticationStatus;
    }

    public Signer recipientId(String recipientId) {
        this.recipientId = recipientId;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.")
    public String getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(String recipientId) {
        this.recipientId = recipientId;
    }

    public Signer recipientIdGuid(String recipientIdGuid) {
        this.recipientIdGuid = recipientIdGuid;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getRecipientIdGuid() {
        return this.recipientIdGuid;
    }

    public void setRecipientIdGuid(String recipientIdGuid) {
        this.recipientIdGuid = recipientIdGuid;
    }

    public Signer recipientSignatureProviders(List<RecipientSignatureProvider> recipientSignatureProviders) {
        this.recipientSignatureProviders = recipientSignatureProviders;
        return this;
    }

    public Signer addRecipientSignatureProvidersItem(RecipientSignatureProvider recipientSignatureProvidersItem) {
        this.recipientSignatureProviders.add(recipientSignatureProvidersItem);
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public List<RecipientSignatureProvider> getRecipientSignatureProviders() {
        return this.recipientSignatureProviders;
    }

    public void setRecipientSignatureProviders(List<RecipientSignatureProvider> recipientSignatureProviders) {
        this.recipientSignatureProviders = recipientSignatureProviders;
    }

    public Signer recipientSuppliesTabs(String recipientSuppliesTabs) {
        this.recipientSuppliesTabs = recipientSuppliesTabs;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getRecipientSuppliesTabs() {
        return this.recipientSuppliesTabs;
    }

    public void setRecipientSuppliesTabs(String recipientSuppliesTabs) {
        this.recipientSuppliesTabs = recipientSuppliesTabs;
    }

    public Signer requireIdLookup(String requireIdLookup) {
        this.requireIdLookup = requireIdLookup;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the recipient is required to use the specified ID check method (including Phone and SMS authentication) to validate their identity. ")
    public String getRequireIdLookup() {
        return this.requireIdLookup;
    }

    public void setRequireIdLookup(String requireIdLookup) {
        this.requireIdLookup = requireIdLookup;
    }

    public Signer requireSignerCertificate(String requireSignerCertificate) {
        this.requireSignerCertificate = requireSignerCertificate;
        return this;
    }

    @ApiModelProperty(example="null", value="Sets the type of signer certificate required for signing. If left blank, no certificate is required. Only one type of certificate can be set for a signer. The possible values are:  * docusign_express \u00c3\u00a2\u00e2\u0082\u00ac\u00e2\u0080\u009c Requires a DocuSign Express certificate. * safe \u00c3\u00a2\u00e2\u0082\u00ac\u00e2\u0080\u009c Requires a SAFE-BioPharma certificate. * open_trust \u00c3\u00a2\u00e2\u0082\u00ac\u00e2\u0080\u009c Requires an OpenTrust certificate.   **Important**: There are certain rules and restrictions that must be followed when requiring OpenTrust digital signatures. See [ML:OpenTrust Rules and Restrictions] for more information.   ")
    public String getRequireSignerCertificate() {
        return this.requireSignerCertificate;
    }

    public void setRequireSignerCertificate(String requireSignerCertificate) {
        this.requireSignerCertificate = requireSignerCertificate;
    }

    public Signer requireSignOnPaper(String requireSignOnPaper) {
        this.requireSignOnPaper = requireSignOnPaper;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the signer must print, sign, and upload or fax the signed documents to DocuSign.")
    public String getRequireSignOnPaper() {
        return this.requireSignOnPaper;
    }

    public void setRequireSignOnPaper(String requireSignOnPaper) {
        this.requireSignOnPaper = requireSignOnPaper;
    }

    public Signer roleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    @ApiModelProperty(example="null", value="Optional element. Specifies the role name associated with the recipient.<br/><br/>This is required when working with template recipients.")
    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public Signer routingOrder(String routingOrder) {
        this.routingOrder = routingOrder;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies the routing order of the recipient in the envelope. ")
    public String getRoutingOrder() {
        return this.routingOrder;
    }

    public void setRoutingOrder(String routingOrder) {
        this.routingOrder = routingOrder;
    }

    public Signer samlAuthentication(RecipientSAMLAuthentication samlAuthentication) {
        this.samlAuthentication = samlAuthentication;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public RecipientSAMLAuthentication getSamlAuthentication() {
        return this.samlAuthentication;
    }

    public void setSamlAuthentication(RecipientSAMLAuthentication samlAuthentication) {
        this.samlAuthentication = samlAuthentication;
    }

    public Signer sentDateTime(String sentDateTime) {
        this.sentDateTime = sentDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The date and time the envelope was sent.")
    public String getSentDateTime() {
        return this.sentDateTime;
    }

    public void setSentDateTime(String sentDateTime) {
        this.sentDateTime = sentDateTime;
    }

    public Signer signatureInfo(RecipientSignatureInformation signatureInfo) {
        this.signatureInfo = signatureInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public RecipientSignatureInformation getSignatureInfo() {
        return this.signatureInfo;
    }

    public void setSignatureInfo(RecipientSignatureInformation signatureInfo) {
        this.signatureInfo = signatureInfo;
    }

    public Signer signedDateTime(String signedDateTime) {
        this.signedDateTime = signedDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Reserved: For DocuSign use only. ")
    public String getSignedDateTime() {
        return this.signedDateTime;
    }

    public void setSignedDateTime(String signedDateTime) {
        this.signedDateTime = signedDateTime;
    }

    public Signer signInEachLocation(String signInEachLocation) {
        this.signInEachLocation = signInEachLocation;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, specifies that the signer must sign in all locations.")
    public String getSignInEachLocation() {
        return this.signInEachLocation;
    }

    public void setSignInEachLocation(String signInEachLocation) {
        this.signInEachLocation = signInEachLocation;
    }

    public Signer signingGroupId(String signingGroupId) {
        this.signingGroupId = signingGroupId;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true** and the feature is enabled in the sender's account, the signing recipient is required to draw signatures and initials at each signature/initial tab ( instead of adopting a signature/initial style or only drawing a signature/initial once).")
    public String getSigningGroupId() {
        return this.signingGroupId;
    }

    public void setSigningGroupId(String signingGroupId) {
        this.signingGroupId = signingGroupId;
    }

    public Signer signingGroupName(String signingGroupName) {
        this.signingGroupName = signingGroupName;
        return this;
    }

    @ApiModelProperty(example="null", value="The display name for the signing group.   Maximum Length: 100 characters. ")
    public String getSigningGroupName() {
        return this.signingGroupName;
    }

    public void setSigningGroupName(String signingGroupName) {
        this.signingGroupName = signingGroupName;
    }

    public Signer signingGroupUsers(List<UserInfo> signingGroupUsers) {
        this.signingGroupUsers = signingGroupUsers;
        return this;
    }

    public Signer addSigningGroupUsersItem(UserInfo signingGroupUsersItem) {
        this.signingGroupUsers.add(signingGroupUsersItem);
        return this;
    }

    @ApiModelProperty(example="null", value="A complex type that contains information about users in the signing group.")
    public List<UserInfo> getSigningGroupUsers() {
        return this.signingGroupUsers;
    }

    public void setSigningGroupUsers(List<UserInfo> signingGroupUsers) {
        this.signingGroupUsers = signingGroupUsers;
    }

    public Signer smsAuthentication(RecipientSMSAuthentication smsAuthentication) {
        this.smsAuthentication = smsAuthentication;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public RecipientSMSAuthentication getSmsAuthentication() {
        return this.smsAuthentication;
    }

    public void setSmsAuthentication(RecipientSMSAuthentication smsAuthentication) {
        this.smsAuthentication = smsAuthentication;
    }

    public Signer socialAuthentications(List<SocialAuthentication> socialAuthentications) {
        this.socialAuthentications = socialAuthentications;
        return this;
    }

    public Signer addSocialAuthenticationsItem(SocialAuthentication socialAuthenticationsItem) {
        this.socialAuthentications.add(socialAuthenticationsItem);
        return this;
    }

    @ApiModelProperty(example="null", value=" Lists the social ID type that can be used for recipient authentication.")
    public List<SocialAuthentication> getSocialAuthentications() {
        return this.socialAuthentications;
    }

    public void setSocialAuthentications(List<SocialAuthentication> socialAuthentications) {
        this.socialAuthentications = socialAuthentications;
    }

    public Signer status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Signer tabs(Tabs tabs) {
        this.tabs = tabs;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Tabs getTabs() {
        return this.tabs;
    }

    public void setTabs(Tabs tabs) {
        this.tabs = tabs;
    }

    public Signer templateLocked(String templateLocked) {
        this.templateLocked = templateLocked;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the sender cannot change any attributes of the recipient. Used only when working with template recipients. ")
    public String getTemplateLocked() {
        return this.templateLocked;
    }

    public void setTemplateLocked(String templateLocked) {
        this.templateLocked = templateLocked;
    }

    public Signer templateRequired(String templateRequired) {
        this.templateRequired = templateRequired;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the sender may not remove the recipient. Used only when working with template recipients.")
    public String getTemplateRequired() {
        return this.templateRequired;
    }

    public void setTemplateRequired(String templateRequired) {
        this.templateRequired = templateRequired;
    }

    public Signer totalTabCount(String totalTabCount) {
        this.totalTabCount = totalTabCount;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getTotalTabCount() {
        return this.totalTabCount;
    }

    public void setTotalTabCount(String totalTabCount) {
        this.totalTabCount = totalTabCount;
    }

    public Signer userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signer signer = (Signer)o;
        return Objects.equals(this.accessCode, signer.accessCode) && Objects.equals(this.addAccessCodeToEmail, signer.addAccessCodeToEmail) && Objects.equals(this.agentCanEditEmail, signer.agentCanEditEmail) && Objects.equals(this.agentCanEditName, signer.agentCanEditName) && Objects.equals(this.autoNavigation, signer.autoNavigation) && Objects.equals(this.bulkRecipientsUri, signer.bulkRecipientsUri) && Objects.equals(this.canSignOffline, signer.canSignOffline) && Objects.equals(this.clientUserId, signer.clientUserId) && Objects.equals(this.creationReason, signer.creationReason) && Objects.equals(this.customFields, signer.customFields) && Objects.equals(this.declinedDateTime, signer.declinedDateTime) && Objects.equals(this.declinedReason, signer.declinedReason) && Objects.equals(this.defaultRecipient, signer.defaultRecipient) && Objects.equals(this.deliveredDateTime, signer.deliveredDateTime) && Objects.equals(this.deliveryMethod, signer.deliveryMethod) && Objects.equals(this.documentVisibility, signer.documentVisibility) && Objects.equals(this.email, signer.email) && Objects.equals(this.emailNotification, signer.emailNotification) && Objects.equals(this.emailRecipientPostSigningURL, signer.emailRecipientPostSigningURL) && Objects.equals(this.embeddedRecipientStartURL, signer.embeddedRecipientStartURL) && Objects.equals(this.errorDetails, signer.errorDetails) && Objects.equals(this.excludedDocuments, signer.excludedDocuments) && Objects.equals(this.faxNumber, signer.faxNumber) && Objects.equals(this.firstName, signer.firstName) && Objects.equals(this.fullName, signer.fullName) && Objects.equals(this.idCheckConfigurationName, signer.idCheckConfigurationName) && Objects.equals(this.idCheckInformationInput, signer.idCheckInformationInput) && Objects.equals(this.identityVerification, signer.identityVerification) && Objects.equals(this.inheritEmailNotificationConfiguration, signer.inheritEmailNotificationConfiguration) && Objects.equals(this.isBulkRecipient, signer.isBulkRecipient) && Objects.equals(this.lastName, signer.lastName) && Objects.equals(this.name, signer.name) && Objects.equals(this.note, signer.note) && Objects.equals(this.offlineAttributes, signer.offlineAttributes) && Objects.equals(this.phoneAuthentication, signer.phoneAuthentication) && Objects.equals(this.proofFile, signer.proofFile) && Objects.equals(this.recipientAttachments, signer.recipientAttachments) && Objects.equals(this.recipientAuthenticationStatus, signer.recipientAuthenticationStatus) && Objects.equals(this.recipientId, signer.recipientId) && Objects.equals(this.recipientIdGuid, signer.recipientIdGuid) && Objects.equals(this.recipientSignatureProviders, signer.recipientSignatureProviders) && Objects.equals(this.recipientSuppliesTabs, signer.recipientSuppliesTabs) && Objects.equals(this.requireIdLookup, signer.requireIdLookup) && Objects.equals(this.requireSignerCertificate, signer.requireSignerCertificate) && Objects.equals(this.requireSignOnPaper, signer.requireSignOnPaper) && Objects.equals(this.roleName, signer.roleName) && Objects.equals(this.routingOrder, signer.routingOrder) && Objects.equals(this.samlAuthentication, signer.samlAuthentication) && Objects.equals(this.sentDateTime, signer.sentDateTime) && Objects.equals(this.signatureInfo, signer.signatureInfo) && Objects.equals(this.signedDateTime, signer.signedDateTime) && Objects.equals(this.signInEachLocation, signer.signInEachLocation) && Objects.equals(this.signingGroupId, signer.signingGroupId) && Objects.equals(this.signingGroupName, signer.signingGroupName) && Objects.equals(this.signingGroupUsers, signer.signingGroupUsers) && Objects.equals(this.smsAuthentication, signer.smsAuthentication) && Objects.equals(this.socialAuthentications, signer.socialAuthentications) && Objects.equals(this.status, signer.status) && Objects.equals(this.tabs, signer.tabs) && Objects.equals(this.templateLocked, signer.templateLocked) && Objects.equals(this.templateRequired, signer.templateRequired) && Objects.equals(this.totalTabCount, signer.totalTabCount) && Objects.equals(this.userId, signer.userId);
    }

    public int hashCode() {
        return Objects.hash(this.accessCode, this.addAccessCodeToEmail, this.agentCanEditEmail, this.agentCanEditName, this.autoNavigation, this.bulkRecipientsUri, this.canSignOffline, this.clientUserId, this.creationReason, this.customFields, this.declinedDateTime, this.declinedReason, this.defaultRecipient, this.deliveredDateTime, this.deliveryMethod, this.documentVisibility, this.email, this.emailNotification, this.emailRecipientPostSigningURL, this.embeddedRecipientStartURL, this.errorDetails, this.excludedDocuments, this.faxNumber, this.firstName, this.fullName, this.idCheckConfigurationName, this.idCheckInformationInput, this.identityVerification, this.inheritEmailNotificationConfiguration, this.isBulkRecipient, this.lastName, this.name, this.note, this.offlineAttributes, this.phoneAuthentication, this.proofFile, this.recipientAttachments, this.recipientAuthenticationStatus, this.recipientId, this.recipientIdGuid, this.recipientSignatureProviders, this.recipientSuppliesTabs, this.requireIdLookup, this.requireSignerCertificate, this.requireSignOnPaper, this.roleName, this.routingOrder, this.samlAuthentication, this.sentDateTime, this.signatureInfo, this.signedDateTime, this.signInEachLocation, this.signingGroupId, this.signingGroupName, this.signingGroupUsers, this.smsAuthentication, this.socialAuthentications, this.status, this.tabs, this.templateLocked, this.templateRequired, this.totalTabCount, this.userId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Signer {\n");
        sb.append("    accessCode: ").append(this.toIndentedString(this.accessCode)).append("\n");
        sb.append("    addAccessCodeToEmail: ").append(this.toIndentedString(this.addAccessCodeToEmail)).append("\n");
        sb.append("    agentCanEditEmail: ").append(this.toIndentedString(this.agentCanEditEmail)).append("\n");
        sb.append("    agentCanEditName: ").append(this.toIndentedString(this.agentCanEditName)).append("\n");
        sb.append("    autoNavigation: ").append(this.toIndentedString(this.autoNavigation)).append("\n");
        sb.append("    bulkRecipientsUri: ").append(this.toIndentedString(this.bulkRecipientsUri)).append("\n");
        sb.append("    canSignOffline: ").append(this.toIndentedString(this.canSignOffline)).append("\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    creationReason: ").append(this.toIndentedString(this.creationReason)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    declinedDateTime: ").append(this.toIndentedString(this.declinedDateTime)).append("\n");
        sb.append("    declinedReason: ").append(this.toIndentedString(this.declinedReason)).append("\n");
        sb.append("    defaultRecipient: ").append(this.toIndentedString(this.defaultRecipient)).append("\n");
        sb.append("    deliveredDateTime: ").append(this.toIndentedString(this.deliveredDateTime)).append("\n");
        sb.append("    deliveryMethod: ").append(this.toIndentedString(this.deliveryMethod)).append("\n");
        sb.append("    documentVisibility: ").append(this.toIndentedString(this.documentVisibility)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    emailNotification: ").append(this.toIndentedString(this.emailNotification)).append("\n");
        sb.append("    emailRecipientPostSigningURL: ").append(this.toIndentedString(this.emailRecipientPostSigningURL)).append("\n");
        sb.append("    embeddedRecipientStartURL: ").append(this.toIndentedString(this.embeddedRecipientStartURL)).append("\n");
        sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        sb.append("    excludedDocuments: ").append(this.toIndentedString(this.excludedDocuments)).append("\n");
        sb.append("    faxNumber: ").append(this.toIndentedString(this.faxNumber)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    fullName: ").append(this.toIndentedString(this.fullName)).append("\n");
        sb.append("    idCheckConfigurationName: ").append(this.toIndentedString(this.idCheckConfigurationName)).append("\n");
        sb.append("    idCheckInformationInput: ").append(this.toIndentedString(this.idCheckInformationInput)).append("\n");
        sb.append("    identityVerification: ").append(this.toIndentedString(this.identityVerification)).append("\n");
        sb.append("    inheritEmailNotificationConfiguration: ").append(this.toIndentedString(this.inheritEmailNotificationConfiguration)).append("\n");
        sb.append("    isBulkRecipient: ").append(this.toIndentedString(this.isBulkRecipient)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    offlineAttributes: ").append(this.toIndentedString(this.offlineAttributes)).append("\n");
        sb.append("    phoneAuthentication: ").append(this.toIndentedString(this.phoneAuthentication)).append("\n");
        sb.append("    proofFile: ").append(this.toIndentedString(this.proofFile)).append("\n");
        sb.append("    recipientAttachments: ").append(this.toIndentedString(this.recipientAttachments)).append("\n");
        sb.append("    recipientAuthenticationStatus: ").append(this.toIndentedString(this.recipientAuthenticationStatus)).append("\n");
        sb.append("    recipientId: ").append(this.toIndentedString(this.recipientId)).append("\n");
        sb.append("    recipientIdGuid: ").append(this.toIndentedString(this.recipientIdGuid)).append("\n");
        sb.append("    recipientSignatureProviders: ").append(this.toIndentedString(this.recipientSignatureProviders)).append("\n");
        sb.append("    recipientSuppliesTabs: ").append(this.toIndentedString(this.recipientSuppliesTabs)).append("\n");
        sb.append("    requireIdLookup: ").append(this.toIndentedString(this.requireIdLookup)).append("\n");
        sb.append("    requireSignerCertificate: ").append(this.toIndentedString(this.requireSignerCertificate)).append("\n");
        sb.append("    requireSignOnPaper: ").append(this.toIndentedString(this.requireSignOnPaper)).append("\n");
        sb.append("    roleName: ").append(this.toIndentedString(this.roleName)).append("\n");
        sb.append("    routingOrder: ").append(this.toIndentedString(this.routingOrder)).append("\n");
        sb.append("    samlAuthentication: ").append(this.toIndentedString(this.samlAuthentication)).append("\n");
        sb.append("    sentDateTime: ").append(this.toIndentedString(this.sentDateTime)).append("\n");
        sb.append("    signatureInfo: ").append(this.toIndentedString(this.signatureInfo)).append("\n");
        sb.append("    signedDateTime: ").append(this.toIndentedString(this.signedDateTime)).append("\n");
        sb.append("    signInEachLocation: ").append(this.toIndentedString(this.signInEachLocation)).append("\n");
        sb.append("    signingGroupId: ").append(this.toIndentedString(this.signingGroupId)).append("\n");
        sb.append("    signingGroupName: ").append(this.toIndentedString(this.signingGroupName)).append("\n");
        sb.append("    signingGroupUsers: ").append(this.toIndentedString(this.signingGroupUsers)).append("\n");
        sb.append("    smsAuthentication: ").append(this.toIndentedString(this.smsAuthentication)).append("\n");
        sb.append("    socialAuthentications: ").append(this.toIndentedString(this.socialAuthentications)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    tabs: ").append(this.toIndentedString(this.tabs)).append("\n");
        sb.append("    templateLocked: ").append(this.toIndentedString(this.templateLocked)).append("\n");
        sb.append("    templateRequired: ").append(this.toIndentedString(this.templateRequired)).append("\n");
        sb.append("    totalTabCount: ").append(this.toIndentedString(this.totalTabCount)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

