/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.AccountBillingPlanResponse;
import com.docusign.esign.model.BillingInvoice;
import com.docusign.esign.model.BillingInvoicesResponse;
import com.docusign.esign.model.BillingInvoicesSummary;
import com.docusign.esign.model.BillingPaymentItem;
import com.docusign.esign.model.BillingPaymentRequest;
import com.docusign.esign.model.BillingPaymentResponse;
import com.docusign.esign.model.BillingPaymentsResponse;
import com.docusign.esign.model.BillingPlanInformation;
import com.docusign.esign.model.BillingPlanResponse;
import com.docusign.esign.model.BillingPlanUpdateResponse;
import com.docusign.esign.model.BillingPlansResponse;
import com.docusign.esign.model.PurchasedEnvelopesInformation;
import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class BillingApi {
    private ApiClient apiClient;

    public BillingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BillingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public BillingInvoicesResponse listInvoices(String accountId) throws ApiException {
        return this.listInvoices(accountId, null);
    }

    public BillingInvoicesResponse listInvoices(String accountId, ListInvoicesOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listInvoices");
        }
        String path = "/v2/accounts/{accountId}/billing_invoices".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "from_date", options.fromDate));
            queryParams.addAll(this.apiClient.parameterToPairs("", "to_date", options.toDate));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<BillingInvoicesResponse> returnType = new GenericType<BillingInvoicesResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public BillingInvoice getInvoice(String accountId, String invoiceId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getInvoice");
        }
        if (invoiceId == null) {
            throw new ApiException(400, "Missing the required parameter 'invoiceId' when calling getInvoice");
        }
        String path = "/v2/accounts/{accountId}/billing_invoices/{invoiceId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{invoiceId\\}", this.apiClient.escapeString(invoiceId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<BillingInvoice> returnType = new GenericType<BillingInvoice>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public BillingInvoicesSummary listInvoicesPastDue(String accountId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listInvoicesPastDue");
        }
        String path = "/v2/accounts/{accountId}/billing_invoices_past_due".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<BillingInvoicesSummary> returnType = new GenericType<BillingInvoicesSummary>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public BillingPaymentsResponse listPayments(String accountId) throws ApiException {
        return this.listPayments(accountId, null);
    }

    public BillingPaymentsResponse listPayments(String accountId, ListPaymentsOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listPayments");
        }
        String path = "/v2/accounts/{accountId}/billing_payments".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "from_date", options.fromDate));
            queryParams.addAll(this.apiClient.parameterToPairs("", "to_date", options.toDate));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<BillingPaymentsResponse> returnType = new GenericType<BillingPaymentsResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public BillingPaymentResponse makePayment(String accountId, BillingPaymentRequest billingPaymentRequest) throws ApiException {
        BillingPaymentRequest postBody = billingPaymentRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling makePayment");
        }
        String path = "/v2/accounts/{accountId}/billing_payments".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<BillingPaymentResponse> returnType = new GenericType<BillingPaymentResponse>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public BillingPaymentItem getPayment(String accountId, String paymentId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getPayment");
        }
        if (paymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'paymentId' when calling getPayment");
        }
        String path = "/v2/accounts/{accountId}/billing_payments/{paymentId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{paymentId\\}", this.apiClient.escapeString(paymentId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<BillingPaymentItem> returnType = new GenericType<BillingPaymentItem>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public AccountBillingPlanResponse getPlan(String accountId) throws ApiException {
        return this.getPlan(accountId, null);
    }

    public AccountBillingPlanResponse getPlan(String accountId, GetPlanOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getPlan");
        }
        String path = "/v2/accounts/{accountId}/billing_plan".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "include_credit_card_information", options.includeCreditCardInformation));
            queryParams.addAll(this.apiClient.parameterToPairs("", "include_metadata", options.includeMetadata));
            queryParams.addAll(this.apiClient.parameterToPairs("", "include_successor_plans", options.includeSuccessorPlans));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<AccountBillingPlanResponse> returnType = new GenericType<AccountBillingPlanResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public BillingPlanUpdateResponse updatePlan(String accountId, BillingPlanInformation billingPlanInformation) throws ApiException {
        return this.updatePlan(accountId, billingPlanInformation, null);
    }

    public BillingPlanUpdateResponse updatePlan(String accountId, BillingPlanInformation billingPlanInformation, UpdatePlanOptions options) throws ApiException {
        BillingPlanInformation postBody = billingPlanInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updatePlan");
        }
        String path = "/v2/accounts/{accountId}/billing_plan".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "preview_billing_plan", options.previewBillingPlan));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<BillingPlanUpdateResponse> returnType = new GenericType<BillingPlanUpdateResponse>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public void purchaseEnvelopes(String accountId, PurchasedEnvelopesInformation purchasedEnvelopesInformation) throws ApiException {
        PurchasedEnvelopesInformation postBody = purchasedEnvelopesInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling purchaseEnvelopes");
        }
        String path = "/v2/accounts/{accountId}/billing_plan/purchased_envelopes".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public BillingPlansResponse listBillingPlans() throws ApiException {
        Object postBody = null;
        String path = "/v2/billing_plans".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<BillingPlansResponse> returnType = new GenericType<BillingPlansResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public BillingPlanResponse getBillingPlan(String billingPlanId) throws ApiException {
        Object postBody = null;
        if (billingPlanId == null) {
            throw new ApiException(400, "Missing the required parameter 'billingPlanId' when calling getBillingPlan");
        }
        String path = "/v2/billing_plans/{billingPlanId}".replaceAll("\\{format\\}", "json").replaceAll("\\{billingPlanId\\}", this.apiClient.escapeString(billingPlanId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<BillingPlanResponse> returnType = new GenericType<BillingPlanResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public class UpdatePlanOptions {
        private String previewBillingPlan = null;

        public void setPreviewBillingPlan(String previewBillingPlan) {
            this.previewBillingPlan = previewBillingPlan;
        }

        public String getPreviewBillingPlan() {
            return this.previewBillingPlan;
        }
    }

    public class GetPlanOptions {
        private String includeCreditCardInformation = null;
        private String includeMetadata = null;
        private String includeSuccessorPlans = null;

        public void setIncludeCreditCardInformation(String includeCreditCardInformation) {
            this.includeCreditCardInformation = includeCreditCardInformation;
        }

        public String getIncludeCreditCardInformation() {
            return this.includeCreditCardInformation;
        }

        public void setIncludeMetadata(String includeMetadata) {
            this.includeMetadata = includeMetadata;
        }

        public String getIncludeMetadata() {
            return this.includeMetadata;
        }

        public void setIncludeSuccessorPlans(String includeSuccessorPlans) {
            this.includeSuccessorPlans = includeSuccessorPlans;
        }

        public String getIncludeSuccessorPlans() {
            return this.includeSuccessorPlans;
        }
    }

    public class ListPaymentsOptions {
        private String fromDate = null;
        private String toDate = null;

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }
    }

    public class ListInvoicesOptions {
        private String fromDate = null;
        private String toDate = null;

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }
    }
}

