/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.BulkEnvelopeStatus;
import com.docusign.esign.model.BulkEnvelopesResponse;
import com.docusign.esign.model.BulkRecipientsRequest;
import com.docusign.esign.model.BulkRecipientsResponse;
import com.docusign.esign.model.BulkRecipientsSummaryResponse;
import com.docusign.esign.model.BulkRecipientsUpdateResponse;
import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class BulkEnvelopesApi {
    private ApiClient apiClient;

    public BulkEnvelopesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BulkEnvelopesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public BulkEnvelopesResponse list(String accountId) throws ApiException {
        return this.list(accountId, null);
    }

    public BulkEnvelopesResponse list(String accountId, ListOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling list");
        }
        String path = "/v2/accounts/{accountId}/bulk_envelopes".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "count", options.count));
            queryParams.addAll(this.apiClient.parameterToPairs("", "include", options.include));
            queryParams.addAll(this.apiClient.parameterToPairs("", "start_position", options.startPosition));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<BulkEnvelopesResponse> returnType = new GenericType<BulkEnvelopesResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public BulkEnvelopeStatus get(String accountId, String batchId) throws ApiException {
        return this.get(accountId, batchId, null);
    }

    public BulkEnvelopeStatus get(String accountId, String batchId, GetOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling get");
        }
        if (batchId == null) {
            throw new ApiException(400, "Missing the required parameter 'batchId' when calling get");
        }
        String path = "/v2/accounts/{accountId}/bulk_envelopes/{batchId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{batchId\\}", this.apiClient.escapeString(batchId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "count", options.count));
            queryParams.addAll(this.apiClient.parameterToPairs("", "include", options.include));
            queryParams.addAll(this.apiClient.parameterToPairs("", "start_position", options.startPosition));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<BulkEnvelopeStatus> returnType = new GenericType<BulkEnvelopeStatus>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public BulkRecipientsResponse getRecipients(String accountId, String envelopeId, String recipientId) throws ApiException {
        return this.getRecipients(accountId, envelopeId, recipientId, null);
    }

    public BulkRecipientsResponse getRecipients(String accountId, String envelopeId, String recipientId, GetRecipientsOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getRecipients");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getRecipients");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling getRecipients");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/bulk_recipients".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "include_tabs", options.includeTabs));
            queryParams.addAll(this.apiClient.parameterToPairs("", "start_position", options.startPosition));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<BulkRecipientsResponse> returnType = new GenericType<BulkRecipientsResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public BulkRecipientsSummaryResponse updateRecipients(String accountId, String envelopeId, String recipientId, BulkRecipientsRequest bulkRecipientsRequest) throws ApiException {
        BulkRecipientsRequest postBody = bulkRecipientsRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateRecipients");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateRecipients");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling updateRecipients");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/bulk_recipients".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<BulkRecipientsSummaryResponse> returnType = new GenericType<BulkRecipientsSummaryResponse>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public BulkRecipientsUpdateResponse deleteRecipients(String accountId, String envelopeId, String recipientId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteRecipients");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteRecipients");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling deleteRecipients");
        }
        String path = "/v2/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/bulk_recipients".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<BulkRecipientsUpdateResponse> returnType = new GenericType<BulkRecipientsUpdateResponse>(){};
        return this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public class GetRecipientsOptions {
        private String includeTabs = null;
        private String startPosition = null;

        public void setIncludeTabs(String includeTabs) {
            this.includeTabs = includeTabs;
        }

        public String getIncludeTabs() {
            return this.includeTabs;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }
    }

    public class GetOptions {
        private String count = null;
        private String include = null;
        private String startPosition = null;

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }
    }

    public class ListOptions {
        private String count = null;
        private String include = null;
        private String startPosition = null;

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }
    }
}

