/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.client.auth;

import com.docusign.esign.client.Pair;
import com.docusign.esign.client.auth.Authentication;
import com.docusign.esign.client.auth.OAuthFlow;
import com.migcomponents.migbase64.Base64;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthClientResponse;
import org.apache.oltu.oauth2.client.response.OAuthClientResponseFactory;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.apache.oltu.oauth2.common.message.types.ResponseType;
import org.apache.oltu.oauth2.common.token.BasicOAuthToken;

public class OAuth
implements Authentication {
    static final int MILLIS_PER_SECOND = 1000;
    private volatile String accessToken;
    private Long expirationTimeMillis;
    private OAuthClient oauthClient;
    private OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder;
    private OAuthClientRequest.AuthenticationRequestBuilder authenticationRequestBuilder;
    private AccessTokenListener accessTokenListener;

    public OAuth(Client client, OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder, OAuthClientRequest.AuthenticationRequestBuilder authenticationRequestBuilder) {
        this.oauthClient = new OAuthClient((HttpClient)new OAuthJerseyClient(client));
        this.tokenRequestBuilder = tokenRequestBuilder;
        this.authenticationRequestBuilder = authenticationRequestBuilder;
    }

    public OAuth(Client client, OAuthFlow flow, String authorizationUrl, String tokenUrl, String scopes) {
        this(client, OAuthClientRequest.tokenLocation((String)tokenUrl).setScope(scopes), OAuthClientRequest.authorizationLocation((String)authorizationUrl).setScope(scopes));
        switch (flow) {
            case accessCode: {
                this.tokenRequestBuilder.setGrantType(GrantType.AUTHORIZATION_CODE);
                this.authenticationRequestBuilder.setResponseType(ResponseType.CODE.name().toLowerCase());
                break;
            }
            case implicit: {
                this.tokenRequestBuilder.setGrantType(GrantType.IMPLICIT);
                this.authenticationRequestBuilder.setResponseType(ResponseType.TOKEN.name().toLowerCase());
                break;
            }
            case password: {
                this.tokenRequestBuilder.setGrantType(GrantType.PASSWORD);
                break;
            }
            case application: {
                this.tokenRequestBuilder.setGrantType(GrantType.CLIENT_CREDENTIALS);
                break;
            }
        }
    }

    public OAuth(OAuthFlow flow, String authorizationUrl, String tokenUrl, String scopes) {
        this(new Client(null, null), flow, authorizationUrl, tokenUrl, scopes);
    }

    @Override
    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams) {
        if (headerParams.containsKey("Authorization")) {
            return;
        }
        if (this.expirationTimeMillis == null || System.currentTimeMillis() >= this.expirationTimeMillis) {
            this.updateAccessToken();
        }
        if (this.accessToken != null) {
            headerParams.put("Authorization", "Bearer " + this.accessToken);
        }
    }

    public synchronized void updateAccessToken() {
        OAuthJSONAccessTokenResponse accessTokenResponse;
        try {
            accessTokenResponse = this.oauthClient.accessToken(this.tokenRequestBuilder.buildBodyMessage());
        }
        catch (Exception e) {
            throw new ClientHandlerException(e.getMessage(), (Throwable)e);
        }
        if (accessTokenResponse != null && accessTokenResponse.getAccessToken() != null) {
            this.setAccessToken(accessTokenResponse.getAccessToken(), accessTokenResponse.getExpiresIn());
            if (this.accessTokenListener != null) {
                this.accessTokenListener.notify((BasicOAuthToken)accessTokenResponse.getOAuthToken());
            }
        }
    }

    public synchronized void registerAccessTokenListener(AccessTokenListener accessTokenListener) {
        this.accessTokenListener = accessTokenListener;
    }

    public synchronized String getAccessToken() {
        return this.accessToken;
    }

    public synchronized void setAccessToken(String accessToken, Long expiresIn) {
        this.accessToken = accessToken;
        this.expirationTimeMillis = System.currentTimeMillis() + expiresIn * 1000L;
    }

    public OAuthClientRequest.TokenRequestBuilder getTokenRequestBuilder() {
        return this.tokenRequestBuilder;
    }

    public void setTokenRequestBuilder(OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder) {
        this.tokenRequestBuilder = tokenRequestBuilder;
    }

    public OAuthClientRequest.AuthenticationRequestBuilder getAuthenticationRequestBuilder() {
        return this.authenticationRequestBuilder;
    }

    public void setAuthenticationRequestBuilder(OAuthClientRequest.AuthenticationRequestBuilder authenticationRequestBuilder) {
        this.authenticationRequestBuilder = authenticationRequestBuilder;
    }

    public OAuthClient getOauthClient() {
        return this.oauthClient;
    }

    public void setOauthClient(OAuthClient oauthClient) {
        this.oauthClient = oauthClient;
    }

    public void setOauthClient(Client client) {
        this.oauthClient = new OAuthClient((HttpClient)new OAuthJerseyClient(client));
    }

    public static class OAuthJerseyClient
    implements HttpClient {
        private Client client;

        public OAuthJerseyClient() {
            this.client = new Client(null, null);
        }

        public OAuthJerseyClient(Client client) {
            this.client = client;
        }

        public <T extends OAuthClientResponse> T execute(OAuthClientRequest request, Map<String, String> headers, String requestMethod, Class<T> responseClass) throws OAuthSystemException, OAuthProblemException {
            String contentType = headers.get("Content-Type");
            String url = request.getLocationUri();
            String body = request.getBody();
            WebResource.Builder builder = this.client.resource(url).getRequestBuilder();
            for (String key : headers.keySet()) {
                builder = (WebResource.Builder)builder.header(key, (Object)headers.get(key));
            }
            String grantType = null;
            String code = null;
            String clientId = null;
            String clientSecret = null;
            for (String entry : body.split("&")) {
                String key = entry.split("=")[0];
                String value = entry.split("=")[1];
                if ("grant_type".equals(key)) {
                    grantType = value;
                    continue;
                }
                if ("code".equals(key)) {
                    code = value;
                    continue;
                }
                if ("client_id".equals(key)) {
                    clientId = value;
                    continue;
                }
                if (!"client_secret".equals(key)) continue;
                clientSecret = value;
            }
            if (grantType == null || code == null) {
                throw new OAuthSystemException("Missing grant_type/code");
            }
            body = "grant_type=" + grantType + "&code=" + code;
            if (clientId == null || clientSecret == null) {
                throw new OAuthSystemException("Missing clientId/secret");
            }
            byte[] bytes = (clientId + ":" + clientSecret).getBytes();
            builder.header("Authorization", (Object)("Basic " + Base64.encodeToString((byte[])bytes, (boolean)false)));
            ClientResponse response = null;
            if ("GET".equals(requestMethod)) {
                response = (ClientResponse)builder.get(ClientResponse.class);
            } else if ("POST".equals(requestMethod)) {
                response = (ClientResponse)((WebResource.Builder)builder.type(contentType)).post(ClientResponse.class, (Object)body);
            } else if ("PUT".equals(requestMethod)) {
                response = (ClientResponse)((WebResource.Builder)builder.type(contentType)).put(ClientResponse.class, (Object)body);
            } else if ("DELETE".equals(requestMethod)) {
                response = (ClientResponse)((WebResource.Builder)builder.type(contentType)).delete(ClientResponse.class, (Object)body);
            }
            if (response.getStatusInfo() == ClientResponse.Status.NO_CONTENT) {
                return null;
            }
            if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                if (responseClass == null) {
                    return null;
                }
                String respBody = (String)response.getEntity(String.class);
                return (T)OAuthClientResponseFactory.createCustomResponse((String)respBody, (String)contentType, (int)response.getStatus(), (Map)response.getHeaders(), responseClass);
            }
            String message = "error";
            String respBody = null;
            if (response.hasEntity()) {
                try {
                    message = respBody = (String)response.getEntity(String.class);
                    System.err.println(message);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public void shutdown() {
        }
    }

    public static interface AccessTokenListener {
        public void notify(BasicOAuthToken var1);
    }
}

