/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.ErrorDetails;
import com.docusign.esign.model.MemberSharedItems;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Contains shared access information.")
public class AccountSharedAccess {
    private String accountId = null;
    private String endPosition = null;
    private ErrorDetails errorDetails = null;
    private String nextUri = null;
    private String previousUri = null;
    private String resultSetSize = null;
    private List<MemberSharedItems> sharedAccess = new ArrayList<MemberSharedItems>();
    private String startPosition = null;
    private String totalSetSize = null;

    @ApiModelProperty(value="The account ID associated with the envelope.")
    @JsonProperty(value="accountId")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    @ApiModelProperty(value="The last position in the result set.")
    @JsonProperty(value="endPosition")
    public String getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(String endPosition) {
        this.endPosition = endPosition;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="errorDetails")
    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
    }

    @ApiModelProperty(value="The URI to the next chunk of records based on the search request. If the endPosition is the entire results of the search, this is null.")
    @JsonProperty(value="nextUri")
    public String getNextUri() {
        return this.nextUri;
    }

    public void setNextUri(String nextUri) {
        this.nextUri = nextUri;
    }

    @ApiModelProperty(value="The postal code for the billing address.")
    @JsonProperty(value="previousUri")
    public String getPreviousUri() {
        return this.previousUri;
    }

    public void setPreviousUri(String previousUri) {
        this.previousUri = previousUri;
    }

    @ApiModelProperty(value="The number of results returned in this response.")
    @JsonProperty(value="resultSetSize")
    public String getResultSetSize() {
        return this.resultSetSize;
    }

    public void setResultSetSize(String resultSetSize) {
        this.resultSetSize = resultSetSize;
    }

    @ApiModelProperty(value="A complex type containing the shared access information to an envelope for the users specified in the request.")
    @JsonProperty(value="sharedAccess")
    public List<MemberSharedItems> getSharedAccess() {
        return this.sharedAccess;
    }

    public void setSharedAccess(List<MemberSharedItems> sharedAccess) {
        this.sharedAccess = sharedAccess;
    }

    @ApiModelProperty(value="Starting position of the current result set.")
    @JsonProperty(value="startPosition")
    public String getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(String startPosition) {
        this.startPosition = startPosition;
    }

    @ApiModelProperty(value="The total number of items available in the result set. This will always be greater than or equal to the value of the property returning the results in the in the response.")
    @JsonProperty(value="totalSetSize")
    public String getTotalSetSize() {
        return this.totalSetSize;
    }

    public void setTotalSetSize(String totalSetSize) {
        this.totalSetSize = totalSetSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountSharedAccess accountSharedAccess = (AccountSharedAccess)o;
        return Objects.equals(this.accountId, accountSharedAccess.accountId) && Objects.equals(this.endPosition, accountSharedAccess.endPosition) && Objects.equals(this.errorDetails, accountSharedAccess.errorDetails) && Objects.equals(this.nextUri, accountSharedAccess.nextUri) && Objects.equals(this.previousUri, accountSharedAccess.previousUri) && Objects.equals(this.resultSetSize, accountSharedAccess.resultSetSize) && Objects.equals(this.sharedAccess, accountSharedAccess.sharedAccess) && Objects.equals(this.startPosition, accountSharedAccess.startPosition) && Objects.equals(this.totalSetSize, accountSharedAccess.totalSetSize);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.endPosition, this.errorDetails, this.nextUri, this.previousUri, this.resultSetSize, this.sharedAccess, this.startPosition, this.totalSetSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountSharedAccess {\n");
        if (this.accountId != null) {
            sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        }
        if (this.endPosition != null) {
            sb.append("    endPosition: ").append(this.toIndentedString(this.endPosition)).append("\n");
        }
        if (this.errorDetails != null) {
            sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        }
        if (this.nextUri != null) {
            sb.append("    nextUri: ").append(this.toIndentedString(this.nextUri)).append("\n");
        }
        if (this.previousUri != null) {
            sb.append("    previousUri: ").append(this.toIndentedString(this.previousUri)).append("\n");
        }
        if (this.resultSetSize != null) {
            sb.append("    resultSetSize: ").append(this.toIndentedString(this.resultSetSize)).append("\n");
        }
        if (this.sharedAccess != null) {
            sb.append("    sharedAccess: ").append(this.toIndentedString(this.sharedAccess)).append("\n");
        }
        if (this.startPosition != null) {
            sb.append("    startPosition: ").append(this.toIndentedString(this.startPosition)).append("\n");
        }
        if (this.totalSetSize != null) {
            sb.append("    totalSetSize: ").append(this.toIndentedString(this.totalSetSize)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

