/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Contains information about the method used for authentication.")
public class AuthenticationMethod {
    private String authenticationType = null;
    private String lastProvider = null;
    private String lastTimestamp = null;
    private Integer totalCount = null;

    @ApiModelProperty(value="Indicates the type of authentication. Valid values are: PhoneAuth, STAN, ISCheck, OFAC, AccessCode, AgeVerify, or SSOAuth.")
    @JsonProperty(value="authenticationType")
    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    @ApiModelProperty(value="The last provider that authenticated the user.")
    @JsonProperty(value="lastProvider")
    public String getLastProvider() {
        return this.lastProvider;
    }

    public void setLastProvider(String lastProvider) {
        this.lastProvider = lastProvider;
    }

    @ApiModelProperty(value="The data and time the user last used the authentication method.")
    @JsonProperty(value="lastTimestamp")
    public String getLastTimestamp() {
        return this.lastTimestamp;
    }

    public void setLastTimestamp(String lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
    }

    @ApiModelProperty(value="The number of times the authentication method was used.")
    @JsonProperty(value="totalCount")
    public Integer getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationMethod authenticationMethod = (AuthenticationMethod)o;
        return Objects.equals(this.authenticationType, authenticationMethod.authenticationType) && Objects.equals(this.lastProvider, authenticationMethod.lastProvider) && Objects.equals(this.lastTimestamp, authenticationMethod.lastTimestamp) && Objects.equals(this.totalCount, authenticationMethod.totalCount);
    }

    public int hashCode() {
        return Objects.hash(this.authenticationType, this.lastProvider, this.lastTimestamp, this.totalCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticationMethod {\n");
        if (this.authenticationType != null) {
            sb.append("    authenticationType: ").append(this.toIndentedString(this.authenticationType)).append("\n");
        }
        if (this.lastProvider != null) {
            sb.append("    lastProvider: ").append(this.toIndentedString(this.lastProvider)).append("\n");
        }
        if (this.lastTimestamp != null) {
            sb.append("    lastTimestamp: ").append(this.toIndentedString(this.lastTimestamp)).append("\n");
        }
        if (this.totalCount != null) {
            sb.append("    totalCount: ").append(this.toIndentedString(this.totalCount)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

