/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.BillingDiscount;
import com.docusign.esign.model.BillingPrice;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Contains information about a billing charge.")
public class BillingCharge {
    private String allowedQuantity = null;
    private String blocked = null;
    private String chargeName = null;
    private String chargeType = null;
    private String chargeUnitOfMeasure = null;
    private List<BillingDiscount> discounts = new ArrayList<BillingDiscount>();
    private String firstEffectiveDate = null;
    private String includedQuantity = null;
    private String incrementalQuantity = null;
    private String lastEffectiveDate = null;
    private List<BillingPrice> prices = new ArrayList<BillingPrice>();
    private String unitPrice = null;
    private String usedQuantity = null;

    @ApiModelProperty(value="Reserved: TBD")
    @JsonProperty(value="allowedQuantity")
    public String getAllowedQuantity() {
        return this.allowedQuantity;
    }

    public void setAllowedQuantity(String allowedQuantity) {
        this.allowedQuantity = allowedQuantity;
    }

    @ApiModelProperty(value="Reserved: TBD")
    @JsonProperty(value="blocked")
    public String getBlocked() {
        return this.blocked;
    }

    public void setBlocked(String blocked) {
        this.blocked = blocked;
    }

    @ApiModelProperty(value="Provides information on what services the charge item is for.\n\nThe following table provides a description of the different chargeName values available at this time.\n\n| chargeName | Description |\n| --- | --- |\n| id_check | ID\u00a0Check Charge |\n| in_person_signing | In Person Signing charge |\n| envelopes Included | Sent Envelopes for the account |\n| age_verify | Age verification check |\n| ofac | OFAC Check |\n| id_confirm | ID confirmation check |\n| student_authentication | STAN PIN authentication check |\n| wet_sign_fax | Pages for returning signed documents by fax |\n| attachment_fax | Pages for returning attachments by fax |\n| phone_authentication | Phone authentication charge |\n| powerforms | PowerForm envelopes sent |\n| signer_payments | Payment processing charge |\n| outbound_fax | Send by fax charge |\n| bulk_recipient_envelopes | Bulk Recipient Envelopes sent |\n| sms_authentications | SMS authentication charge |\n| saml_authentications | SAML authentication charge |\n| express_signer_certificate | DocuSign Express Certificate charge |\n| personal_signer_certificate | Personal Signer Certificate charge |\n| safe_certificate | SAFE BioPharma Signer Certificate charge |\n| seats | Included active seats charge |\n| open_trust_certificate | OpenTrust Signer Certificate charge |")
    @JsonProperty(value="chargeName")
    public String getChargeName() {
        return this.chargeName;
    }

    public void setChargeName(String chargeName) {
        this.chargeName = chargeName;
    }

    @ApiModelProperty(value="Reserved: TBD")
    @JsonProperty(value="chargeType")
    public String getChargeType() {
        return this.chargeType;
    }

    public void setChargeType(String chargeType) {
        this.chargeType = chargeType;
    }

    @ApiModelProperty(value="Reserved: TBD")
    @JsonProperty(value="chargeUnitOfMeasure")
    public String getChargeUnitOfMeasure() {
        return this.chargeUnitOfMeasure;
    }

    public void setChargeUnitOfMeasure(String chargeUnitOfMeasure) {
        this.chargeUnitOfMeasure = chargeUnitOfMeasure;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="discounts")
    public List<BillingDiscount> getDiscounts() {
        return this.discounts;
    }

    public void setDiscounts(List<BillingDiscount> discounts) {
        this.discounts = discounts;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="firstEffectiveDate")
    public String getFirstEffectiveDate() {
        return this.firstEffectiveDate;
    }

    public void setFirstEffectiveDate(String firstEffectiveDate) {
        this.firstEffectiveDate = firstEffectiveDate;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="includedQuantity")
    public String getIncludedQuantity() {
        return this.includedQuantity;
    }

    public void setIncludedQuantity(String includedQuantity) {
        this.includedQuantity = includedQuantity;
    }

    @ApiModelProperty(value="Reserved: TBD")
    @JsonProperty(value="incrementalQuantity")
    public String getIncrementalQuantity() {
        return this.incrementalQuantity;
    }

    public void setIncrementalQuantity(String incrementalQuantity) {
        this.incrementalQuantity = incrementalQuantity;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="lastEffectiveDate")
    public String getLastEffectiveDate() {
        return this.lastEffectiveDate;
    }

    public void setLastEffectiveDate(String lastEffectiveDate) {
        this.lastEffectiveDate = lastEffectiveDate;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="prices")
    public List<BillingPrice> getPrices() {
        return this.prices;
    }

    public void setPrices(List<BillingPrice> prices) {
        this.prices = prices;
    }

    @ApiModelProperty(value="Reserved: TBD")
    @JsonProperty(value="unitPrice")
    public String getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(String unitPrice) {
        this.unitPrice = unitPrice;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="usedQuantity")
    public String getUsedQuantity() {
        return this.usedQuantity;
    }

    public void setUsedQuantity(String usedQuantity) {
        this.usedQuantity = usedQuantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingCharge billingCharge = (BillingCharge)o;
        return Objects.equals(this.allowedQuantity, billingCharge.allowedQuantity) && Objects.equals(this.blocked, billingCharge.blocked) && Objects.equals(this.chargeName, billingCharge.chargeName) && Objects.equals(this.chargeType, billingCharge.chargeType) && Objects.equals(this.chargeUnitOfMeasure, billingCharge.chargeUnitOfMeasure) && Objects.equals(this.discounts, billingCharge.discounts) && Objects.equals(this.firstEffectiveDate, billingCharge.firstEffectiveDate) && Objects.equals(this.includedQuantity, billingCharge.includedQuantity) && Objects.equals(this.incrementalQuantity, billingCharge.incrementalQuantity) && Objects.equals(this.lastEffectiveDate, billingCharge.lastEffectiveDate) && Objects.equals(this.prices, billingCharge.prices) && Objects.equals(this.unitPrice, billingCharge.unitPrice) && Objects.equals(this.usedQuantity, billingCharge.usedQuantity);
    }

    public int hashCode() {
        return Objects.hash(this.allowedQuantity, this.blocked, this.chargeName, this.chargeType, this.chargeUnitOfMeasure, this.discounts, this.firstEffectiveDate, this.includedQuantity, this.incrementalQuantity, this.lastEffectiveDate, this.prices, this.unitPrice, this.usedQuantity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingCharge {\n");
        if (this.allowedQuantity != null) {
            sb.append("    allowedQuantity: ").append(this.toIndentedString(this.allowedQuantity)).append("\n");
        }
        if (this.blocked != null) {
            sb.append("    blocked: ").append(this.toIndentedString(this.blocked)).append("\n");
        }
        if (this.chargeName != null) {
            sb.append("    chargeName: ").append(this.toIndentedString(this.chargeName)).append("\n");
        }
        if (this.chargeType != null) {
            sb.append("    chargeType: ").append(this.toIndentedString(this.chargeType)).append("\n");
        }
        if (this.chargeUnitOfMeasure != null) {
            sb.append("    chargeUnitOfMeasure: ").append(this.toIndentedString(this.chargeUnitOfMeasure)).append("\n");
        }
        if (this.discounts != null) {
            sb.append("    discounts: ").append(this.toIndentedString(this.discounts)).append("\n");
        }
        if (this.firstEffectiveDate != null) {
            sb.append("    firstEffectiveDate: ").append(this.toIndentedString(this.firstEffectiveDate)).append("\n");
        }
        if (this.includedQuantity != null) {
            sb.append("    includedQuantity: ").append(this.toIndentedString(this.includedQuantity)).append("\n");
        }
        if (this.incrementalQuantity != null) {
            sb.append("    incrementalQuantity: ").append(this.toIndentedString(this.incrementalQuantity)).append("\n");
        }
        if (this.lastEffectiveDate != null) {
            sb.append("    lastEffectiveDate: ").append(this.toIndentedString(this.lastEffectiveDate)).append("\n");
        }
        if (this.prices != null) {
            sb.append("    prices: ").append(this.toIndentedString(this.prices)).append("\n");
        }
        if (this.unitPrice != null) {
            sb.append("    unitPrice: ").append(this.toIndentedString(this.unitPrice)).append("\n");
        }
        if (this.usedQuantity != null) {
            sb.append("    usedQuantity: ").append(this.toIndentedString(this.usedQuantity)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

