/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.ConnectDebugLog;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ConnectLog {
    private String accountId = null;
    private String configUrl = null;
    private List<ConnectDebugLog> connectDebugLog = new ArrayList<ConnectDebugLog>();
    private String connectId = null;
    private String created = null;
    private String email = null;
    private String envelopeId = null;
    private String error = null;
    private String failureId = null;
    private String failureUri = null;
    private String lastTry = null;
    private String logId = null;
    private String logUri = null;
    private String retryCount = null;
    private String retryUri = null;
    private String status = null;
    private String subject = null;
    private String userName = null;

    @ApiModelProperty(value="The account ID associated with the envelope.")
    @JsonProperty(value="accountId")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    @ApiModelProperty(value="The web address of the listener or Retrieving Service end point for Connect.")
    @JsonProperty(value="configUrl")
    public String getConfigUrl() {
        return this.configUrl;
    }

    public void setConfigUrl(String configUrl) {
        this.configUrl = configUrl;
    }

    @ApiModelProperty(value="A complex element containing information about the Connect configuration, error details, date/time, description and payload.\n\nThis is only included in the response if the query additional_info=true is used.")
    @JsonProperty(value="connectDebugLog")
    public List<ConnectDebugLog> getConnectDebugLog() {
        return this.connectDebugLog;
    }

    public void setConnectDebugLog(List<ConnectDebugLog> connectDebugLog) {
        this.connectDebugLog = connectDebugLog;
    }

    @ApiModelProperty(value="The identifier for the Connect configuration that failed. If an account has multiple Connect configurations, this value is used to look up the Connect configuration for the failed post.")
    @JsonProperty(value="connectId")
    public String getConnectId() {
        return this.connectId;
    }

    public void setConnectId(String connectId) {
        this.connectId = connectId;
    }

    @ApiModelProperty(value="The date and time the entry was created.")
    @JsonProperty(value="created")
    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    @ApiModelProperty(value="The email that sent the envelope.")
    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @ApiModelProperty(value="The envelope ID of the envelope status that failed to post.")
    @JsonProperty(value="envelopeId")
    public String getEnvelopeId() {
        return this.envelopeId;
    }

    public void setEnvelopeId(String envelopeId) {
        this.envelopeId = envelopeId;
    }

    @ApiModelProperty(value="The error that caused the Connect post to fail.")
    @JsonProperty(value="error")
    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    @ApiModelProperty(value="The failure log ID for the failure.")
    @JsonProperty(value="failureId")
    public String getFailureId() {
        return this.failureId;
    }

    public void setFailureId(String failureId) {
        this.failureId = failureId;
    }

    @ApiModelProperty(value="The URI for the failure.")
    @JsonProperty(value="failureUri")
    public String getFailureUri() {
        return this.failureUri;
    }

    public void setFailureUri(String failureUri) {
        this.failureUri = failureUri;
    }

    @ApiModelProperty(value="The date and time the last attempt to post.")
    @JsonProperty(value="lastTry")
    public String getLastTry() {
        return this.lastTry;
    }

    public void setLastTry(String lastTry) {
        this.lastTry = lastTry;
    }

    @ApiModelProperty(value="The Connect log ID for the entry.")
    @JsonProperty(value="logId")
    public String getLogId() {
        return this.logId;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }

    @ApiModelProperty(value="The URI for the log item.")
    @JsonProperty(value="logUri")
    public String getLogUri() {
        return this.logUri;
    }

    public void setLogUri(String logUri) {
        this.logUri = logUri;
    }

    @ApiModelProperty(value="The number of times the Connect post has been retried.")
    @JsonProperty(value="retryCount")
    public String getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(String retryCount) {
        this.retryCount = retryCount;
    }

    @ApiModelProperty(value="The UEI to retry to publish the Connect failure.")
    @JsonProperty(value="retryUri")
    public String getRetryUri() {
        return this.retryUri;
    }

    public void setRetryUri(String retryUri) {
        this.retryUri = retryUri;
    }

    @ApiModelProperty(value="The new envelope status for the failed Connect post. The possible values are: Any, Voided, Created, Deleted, Sent, Delivered, Signed, Completed, Declined, TimedOut, Template, or Processing.")
    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @ApiModelProperty(value="The envelope subject.")
    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @ApiModelProperty(value="The name of the envelope sender.")
    @JsonProperty(value="userName")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectLog connectLog = (ConnectLog)o;
        return Objects.equals(this.accountId, connectLog.accountId) && Objects.equals(this.configUrl, connectLog.configUrl) && Objects.equals(this.connectDebugLog, connectLog.connectDebugLog) && Objects.equals(this.connectId, connectLog.connectId) && Objects.equals(this.created, connectLog.created) && Objects.equals(this.email, connectLog.email) && Objects.equals(this.envelopeId, connectLog.envelopeId) && Objects.equals(this.error, connectLog.error) && Objects.equals(this.failureId, connectLog.failureId) && Objects.equals(this.failureUri, connectLog.failureUri) && Objects.equals(this.lastTry, connectLog.lastTry) && Objects.equals(this.logId, connectLog.logId) && Objects.equals(this.logUri, connectLog.logUri) && Objects.equals(this.retryCount, connectLog.retryCount) && Objects.equals(this.retryUri, connectLog.retryUri) && Objects.equals(this.status, connectLog.status) && Objects.equals(this.subject, connectLog.subject) && Objects.equals(this.userName, connectLog.userName);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.configUrl, this.connectDebugLog, this.connectId, this.created, this.email, this.envelopeId, this.error, this.failureId, this.failureUri, this.lastTry, this.logId, this.logUri, this.retryCount, this.retryUri, this.status, this.subject, this.userName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConnectLog {\n");
        if (this.accountId != null) {
            sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        }
        if (this.configUrl != null) {
            sb.append("    configUrl: ").append(this.toIndentedString(this.configUrl)).append("\n");
        }
        if (this.connectDebugLog != null) {
            sb.append("    connectDebugLog: ").append(this.toIndentedString(this.connectDebugLog)).append("\n");
        }
        if (this.connectId != null) {
            sb.append("    connectId: ").append(this.toIndentedString(this.connectId)).append("\n");
        }
        if (this.created != null) {
            sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        }
        if (this.email != null) {
            sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        }
        if (this.envelopeId != null) {
            sb.append("    envelopeId: ").append(this.toIndentedString(this.envelopeId)).append("\n");
        }
        if (this.error != null) {
            sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        }
        if (this.failureId != null) {
            sb.append("    failureId: ").append(this.toIndentedString(this.failureId)).append("\n");
        }
        if (this.failureUri != null) {
            sb.append("    failureUri: ").append(this.toIndentedString(this.failureUri)).append("\n");
        }
        if (this.lastTry != null) {
            sb.append("    lastTry: ").append(this.toIndentedString(this.lastTry)).append("\n");
        }
        if (this.logId != null) {
            sb.append("    logId: ").append(this.toIndentedString(this.logId)).append("\n");
        }
        if (this.logUri != null) {
            sb.append("    logUri: ").append(this.toIndentedString(this.logUri)).append("\n");
        }
        if (this.retryCount != null) {
            sb.append("    retryCount: ").append(this.toIndentedString(this.retryCount)).append("\n");
        }
        if (this.retryUri != null) {
            sb.append("    retryUri: ").append(this.toIndentedString(this.retryUri)).append("\n");
        }
        if (this.status != null) {
            sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        }
        if (this.subject != null) {
            sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        }
        if (this.userName != null) {
            sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

