/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A complex element that specifies the expiration settings for the envelope.")
public class Expirations {
    private String expireAfter = null;
    private String expireEnabled = null;
    private String expireWarn = null;

    @ApiModelProperty(value="An integer that sets the number of days the envelope is active.")
    @JsonProperty(value="expireAfter")
    public String getExpireAfter() {
        return this.expireAfter;
    }

    public void setExpireAfter(String expireAfter) {
        this.expireAfter = expireAfter;
    }

    @ApiModelProperty(value="When set to **true**, the envelope expires (is no longer available for signing) in the set number of days. If false, the account default setting is used. If the account does not have an expiration setting, the DocuSign default value of 120 days is used.")
    @JsonProperty(value="expireEnabled")
    public String getExpireEnabled() {
        return this.expireEnabled;
    }

    public void setExpireEnabled(String expireEnabled) {
        this.expireEnabled = expireEnabled;
    }

    @ApiModelProperty(value="An integer that sets the number of days before envelope expiration that an expiration warning email is sent to the recipient. If set to 0 (zero), no warning email is sent.")
    @JsonProperty(value="expireWarn")
    public String getExpireWarn() {
        return this.expireWarn;
    }

    public void setExpireWarn(String expireWarn) {
        this.expireWarn = expireWarn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Expirations expirations = (Expirations)o;
        return Objects.equals(this.expireAfter, expirations.expireAfter) && Objects.equals(this.expireEnabled, expirations.expireEnabled) && Objects.equals(this.expireWarn, expirations.expireWarn);
    }

    public int hashCode() {
        return Objects.hash(this.expireAfter, this.expireEnabled, this.expireWarn);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Expirations {\n");
        if (this.expireAfter != null) {
            sb.append("    expireAfter: ").append(this.toIndentedString(this.expireAfter)).append("\n");
        }
        if (this.expireEnabled != null) {
            sb.append("    expireEnabled: ").append(this.toIndentedString(this.expireEnabled)).append("\n");
        }
        if (this.expireWarn != null) {
            sb.append("    expireWarn: ").append(this.toIndentedString(this.expireWarn)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

