/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.Expirations;
import com.docusign.esign.model.Reminders;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A complex element that specifies the notification options for the envelope. It consists of:\n\n* useAccountDefaults - When set to **true**, the account default notification settings are used for the envelope. \n* reminders - A complex element that specifies reminder settings for the envelope. It consists of: \n\n   * reminderEnabled - When set to **true**, a reminder message is sent to the recipient.\n   * reminderDelay - An interger that sets the number of days after the recipient receives the envelope that reminder emails are sent to the recipient. \n   * reminderFrequency - An interger that sets the interval, in days, between reminder emails. \n\n* expirations - A complex element that specifies the expiration settings for the envelope. It consists of:\n\n   * expireEnabled - When set to **true**, the envelope expires (is no longer available for signing) in the set number of days. If false, the account default setting is used. If the account does not have an expiration setting, the DocuSign default value of 120 days is used. \n   * expireAfter - An integer that sets the number of days the envelope is active.\n   * expireWarn - An integer that sets the number of days before envelope expiration that an expiration warning email is sent to the recipient. If set to 0 (zero), no warning email is sent.")
public class Notification {
    private Expirations expirations = null;
    private Reminders reminders = null;
    private String useAccountDefaults = null;

    @ApiModelProperty(value="")
    @JsonProperty(value="expirations")
    public Expirations getExpirations() {
        return this.expirations;
    }

    public void setExpirations(Expirations expirations) {
        this.expirations = expirations;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="reminders")
    public Reminders getReminders() {
        return this.reminders;
    }

    public void setReminders(Reminders reminders) {
        this.reminders = reminders;
    }

    @ApiModelProperty(value="When set to **true**, the account default notification settings are used for the envelope.")
    @JsonProperty(value="useAccountDefaults")
    public String getUseAccountDefaults() {
        return this.useAccountDefaults;
    }

    public void setUseAccountDefaults(String useAccountDefaults) {
        this.useAccountDefaults = useAccountDefaults;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notification notification = (Notification)o;
        return Objects.equals(this.expirations, notification.expirations) && Objects.equals(this.reminders, notification.reminders) && Objects.equals(this.useAccountDefaults, notification.useAccountDefaults);
    }

    public int hashCode() {
        return Objects.hash(this.expirations, this.reminders, this.useAccountDefaults);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Notification {\n");
        if (this.expirations != null) {
            sb.append("    expirations: ").append(this.toIndentedString(this.expirations)).append("\n");
        }
        if (this.reminders != null) {
            sb.append("    reminders: ").append(this.toIndentedString(this.reminders)).append("\n");
        }
        if (this.useAccountDefaults != null) {
            sb.append("    useAccountDefaults: ").append(this.toIndentedString(this.useAccountDefaults)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

