/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.Radio;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RadioGroup {
    private String conditionalParentLabel = null;
    private String conditionalParentValue = null;
    private String documentId = null;
    private String groupName = null;
    private List<Radio> radios = new ArrayList<Radio>();
    private String recipientId = null;
    private String requireAll = null;
    private String requireInitialOnSharedChange = null;
    private String shared = null;

    @ApiModelProperty(value="For conditional fields this is the TabLabel of the parent tab that controls this tab's visibility.")
    @JsonProperty(value="conditionalParentLabel")
    public String getConditionalParentLabel() {
        return this.conditionalParentLabel;
    }

    public void setConditionalParentLabel(String conditionalParentLabel) {
        this.conditionalParentLabel = conditionalParentLabel;
    }

    @ApiModelProperty(value="For conditional fields, this is the value of the parent tab that controls the tab's visibility.\n\nIf the parent tab is a Checkbox, Radio button, Optional Signature, or Optional Initial use \"on\" as the value to show that the parent tab is active.")
    @JsonProperty(value="conditionalParentValue")
    public String getConditionalParentValue() {
        return this.conditionalParentValue;
    }

    public void setConditionalParentValue(String conditionalParentValue) {
        this.conditionalParentValue = conditionalParentValue;
    }

    @ApiModelProperty(value="Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.")
    @JsonProperty(value="documentId")
    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    @ApiModelProperty(value="The name of the group.")
    @JsonProperty(value="groupName")
    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @ApiModelProperty(value="Specifies the locations and status for radio buttons that are grouped together.")
    @JsonProperty(value="radios")
    public List<Radio> getRadios() {
        return this.radios;
    }

    public void setRadios(List<Radio> radios) {
        this.radios = radios;
    }

    @ApiModelProperty(value="Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.")
    @JsonProperty(value="recipientId")
    public String getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(String recipientId) {
        this.recipientId = recipientId;
    }

    @ApiModelProperty(value="When set to **true** and shared is true, information must be entered in this field to complete the envelope.")
    @JsonProperty(value="requireAll")
    public String getRequireAll() {
        return this.requireAll;
    }

    public void setRequireAll(String requireAll) {
        this.requireAll = requireAll;
    }

    @ApiModelProperty(value="Optional element for field markup. When set to **true**, the signer is required to initial when they modify a shared field.")
    @JsonProperty(value="requireInitialOnSharedChange")
    public String getRequireInitialOnSharedChange() {
        return this.requireInitialOnSharedChange;
    }

    public void setRequireInitialOnSharedChange(String requireInitialOnSharedChange) {
        this.requireInitialOnSharedChange = requireInitialOnSharedChange;
    }

    @ApiModelProperty(value="When set to **true**, this custom tab is shared.")
    @JsonProperty(value="shared")
    public String getShared() {
        return this.shared;
    }

    public void setShared(String shared) {
        this.shared = shared;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RadioGroup radioGroup = (RadioGroup)o;
        return Objects.equals(this.conditionalParentLabel, radioGroup.conditionalParentLabel) && Objects.equals(this.conditionalParentValue, radioGroup.conditionalParentValue) && Objects.equals(this.documentId, radioGroup.documentId) && Objects.equals(this.groupName, radioGroup.groupName) && Objects.equals(this.radios, radioGroup.radios) && Objects.equals(this.recipientId, radioGroup.recipientId) && Objects.equals(this.requireAll, radioGroup.requireAll) && Objects.equals(this.requireInitialOnSharedChange, radioGroup.requireInitialOnSharedChange) && Objects.equals(this.shared, radioGroup.shared);
    }

    public int hashCode() {
        return Objects.hash(this.conditionalParentLabel, this.conditionalParentValue, this.documentId, this.groupName, this.radios, this.recipientId, this.requireAll, this.requireInitialOnSharedChange, this.shared);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RadioGroup {\n");
        if (this.conditionalParentLabel != null) {
            sb.append("    conditionalParentLabel: ").append(this.toIndentedString(this.conditionalParentLabel)).append("\n");
        }
        if (this.conditionalParentValue != null) {
            sb.append("    conditionalParentValue: ").append(this.toIndentedString(this.conditionalParentValue)).append("\n");
        }
        if (this.documentId != null) {
            sb.append("    documentId: ").append(this.toIndentedString(this.documentId)).append("\n");
        }
        if (this.groupName != null) {
            sb.append("    groupName: ").append(this.toIndentedString(this.groupName)).append("\n");
        }
        if (this.radios != null) {
            sb.append("    radios: ").append(this.toIndentedString(this.radios)).append("\n");
        }
        if (this.recipientId != null) {
            sb.append("    recipientId: ").append(this.toIndentedString(this.recipientId)).append("\n");
        }
        if (this.requireAll != null) {
            sb.append("    requireAll: ").append(this.toIndentedString(this.requireAll)).append("\n");
        }
        if (this.requireInitialOnSharedChange != null) {
            sb.append("    requireInitialOnSharedChange: ").append(this.toIndentedString(this.requireInitialOnSharedChange)).append("\n");
        }
        if (this.shared != null) {
            sb.append("    shared: ").append(this.toIndentedString(this.shared)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

