/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.Agent;
import com.docusign.esign.model.CarbonCopy;
import com.docusign.esign.model.CertifiedDelivery;
import com.docusign.esign.model.Editor;
import com.docusign.esign.model.ErrorDetails;
import com.docusign.esign.model.InPersonSigner;
import com.docusign.esign.model.Intermediary;
import com.docusign.esign.model.Signer;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Specifies the envelope recipients.")
public class Recipients {
    private List<Agent> agents = new ArrayList<Agent>();
    private List<CarbonCopy> carbonCopies = new ArrayList<CarbonCopy>();
    private List<CertifiedDelivery> certifiedDeliveries = new ArrayList<CertifiedDelivery>();
    private String currentRoutingOrder = null;
    private List<Editor> editors = new ArrayList<Editor>();
    private ErrorDetails errorDetails = null;
    private List<InPersonSigner> inPersonSigners = new ArrayList<InPersonSigner>();
    private List<Intermediary> intermediaries = new ArrayList<Intermediary>();
    private String recipientCount = null;
    private List<Signer> signers = new ArrayList<Signer>();

    @ApiModelProperty(value="A complex type defining the management and access rights of a recipient assigned assigned as an agent on the document.")
    @JsonProperty(value="agents")
    public List<Agent> getAgents() {
        return this.agents;
    }

    public void setAgents(List<Agent> agents) {
        this.agents = agents;
    }

    @ApiModelProperty(value="A complex type containing information about recipients who should receive a copy of the envelope, but does not need to sign it.")
    @JsonProperty(value="carbonCopies")
    public List<CarbonCopy> getCarbonCopies() {
        return this.carbonCopies;
    }

    public void setCarbonCopies(List<CarbonCopy> carbonCopies) {
        this.carbonCopies = carbonCopies;
    }

    @ApiModelProperty(value="A complex type containing information on a recipient the must receive the completed documents for the envelope to be completed, but the recipient does not need to sign, initial, date, or add information to any of the documents.")
    @JsonProperty(value="certifiedDeliveries")
    public List<CertifiedDelivery> getCertifiedDeliveries() {
        return this.certifiedDeliveries;
    }

    public void setCertifiedDeliveries(List<CertifiedDelivery> certifiedDeliveries) {
        this.certifiedDeliveries = certifiedDeliveries;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="currentRoutingOrder")
    public String getCurrentRoutingOrder() {
        return this.currentRoutingOrder;
    }

    public void setCurrentRoutingOrder(String currentRoutingOrder) {
        this.currentRoutingOrder = currentRoutingOrder;
    }

    @ApiModelProperty(value="A complex type defining the management and access rights of a recipient assigned assigned as an editor on the document.")
    @JsonProperty(value="editors")
    public List<Editor> getEditors() {
        return this.editors;
    }

    public void setEditors(List<Editor> editors) {
        this.editors = editors;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="errorDetails")
    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
    }

    @ApiModelProperty(value="Specifies a signer that is in the same physical location as a DocuSign user who will act as a Signing Host for the transaction. The recipient added is the Signing Host and new separate Signer Name field appears after Sign in person is selected.")
    @JsonProperty(value="inPersonSigners")
    public List<InPersonSigner> getInPersonSigners() {
        return this.inPersonSigners;
    }

    public void setInPersonSigners(List<InPersonSigner> inPersonSigners) {
        this.inPersonSigners = inPersonSigners;
    }

    @ApiModelProperty(value="Identifies a recipient that can, but is not required to, add name and email information for recipients at the same or subsequent level in the routing order (until subsequent Agents, Editors or Intermediaries recipient types are added).")
    @JsonProperty(value="intermediaries")
    public List<Intermediary> getIntermediaries() {
        return this.intermediaries;
    }

    public void setIntermediaries(List<Intermediary> intermediaries) {
        this.intermediaries = intermediaries;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="recipientCount")
    public String getRecipientCount() {
        return this.recipientCount;
    }

    public void setRecipientCount(String recipientCount) {
        this.recipientCount = recipientCount;
    }

    @ApiModelProperty(value="A complex type containing information about the Signer recipient.")
    @JsonProperty(value="signers")
    public List<Signer> getSigners() {
        return this.signers;
    }

    public void setSigners(List<Signer> signers) {
        this.signers = signers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recipients recipients = (Recipients)o;
        return Objects.equals(this.agents, recipients.agents) && Objects.equals(this.carbonCopies, recipients.carbonCopies) && Objects.equals(this.certifiedDeliveries, recipients.certifiedDeliveries) && Objects.equals(this.currentRoutingOrder, recipients.currentRoutingOrder) && Objects.equals(this.editors, recipients.editors) && Objects.equals(this.errorDetails, recipients.errorDetails) && Objects.equals(this.inPersonSigners, recipients.inPersonSigners) && Objects.equals(this.intermediaries, recipients.intermediaries) && Objects.equals(this.recipientCount, recipients.recipientCount) && Objects.equals(this.signers, recipients.signers);
    }

    public int hashCode() {
        return Objects.hash(this.agents, this.carbonCopies, this.certifiedDeliveries, this.currentRoutingOrder, this.editors, this.errorDetails, this.inPersonSigners, this.intermediaries, this.recipientCount, this.signers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Recipients {\n");
        if (this.agents != null) {
            sb.append("    agents: ").append(this.toIndentedString(this.agents)).append("\n");
        }
        if (this.carbonCopies != null) {
            sb.append("    carbonCopies: ").append(this.toIndentedString(this.carbonCopies)).append("\n");
        }
        if (this.certifiedDeliveries != null) {
            sb.append("    certifiedDeliveries: ").append(this.toIndentedString(this.certifiedDeliveries)).append("\n");
        }
        if (this.currentRoutingOrder != null) {
            sb.append("    currentRoutingOrder: ").append(this.toIndentedString(this.currentRoutingOrder)).append("\n");
        }
        if (this.editors != null) {
            sb.append("    editors: ").append(this.toIndentedString(this.editors)).append("\n");
        }
        if (this.errorDetails != null) {
            sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        }
        if (this.inPersonSigners != null) {
            sb.append("    inPersonSigners: ").append(this.toIndentedString(this.inPersonSigners)).append("\n");
        }
        if (this.intermediaries != null) {
            sb.append("    intermediaries: ").append(this.toIndentedString(this.intermediaries)).append("\n");
        }
        if (this.recipientCount != null) {
            sb.append("    recipientCount: ").append(this.toIndentedString(this.recipientCount)).append("\n");
        }
        if (this.signers != null) {
            sb.append("    signers: ").append(this.toIndentedString(this.signers)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

