/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.client.auth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class JWTUtils {
    public static String generateJWTAssertion(String publicKeyFilename, String privateKeyFilename, String oAuthBasePath, String clientId, String userId, long expiresIn) throws JWTCreationException, IOException {
        String token = null;
        try {
            RSAPublicKey publicKey = JWTUtils.readPublicKeyFromFile(publicKeyFilename, "RSA");
            RSAPrivateKey privateKey = JWTUtils.readPrivateKeyFromFile(privateKeyFilename, "RSA");
            Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)publicKey, (RSAPrivateKey)privateKey);
            long now = System.currentTimeMillis();
            token = JWT.create().withIssuer(clientId).withSubject(userId).withAudience(new String[]{oAuthBasePath}).withNotBefore(new Date(now)).withExpiresAt(new Date(now + expiresIn * 1000L)).withClaim("scope", "signature").sign(algorithm);
        }
        catch (JWTCreationException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RSAPublicKey readPublicKeyFromFile(String filepath, String algorithm) throws IOException {
        File pemFile = new File(filepath);
        if (!pemFile.isFile() || !pemFile.exists()) {
            throw new FileNotFoundException(String.format("The file '%s' doesn't exist.", pemFile.getAbsolutePath()));
        }
        PemReader reader = new PemReader((Reader)new FileReader(pemFile));
        try {
            PemObject pemObject = reader.readPemObject();
            byte[] bytes = pemObject.getContent();
            RSAPublicKey publicKey = null;
            try {
                KeyFactory kf = KeyFactory.getInstance(algorithm);
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
                publicKey = (RSAPublicKey)kf.generatePublic(keySpec);
            }
            catch (NoSuchAlgorithmException e) {
                System.out.println("Could not reconstruct the public key, the given algorithm could not be found.");
            }
            catch (InvalidKeySpecException e) {
                System.out.println("Could not reconstruct the public key");
            }
            RSAPublicKey rSAPublicKey = publicKey;
            return rSAPublicKey;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RSAPrivateKey readPrivateKeyFromFile(String filepath, String algorithm) throws IOException {
        File pemFile = new File(filepath);
        if (!pemFile.isFile() || !pemFile.exists()) {
            throw new FileNotFoundException(String.format("The file '%s' doesn't exist.", pemFile.getAbsolutePath()));
        }
        PemReader reader = new PemReader((Reader)new FileReader(pemFile));
        try {
            PemObject pemObject = reader.readPemObject();
            byte[] bytes = pemObject.getContent();
            RSAPrivateKey privateKey = null;
            try {
                Security.addProvider((Provider)new BouncyCastleProvider());
                KeyFactory kf = KeyFactory.getInstance(algorithm, "BC");
                PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
                privateKey = (RSAPrivateKey)kf.generatePrivate(keySpec);
            }
            catch (NoSuchAlgorithmException e) {
                System.out.println("Could not reconstruct the private key, the given algorithm could not be found.");
            }
            catch (InvalidKeySpecException e) {
                System.out.println("Could not reconstruct the private key");
            }
            catch (NoSuchProviderException e) {
                System.out.println("Could not reconstruct the private key, invalid provider.");
            }
            RSAPrivateKey rSAPrivateKey = privateKey;
            return rSAPrivateKey;
        }
        finally {
            reader.close();
        }
    }
}

