/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.BccEmailAddress;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A complex element that allows  the sender to override some envelope email setting information. This can be used to override the Reply To email address and name associated with the envelope and to override the BCC email addresses to which an envelope is sent.   When the emailSettings information is used for an envelope, it only applies to that envelope.   **IMPORTANT**: The emailSettings information is not returned in the GET for envelope status. Use GET /email_settings to return information about the emailSettings.   EmailSettings consists of:   * replyEmailAddressOverride - The Reply To email used for the envelope. DocuSign will verify that a correct email format is used, but does not verify that the email is active. Maximum Length: 100 characters. * replyEmailNameOverride - The name associated with the Reply To email address. Maximum Length: 100 characters. * bccEmailAddresses - An array of up to five email addresses to which the envelope is sent to as a BCC email. Only users with canManageAccount setting set to true can use this option.  DocuSign verifies that the email format is correct, but does not verify that the email is active. Using this overrides the BCC for Email Archive information setting for this envelope. Maximum Length: 100 characters. *Example*: if your account has BCC for Email Archive set up for the email address \u2018archive@mycompany.com\u2019 and you send an envelope using the BCC Email Override to send a BCC email to \u2018salesarchive@mycompany.com\u2019, then a copy of the envelope is only sent to the \u2018salesarchive@mycompany.com\u2019 email address.")
public class EmailSettings {
    @JsonProperty(value="bccEmailAddresses")
    private List<BccEmailAddress> bccEmailAddresses = new ArrayList<BccEmailAddress>();
    @JsonProperty(value="replyEmailAddressOverride")
    private String replyEmailAddressOverride = null;
    @JsonProperty(value="replyEmailNameOverride")
    private String replyEmailNameOverride = null;

    public EmailSettings bccEmailAddresses(List<BccEmailAddress> bccEmailAddresses) {
        this.bccEmailAddresses = bccEmailAddresses;
        return this;
    }

    public EmailSettings addBccEmailAddressesItem(BccEmailAddress bccEmailAddressesItem) {
        this.bccEmailAddresses.add(bccEmailAddressesItem);
        return this;
    }

    @ApiModelProperty(example="null", value="A list of email addresses that receive a copy of all email communications for an envelope. You can use this for archiving purposes.")
    public List<BccEmailAddress> getBccEmailAddresses() {
        return this.bccEmailAddresses;
    }

    public void setBccEmailAddresses(List<BccEmailAddress> bccEmailAddresses) {
        this.bccEmailAddresses = bccEmailAddresses;
    }

    public EmailSettings replyEmailAddressOverride(String replyEmailAddressOverride) {
        this.replyEmailAddressOverride = replyEmailAddressOverride;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getReplyEmailAddressOverride() {
        return this.replyEmailAddressOverride;
    }

    public void setReplyEmailAddressOverride(String replyEmailAddressOverride) {
        this.replyEmailAddressOverride = replyEmailAddressOverride;
    }

    public EmailSettings replyEmailNameOverride(String replyEmailNameOverride) {
        this.replyEmailNameOverride = replyEmailNameOverride;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getReplyEmailNameOverride() {
        return this.replyEmailNameOverride;
    }

    public void setReplyEmailNameOverride(String replyEmailNameOverride) {
        this.replyEmailNameOverride = replyEmailNameOverride;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailSettings emailSettings = (EmailSettings)o;
        return Objects.equals(this.bccEmailAddresses, emailSettings.bccEmailAddresses) && Objects.equals(this.replyEmailAddressOverride, emailSettings.replyEmailAddressOverride) && Objects.equals(this.replyEmailNameOverride, emailSettings.replyEmailNameOverride);
    }

    public int hashCode() {
        return Objects.hash(this.bccEmailAddresses, this.replyEmailAddressOverride, this.replyEmailNameOverride);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailSettings {\n");
        sb.append("    bccEmailAddresses: ").append(this.toIndentedString(this.bccEmailAddresses)).append("\n");
        sb.append("    replyEmailAddressOverride: ").append(this.toIndentedString(this.replyEmailAddressOverride)).append("\n");
        sb.append("    replyEmailNameOverride: ").append(this.toIndentedString(this.replyEmailNameOverride)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

