/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.AddressInformationInput;
import com.docusign.esign.model.DobInformationInput;
import com.docusign.esign.model.Ssn4InformationInput;
import com.docusign.esign.model.Ssn9InformationInput;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A complex element that contains input information related to a recipient ID check. It can include the following information.  addressInformationInput: Used to set recipient address information and consists of:  * addressInformation: consists of six elements, with stree2 and zipPlus4 being optional. The elements are: street1, street2, city, state, zip, zipPlus4. The maximum length of each element is: street1/street2 = 150 characters, city = 50 characters, state = 2 characters, and zip/zipPlus4 = 20 characters. * displayLevelCode: Specifies the display level for the recipient. Values are: ReadOnly, Editable, or DoNotDisplay. * receiveInResponse: A Boolean element that specifies if the information needs to be returned in the response.  dobInformationInput: Used to set recipient date of birth information and consists of:  * dateOfBirth: Specifies the recipient\u2019s date, month and year of birth. * displayLevelCode: Specifies the display level for the recipient. Values are: ReadOnly, Editable, or DoNotDisplay. * receiveInResponse: A Boolean element that specifies if the information needs to be returned in the response.  ssn4InformationInput: Used to set the last four digits of the recipient\u2019s SSN information and consists of:  * ssn4: Specifies the last four digits of the recipient\u2019s SSN. * displayLevelCode: Specifies the display level for the recipient. Values are: ReadOnly, Editable, or DoNotDisplay. * receiveInResponse: A Boolean element that specifies if the information needs to be returned in the response.  ssn9InformationInput: Used to set the recipient\u2019s SSN information. Note that the ssn9 information can never be returned in the response. The ssn9 input consists of:  * ssn9: Specifies the recipient\u2019s SSN. * displayLevelCode: Specifies the display level for the recipient. Values are: ReadOnly, Editable, or DoNotDisplay.")
public class IdCheckInformationInput {
    @JsonProperty(value="addressInformationInput")
    private AddressInformationInput addressInformationInput = null;
    @JsonProperty(value="dobInformationInput")
    private DobInformationInput dobInformationInput = null;
    @JsonProperty(value="ssn4InformationInput")
    private Ssn4InformationInput ssn4InformationInput = null;
    @JsonProperty(value="ssn9InformationInput")
    private Ssn9InformationInput ssn9InformationInput = null;

    public IdCheckInformationInput addressInformationInput(AddressInformationInput addressInformationInput) {
        this.addressInformationInput = addressInformationInput;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public AddressInformationInput getAddressInformationInput() {
        return this.addressInformationInput;
    }

    public void setAddressInformationInput(AddressInformationInput addressInformationInput) {
        this.addressInformationInput = addressInformationInput;
    }

    public IdCheckInformationInput dobInformationInput(DobInformationInput dobInformationInput) {
        this.dobInformationInput = dobInformationInput;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public DobInformationInput getDobInformationInput() {
        return this.dobInformationInput;
    }

    public void setDobInformationInput(DobInformationInput dobInformationInput) {
        this.dobInformationInput = dobInformationInput;
    }

    public IdCheckInformationInput ssn4InformationInput(Ssn4InformationInput ssn4InformationInput) {
        this.ssn4InformationInput = ssn4InformationInput;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Ssn4InformationInput getSsn4InformationInput() {
        return this.ssn4InformationInput;
    }

    public void setSsn4InformationInput(Ssn4InformationInput ssn4InformationInput) {
        this.ssn4InformationInput = ssn4InformationInput;
    }

    public IdCheckInformationInput ssn9InformationInput(Ssn9InformationInput ssn9InformationInput) {
        this.ssn9InformationInput = ssn9InformationInput;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Ssn9InformationInput getSsn9InformationInput() {
        return this.ssn9InformationInput;
    }

    public void setSsn9InformationInput(Ssn9InformationInput ssn9InformationInput) {
        this.ssn9InformationInput = ssn9InformationInput;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdCheckInformationInput idCheckInformationInput = (IdCheckInformationInput)o;
        return Objects.equals(this.addressInformationInput, idCheckInformationInput.addressInformationInput) && Objects.equals(this.dobInformationInput, idCheckInformationInput.dobInformationInput) && Objects.equals(this.ssn4InformationInput, idCheckInformationInput.ssn4InformationInput) && Objects.equals(this.ssn9InformationInput, idCheckInformationInput.ssn9InformationInput);
    }

    public int hashCode() {
        return Objects.hash(this.addressInformationInput, this.dobInformationInput, this.ssn4InformationInput, this.ssn9InformationInput);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdCheckInformationInput {\n");
        sb.append("    addressInformationInput: ").append(this.toIndentedString(this.addressInformationInput)).append("\n");
        sb.append("    dobInformationInput: ").append(this.toIndentedString(this.dobInformationInput)).append("\n");
        sb.append("    ssn4InformationInput: ").append(this.toIndentedString(this.ssn4InformationInput)).append("\n");
        sb.append("    ssn9InformationInput: ").append(this.toIndentedString(this.ssn9InformationInput)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

