/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.client.auth;

import com.migcomponents.migbase64.Base64;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthClientResponse;
import org.apache.oltu.oauth2.client.response.OAuthClientResponseFactory;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;

public class OAuthJerseyClient
implements HttpClient {
    private Client client;

    public OAuthJerseyClient() {
        this.client = new Client(null, null);
    }

    public OAuthJerseyClient(Client client) {
        this.client = client;
    }

    public <T extends OAuthClientResponse> T execute(OAuthClientRequest request, Map<String, String> headers, String requestMethod, Class<T> responseClass) throws OAuthSystemException, OAuthProblemException {
        String contentType = headers.get("Content-Type");
        String url = request.getLocationUri();
        String body = request.getBody();
        WebResource.Builder builder = this.client.resource(url).getRequestBuilder();
        for (String key : headers.keySet()) {
            builder = (WebResource.Builder)builder.header(key, (Object)headers.get(key));
        }
        String grantType = null;
        String code = null;
        String clientId = null;
        String clientSecret = null;
        String refreshToken = null;
        for (String entry : body.split("&")) {
            String key = entry.split("=")[0];
            String value = entry.split("=")[1];
            if ("grant_type".equals(key)) {
                grantType = value;
                continue;
            }
            if ("code".equals(key)) {
                code = value;
                continue;
            }
            if ("client_id".equals(key)) {
                clientId = value;
                continue;
            }
            if ("client_secret".equals(key)) {
                clientSecret = value;
                continue;
            }
            if (!"refresh_token".equals(key)) continue;
            refreshToken = value;
        }
        if (grantType == null) {
            throw new OAuthSystemException("Missing grant_type");
        }
        if (!grantType.equals(GrantType.REFRESH_TOKEN.toString()) && code == null) {
            throw new OAuthSystemException("Missing code for grant_type=" + grantType);
        }
        if (grantType.equals(GrantType.REFRESH_TOKEN.toString()) && refreshToken == null) {
            throw new OAuthSystemException("Missing refresh_token for grant_type=" + grantType);
        }
        body = "grant_type=" + grantType;
        if (code != null) {
            body = body + "&code=" + code;
        }
        if (refreshToken != null) {
            body = body + "&refresh_token=" + refreshToken;
        }
        if (clientId == null || clientSecret == null) {
            throw new OAuthSystemException("Missing clientId/secret");
        }
        byte[] bytes = (clientId + ":" + clientSecret).getBytes();
        builder.header("Authorization", (Object)("Basic " + Base64.encodeToString((byte[])bytes, (boolean)false)));
        ClientResponse response = null;
        if ("GET".equals(requestMethod)) {
            response = (ClientResponse)builder.get(ClientResponse.class);
        } else if ("POST".equals(requestMethod)) {
            response = (ClientResponse)((WebResource.Builder)builder.type(contentType)).post(ClientResponse.class, (Object)body);
        } else if ("PUT".equals(requestMethod)) {
            response = (ClientResponse)((WebResource.Builder)builder.type(contentType)).put(ClientResponse.class, (Object)body);
        } else if ("DELETE".equals(requestMethod)) {
            response = (ClientResponse)((WebResource.Builder)builder.type(contentType)).delete(ClientResponse.class, (Object)body);
        }
        if (response.getStatusInfo() == ClientResponse.Status.NO_CONTENT) {
            return null;
        }
        if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
            if (responseClass == null) {
                return null;
            }
            String respBody = (String)response.getEntity(String.class);
            return (T)OAuthClientResponseFactory.createCustomResponse((String)respBody, (String)contentType, (int)response.getStatus(), (Map)response.getHeaders(), responseClass);
        }
        String message = "error";
        String respBody = null;
        if (response.hasEntity()) {
            try {
                message = respBody = (String)response.getEntity(String.class);
                System.err.println(message);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void shutdown() {
    }
}

