/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.Attachment;
import com.docusign.esign.model.ChunkedUploadRequest;
import com.docusign.esign.model.ChunkedUploadResponse;
import com.docusign.esign.model.CommentHistoryResult;
import com.docusign.esign.model.CommentsPublish;
import com.docusign.esign.model.ConsoleViewRequest;
import com.docusign.esign.model.ConsumerDisclosure;
import com.docusign.esign.model.CorrectViewRequest;
import com.docusign.esign.model.CustomFields;
import com.docusign.esign.model.CustomFieldsEnvelope;
import com.docusign.esign.model.DocumentFieldsInformation;
import com.docusign.esign.model.DocumentHtmlDefinition;
import com.docusign.esign.model.DocumentHtmlDefinitionOriginals;
import com.docusign.esign.model.DocumentHtmlDefinitions;
import com.docusign.esign.model.DocumentTemplateList;
import com.docusign.esign.model.DocumentVisibilityList;
import com.docusign.esign.model.EmailSettings;
import com.docusign.esign.model.Envelope;
import com.docusign.esign.model.EnvelopeAttachmentsRequest;
import com.docusign.esign.model.EnvelopeAttachmentsResult;
import com.docusign.esign.model.EnvelopeAuditEventResponse;
import com.docusign.esign.model.EnvelopeDefinition;
import com.docusign.esign.model.EnvelopeDocument;
import com.docusign.esign.model.EnvelopeDocumentsResult;
import com.docusign.esign.model.EnvelopeFormData;
import com.docusign.esign.model.EnvelopeIdsRequest;
import com.docusign.esign.model.EnvelopeNotificationRequest;
import com.docusign.esign.model.EnvelopeSummary;
import com.docusign.esign.model.EnvelopeTransferRule;
import com.docusign.esign.model.EnvelopeTransferRuleInformation;
import com.docusign.esign.model.EnvelopeTransferRuleRequest;
import com.docusign.esign.model.EnvelopeUpdateSummary;
import com.docusign.esign.model.EnvelopesInformation;
import com.docusign.esign.model.LockInformation;
import com.docusign.esign.model.LockRequest;
import com.docusign.esign.model.Notification;
import com.docusign.esign.model.PageImages;
import com.docusign.esign.model.PageRequest;
import com.docusign.esign.model.ProofServiceResourceToken;
import com.docusign.esign.model.ProofServiceViewLink;
import com.docusign.esign.model.RecipientPreviewRequest;
import com.docusign.esign.model.RecipientViewRequest;
import com.docusign.esign.model.Recipients;
import com.docusign.esign.model.RecipientsUpdateSummary;
import com.docusign.esign.model.ReturnUrlRequest;
import com.docusign.esign.model.Tabs;
import com.docusign.esign.model.TemplateDocumentVisibilityList;
import com.docusign.esign.model.TemplateInformation;
import com.docusign.esign.model.UserSignature;
import com.docusign.esign.model.ViewUrl;
import com.docusign.esign.model.Workflow;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class EnvelopesApi {
    private ApiClient apiClient;

    public EnvelopesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EnvelopesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public DocumentTemplateList applyTemplate(String accountId, String envelopeId, DocumentTemplateList documentTemplateList) throws ApiException {
        return this.applyTemplate(accountId, envelopeId, documentTemplateList, null);
    }

    public DocumentTemplateList applyTemplate(String accountId, String envelopeId, DocumentTemplateList documentTemplateList, ApplyTemplateOptions options) throws ApiException {
        DocumentTemplateList localVarPostBody = documentTemplateList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling applyTemplate");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling applyTemplate");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/templates".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("preserve_template_recipient", options.preserveTemplateRecipient));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentTemplateList> localVarReturnType = new GenericType<DocumentTemplateList>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DocumentTemplateList applyTemplateToDocument(String accountId, String envelopeId, String documentId, DocumentTemplateList documentTemplateList) throws ApiException {
        return this.applyTemplateToDocument(accountId, envelopeId, documentId, documentTemplateList, null);
    }

    public DocumentTemplateList applyTemplateToDocument(String accountId, String envelopeId, String documentId, DocumentTemplateList documentTemplateList, ApplyTemplateToDocumentOptions options) throws ApiException {
        DocumentTemplateList localVarPostBody = documentTemplateList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling applyTemplateToDocument");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling applyTemplateToDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling applyTemplateToDocument");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("preserve_template_recipient", options.preserveTemplateRecipient));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentTemplateList> localVarReturnType = new GenericType<DocumentTemplateList>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ChunkedUploadResponse createChunkedUpload(String accountId, ChunkedUploadRequest chunkedUploadRequest) throws ApiException {
        ChunkedUploadRequest localVarPostBody = chunkedUploadRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createChunkedUpload");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/chunked_uploads".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ChunkedUploadResponse> localVarReturnType = new GenericType<ChunkedUploadResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ViewUrl createConsoleView(String accountId, ConsoleViewRequest consoleViewRequest) throws ApiException {
        ConsoleViewRequest localVarPostBody = consoleViewRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createConsoleView");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/views/console".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ViewUrl> localVarReturnType = new GenericType<ViewUrl>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ViewUrl createCorrectView(String accountId, String envelopeId, CorrectViewRequest correctViewRequest) throws ApiException {
        CorrectViewRequest localVarPostBody = correctViewRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createCorrectView");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createCorrectView");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/correct".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ViewUrl> localVarReturnType = new GenericType<ViewUrl>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CustomFields createCustomFields(String accountId, String envelopeId, CustomFields customFields) throws ApiException {
        CustomFields localVarPostBody = customFields;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createCustomFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createCustomFields");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/custom_fields".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<CustomFields> localVarReturnType = new GenericType<CustomFields>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DocumentFieldsInformation createDocumentFields(String accountId, String envelopeId, String documentId, DocumentFieldsInformation documentFieldsInformation) throws ApiException {
        DocumentFieldsInformation localVarPostBody = documentFieldsInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createDocumentFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createDocumentFields");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling createDocumentFields");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentFieldsInformation> localVarReturnType = new GenericType<DocumentFieldsInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DocumentHtmlDefinitions createDocumentResponsiveHtmlPreview(String accountId, String envelopeId, String documentId, DocumentHtmlDefinition documentHtmlDefinition) throws ApiException {
        DocumentHtmlDefinition localVarPostBody = documentHtmlDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createDocumentResponsiveHtmlPreview");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createDocumentResponsiveHtmlPreview");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling createDocumentResponsiveHtmlPreview");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/responsive_html_preview".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentHtmlDefinitions> localVarReturnType = new GenericType<DocumentHtmlDefinitions>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Tabs createDocumentTabs(String accountId, String envelopeId, String documentId, Tabs tabs) throws ApiException {
        Tabs localVarPostBody = tabs;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createDocumentTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createDocumentTabs");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling createDocumentTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ViewUrl createEditView(String accountId, String envelopeId, ReturnUrlRequest returnUrlRequest) throws ApiException {
        ReturnUrlRequest localVarPostBody = returnUrlRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createEditView");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createEditView");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/edit".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ViewUrl> localVarReturnType = new GenericType<ViewUrl>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EmailSettings createEmailSettings(String accountId, String envelopeId, EmailSettings emailSettings) throws ApiException {
        EmailSettings localVarPostBody = emailSettings;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createEmailSettings");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createEmailSettings");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/email_settings".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EmailSettings> localVarReturnType = new GenericType<EmailSettings>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvelopeSummary createEnvelope(String accountId, EnvelopeDefinition envelopeDefinition) throws ApiException {
        return this.createEnvelope(accountId, envelopeDefinition, null);
    }

    public EnvelopeSummary createEnvelope(String accountId, EnvelopeDefinition envelopeDefinition, CreateEnvelopeOptions options) throws ApiException {
        EnvelopeDefinition localVarPostBody = envelopeDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createEnvelope");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cdse_mode", options.cdseMode));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("change_routing_order", options.changeRoutingOrder));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("completed_documents_only", options.completedDocumentsOnly));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("merge_roles_on_draft", options.mergeRolesOnDraft));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("tab_label_exact_matches", options.tabLabelExactMatches));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeSummary> localVarReturnType = new GenericType<EnvelopeSummary>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CommentHistoryResult createEnvelopeComments(String accountId, String envelopeId, CommentsPublish commentsPublish) throws ApiException {
        CommentsPublish localVarPostBody = commentsPublish;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createEnvelopeComments");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createEnvelopeComments");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/comments".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<CommentHistoryResult> localVarReturnType = new GenericType<CommentHistoryResult>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ViewUrl createEnvelopeRecipientPreview(String accountId, String envelopeId, RecipientPreviewRequest recipientPreviewRequest) throws ApiException {
        RecipientPreviewRequest localVarPostBody = recipientPreviewRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createEnvelopeRecipientPreview");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createEnvelopeRecipientPreview");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/recipient_preview".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ViewUrl> localVarReturnType = new GenericType<ViewUrl>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ViewUrl createEnvelopeRecipientSharedView(String accountId, String envelopeId, RecipientViewRequest recipientViewRequest) throws ApiException {
        RecipientViewRequest localVarPostBody = recipientViewRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createEnvelopeRecipientSharedView");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createEnvelopeRecipientSharedView");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/shared".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ViewUrl> localVarReturnType = new GenericType<ViewUrl>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvelopeTransferRuleInformation createEnvelopeTransferRules(String accountId, EnvelopeTransferRuleRequest envelopeTransferRuleRequest) throws ApiException {
        EnvelopeTransferRuleRequest localVarPostBody = envelopeTransferRuleRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createEnvelopeTransferRules");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/transfer_rules".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeTransferRuleInformation> localVarReturnType = new GenericType<EnvelopeTransferRuleInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public LockInformation createLock(String accountId, String envelopeId, LockRequest lockRequest) throws ApiException {
        LockRequest localVarPostBody = lockRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createLock");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createLock");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/lock".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<LockInformation> localVarReturnType = new GenericType<LockInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Recipients createRecipient(String accountId, String envelopeId, Recipients recipients) throws ApiException {
        return this.createRecipient(accountId, envelopeId, recipients, null);
    }

    public Recipients createRecipient(String accountId, String envelopeId, Recipients recipients, CreateRecipientOptions options) throws ApiException {
        Recipients localVarPostBody = recipients;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createRecipient");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createRecipient");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resend_envelope", options.resendEnvelope));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Recipients> localVarReturnType = new GenericType<Recipients>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ViewUrl createRecipientManualReviewView(String accountId, String envelopeId, String recipientId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createRecipientManualReviewView");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createRecipientManualReviewView");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling createRecipientManualReviewView");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/views/identity_manual_review".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ViewUrl> localVarReturnType = new GenericType<ViewUrl>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ProofServiceViewLink createRecipientProofFileLink(String accountId, String envelopeId, String recipientId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createRecipientProofFileLink");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createRecipientProofFileLink");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling createRecipientProofFileLink");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/identity_proof".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ProofServiceViewLink> localVarReturnType = new GenericType<ProofServiceViewLink>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ProofServiceResourceToken createRecipientProofFileResourceToken(String tokenScopes, String accountId, String envelopeId, String recipientId) throws ApiException {
        String localVarPostBody = "{}";
        if (tokenScopes == null) {
            throw new ApiException(400, "Missing the required parameter 'tokenScopes' when calling createRecipientProofFileResourceToken");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createRecipientProofFileResourceToken");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createRecipientProofFileResourceToken");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling createRecipientProofFileResourceToken");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/identity_proof_token".replaceAll("\\{token_scopes\\}", this.apiClient.escapeString(tokenScopes.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ProofServiceResourceToken> localVarReturnType = new GenericType<ProofServiceResourceToken>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ViewUrl createRecipientView(String accountId, String envelopeId, RecipientViewRequest recipientViewRequest) throws ApiException {
        RecipientViewRequest localVarPostBody = recipientViewRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createRecipientView");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createRecipientView");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/recipient".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ViewUrl> localVarReturnType = new GenericType<ViewUrl>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DocumentHtmlDefinitions createResponsiveHtmlPreview(String accountId, String envelopeId, DocumentHtmlDefinition documentHtmlDefinition) throws ApiException {
        DocumentHtmlDefinition localVarPostBody = documentHtmlDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createResponsiveHtmlPreview");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createResponsiveHtmlPreview");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/responsive_html_preview".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentHtmlDefinitions> localVarReturnType = new GenericType<DocumentHtmlDefinitions>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ViewUrl createSenderView(String accountId, String envelopeId, ReturnUrlRequest returnUrlRequest) throws ApiException {
        ReturnUrlRequest localVarPostBody = returnUrlRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createSenderView");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createSenderView");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/sender".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ViewUrl> localVarReturnType = new GenericType<ViewUrl>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Tabs createTabs(String accountId, String envelopeId, String recipientId, Tabs tabs) throws ApiException {
        Tabs localVarPostBody = tabs;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createTabs");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling createTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvelopeAttachmentsResult deleteAttachments(String accountId, String envelopeId, EnvelopeAttachmentsRequest envelopeAttachmentsRequest) throws ApiException {
        EnvelopeAttachmentsRequest localVarPostBody = envelopeAttachmentsRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteAttachments");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteAttachments");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeAttachmentsResult> localVarReturnType = new GenericType<EnvelopeAttachmentsResult>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ChunkedUploadResponse deleteChunkedUpload(String accountId, String chunkedUploadId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteChunkedUpload");
        }
        if (chunkedUploadId == null) {
            throw new ApiException(400, "Missing the required parameter 'chunkedUploadId' when calling deleteChunkedUpload");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{chunkedUploadId\\}", this.apiClient.escapeString(chunkedUploadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ChunkedUploadResponse> localVarReturnType = new GenericType<ChunkedUploadResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CustomFields deleteCustomFields(String accountId, String envelopeId, CustomFields customFields) throws ApiException {
        CustomFields localVarPostBody = customFields;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteCustomFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteCustomFields");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/custom_fields".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<CustomFields> localVarReturnType = new GenericType<CustomFields>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DocumentFieldsInformation deleteDocumentFields(String accountId, String envelopeId, String documentId, DocumentFieldsInformation documentFieldsInformation) throws ApiException {
        DocumentFieldsInformation localVarPostBody = documentFieldsInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteDocumentFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteDocumentFields");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling deleteDocumentFields");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentFieldsInformation> localVarReturnType = new GenericType<DocumentFieldsInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteDocumentPage(String accountId, String envelopeId, String documentId, String pageNumber) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteDocumentPage");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteDocumentPage");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling deleteDocumentPage");
        }
        if (pageNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'pageNumber' when calling deleteDocumentPage");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString())).replaceAll("\\{pageNumber\\}", this.apiClient.escapeString(pageNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public Tabs deleteDocumentTabs(String accountId, String envelopeId, String documentId, Tabs tabs) throws ApiException {
        Tabs localVarPostBody = tabs;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteDocumentTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteDocumentTabs");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling deleteDocumentTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvelopeDocumentsResult deleteDocuments(String accountId, String envelopeId, EnvelopeDefinition envelopeDefinition) throws ApiException {
        EnvelopeDefinition localVarPostBody = envelopeDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteDocuments");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteDocuments");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeDocumentsResult> localVarReturnType = new GenericType<EnvelopeDocumentsResult>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EmailSettings deleteEmailSettings(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteEmailSettings");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteEmailSettings");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/email_settings".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EmailSettings> localVarReturnType = new GenericType<EmailSettings>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteEnvelopeCorrectView(String accountId, String envelopeId, CorrectViewRequest correctViewRequest) throws ApiException {
        CorrectViewRequest localVarPostBody = correctViewRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteEnvelopeCorrectView");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteEnvelopeCorrectView");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/correct".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteEnvelopeTransferRules(String accountId, String envelopeTransferRuleId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteEnvelopeTransferRules");
        }
        if (envelopeTransferRuleId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeTransferRuleId' when calling deleteEnvelopeTransferRules");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/transfer_rules/{envelopeTransferRuleId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeTransferRuleId\\}", this.apiClient.escapeString(envelopeTransferRuleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteEnvelopeWorkflowDefinition(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteEnvelopeWorkflowDefinition");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteEnvelopeWorkflowDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public LockInformation deleteLock(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteLock");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteLock");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/lock".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<LockInformation> localVarReturnType = new GenericType<LockInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Recipients deleteRecipient(String accountId, String envelopeId, String recipientId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteRecipient");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteRecipient");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling deleteRecipient");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Recipients> localVarReturnType = new GenericType<Recipients>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Recipients deleteRecipients(String accountId, String envelopeId, Recipients recipients) throws ApiException {
        Recipients localVarPostBody = recipients;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteRecipients");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteRecipients");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Recipients> localVarReturnType = new GenericType<Recipients>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Tabs deleteTabs(String accountId, String envelopeId, String recipientId, Tabs tabs) throws ApiException {
        Tabs localVarPostBody = tabs;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteTabs");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling deleteTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteTemplateWorkflowDefinition(String accountId, String templateId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteTemplateWorkflowDefinition");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling deleteTemplateWorkflowDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteTemplatesFromDocument(String accountId, String envelopeId, String documentId, String templateId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteTemplatesFromDocument");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteTemplatesFromDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling deleteTemplatesFromDocument");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling deleteTemplatesFromDocument");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates/{templateId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void getAttachment(String accountId, String envelopeId, String attachmentId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAttachment");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getAttachment");
        }
        if (attachmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'attachmentId' when calling getAttachment");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments/{attachmentId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{attachmentId\\}", this.apiClient.escapeString(attachmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public EnvelopeAttachmentsResult getAttachments(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAttachments");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getAttachments");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeAttachmentsResult> localVarReturnType = new GenericType<EnvelopeAttachmentsResult>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ChunkedUploadResponse getChunkedUpload(String accountId, String chunkedUploadId) throws ApiException {
        return this.getChunkedUpload(accountId, chunkedUploadId, null);
    }

    public ChunkedUploadResponse getChunkedUpload(String accountId, String chunkedUploadId, GetChunkedUploadOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getChunkedUpload");
        }
        if (chunkedUploadId == null) {
            throw new ApiException(400, "Missing the required parameter 'chunkedUploadId' when calling getChunkedUpload");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{chunkedUploadId\\}", this.apiClient.escapeString(chunkedUploadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include", options.include));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ChunkedUploadResponse> localVarReturnType = new GenericType<ChunkedUploadResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public byte[] getCommentsTranscript(String accountId, String envelopeId) throws ApiException {
        return this.getCommentsTranscript(accountId, envelopeId, null);
    }

    public byte[] getCommentsTranscript(String accountId, String envelopeId, GetCommentsTranscriptOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getCommentsTranscript");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getCommentsTranscript");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/comments/transcript".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("encoding", options.encoding));
        }
        String[] localVarAccepts = new String[]{"application/pdf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<byte[]> localVarReturnType = new GenericType<byte[]>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ConsumerDisclosure getConsumerDisclosure(String accountId, String envelopeId, String recipientId, String langCode) throws ApiException {
        return this.getConsumerDisclosure(accountId, envelopeId, recipientId, langCode, null);
    }

    public ConsumerDisclosure getConsumerDisclosure(String accountId, String envelopeId, String recipientId, String langCode, GetConsumerDisclosureOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getConsumerDisclosure");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getConsumerDisclosure");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling getConsumerDisclosure");
        }
        if (langCode == null) {
            throw new ApiException(400, "Missing the required parameter 'langCode' when calling getConsumerDisclosure");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/consumer_disclosure/{langCode}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString())).replaceAll("\\{langCode\\}", this.apiClient.escapeString(langCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("langCode", options.langCode2));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ConsumerDisclosure> localVarReturnType = new GenericType<ConsumerDisclosure>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ConsumerDisclosure getConsumerDisclosureDefault(String accountId, String envelopeId, String recipientId) throws ApiException {
        return this.getConsumerDisclosureDefault(accountId, envelopeId, recipientId, null);
    }

    public ConsumerDisclosure getConsumerDisclosureDefault(String accountId, String envelopeId, String recipientId, GetConsumerDisclosureDefaultOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getConsumerDisclosureDefault");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getConsumerDisclosureDefault");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling getConsumerDisclosureDefault");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/consumer_disclosure".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("langCode", options.langCode));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ConsumerDisclosure> localVarReturnType = new GenericType<ConsumerDisclosure>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public byte[] getDocument(String accountId, String envelopeId, String documentId) throws ApiException {
        return this.getDocument(accountId, envelopeId, documentId, null);
    }

    public byte[] getDocument(String accountId, String envelopeId, String documentId, GetDocumentOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getDocument");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling getDocument");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("certificate", options.certificate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("documents_by_userid", options.documentsByUserid));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("encoding", options.encoding));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("encrypt", options.encrypt));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("language", options.language));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("recipient_id", options.recipientId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shared_user_id", options.sharedUserId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("show_changes", options.showChanges));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("watermark", options.watermark));
        }
        String[] localVarAccepts = new String[]{"application/pdf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<byte[]> localVarReturnType = new GenericType<byte[]>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public byte[] getDocumentPageImage(String accountId, String envelopeId, String documentId, String pageNumber) throws ApiException {
        return this.getDocumentPageImage(accountId, envelopeId, documentId, pageNumber, null);
    }

    public byte[] getDocumentPageImage(String accountId, String envelopeId, String documentId, String pageNumber, GetDocumentPageImageOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getDocumentPageImage");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getDocumentPageImage");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling getDocumentPageImage");
        }
        if (pageNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'pageNumber' when calling getDocumentPageImage");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}/page_image".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString())).replaceAll("\\{pageNumber\\}", this.apiClient.escapeString(pageNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dpi", options.dpi));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("max_height", options.maxHeight));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("max_width", options.maxWidth));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("show_changes", options.showChanges));
        }
        String[] localVarAccepts = new String[]{"image/png"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<byte[]> localVarReturnType = new GenericType<byte[]>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Tabs getDocumentTabs(String accountId, String envelopeId, String documentId) throws ApiException {
        return this.getDocumentTabs(accountId, envelopeId, documentId, null);
    }

    public Tabs getDocumentTabs(String accountId, String envelopeId, String documentId, GetDocumentTabsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getDocumentTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getDocumentTabs");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling getDocumentTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_metadata", options.includeMetadata));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_numbers", options.pageNumbers));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EmailSettings getEmailSettings(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getEmailSettings");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getEmailSettings");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/email_settings".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EmailSettings> localVarReturnType = new GenericType<EmailSettings>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Envelope getEnvelope(String accountId, String envelopeId) throws ApiException {
        return this.getEnvelope(accountId, envelopeId, null);
    }

    public Envelope getEnvelope(String accountId, String envelopeId, GetEnvelopeOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getEnvelope");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getEnvelope");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("advanced_update", options.advancedUpdate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include", options.include));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Envelope> localVarReturnType = new GenericType<Envelope>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DocumentHtmlDefinitionOriginals getEnvelopeDocumentHtmlDefinitions(String accountId, String envelopeId, String documentId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getEnvelopeDocumentHtmlDefinitions");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getEnvelopeDocumentHtmlDefinitions");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling getEnvelopeDocumentHtmlDefinitions");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/html_definitions".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentHtmlDefinitionOriginals> localVarReturnType = new GenericType<DocumentHtmlDefinitionOriginals>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DocumentHtmlDefinitionOriginals getEnvelopeHtmlDefinitions(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getEnvelopeHtmlDefinitions");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getEnvelopeHtmlDefinitions");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/html_definitions".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentHtmlDefinitionOriginals> localVarReturnType = new GenericType<DocumentHtmlDefinitionOriginals>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvelopeTransferRuleInformation getEnvelopeTransferRules(String accountId) throws ApiException {
        return this.getEnvelopeTransferRules(accountId, null);
    }

    public EnvelopeTransferRuleInformation getEnvelopeTransferRules(String accountId, GetEnvelopeTransferRulesOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getEnvelopeTransferRules");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/transfer_rules".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_position", options.startPosition));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeTransferRuleInformation> localVarReturnType = new GenericType<EnvelopeTransferRuleInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Workflow getEnvelopeWorkflowDefinition(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getEnvelopeWorkflowDefinition");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getEnvelopeWorkflowDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Workflow> localVarReturnType = new GenericType<Workflow>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvelopeFormData getFormData(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getFormData");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getFormData");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/form_data".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeFormData> localVarReturnType = new GenericType<EnvelopeFormData>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public LockInformation getLock(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getLock");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getLock");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/lock".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<LockInformation> localVarReturnType = new GenericType<LockInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Notification getNotificationSettings(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getNotificationSettings");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getNotificationSettings");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/notification".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Notification> localVarReturnType = new GenericType<Notification>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Tabs getPageTabs(String accountId, String envelopeId, String documentId, String pageNumber) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getPageTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getPageTabs");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling getPageTabs");
        }
        if (pageNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'pageNumber' when calling getPageTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString())).replaceAll("\\{pageNumber\\}", this.apiClient.escapeString(pageNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PageImages getPages(String accountId, String envelopeId, String documentId) throws ApiException {
        return this.getPages(accountId, envelopeId, documentId, null);
    }

    public PageImages getPages(String accountId, String envelopeId, String documentId, GetPagesOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getPages");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getPages");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling getPages");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dpi", options.dpi));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("max_height", options.maxHeight));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("max_width", options.maxWidth));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nocache", options.nocache));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("show_changes", options.showChanges));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_position", options.startPosition));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<PageImages> localVarReturnType = new GenericType<PageImages>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DocumentVisibilityList getRecipientDocumentVisibility(String accountId, String envelopeId, String recipientId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getRecipientDocumentVisibility");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getRecipientDocumentVisibility");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling getRecipientDocumentVisibility");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/document_visibility".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentVisibilityList> localVarReturnType = new GenericType<DocumentVisibilityList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public byte[] getRecipientInitialsImage(String accountId, String envelopeId, String recipientId) throws ApiException {
        return this.getRecipientInitialsImage(accountId, envelopeId, recipientId, null);
    }

    public byte[] getRecipientInitialsImage(String accountId, String envelopeId, String recipientId, GetRecipientInitialsImageOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getRecipientInitialsImage");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getRecipientInitialsImage");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling getRecipientInitialsImage");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/initials_image".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_chrome", options.includeChrome));
        }
        String[] localVarAccepts = new String[]{"image/gif"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<byte[]> localVarReturnType = new GenericType<byte[]>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserSignature getRecipientSignature(String accountId, String envelopeId, String recipientId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getRecipientSignature");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getRecipientSignature");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling getRecipientSignature");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserSignature> localVarReturnType = new GenericType<UserSignature>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public byte[] getRecipientSignatureImage(String accountId, String envelopeId, String recipientId) throws ApiException {
        return this.getRecipientSignatureImage(accountId, envelopeId, recipientId, null);
    }

    public byte[] getRecipientSignatureImage(String accountId, String envelopeId, String recipientId, GetRecipientSignatureImageOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getRecipientSignatureImage");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getRecipientSignatureImage");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling getRecipientSignatureImage");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature_image".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_chrome", options.includeChrome));
        }
        String[] localVarAccepts = new String[]{"image/gif"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<byte[]> localVarReturnType = new GenericType<byte[]>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void getTabsBlob(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getTabsBlob");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getTabsBlob");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/tabs_blob".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public DocumentVisibilityList getTemplateRecipientDocumentVisibility(String accountId, String templateId, String recipientId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getTemplateRecipientDocumentVisibility");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling getTemplateRecipientDocumentVisibility");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling getTemplateRecipientDocumentVisibility");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/document_visibility".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentVisibilityList> localVarReturnType = new GenericType<DocumentVisibilityList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Workflow getTemplateWorkflowDefinition(String accountId, String templateId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getTemplateWorkflowDefinition");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling getTemplateWorkflowDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Workflow> localVarReturnType = new GenericType<Workflow>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvelopeAuditEventResponse listAuditEvents(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listAuditEvents");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listAuditEvents");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/audit_events".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeAuditEventResponse> localVarReturnType = new GenericType<EnvelopeAuditEventResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CustomFieldsEnvelope listCustomFields(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listCustomFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listCustomFields");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/custom_fields".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<CustomFieldsEnvelope> localVarReturnType = new GenericType<CustomFieldsEnvelope>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DocumentFieldsInformation listDocumentFields(String accountId, String envelopeId, String documentId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listDocumentFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listDocumentFields");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling listDocumentFields");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentFieldsInformation> localVarReturnType = new GenericType<DocumentFieldsInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvelopeDocumentsResult listDocuments(String accountId, String envelopeId) throws ApiException {
        return this.listDocuments(accountId, envelopeId, null);
    }

    public EnvelopeDocumentsResult listDocuments(String accountId, String envelopeId, ListDocumentsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listDocuments");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listDocuments");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("documents_by_userid", options.documentsByUserid));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_document_size", options.includeDocumentSize));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_metadata", options.includeMetadata));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_tabs", options.includeTabs));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("recipient_id", options.recipientId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shared_user_id", options.sharedUserId));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeDocumentsResult> localVarReturnType = new GenericType<EnvelopeDocumentsResult>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Recipients listRecipients(String accountId, String envelopeId) throws ApiException {
        return this.listRecipients(accountId, envelopeId, null);
    }

    public Recipients listRecipients(String accountId, String envelopeId, ListRecipientsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listRecipients");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listRecipients");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_anchor_tab_locations", options.includeAnchorTabLocations));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_extended", options.includeExtended));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_metadata", options.includeMetadata));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_tabs", options.includeTabs));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Recipients> localVarReturnType = new GenericType<Recipients>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvelopesInformation listStatus(String accountId, EnvelopeIdsRequest envelopeIdsRequest) throws ApiException {
        return this.listStatus(accountId, envelopeIdsRequest, null);
    }

    public EnvelopesInformation listStatus(String accountId, EnvelopeIdsRequest envelopeIdsRequest, ListStatusOptions options) throws ApiException {
        EnvelopeIdsRequest localVarPostBody = envelopeIdsRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listStatus");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/status".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ac_status", options.acStatus));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("block", options.block));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("email", options.email));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("envelope_ids", options.envelopeIds));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from_date", options.fromDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from_to_status", options.fromToStatus));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_position", options.startPosition));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", options.status));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to_date", options.toDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("transaction_ids", options.transactionIds));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("user_name", options.userName));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopesInformation> localVarReturnType = new GenericType<EnvelopesInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvelopesInformation listStatusChanges(String accountId) throws ApiException {
        return this.listStatusChanges(accountId, null);
    }

    public EnvelopesInformation listStatusChanges(String accountId, ListStatusChangesOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listStatusChanges");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ac_status", options.acStatus));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("block", options.block));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cdse_mode", options.cdseMode));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("continuation_token", options.continuationToken));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("custom_field", options.customField));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("email", options.email));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("envelope_ids", options.envelopeIds));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("exclude", options.exclude));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("folder_ids", options.folderIds));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("folder_types", options.folderTypes));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from_date", options.fromDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from_to_status", options.fromToStatus));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include", options.include));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_purge_information", options.includePurgeInformation));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("intersecting_folder_ids", options.intersectingFolderIds));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("last_queried_date", options.lastQueriedDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("order", options.order));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("order_by", options.orderBy));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("powerformids", options.powerformids));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("query_budget", options.queryBudget));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("requester_date_format", options.requesterDateFormat));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("search_text", options.searchText));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_position", options.startPosition));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", options.status));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to_date", options.toDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("transaction_ids", options.transactionIds));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("user_filter", options.userFilter));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("user_id", options.userId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("user_name", options.userName));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopesInformation> localVarReturnType = new GenericType<EnvelopesInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Tabs listTabs(String accountId, String envelopeId, String recipientId) throws ApiException {
        return this.listTabs(accountId, envelopeId, recipientId, null);
    }

    public Tabs listTabs(String accountId, String envelopeId, String recipientId, ListTabsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listTabs");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling listTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_anchor_tab_locations", options.includeAnchorTabLocations));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_metadata", options.includeMetadata));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TemplateInformation listTemplates(String accountId, String envelopeId) throws ApiException {
        return this.listTemplates(accountId, envelopeId, null);
    }

    public TemplateInformation listTemplates(String accountId, String envelopeId, ListTemplatesOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listTemplates");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listTemplates");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/templates".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include", options.include));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<TemplateInformation> localVarReturnType = new GenericType<TemplateInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TemplateInformation listTemplatesForDocument(String accountId, String envelopeId, String documentId) throws ApiException {
        return this.listTemplatesForDocument(accountId, envelopeId, documentId, null);
    }

    public TemplateInformation listTemplatesForDocument(String accountId, String envelopeId, String documentId, ListTemplatesForDocumentOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listTemplatesForDocument");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listTemplatesForDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling listTemplatesForDocument");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include", options.include));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<TemplateInformation> localVarReturnType = new GenericType<TemplateInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvelopeAttachmentsResult putAttachment(String accountId, String envelopeId, String attachmentId, Attachment attachment) throws ApiException {
        Attachment localVarPostBody = attachment;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling putAttachment");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling putAttachment");
        }
        if (attachmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'attachmentId' when calling putAttachment");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments/{attachmentId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{attachmentId\\}", this.apiClient.escapeString(attachmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeAttachmentsResult> localVarReturnType = new GenericType<EnvelopeAttachmentsResult>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvelopeAttachmentsResult putAttachments(String accountId, String envelopeId, EnvelopeAttachmentsRequest envelopeAttachmentsRequest) throws ApiException {
        EnvelopeAttachmentsRequest localVarPostBody = envelopeAttachmentsRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling putAttachments");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling putAttachments");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeAttachmentsResult> localVarReturnType = new GenericType<EnvelopeAttachmentsResult>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void rotateDocumentPage(String accountId, String envelopeId, String documentId, String pageNumber, PageRequest pageRequest) throws ApiException {
        PageRequest localVarPostBody = pageRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling rotateDocumentPage");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling rotateDocumentPage");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling rotateDocumentPage");
        }
        if (pageNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'pageNumber' when calling rotateDocumentPage");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}/page_image".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString())).replaceAll("\\{pageNumber\\}", this.apiClient.escapeString(pageNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public EnvelopeUpdateSummary update(String accountId, String envelopeId, Envelope envelope) throws ApiException {
        return this.update(accountId, envelopeId, envelope, null);
    }

    public EnvelopeUpdateSummary update(String accountId, String envelopeId, Envelope envelope, UpdateOptions options) throws ApiException {
        Envelope localVarPostBody = envelope;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling update");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling update");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("advanced_update", options.advancedUpdate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resend_envelope", options.resendEnvelope));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeUpdateSummary> localVarReturnType = new GenericType<EnvelopeUpdateSummary>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ChunkedUploadResponse updateChunkedUpload(String accountId, String chunkedUploadId) throws ApiException {
        return this.updateChunkedUpload(accountId, chunkedUploadId, null);
    }

    public ChunkedUploadResponse updateChunkedUpload(String accountId, String chunkedUploadId, UpdateChunkedUploadOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateChunkedUpload");
        }
        if (chunkedUploadId == null) {
            throw new ApiException(400, "Missing the required parameter 'chunkedUploadId' when calling updateChunkedUpload");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{chunkedUploadId\\}", this.apiClient.escapeString(chunkedUploadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("action", options.action));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ChunkedUploadResponse> localVarReturnType = new GenericType<ChunkedUploadResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ChunkedUploadResponse updateChunkedUploadPart(String accountId, String chunkedUploadId, String chunkedUploadPartSeq, ChunkedUploadRequest chunkedUploadRequest) throws ApiException {
        ChunkedUploadRequest localVarPostBody = chunkedUploadRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateChunkedUploadPart");
        }
        if (chunkedUploadId == null) {
            throw new ApiException(400, "Missing the required parameter 'chunkedUploadId' when calling updateChunkedUploadPart");
        }
        if (chunkedUploadPartSeq == null) {
            throw new ApiException(400, "Missing the required parameter 'chunkedUploadPartSeq' when calling updateChunkedUploadPart");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}/{chunkedUploadPartSeq}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{chunkedUploadId\\}", this.apiClient.escapeString(chunkedUploadId.toString())).replaceAll("\\{chunkedUploadPartSeq\\}", this.apiClient.escapeString(chunkedUploadPartSeq.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ChunkedUploadResponse> localVarReturnType = new GenericType<ChunkedUploadResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CustomFields updateCustomFields(String accountId, String envelopeId, CustomFields customFields) throws ApiException {
        CustomFields localVarPostBody = customFields;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateCustomFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateCustomFields");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/custom_fields".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<CustomFields> localVarReturnType = new GenericType<CustomFields>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvelopeDocument updateDocument(String accountId, String envelopeId, String documentId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateDocument");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling updateDocument");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeDocument> localVarReturnType = new GenericType<EnvelopeDocument>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DocumentFieldsInformation updateDocumentFields(String accountId, String envelopeId, String documentId, DocumentFieldsInformation documentFieldsInformation) throws ApiException {
        DocumentFieldsInformation localVarPostBody = documentFieldsInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateDocumentFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateDocumentFields");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling updateDocumentFields");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentFieldsInformation> localVarReturnType = new GenericType<DocumentFieldsInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Tabs updateDocumentTabs(String accountId, String envelopeId, String documentId, Tabs tabs) throws ApiException {
        Tabs localVarPostBody = tabs;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateDocumentTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateDocumentTabs");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling updateDocumentTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvelopeDocumentsResult updateDocuments(String accountId, String envelopeId, EnvelopeDefinition envelopeDefinition) throws ApiException {
        EnvelopeDefinition localVarPostBody = envelopeDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateDocuments");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateDocuments");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeDocumentsResult> localVarReturnType = new GenericType<EnvelopeDocumentsResult>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EmailSettings updateEmailSettings(String accountId, String envelopeId, EmailSettings emailSettings) throws ApiException {
        EmailSettings localVarPostBody = emailSettings;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateEmailSettings");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateEmailSettings");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/email_settings".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EmailSettings> localVarReturnType = new GenericType<EmailSettings>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvelopeTransferRule updateEnvelopeTransferRule(String accountId, String envelopeTransferRuleId, EnvelopeTransferRule envelopeTransferRule) throws ApiException {
        EnvelopeTransferRule localVarPostBody = envelopeTransferRule;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateEnvelopeTransferRule");
        }
        if (envelopeTransferRuleId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeTransferRuleId' when calling updateEnvelopeTransferRule");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/transfer_rules/{envelopeTransferRuleId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeTransferRuleId\\}", this.apiClient.escapeString(envelopeTransferRuleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeTransferRule> localVarReturnType = new GenericType<EnvelopeTransferRule>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvelopeTransferRuleInformation updateEnvelopeTransferRules(String accountId, EnvelopeTransferRuleInformation envelopeTransferRuleInformation) throws ApiException {
        EnvelopeTransferRuleInformation localVarPostBody = envelopeTransferRuleInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateEnvelopeTransferRules");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/transfer_rules".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeTransferRuleInformation> localVarReturnType = new GenericType<EnvelopeTransferRuleInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Workflow updateEnvelopeWorkflowDefinition(String accountId, String envelopeId, Workflow workflow) throws ApiException {
        Workflow localVarPostBody = workflow;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateEnvelopeWorkflowDefinition");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateEnvelopeWorkflowDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Workflow> localVarReturnType = new GenericType<Workflow>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public LockInformation updateLock(String accountId, String envelopeId, LockRequest lockRequest) throws ApiException {
        LockRequest localVarPostBody = lockRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateLock");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateLock");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/lock".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<LockInformation> localVarReturnType = new GenericType<LockInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Notification updateNotificationSettings(String accountId, String envelopeId, EnvelopeNotificationRequest envelopeNotificationRequest) throws ApiException {
        EnvelopeNotificationRequest localVarPostBody = envelopeNotificationRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateNotificationSettings");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateNotificationSettings");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/notification".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Notification> localVarReturnType = new GenericType<Notification>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DocumentVisibilityList updateRecipientDocumentVisibility(String accountId, String envelopeId, String recipientId, DocumentVisibilityList documentVisibilityList) throws ApiException {
        DocumentVisibilityList localVarPostBody = documentVisibilityList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateRecipientDocumentVisibility");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateRecipientDocumentVisibility");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling updateRecipientDocumentVisibility");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/document_visibility".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentVisibilityList> localVarReturnType = new GenericType<DocumentVisibilityList>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void updateRecipientInitialsImage(String accountId, String envelopeId, String recipientId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateRecipientInitialsImage");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateRecipientInitialsImage");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling updateRecipientInitialsImage");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/initials_image".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"image/gif"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateRecipientSignatureImage(String accountId, String envelopeId, String recipientId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateRecipientSignatureImage");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateRecipientSignatureImage");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling updateRecipientSignatureImage");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature_image".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"image/gif"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public RecipientsUpdateSummary updateRecipients(String accountId, String envelopeId, Recipients recipients) throws ApiException {
        return this.updateRecipients(accountId, envelopeId, recipients, null);
    }

    public RecipientsUpdateSummary updateRecipients(String accountId, String envelopeId, Recipients recipients, UpdateRecipientsOptions options) throws ApiException {
        Recipients localVarPostBody = recipients;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateRecipients");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateRecipients");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("combine_same_order_recipients", options.combineSameOrderRecipients));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offline_signing", options.offlineSigning));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resend_envelope", options.resendEnvelope));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<RecipientsUpdateSummary> localVarReturnType = new GenericType<RecipientsUpdateSummary>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DocumentVisibilityList updateRecipientsDocumentVisibility(String accountId, String envelopeId, DocumentVisibilityList documentVisibilityList) throws ApiException {
        DocumentVisibilityList localVarPostBody = documentVisibilityList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateRecipientsDocumentVisibility");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateRecipientsDocumentVisibility");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/document_visibility".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentVisibilityList> localVarReturnType = new GenericType<DocumentVisibilityList>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Tabs updateTabs(String accountId, String envelopeId, String recipientId, Tabs tabs) throws ApiException {
        Tabs localVarPostBody = tabs;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateTabs");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling updateTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void updateTabsBlob(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateTabsBlob");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateTabsBlob");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/tabs_blob".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public TemplateDocumentVisibilityList updateTemplateRecipientDocumentVisibility(String accountId, String templateId, String recipientId, TemplateDocumentVisibilityList templateDocumentVisibilityList) throws ApiException {
        TemplateDocumentVisibilityList localVarPostBody = templateDocumentVisibilityList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateTemplateRecipientDocumentVisibility");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateTemplateRecipientDocumentVisibility");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling updateTemplateRecipientDocumentVisibility");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/document_visibility".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<TemplateDocumentVisibilityList> localVarReturnType = new GenericType<TemplateDocumentVisibilityList>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TemplateDocumentVisibilityList updateTemplateRecipientsDocumentVisibility(String accountId, String templateId, TemplateDocumentVisibilityList templateDocumentVisibilityList) throws ApiException {
        TemplateDocumentVisibilityList localVarPostBody = templateDocumentVisibilityList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateTemplateRecipientsDocumentVisibility");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateTemplateRecipientsDocumentVisibility");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients/document_visibility".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<TemplateDocumentVisibilityList> localVarReturnType = new GenericType<TemplateDocumentVisibilityList>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Workflow updateTemplateWorkflowDefinition(String accountId, String templateId, Workflow workflow) throws ApiException {
        Workflow localVarPostBody = workflow;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateTemplateWorkflowDefinition");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateTemplateWorkflowDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Workflow> localVarReturnType = new GenericType<Workflow>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public class UpdateRecipientsOptions {
        private String combineSameOrderRecipients = null;
        private String offlineSigning = null;
        private String resendEnvelope = null;

        public void setCombineSameOrderRecipients(String combineSameOrderRecipients) {
            this.combineSameOrderRecipients = combineSameOrderRecipients;
        }

        public String getCombineSameOrderRecipients() {
            return this.combineSameOrderRecipients;
        }

        public void setOfflineSigning(String offlineSigning) {
            this.offlineSigning = offlineSigning;
        }

        public String getOfflineSigning() {
            return this.offlineSigning;
        }

        public void setResendEnvelope(String resendEnvelope) {
            this.resendEnvelope = resendEnvelope;
        }

        public String getResendEnvelope() {
            return this.resendEnvelope;
        }
    }

    public class UpdateChunkedUploadOptions {
        private String action = null;

        public void setAction(String action) {
            this.action = action;
        }

        public String getAction() {
            return this.action;
        }
    }

    public class UpdateOptions {
        private String advancedUpdate = null;
        private String resendEnvelope = null;

        public void setAdvancedUpdate(String advancedUpdate) {
            this.advancedUpdate = advancedUpdate;
        }

        public String getAdvancedUpdate() {
            return this.advancedUpdate;
        }

        public void setResendEnvelope(String resendEnvelope) {
            this.resendEnvelope = resendEnvelope;
        }

        public String getResendEnvelope() {
            return this.resendEnvelope;
        }
    }

    public class ListTemplatesForDocumentOptions {
        private String include = null;

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }
    }

    public class ListTemplatesOptions {
        private String include = null;

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }
    }

    public class ListTabsOptions {
        private String includeAnchorTabLocations = null;
        private String includeMetadata = null;

        public void setIncludeAnchorTabLocations(String includeAnchorTabLocations) {
            this.includeAnchorTabLocations = includeAnchorTabLocations;
        }

        public String getIncludeAnchorTabLocations() {
            return this.includeAnchorTabLocations;
        }

        public void setIncludeMetadata(String includeMetadata) {
            this.includeMetadata = includeMetadata;
        }

        public String getIncludeMetadata() {
            return this.includeMetadata;
        }
    }

    public class ListStatusChangesOptions {
        private String acStatus = null;
        private String block = null;
        private String cdseMode = null;
        private String continuationToken = null;
        private String count = null;
        private String customField = null;
        private String email = null;
        private String envelopeIds = null;
        private String exclude = null;
        private String folderIds = null;
        private String folderTypes = null;
        private String fromDate = null;
        private String fromToStatus = null;
        private String include = null;
        private String includePurgeInformation = null;
        private String intersectingFolderIds = null;
        private String lastQueriedDate = null;
        private String order = null;
        private String orderBy = null;
        private String powerformids = null;
        private String queryBudget = null;
        private String requesterDateFormat = null;
        private String searchText = null;
        private String startPosition = null;
        private String status = null;
        private String toDate = null;
        private String transactionIds = null;
        private String userFilter = null;
        private String userId = null;
        private String userName = null;

        public void setAcStatus(String acStatus) {
            this.acStatus = acStatus;
        }

        public String getAcStatus() {
            return this.acStatus;
        }

        public void setBlock(String block) {
            this.block = block;
        }

        public String getBlock() {
            return this.block;
        }

        public void setCdseMode(String cdseMode) {
            this.cdseMode = cdseMode;
        }

        public String getCdseMode() {
            return this.cdseMode;
        }

        public void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        public String getContinuationToken() {
            return this.continuationToken;
        }

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setCustomField(String customField) {
            this.customField = customField;
        }

        public String getCustomField() {
            return this.customField;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEnvelopeIds(String envelopeIds) {
            this.envelopeIds = envelopeIds;
        }

        public String getEnvelopeIds() {
            return this.envelopeIds;
        }

        public void setExclude(String exclude) {
            this.exclude = exclude;
        }

        public String getExclude() {
            return this.exclude;
        }

        public void setFolderIds(String folderIds) {
            this.folderIds = folderIds;
        }

        public String getFolderIds() {
            return this.folderIds;
        }

        public void setFolderTypes(String folderTypes) {
            this.folderTypes = folderTypes;
        }

        public String getFolderTypes() {
            return this.folderTypes;
        }

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setFromToStatus(String fromToStatus) {
            this.fromToStatus = fromToStatus;
        }

        public String getFromToStatus() {
            return this.fromToStatus;
        }

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }

        public void setIncludePurgeInformation(String includePurgeInformation) {
            this.includePurgeInformation = includePurgeInformation;
        }

        public String getIncludePurgeInformation() {
            return this.includePurgeInformation;
        }

        public void setIntersectingFolderIds(String intersectingFolderIds) {
            this.intersectingFolderIds = intersectingFolderIds;
        }

        public String getIntersectingFolderIds() {
            return this.intersectingFolderIds;
        }

        public void setLastQueriedDate(String lastQueriedDate) {
            this.lastQueriedDate = lastQueriedDate;
        }

        public String getLastQueriedDate() {
            return this.lastQueriedDate;
        }

        public void setOrder(String order) {
            this.order = order;
        }

        public String getOrder() {
            return this.order;
        }

        public void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        public String getOrderBy() {
            return this.orderBy;
        }

        public void setPowerformids(String powerformids) {
            this.powerformids = powerformids;
        }

        public String getPowerformids() {
            return this.powerformids;
        }

        public void setQueryBudget(String queryBudget) {
            this.queryBudget = queryBudget;
        }

        public String getQueryBudget() {
            return this.queryBudget;
        }

        public void setRequesterDateFormat(String requesterDateFormat) {
            this.requesterDateFormat = requesterDateFormat;
        }

        public String getRequesterDateFormat() {
            return this.requesterDateFormat;
        }

        public void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        public String getSearchText() {
            return this.searchText;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }

        public void setTransactionIds(String transactionIds) {
            this.transactionIds = transactionIds;
        }

        public String getTransactionIds() {
            return this.transactionIds;
        }

        public void setUserFilter(String userFilter) {
            this.userFilter = userFilter;
        }

        public String getUserFilter() {
            return this.userFilter;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getUserName() {
            return this.userName;
        }
    }

    public class ListStatusOptions {
        private String acStatus = null;
        private String block = null;
        private String count = null;
        private String email = null;
        private String envelopeIds = null;
        private String fromDate = null;
        private String fromToStatus = null;
        private String startPosition = null;
        private String status = null;
        private String toDate = null;
        private String transactionIds = null;
        private String userName = null;

        public void setAcStatus(String acStatus) {
            this.acStatus = acStatus;
        }

        public String getAcStatus() {
            return this.acStatus;
        }

        public void setBlock(String block) {
            this.block = block;
        }

        public String getBlock() {
            return this.block;
        }

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEnvelopeIds(String envelopeIds) {
            this.envelopeIds = envelopeIds;
        }

        public String getEnvelopeIds() {
            return this.envelopeIds;
        }

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setFromToStatus(String fromToStatus) {
            this.fromToStatus = fromToStatus;
        }

        public String getFromToStatus() {
            return this.fromToStatus;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }

        public void setTransactionIds(String transactionIds) {
            this.transactionIds = transactionIds;
        }

        public String getTransactionIds() {
            return this.transactionIds;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getUserName() {
            return this.userName;
        }
    }

    public class ListRecipientsOptions {
        private String includeAnchorTabLocations = null;
        private String includeExtended = null;
        private String includeMetadata = null;
        private String includeTabs = null;

        public void setIncludeAnchorTabLocations(String includeAnchorTabLocations) {
            this.includeAnchorTabLocations = includeAnchorTabLocations;
        }

        public String getIncludeAnchorTabLocations() {
            return this.includeAnchorTabLocations;
        }

        public void setIncludeExtended(String includeExtended) {
            this.includeExtended = includeExtended;
        }

        public String getIncludeExtended() {
            return this.includeExtended;
        }

        public void setIncludeMetadata(String includeMetadata) {
            this.includeMetadata = includeMetadata;
        }

        public String getIncludeMetadata() {
            return this.includeMetadata;
        }

        public void setIncludeTabs(String includeTabs) {
            this.includeTabs = includeTabs;
        }

        public String getIncludeTabs() {
            return this.includeTabs;
        }
    }

    public class ListDocumentsOptions {
        private String documentsByUserid = null;
        private String includeDocumentSize = null;
        private String includeMetadata = null;
        private String includeTabs = null;
        private String recipientId = null;
        private String sharedUserId = null;

        public void setDocumentsByUserid(String documentsByUserid) {
            this.documentsByUserid = documentsByUserid;
        }

        public String getDocumentsByUserid() {
            return this.documentsByUserid;
        }

        public void setIncludeDocumentSize(String includeDocumentSize) {
            this.includeDocumentSize = includeDocumentSize;
        }

        public String getIncludeDocumentSize() {
            return this.includeDocumentSize;
        }

        public void setIncludeMetadata(String includeMetadata) {
            this.includeMetadata = includeMetadata;
        }

        public String getIncludeMetadata() {
            return this.includeMetadata;
        }

        public void setIncludeTabs(String includeTabs) {
            this.includeTabs = includeTabs;
        }

        public String getIncludeTabs() {
            return this.includeTabs;
        }

        public void setRecipientId(String recipientId) {
            this.recipientId = recipientId;
        }

        public String getRecipientId() {
            return this.recipientId;
        }

        public void setSharedUserId(String sharedUserId) {
            this.sharedUserId = sharedUserId;
        }

        public String getSharedUserId() {
            return this.sharedUserId;
        }
    }

    public class GetRecipientSignatureImageOptions {
        private String includeChrome = null;

        public void setIncludeChrome(String includeChrome) {
            this.includeChrome = includeChrome;
        }

        public String getIncludeChrome() {
            return this.includeChrome;
        }
    }

    public class GetRecipientInitialsImageOptions {
        private String includeChrome = null;

        public void setIncludeChrome(String includeChrome) {
            this.includeChrome = includeChrome;
        }

        public String getIncludeChrome() {
            return this.includeChrome;
        }
    }

    public class GetPagesOptions {
        private String count = null;
        private String dpi = null;
        private String maxHeight = null;
        private String maxWidth = null;
        private String nocache = null;
        private String showChanges = null;
        private String startPosition = null;

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setDpi(String dpi) {
            this.dpi = dpi;
        }

        public String getDpi() {
            return this.dpi;
        }

        public void setMaxHeight(String maxHeight) {
            this.maxHeight = maxHeight;
        }

        public String getMaxHeight() {
            return this.maxHeight;
        }

        public void setMaxWidth(String maxWidth) {
            this.maxWidth = maxWidth;
        }

        public String getMaxWidth() {
            return this.maxWidth;
        }

        public void setNocache(String nocache) {
            this.nocache = nocache;
        }

        public String getNocache() {
            return this.nocache;
        }

        public void setShowChanges(String showChanges) {
            this.showChanges = showChanges;
        }

        public String getShowChanges() {
            return this.showChanges;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }
    }

    public class GetEnvelopeTransferRulesOptions {
        private String count = null;
        private String startPosition = null;

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }
    }

    public class GetEnvelopeOptions {
        private String advancedUpdate = null;
        private String include = null;

        public void setAdvancedUpdate(String advancedUpdate) {
            this.advancedUpdate = advancedUpdate;
        }

        public String getAdvancedUpdate() {
            return this.advancedUpdate;
        }

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }
    }

    public class GetDocumentTabsOptions {
        private String includeMetadata = null;
        private String pageNumbers = null;

        public void setIncludeMetadata(String includeMetadata) {
            this.includeMetadata = includeMetadata;
        }

        public String getIncludeMetadata() {
            return this.includeMetadata;
        }

        public void setPageNumbers(String pageNumbers) {
            this.pageNumbers = pageNumbers;
        }

        public String getPageNumbers() {
            return this.pageNumbers;
        }
    }

    public class GetDocumentPageImageOptions {
        private String dpi = null;
        private String maxHeight = null;
        private String maxWidth = null;
        private String showChanges = null;

        public void setDpi(String dpi) {
            this.dpi = dpi;
        }

        public String getDpi() {
            return this.dpi;
        }

        public void setMaxHeight(String maxHeight) {
            this.maxHeight = maxHeight;
        }

        public String getMaxHeight() {
            return this.maxHeight;
        }

        public void setMaxWidth(String maxWidth) {
            this.maxWidth = maxWidth;
        }

        public String getMaxWidth() {
            return this.maxWidth;
        }

        public void setShowChanges(String showChanges) {
            this.showChanges = showChanges;
        }

        public String getShowChanges() {
            return this.showChanges;
        }
    }

    public class GetDocumentOptions {
        private String certificate = null;
        private String documentsByUserid = null;
        private String encoding = null;
        private String encrypt = null;
        private String language = null;
        private String recipientId = null;
        private String sharedUserId = null;
        private String showChanges = null;
        private String watermark = null;

        public void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        public String getCertificate() {
            return this.certificate;
        }

        public void setDocumentsByUserid(String documentsByUserid) {
            this.documentsByUserid = documentsByUserid;
        }

        public String getDocumentsByUserid() {
            return this.documentsByUserid;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setEncrypt(String encrypt) {
            this.encrypt = encrypt;
        }

        public String getEncrypt() {
            return this.encrypt;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setRecipientId(String recipientId) {
            this.recipientId = recipientId;
        }

        public String getRecipientId() {
            return this.recipientId;
        }

        public void setSharedUserId(String sharedUserId) {
            this.sharedUserId = sharedUserId;
        }

        public String getSharedUserId() {
            return this.sharedUserId;
        }

        public void setShowChanges(String showChanges) {
            this.showChanges = showChanges;
        }

        public String getShowChanges() {
            return this.showChanges;
        }

        public void setWatermark(String watermark) {
            this.watermark = watermark;
        }

        public String getWatermark() {
            return this.watermark;
        }
    }

    public class GetConsumerDisclosureDefaultOptions {
        private String langCode = null;

        public void setLangCode(String langCode) {
            this.langCode = langCode;
        }

        public String getLangCode() {
            return this.langCode;
        }
    }

    public class GetConsumerDisclosureOptions {
        private String langCode2 = null;

        public void setLangCode2(String langCode2) {
            this.langCode2 = langCode2;
        }

        public String getLangCode2() {
            return this.langCode2;
        }
    }

    public class GetCommentsTranscriptOptions {
        private String encoding = null;

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public String getEncoding() {
            return this.encoding;
        }
    }

    public class GetChunkedUploadOptions {
        private String include = null;

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }
    }

    public class CreateRecipientOptions {
        private String resendEnvelope = null;

        public void setResendEnvelope(String resendEnvelope) {
            this.resendEnvelope = resendEnvelope;
        }

        public String getResendEnvelope() {
            return this.resendEnvelope;
        }
    }

    public class CreateEnvelopeOptions {
        private String cdseMode = null;
        private String changeRoutingOrder = null;
        private String completedDocumentsOnly = null;
        private String mergeRolesOnDraft = null;
        private String tabLabelExactMatches = null;

        public void setCdseMode(String cdseMode) {
            this.cdseMode = cdseMode;
        }

        public String getCdseMode() {
            return this.cdseMode;
        }

        public void setChangeRoutingOrder(String changeRoutingOrder) {
            this.changeRoutingOrder = changeRoutingOrder;
        }

        public String getChangeRoutingOrder() {
            return this.changeRoutingOrder;
        }

        public void setCompletedDocumentsOnly(String completedDocumentsOnly) {
            this.completedDocumentsOnly = completedDocumentsOnly;
        }

        public String getCompletedDocumentsOnly() {
            return this.completedDocumentsOnly;
        }

        public void setMergeRolesOnDraft(String mergeRolesOnDraft) {
            this.mergeRolesOnDraft = mergeRolesOnDraft;
        }

        public String getMergeRolesOnDraft() {
            return this.mergeRolesOnDraft;
        }

        public void setTabLabelExactMatches(String tabLabelExactMatches) {
            this.tabLabelExactMatches = tabLabelExactMatches;
        }

        public String getTabLabelExactMatches() {
            return this.tabLabelExactMatches;
        }
    }

    public class ApplyTemplateToDocumentOptions {
        private String preserveTemplateRecipient = null;

        public void setPreserveTemplateRecipient(String preserveTemplateRecipient) {
            this.preserveTemplateRecipient = preserveTemplateRecipient;
        }

        public String getPreserveTemplateRecipient() {
            return this.preserveTemplateRecipient;
        }
    }

    public class ApplyTemplateOptions {
        private String preserveTemplateRecipient = null;

        public void setPreserveTemplateRecipient(String preserveTemplateRecipient) {
            this.preserveTemplateRecipient = preserveTemplateRecipient;
        }

        public String getPreserveTemplateRecipient() {
            return this.preserveTemplateRecipient;
        }
    }
}

