/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.ApiRequestLogsResult;
import com.docusign.esign.model.DiagnosticsSettingsInformation;
import com.docusign.esign.model.ResourceInformation;
import com.docusign.esign.model.ServiceInformation;
import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class DiagnosticsApi {
    private ApiClient apiClient;

    public DiagnosticsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DiagnosticsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void deleteRequestLogs() throws ApiException {
        String localVarPostBody = "{}";
        String localVarPath = "/v2.1/diagnostics/request_logs".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public byte[] getRequestLog(String requestLogId) throws ApiException {
        String localVarPostBody = "{}";
        if (requestLogId == null) {
            throw new ApiException(400, "Missing the required parameter 'requestLogId' when calling getRequestLog");
        }
        String localVarPath = "/v2.1/diagnostics/request_logs/{requestLogId}".replaceAll("\\{format\\}", "json").replaceAll("\\{requestLogId\\}", this.apiClient.escapeString(requestLogId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<byte[]> localVarReturnType = new GenericType<byte[]>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DiagnosticsSettingsInformation getRequestLogSettings() throws ApiException {
        String localVarPostBody = "{}";
        String localVarPath = "/v2.1/diagnostics/settings".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DiagnosticsSettingsInformation> localVarReturnType = new GenericType<DiagnosticsSettingsInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ResourceInformation getResources() throws ApiException {
        String localVarPostBody = "{}";
        String localVarPath = "/v2.1".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ResourceInformation> localVarReturnType = new GenericType<ResourceInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ServiceInformation getService() throws ApiException {
        String localVarPostBody = "{}";
        String localVarPath = "/service_information".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ServiceInformation> localVarReturnType = new GenericType<ServiceInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ApiRequestLogsResult listRequestLogs() throws ApiException {
        return this.listRequestLogs(null);
    }

    public ApiRequestLogsResult listRequestLogs(ListRequestLogsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        String localVarPath = "/v2.1/diagnostics/request_logs".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "encoding", options.encoding));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ApiRequestLogsResult> localVarReturnType = new GenericType<ApiRequestLogsResult>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DiagnosticsSettingsInformation updateRequestLogSettings(DiagnosticsSettingsInformation diagnosticsSettingsInformation) throws ApiException {
        DiagnosticsSettingsInformation localVarPostBody = diagnosticsSettingsInformation;
        String localVarPath = "/v2.1/diagnostics/settings".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DiagnosticsSettingsInformation> localVarReturnType = new GenericType<DiagnosticsSettingsInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public class ListRequestLogsOptions {
        private String encoding = null;

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public String getEncoding() {
            return this.encoding;
        }
    }
}

