/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.BccEmailArchive;
import com.docusign.esign.model.BccEmailArchiveHistoryList;
import com.docusign.esign.model.BccEmailArchiveList;
import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class EmailArchiveApi {
    private ApiClient apiClient;

    public EmailArchiveApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EmailArchiveApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public BccEmailArchive createBCCEmailArchive(String accountId, BccEmailArchive bccEmailArchive) throws ApiException {
        BccEmailArchive localVarPostBody = bccEmailArchive;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createBCCEmailArchive");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/settings/bcc_email_archives".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BccEmailArchive> localVarReturnType = new GenericType<BccEmailArchive>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteBCCEmailArchive(String accountId, String bccEmailArchiveId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteBCCEmailArchive");
        }
        if (bccEmailArchiveId == null) {
            throw new ApiException(400, "Missing the required parameter 'bccEmailArchiveId' when calling deleteBCCEmailArchive");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/settings/bcc_email_archives/{bccEmailArchiveId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{bccEmailArchiveId\\}", this.apiClient.escapeString(bccEmailArchiveId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public BccEmailArchiveHistoryList getBCCEmailArchiveHistoryList(String accountId, String bccEmailArchiveId) throws ApiException {
        return this.getBCCEmailArchiveHistoryList(accountId, bccEmailArchiveId, null);
    }

    public BccEmailArchiveHistoryList getBCCEmailArchiveHistoryList(String accountId, String bccEmailArchiveId, GetBCCEmailArchiveHistoryListOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getBCCEmailArchiveHistoryList");
        }
        if (bccEmailArchiveId == null) {
            throw new ApiException(400, "Missing the required parameter 'bccEmailArchiveId' when calling getBCCEmailArchiveHistoryList");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/settings/bcc_email_archives/{bccEmailArchiveId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{bccEmailArchiveId\\}", this.apiClient.escapeString(bccEmailArchiveId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", options.count));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_position", options.startPosition));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BccEmailArchiveHistoryList> localVarReturnType = new GenericType<BccEmailArchiveHistoryList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BccEmailArchiveList getBCCEmailArchiveList(String accountId) throws ApiException {
        return this.getBCCEmailArchiveList(accountId, null);
    }

    public BccEmailArchiveList getBCCEmailArchiveList(String accountId, GetBCCEmailArchiveListOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getBCCEmailArchiveList");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/settings/bcc_email_archives".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", options.count));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_position", options.startPosition));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BccEmailArchiveList> localVarReturnType = new GenericType<BccEmailArchiveList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public class GetBCCEmailArchiveListOptions {
        private String count = null;
        private String startPosition = null;

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }
    }

    public class GetBCCEmailArchiveHistoryListOptions {
        private String count = null;
        private String startPosition = null;

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }
    }
}

