/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.PropertyMetadata;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="One of the selectable items in the `listItems` property of a [`list`](/docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/create/) tab.")
public class ListItem {
    @JsonProperty(value="selected")
    private String selected = null;
    @JsonProperty(value="selectedMetadata")
    private PropertyMetadata selectedMetadata = null;
    @JsonProperty(value="text")
    private String text = null;
    @JsonProperty(value="textMetadata")
    private PropertyMetadata textMetadata = null;
    @JsonProperty(value="value")
    private String value = null;
    @JsonProperty(value="valueMetadata")
    private PropertyMetadata valueMetadata = null;

    public ListItem selected(String selected) {
        this.selected = selected;
        return this;
    }

    @ApiModelProperty(value="When set to **true**, indicates that this item is the default selection shown to a signer.   Only one selection can be set as the default.")
    public String getSelected() {
        return this.selected;
    }

    public void setSelected(String selected) {
        this.selected = selected;
    }

    public ListItem selectedMetadata(PropertyMetadata selectedMetadata) {
        this.selectedMetadata = selectedMetadata;
        return this;
    }

    @ApiModelProperty(value="Metadata that indicates whether the `selected` property is editable.")
    public PropertyMetadata getSelectedMetadata() {
        return this.selectedMetadata;
    }

    public void setSelectedMetadata(PropertyMetadata selectedMetadata) {
        this.selectedMetadata = selectedMetadata;
    }

    public ListItem text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(value="Specifies the text that is shown in the dropdown list. ")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public ListItem textMetadata(PropertyMetadata textMetadata) {
        this.textMetadata = textMetadata;
        return this;
    }

    @ApiModelProperty(value="")
    public PropertyMetadata getTextMetadata() {
        return this.textMetadata;
    }

    public void setTextMetadata(PropertyMetadata textMetadata) {
        this.textMetadata = textMetadata;
    }

    public ListItem value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="Specifies the value that is used when the list item is selected.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ListItem valueMetadata(PropertyMetadata valueMetadata) {
        this.valueMetadata = valueMetadata;
        return this;
    }

    @ApiModelProperty(value="Metadata that indicates whether the `value` property is editable.")
    public PropertyMetadata getValueMetadata() {
        return this.valueMetadata;
    }

    public void setValueMetadata(PropertyMetadata valueMetadata) {
        this.valueMetadata = valueMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListItem listItem = (ListItem)o;
        return Objects.equals(this.selected, listItem.selected) && Objects.equals(this.selectedMetadata, listItem.selectedMetadata) && Objects.equals(this.text, listItem.text) && Objects.equals(this.textMetadata, listItem.textMetadata) && Objects.equals(this.value, listItem.value) && Objects.equals(this.valueMetadata, listItem.valueMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.selected, this.selectedMetadata, this.text, this.textMetadata, this.value, this.valueMetadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListItem {\n");
        sb.append("    selected: ").append(this.toIndentedString(this.selected)).append("\n");
        sb.append("    selectedMetadata: ").append(this.toIndentedString(this.selectedMetadata)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    textMetadata: ").append(this.toIndentedString(this.textMetadata)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    valueMetadata: ").append(this.toIndentedString(this.valueMetadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

