/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.Expirations;
import com.docusign.esign.model.Reminders;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A complex element that specifies the notification options for the envelope. It consists of:  * useAccountDefaults - When set to **true**, the account default notification settings are used for the envelope.  * reminders - A complex element that specifies reminder settings for the envelope. It consists of:      * reminderEnabled - When set to **true**, a reminder message is sent to the recipient.    * reminderDelay - An interger that sets the number of days after the recipient receives the envelope that reminder emails are sent to the recipient.     * reminderFrequency - An interger that sets the interval, in days, between reminder emails.   * expirations - A complex element that specifies the expiration settings for the envelope. It consists of:     * expireEnabled - When set to **true**, the envelope expires (is no longer available for signing) in the set number of days. If false, the account default setting is used. If the account does not have an expiration setting, the DocuSign default value of 120 days is used.     * expireAfter - An integer that sets the number of days the envelope is active.    * expireWarn - An integer that sets the number of days before envelope expiration that an expiration warning email is sent to the recipient. If set to 0 (zero), no warning email is sent.")
public class Notification {
    @JsonProperty(value="expirations")
    private Expirations expirations = null;
    @JsonProperty(value="reminders")
    private Reminders reminders = null;
    @JsonProperty(value="useAccountDefaults")
    private String useAccountDefaults = null;

    public Notification expirations(Expirations expirations) {
        this.expirations = expirations;
        return this;
    }

    @ApiModelProperty(value="A complex element that specifies the expiration settings for the envelope.")
    public Expirations getExpirations() {
        return this.expirations;
    }

    public void setExpirations(Expirations expirations) {
        this.expirations = expirations;
    }

    public Notification reminders(Reminders reminders) {
        this.reminders = reminders;
        return this;
    }

    @ApiModelProperty(value="A complex element that specifies reminder settings for the envelope.")
    public Reminders getReminders() {
        return this.reminders;
    }

    public void setReminders(Reminders reminders) {
        this.reminders = reminders;
    }

    public Notification useAccountDefaults(String useAccountDefaults) {
        this.useAccountDefaults = useAccountDefaults;
        return this;
    }

    @ApiModelProperty(value="When set to **true**, the account default notification settings are used for the envelope.")
    public String getUseAccountDefaults() {
        return this.useAccountDefaults;
    }

    public void setUseAccountDefaults(String useAccountDefaults) {
        this.useAccountDefaults = useAccountDefaults;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notification notification = (Notification)o;
        return Objects.equals(this.expirations, notification.expirations) && Objects.equals(this.reminders, notification.reminders) && Objects.equals(this.useAccountDefaults, notification.useAccountDefaults);
    }

    public int hashCode() {
        return Objects.hash(this.expirations, this.reminders, this.useAccountDefaults);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Notification {\n");
        sb.append("    expirations: ").append(this.toIndentedString(this.expirations)).append("\n");
        sb.append("    reminders: ").append(this.toIndentedString(this.reminders)).append("\n");
        sb.append("    useAccountDefaults: ").append(this.toIndentedString(this.useAccountDefaults)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

