/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.FolderItemV2;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Results from a folder item request.")
public class FolderItemResponse {
    @JsonProperty(value="endPosition")
    private String endPosition = null;
    @JsonProperty(value="folderItems")
    private List<FolderItemV2> folderItems = null;
    @JsonProperty(value="nextUri")
    private String nextUri = null;
    @JsonProperty(value="previousUri")
    private String previousUri = null;
    @JsonProperty(value="resultSetSize")
    private String resultSetSize = null;
    @JsonProperty(value="startPosition")
    private String startPosition = null;
    @JsonProperty(value="totalRows")
    private String totalRows = null;

    public FolderItemResponse endPosition(String endPosition) {
        this.endPosition = endPosition;
        return this;
    }

    @Schema(description="The last position in the result set. ")
    public String getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(String endPosition) {
        this.endPosition = endPosition;
    }

    public FolderItemResponse folderItems(List<FolderItemV2> folderItems) {
        this.folderItems = folderItems;
        return this;
    }

    public FolderItemResponse addFolderItemsItem(FolderItemV2 folderItemsItem) {
        if (this.folderItems == null) {
            this.folderItems = new ArrayList<FolderItemV2>();
        }
        this.folderItems.add(folderItemsItem);
        return this;
    }

    @Schema(description="A list of the envelopes in the specified folder or folders. ")
    public List<FolderItemV2> getFolderItems() {
        return this.folderItems;
    }

    public void setFolderItems(List<FolderItemV2> folderItems) {
        this.folderItems = folderItems;
    }

    public FolderItemResponse nextUri(String nextUri) {
        this.nextUri = nextUri;
        return this;
    }

    @Schema(description="The URI to the next chunk of records based on the search request. If the endPosition is the entire results of the search, this is null. ")
    public String getNextUri() {
        return this.nextUri;
    }

    public void setNextUri(String nextUri) {
        this.nextUri = nextUri;
    }

    public FolderItemResponse previousUri(String previousUri) {
        this.previousUri = previousUri;
        return this;
    }

    @Schema(description="The postal code for the billing address.")
    public String getPreviousUri() {
        return this.previousUri;
    }

    public void setPreviousUri(String previousUri) {
        this.previousUri = previousUri;
    }

    public FolderItemResponse resultSetSize(String resultSetSize) {
        this.resultSetSize = resultSetSize;
        return this;
    }

    @Schema(description="The number of results returned in this response. ")
    public String getResultSetSize() {
        return this.resultSetSize;
    }

    public void setResultSetSize(String resultSetSize) {
        this.resultSetSize = resultSetSize;
    }

    public FolderItemResponse startPosition(String startPosition) {
        this.startPosition = startPosition;
        return this;
    }

    @Schema(description="Starting position of the current result set.")
    public String getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(String startPosition) {
        this.startPosition = startPosition;
    }

    public FolderItemResponse totalRows(String totalRows) {
        this.totalRows = totalRows;
        return this;
    }

    @Schema(description="")
    public String getTotalRows() {
        return this.totalRows;
    }

    public void setTotalRows(String totalRows) {
        this.totalRows = totalRows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FolderItemResponse folderItemResponse = (FolderItemResponse)o;
        return Objects.equals(this.endPosition, folderItemResponse.endPosition) && Objects.equals(this.folderItems, folderItemResponse.folderItems) && Objects.equals(this.nextUri, folderItemResponse.nextUri) && Objects.equals(this.previousUri, folderItemResponse.previousUri) && Objects.equals(this.resultSetSize, folderItemResponse.resultSetSize) && Objects.equals(this.startPosition, folderItemResponse.startPosition) && Objects.equals(this.totalRows, folderItemResponse.totalRows);
    }

    public int hashCode() {
        return Objects.hash(this.endPosition, this.folderItems, this.nextUri, this.previousUri, this.resultSetSize, this.startPosition, this.totalRows);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FolderItemResponse {\n");
        sb.append("    endPosition: ").append(this.toIndentedString(this.endPosition)).append("\n");
        sb.append("    folderItems: ").append(this.toIndentedString(this.folderItems)).append("\n");
        sb.append("    nextUri: ").append(this.toIndentedString(this.nextUri)).append("\n");
        sb.append("    previousUri: ").append(this.toIndentedString(this.previousUri)).append("\n");
        sb.append("    resultSetSize: ").append(this.toIndentedString(this.resultSetSize)).append("\n");
        sb.append("    startPosition: ").append(this.toIndentedString(this.startPosition)).append("\n");
        sb.append("    totalRows: ").append(this.toIndentedString(this.totalRows)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

