package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

/** CustomFieldV2 */
public class CustomFieldV2 {
  @JsonProperty("configurationType")
  private String configurationType = null;

  @JsonProperty("errorDetails")
  private ErrorDetails errorDetails = null;

  @JsonProperty("fieldId")
  private String fieldId = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("required")
  private String required = null;

  @JsonProperty("show")
  private String show = null;

  @JsonProperty("value")
  private String value = null;

  public CustomFieldV2 configurationType(String configurationType) {
    this.configurationType = configurationType;
    return this;
  }

  /**
   * If merge field's are being used, specifies the type of the merge field. The only supported
   * value is **salesforce**.
   *
   * @return configurationType
   */
  @Schema(
      example = "null",
      description =
          "If merge field's are being used, specifies the type of the merge field. The only  supported value is **salesforce**.")
  public String getConfigurationType() {
    return configurationType;
  }

  public void setConfigurationType(String configurationType) {
    this.configurationType = configurationType;
  }

  public CustomFieldV2 errorDetails(ErrorDetails errorDetails) {
    this.errorDetails = errorDetails;
    return this;
  }

  /**
   * Get errorDetails
   *
   * @return errorDetails
   */
  @Schema(example = "null", description = "")
  public ErrorDetails getErrorDetails() {
    return errorDetails;
  }

  public void setErrorDetails(ErrorDetails errorDetails) {
    this.errorDetails = errorDetails;
  }

  public CustomFieldV2 fieldId(String fieldId) {
    this.fieldId = fieldId;
    return this;
  }

  /** @return fieldId */
  @Schema(example = "null", description = "")
  public String getFieldId() {
    return fieldId;
  }

  public void setFieldId(String fieldId) {
    this.fieldId = fieldId;
  }

  public CustomFieldV2 name(String name) {
    this.name = name;
    return this;
  }

  /** @return name */
  @Schema(example = "null", description = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public CustomFieldV2 required(String required) {
    this.required = required;
    return this;
  }

  /**
   * When set to **true**, the signer is required to fill out this tab
   *
   * @return required
   */
  @Schema(
      example = "null",
      description = "When set to **true**, the signer is required to fill out this tab")
  public String getRequired() {
    return required;
  }

  public void setRequired(String required) {
    this.required = required;
  }

  public CustomFieldV2 show(String show) {
    this.show = show;
    return this;
  }

  /** @return show */
  @Schema(example = "null", description = "")
  public String getShow() {
    return show;
  }

  public void setShow(String show) {
    this.show = show;
  }

  public CustomFieldV2 value(String value) {
    this.value = value;
    return this;
  }

  /**
   * The value of the custom field.
   *
   * @return value
   */
  @Schema(example = "null", description = "The value of the custom field.")
  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CustomFieldV2 customFieldV2 = (CustomFieldV2) o;
    return Objects.equals(this.configurationType, customFieldV2.configurationType)
        && Objects.equals(this.errorDetails, customFieldV2.errorDetails)
        && Objects.equals(this.fieldId, customFieldV2.fieldId)
        && Objects.equals(this.name, customFieldV2.name)
        && Objects.equals(this.required, customFieldV2.required)
        && Objects.equals(this.show, customFieldV2.show)
        && Objects.equals(this.value, customFieldV2.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(configurationType, errorDetails, fieldId, name, required, show, value);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CustomFieldV2 {\n");

    sb.append("    configurationType: ").append(toIndentedString(configurationType)).append("\n");
    sb.append("    errorDetails: ").append(toIndentedString(errorDetails)).append("\n");
    sb.append("    fieldId: ").append(toIndentedString(fieldId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    required: ").append(toIndentedString(required)).append("\n");
    sb.append("    show: ").append(toIndentedString(show)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
